/*
 * Decompiled with CFR 0.152.
 */
package de.prob.check;

import de.prob.animator.command.AbstractCommand;
import de.prob.animator.command.ConstraintBasedDeadlockCheckCommand;
import de.prob.animator.domainobjects.ClassicalB;
import de.prob.animator.domainobjects.IEvalElement;
import de.prob.check.IModelCheckJob;
import de.prob.check.IModelCheckListener;
import de.prob.check.IModelCheckingResult;
import de.prob.check.ModelChecker;
import de.prob.check.NotYetFinished;
import de.prob.statespace.StateSpace;

public class CBCDeadlockChecker
implements IModelCheckJob {
    private final StateSpace s;
    private final IModelCheckListener ui;
    private final ConstraintBasedDeadlockCheckCommand job;
    String jobId;

    public CBCDeadlockChecker(StateSpace s) {
        this(s, new ClassicalB("1=1"));
    }

    public CBCDeadlockChecker(StateSpace s, IEvalElement constraint) {
        this(s, constraint, null);
    }

    public CBCDeadlockChecker(StateSpace s, IEvalElement constraint, IModelCheckListener ui) {
        this.s = s;
        this.job = new ConstraintBasedDeadlockCheckCommand(s, constraint);
        this.ui = ui;
        this.jobId = ModelChecker.generateJobId();
    }

    @Override
    public IModelCheckingResult call() throws Exception {
        long time = System.currentTimeMillis();
        if (this.ui != null) {
            this.ui.updateStats(this.jobId, 0L, new NotYetFinished("Deadlock check started", 0), null);
        }
        this.s.execute((AbstractCommand)this.job);
        if (this.ui != null) {
            this.ui.isFinished(this.jobId, System.currentTimeMillis() - time, this.job.getResult(), null);
        }
        return this.job.getResult();
    }

    @Override
    public IModelCheckingResult getResult() {
        if (this.job.getResult() == null) {
            return new NotYetFinished("No result was calculated", -1);
        }
        return this.job.getResult();
    }

    @Override
    public String getJobId() {
        return this.jobId;
    }

    @Override
    public StateSpace getStateSpace() {
        return this.s;
    }
}

