/*
 * Decompiled with CFR 0.152.
 */
package de.prob.animator.command;

import com.google.common.base.Joiner;
import de.prob.animator.IPrologResult;
import de.prob.animator.InterruptedResult;
import de.prob.animator.NoResult;
import de.prob.animator.YesResult;
import de.prob.exception.ProBError;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.PrologTerm;
import java.util.Collections;
import java.util.List;

public abstract class AbstractCommand {
    protected boolean interrupted = false;
    protected boolean completed = true;

    public abstract void writeCommand(IPrologTermOutput var1);

    public abstract void processResult(ISimplifiedROMap<String, PrologTerm> var1);

    public List<AbstractCommand> getSubcommands() {
        return Collections.emptyList();
    }

    public boolean isCompleted() {
        return this.interrupted || this.completed;
    }

    public boolean blockAnimator() {
        return false;
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }

    public void processErrorResult(IPrologResult result, List<String> errormessages) {
        if (result instanceof NoResult) {
            String message = "Prolog said no.";
            message = !errormessages.isEmpty() ? message + " Error messages were: " + Joiner.on((String)"\n").join(errormessages) : message + " No error messages were produced.";
            throw new ProBError(message);
        }
        if (!(result instanceof InterruptedResult)) {
            if (result instanceof YesResult) {
                this.processResult(((YesResult)result).getBindings());
                throw new ProBError("ProB reported Errors: " + errormessages);
            }
            throw new ProBError("Errors were: " + Joiner.on((String)"\n").join(errormessages));
        }
        this.interrupted = true;
    }
}

