/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value;

import tlc2.value.Enumerable;
import tlc2.value.MVPerm;
import tlc2.value.SetEnumValue;
import tlc2.value.Value;
import tlc2.value.ValueEnumeration;
import tlc2.value.ValueExcept;
import util.Assert;

public class SetCapValue
extends Value
implements Enumerable {
    public Value set1;
    public Value set2;
    protected SetEnumValue capSet;

    public SetCapValue(Value set1, Value set2) {
        this.set1 = set1;
        this.set2 = set2;
        this.capSet = null;
    }

    @Override
    public final byte getKind() {
        return 18;
    }

    @Override
    public final int compareTo(Object obj) {
        this.convertAndCache();
        return this.capSet.compareTo(obj);
    }

    public final boolean equals(Object obj) {
        this.convertAndCache();
        return this.capSet.equals(obj);
    }

    @Override
    public final boolean member(Value elem) {
        return this.set1.member(elem) && this.set2.member(elem);
    }

    @Override
    public final boolean isFinite() {
        if (!this.set1.isFinite() && !this.set2.isFinite()) {
            Assert.fail("Attempted to check if the set " + SetCapValue.ppr(this.toString()) + "is finite.");
        }
        return true;
    }

    @Override
    public final Value takeExcept(ValueExcept ex) {
        if (ex.idx < ex.path.length) {
            Assert.fail("Attempted to apply EXCEPT to the set " + SetCapValue.ppr(this.toString()) + ".");
        }
        return ex.value;
    }

    @Override
    public final Value takeExcept(ValueExcept[] exs) {
        if (exs.length != 0) {
            Assert.fail("Attempted to apply EXCEPT to the set " + SetCapValue.ppr(this.toString()) + ".");
        }
        return this;
    }

    @Override
    public final int size() {
        this.convertAndCache();
        return this.capSet.size();
    }

    @Override
    public final boolean isNormalized() {
        if (this.capSet == null || this.capSet == DummyEnum) {
            return this.set1.isNormalized() && this.set2.isNormalized();
        }
        return this.capSet.isNormalized();
    }

    @Override
    public final void normalize() {
        if (this.capSet == null || this.capSet == DummyEnum) {
            this.set1.normalize();
            this.set2.normalize();
        } else {
            this.capSet.normalize();
        }
    }

    @Override
    public final boolean isDefined() {
        return this.set1.isDefined() && this.set2.isDefined();
    }

    @Override
    public final Value deepCopy() {
        return this;
    }

    @Override
    public final boolean assignable(Value val) {
        return this.equals(val);
    }

    @Override
    public final long fingerPrint(long fp) {
        this.convertAndCache();
        return this.capSet.fingerPrint(fp);
    }

    @Override
    public final Value permute(MVPerm perm) {
        this.convertAndCache();
        return this.capSet.permute(perm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void convertAndCache() {
        if (this.capSet == null) {
            this.capSet = SetEnumValue.convert(this);
        } else if (this.capSet == DummyEnum) {
            SetEnumValue val = null;
            SetCapValue setCapValue = this;
            synchronized (setCapValue) {
                if (this.capSet == DummyEnum) {
                    val = SetEnumValue.convert(this);
                    val.deepNormalize();
                }
            }
            setCapValue = this;
            synchronized (setCapValue) {
                if (this.capSet == DummyEnum) {
                    this.capSet = val;
                }
            }
        }
    }

    @Override
    public final StringBuffer toString(StringBuffer sb, int offset) {
        try {
            if (expand) {
                SetEnumValue val = SetEnumValue.convert(this);
                return ((Value)val).toString(sb, offset);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        sb = this.set1.toString(sb, offset);
        sb = sb.append(" \\cap ");
        sb = this.set2.toString(sb, offset);
        return sb;
    }

    @Override
    public final ValueEnumeration elements() {
        if (this.capSet == null || this.capSet == DummyEnum) {
            return new Enumerator();
        }
        return this.capSet.elements();
    }

    final class Enumerator
    implements ValueEnumeration {
        ValueEnumeration enum1;
        Value set;

        public Enumerator() {
            if (SetCapValue.this.set1 instanceof Enumerable) {
                this.enum1 = ((Enumerable)((Object)SetCapValue.this.set1)).elements();
                this.set = SetCapValue.this.set2;
            } else if (SetCapValue.this.set2 instanceof Enumerable) {
                this.enum1 = ((Enumerable)((Object)SetCapValue.this.set2)).elements();
                this.set = SetCapValue.this.set1;
            } else {
                Assert.fail("Attempted to enumerate S \\cap T when neither S:\n" + Value.ppr(SetCapValue.this.set1.toString()) + "\nnor T:\n" + Value.ppr(SetCapValue.this.set2.toString()) + "\nis enumerable");
            }
        }

        @Override
        public final void reset() {
            this.enum1.reset();
        }

        @Override
        public final Value nextElement() {
            Value elem = this.enum1.nextElement();
            while (elem != null) {
                if (this.set.member(elem)) {
                    return elem;
                }
                elem = this.enum1.nextElement();
            }
            return null;
        }
    }
}

