/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.liveness;

import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.concurrent.ArrayBlockingQueue;
import tlc2.TLCGlobals;
import tlc2.output.MP;
import tlc2.tool.Action;
import tlc2.tool.StateVec;
import tlc2.tool.TLCState;
import tlc2.tool.Tool;
import tlc2.tool.liveness.AbstractDiskGraph;
import tlc2.tool.liveness.DiskGraph;
import tlc2.tool.liveness.GraphNode;
import tlc2.tool.liveness.ILiveCheck;
import tlc2.tool.liveness.ILiveChecker;
import tlc2.tool.liveness.LiveException;
import tlc2.tool.liveness.LiveWorker;
import tlc2.tool.liveness.Liveness;
import tlc2.tool.liveness.OrderOfSolution;
import tlc2.tool.liveness.TBGraph;
import tlc2.tool.liveness.TBGraphNode;
import tlc2.tool.liveness.TableauDiskGraph;
import tlc2.util.BitVector;
import tlc2.util.FP64;
import tlc2.util.LongVec;
import tlc2.util.statistics.DummyBucketStatistics;
import tlc2.util.statistics.IBucketStatistics;
import util.Assert;
import util.SimpleFilenameToStream;

public class LiveCheck
implements ILiveCheck {
    private final Action[] actions;
    private final Tool myTool;
    private final String metadir;
    private final IBucketStatistics outDegreeGraphStats;
    private final ILiveChecker[] checker;

    public LiveCheck(Tool tool, Action[] acts, String mdir, IBucketStatistics bucketStatistics) throws IOException {
        this(tool, acts, Liveness.processLiveness(tool), mdir, bucketStatistics);
    }

    public LiveCheck(Tool tool, Action[] acts, OrderOfSolution[] solutions, String mdir, IBucketStatistics bucketStatistics) throws IOException {
        this.myTool = tool;
        this.actions = acts;
        this.metadir = mdir;
        this.outDegreeGraphStats = bucketStatistics;
        this.checker = new ILiveChecker[solutions.length];
        for (int soln = 0; soln < solutions.length; ++soln) {
            this.checker[soln] = !solutions[soln].hasTableau() ? new LiveChecker(solutions[soln], soln, bucketStatistics) : new TableauLiveChecker(solutions[soln], soln, bucketStatistics);
        }
    }

    @Override
    public void addInitState(TLCState state, long stateFP) {
        for (int i = 0; i < this.checker.length; ++i) {
            this.checker[i].addInitState(state, stateFP);
        }
    }

    @Override
    public void addNextState(TLCState s0, long fp0, StateVec nextStates, LongVec nextFPs) throws IOException {
        for (int i = 0; i < this.checker.length; ++i) {
            ILiveChecker check = this.checker[i];
            OrderOfSolution oos = check.getSolution();
            int alen = oos.getCheckAction().length;
            BitVector checkActionResults = new BitVector(alen * nextStates.size());
            for (int sidx = 0; sidx < nextStates.size(); ++sidx) {
                TLCState s1 = nextStates.elementAt(sidx);
                oos.checkAction(s0, s1, checkActionResults, alen * sidx);
            }
            check.addNextState(s0, fp0, nextStates, nextFPs, checkActionResults, oos.checkState(s0));
        }
    }

    @Override
    public boolean check(boolean forceCheck) throws Exception {
        if (forceCheck) {
            return this.check0(false);
        }
        for (int i = 0; i < this.checker.length; ++i) {
            AbstractDiskGraph diskGraph = this.checker[i].getDiskGraph();
            long sizeAtLastCheck = diskGraph.getSizeAtLastCheck();
            long sizeCurrently = diskGraph.size();
            double delta = (double)(sizeCurrently - sizeAtLastCheck) / ((double)sizeAtLastCheck * 1.0);
            if (!(delta > TLCGlobals.livenessThreshold)) continue;
            return this.check0(false);
        }
        return true;
    }

    @Override
    public boolean finalCheck() throws InterruptedException, IOException {
        return this.check0(true);
    }

    private boolean check0(boolean finalCheck) throws InterruptedException, IOException {
        long sum = 0L;
        for (int i = 0; i < this.checker.length; ++i) {
            sum += this.checker[i].getDiskGraph().size();
        }
        MP.printMessage(2192, new String[]{"current", Long.toString(sum)});
        ArrayBlockingQueue<ILiveChecker> queue = new ArrayBlockingQueue<ILiveChecker>(this.checker.length);
        queue.addAll(Arrays.asList(this.checker));
        int slen = this.checker.length;
        int wNum = Math.min(slen, TLCGlobals.getNumWorkers());
        if (wNum == 1) {
            LiveWorker worker = new LiveWorker(0, this, queue);
            worker.run();
        } else {
            int i;
            LiveWorker[] workers = new LiveWorker[wNum];
            for (i = 0; i < wNum; ++i) {
                workers[i] = new LiveWorker(i, this, queue);
                workers[i].start();
            }
            for (i = 0; i < wNum; ++i) {
                workers[i].join();
            }
        }
        if (LiveWorker.hasErrFound()) {
            return false;
        }
        if (!finalCheck) {
            for (int i = 0; i < this.checker.length; ++i) {
                this.checker[i].getDiskGraph().makeNodePtrTbl();
            }
        }
        return true;
    }

    @Override
    public void checkTrace(StateVec stateTrace) throws InterruptedException, IOException {
        this.addInitState(stateTrace.elementAt(0), stateTrace.elementAt(0).fingerPrint());
        StateVec successor = new StateVec(2);
        LongVec successorFP = new LongVec(2);
        for (int i = 0; i < stateTrace.size() - 1; ++i) {
            successor.clear();
            successorFP.reset();
            TLCState tlcState = stateTrace.elementAt(i);
            long fingerPrint = tlcState.fingerPrint();
            successor.addElement(tlcState);
            successorFP.addElement(fingerPrint);
            successor.addElement(stateTrace.elementAt(i + 1));
            successorFP.addElement(stateTrace.elementAt(i + 1).fingerPrint());
            this.addNextState(tlcState, fingerPrint, successor, successorFP);
        }
        TLCState lastState = stateTrace.elementAt(stateTrace.size() - 1);
        this.addNextState(lastState, lastState.fingerPrint(), new StateVec(0), new LongVec(0));
        if (!this.check0(true)) {
            throw new LiveException();
        }
        this.reset();
    }

    @Override
    public String getMetaDir() {
        return this.metadir;
    }

    @Override
    public Tool getTool() {
        return this.myTool;
    }

    @Override
    public IBucketStatistics getOutDegreeStatistics() {
        return this.outDegreeGraphStats;
    }

    @Override
    public ILiveChecker getChecker(int idx) {
        return this.checker[idx];
    }

    @Override
    public int getNumChecker() {
        return this.checker.length;
    }

    @Override
    public void close() throws IOException {
        for (int i = 0; i < this.checker.length; ++i) {
            this.checker[i].getDiskGraph().close();
        }
    }

    @Override
    public synchronized void beginChkpt() throws IOException {
        for (int i = 0; i < this.checker.length; ++i) {
            this.checker[i].getDiskGraph().beginChkpt();
        }
    }

    @Override
    public void commitChkpt() throws IOException {
        for (int i = 0; i < this.checker.length; ++i) {
            this.checker[i].getDiskGraph().commitChkpt();
        }
    }

    @Override
    public void recover() throws IOException {
        for (int i = 0; i < this.checker.length; ++i) {
            MP.printMessage(2130);
            this.checker[i].getDiskGraph().recover();
        }
    }

    @Override
    public void reset() throws IOException {
        for (int i = 0; i < this.checker.length; ++i) {
            this.checker[i].getDiskGraph().reset();
        }
    }

    @Override
    public IBucketStatistics calculateInDegreeDiskGraphs(IBucketStatistics aGraphStats) throws IOException {
        for (int i = 0; i < this.checker.length; ++i) {
            AbstractDiskGraph diskGraph = this.checker[i].getDiskGraph();
            diskGraph.calculateInDegreeDiskGraph(aGraphStats);
        }
        return aGraphStats;
    }

    @Override
    public IBucketStatistics calculateOutDegreeDiskGraphs(IBucketStatistics aGraphStats) throws IOException {
        for (int i = 0; i < this.checker.length; ++i) {
            AbstractDiskGraph diskGraph = this.checker[i].getDiskGraph();
            diskGraph.calculateOutDegreeDiskGraph(aGraphStats);
        }
        return aGraphStats;
    }

    static class TestHelper {
        TestHelper() {
        }

        public static ILiveCheck recreateFromDisk(String path) throws Exception {
            FP64.Init(0);
            TLCGlobals.setBound = 9000000;
            Tool tool = new Tool("", "MC", "MC", new SimpleFilenameToStream());
            tool.init(true, null);
            tool.getActions();
            LiveCheck liveCheck = new LiveCheck(tool, null, path, new DummyBucketStatistics());
            StateVec initStates = tool.getInitStates();
            for (int i = 0; i < initStates.size(); ++i) {
                TLCState state = initStates.elementAt(i);
                liveCheck.addInitState(state, state.fingerPrint());
            }
            return liveCheck;
        }
    }

    private class TableauLiveChecker
    extends AbstractLiveChecker {
        private final TableauDiskGraph dgraph;

        public TableauLiveChecker(OrderOfSolution oos, int soln, IBucketStatistics statistics) throws IOException {
            super(oos);
            this.dgraph = new TableauDiskGraph(LiveCheck.this.metadir, soln, statistics);
        }

        @Override
        public void addInitState(TLCState state, long stateFP) {
            int initCnt = this.oos.getTableau().getInitCnt();
            for (int i = 0; i < initCnt; ++i) {
                TBGraphNode tnode = this.oos.getTableau().getNode(i);
                if (!tnode.isConsistent(state, LiveCheck.this.myTool)) continue;
                this.dgraph.addInitNode(stateFP, tnode.index);
                this.dgraph.recordNode(stateFP, tnode.index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addNextState(TLCState s0, long fp0, StateVec nextStates, LongVec nextFPs, BitVector checkActionResults, boolean[] checkStateResults) throws IOException {
            int cnt = 0;
            int succCnt = nextStates.size();
            TBGraph tableau = this.oos.getTableau();
            BitVector consistency = new BitVector(tableau.size() * succCnt);
            Enumeration elements = tableau.elements();
            while (elements.hasMoreElements()) {
                TBGraphNode tableauNode = (TBGraphNode)elements.nextElement();
                for (int sidx = 0; sidx < succCnt; ++sidx) {
                    TLCState s1 = nextStates.elementAt(sidx);
                    if (!tableauNode.isConsistent(s1, LiveCheck.this.myTool)) continue;
                    consistency.set(tableauNode.index * succCnt + sidx);
                }
            }
            OrderOfSolution orderOfSolution = this.oos;
            synchronized (orderOfSolution) {
                int loc0 = this.dgraph.setDone(fp0);
                int[] nodes = this.dgraph.getNodesByLoc(loc0);
                if (nodes == null) {
                    return;
                }
                int alen = this.oos.getCheckAction().length;
                int allocationHint = nodes.length / this.dgraph.getElemLength() * succCnt;
                for (int nidx = 2; nidx < nodes.length; nidx += this.dgraph.getElemLength()) {
                    int tidx0 = nodes[nidx];
                    TBGraphNode tnode0 = this.oos.getTableau().getNode(tidx0);
                    GraphNode node0 = this.dgraph.getNode(fp0, tidx0);
                    int s = node0.succSize();
                    node0.setCheckState(checkStateResults);
                    for (int sidx = 0; sidx < succCnt; ++sidx) {
                        TLCState s1 = nextStates.elementAt(sidx);
                        long successor = nextFPs.elementAt(sidx);
                        boolean isDone = this.dgraph.isDone(successor);
                        for (int k = 0; k < tnode0.nextSize(); ++k) {
                            TBGraphNode tnode1 = tnode0.nextAt(k);
                            long ptr1 = this.dgraph.getPtr(successor, tnode1.index);
                            if (ptr1 == -1L) {
                                if (!consistency.get(tnode1.index * succCnt + sidx)) continue;
                                node0.addTransition(successor, tnode1.index, checkStateResults.length, alen, checkActionResults, sidx * alen, allocationHint - cnt++);
                                this.dgraph.recordNode(successor, tnode1.index);
                                if (!isDone) continue;
                                this.addNextState(s1, successor, tnode1, this.oos, this.dgraph);
                                continue;
                            }
                            if (!node0.transExists(successor, tnode1.index)) {
                                node0.addTransition(successor, tnode1.index, checkStateResults.length, alen, checkActionResults, sidx * alen, allocationHint - cnt++);
                                continue;
                            }
                            ++cnt;
                        }
                    }
                    if (s < node0.succSize()) {
                        node0.realign();
                        this.dgraph.addNode(node0);
                        continue;
                    }
                    Assert.check(TLCGlobals.mainChecker == null, 1000);
                }
            }
        }

        private void addNextState(TLCState s, long fp, TBGraphNode tnode, OrderOfSolution oos, TableauDiskGraph dgraph) throws IOException {
            int i;
            boolean[] checkStateRes = oos.checkState(s);
            int slen = checkStateRes.length;
            int alen = oos.getCheckAction().length;
            GraphNode node = dgraph.getNode(fp, tnode.index);
            int numSucc = node.succSize();
            node.setCheckState(checkStateRes);
            int cnt = 0;
            BitVector checkActionResults = oos.checkAction(s, s, new BitVector(alen), 0);
            int nextSize = tnode.nextSize();
            for (i = 0; i < nextSize; ++i) {
                TBGraphNode tnode1 = tnode.nextAt(i);
                int tidx1 = tnode1.index;
                long ptr1 = dgraph.getPtr(fp, tidx1);
                if (ptr1 == -1L) {
                    if (tnode1.isConsistent(s, LiveCheck.this.myTool)) {
                        node.addTransition(fp, tidx1, slen, alen, checkActionResults, 0, nextSize - cnt++);
                        dgraph.recordNode(fp, tnode1.index);
                        this.addNextState(s, fp, tnode1, oos, dgraph);
                        continue;
                    }
                    ++cnt;
                    continue;
                }
                node.addTransition(fp, tidx1, slen, alen, checkActionResults, 0, nextSize - cnt++);
            }
            cnt = 0;
            for (i = 0; i < LiveCheck.this.actions.length; ++i) {
                StateVec nextStates = LiveCheck.this.myTool.getNextStates(LiveCheck.this.actions[i], s);
                int nextCnt = nextStates.size();
                for (int j = 0; j < nextCnt; ++j) {
                    TLCState s1 = nextStates.elementAt(j);
                    if (LiveCheck.this.myTool.isInModel(s1) && LiveCheck.this.myTool.isInActions(s, s1)) {
                        long fp1 = s1.fingerPrint();
                        BitVector checkActionRes = oos.checkAction(s, s1, new BitVector(alen), 0);
                        boolean isDone = dgraph.isDone(fp1);
                        for (int k = 0; k < tnode.nextSize(); ++k) {
                            TBGraphNode tnode1 = tnode.nextAt(k);
                            int tidx1 = tnode1.index;
                            long ptr1 = dgraph.getPtr(fp1, tidx1);
                            int total = LiveCheck.this.actions.length * nextCnt * tnode.nextSize();
                            if (ptr1 == -1L) {
                                if (!tnode1.isConsistent(s1, LiveCheck.this.myTool)) continue;
                                node.addTransition(fp1, tidx1, slen, alen, checkActionRes, 0, total - cnt++);
                                dgraph.recordNode(fp1, tidx1);
                                if (!isDone) continue;
                                this.addNextState(s1, fp1, tnode1, oos, dgraph);
                                continue;
                            }
                            if (!node.transExists(fp1, tidx1)) {
                                node.addTransition(fp1, tidx1, slen, alen, checkActionRes, 0, total - cnt++);
                                continue;
                            }
                            ++cnt;
                        }
                        continue;
                    }
                    ++cnt;
                }
            }
            if (numSucc < node.succSize()) {
                node.realign();
                dgraph.addNode(node);
            }
        }

        @Override
        public AbstractDiskGraph getDiskGraph() {
            return this.dgraph;
        }
    }

    private class LiveChecker
    extends AbstractLiveChecker {
        private final DiskGraph dgraph;

        public LiveChecker(OrderOfSolution oos, int soln, IBucketStatistics bucketStatistics) throws IOException {
            super(oos);
            this.dgraph = new DiskGraph(LiveCheck.this.metadir, soln, bucketStatistics);
        }

        @Override
        public void addInitState(TLCState state, long stateFP) {
            this.dgraph.addInitNode(stateFP, -1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addNextState(TLCState s0, long fp0, StateVec nextStates, LongVec nextFPs, BitVector checkActionResults, boolean[] checkStateResults) throws IOException {
            int cnt = 0;
            int succCnt = nextStates.size();
            int alen = this.oos.getCheckAction().length;
            OrderOfSolution orderOfSolution = this.oos;
            synchronized (orderOfSolution) {
                GraphNode node0 = this.dgraph.getNode(fp0);
                int s = node0.succSize();
                node0.setCheckState(checkStateResults);
                for (int sidx = 0; sidx < succCnt; ++sidx) {
                    long successor = nextFPs.elementAt(sidx);
                    long ptr1 = this.dgraph.getPtr(successor);
                    if (ptr1 == -1L || !node0.transExists(successor, -1)) {
                        node0.addTransition(successor, -1, checkStateResults.length, alen, checkActionResults, sidx * alen, succCnt - cnt++);
                        continue;
                    }
                    ++cnt;
                }
                if (s < node0.succSize()) {
                    node0.realign();
                    this.dgraph.addNode(node0);
                } else {
                    Assert.check(TLCGlobals.mainChecker == null, 1000);
                }
            }
        }

        @Override
        public DiskGraph getDiskGraph() {
            return this.dgraph;
        }
    }

    static abstract class AbstractLiveChecker
    implements ILiveChecker {
        protected final OrderOfSolution oos;

        public AbstractLiveChecker(OrderOfSolution oos) {
            this.oos = oos;
        }

        @Override
        public OrderOfSolution getSolution() {
            return this.oos;
        }
    }
}

