/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.fp;

import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.NoSuchElementException;
import tlc2.tool.fp.DiskFPSet;
import tlc2.tool.fp.FPSetConfiguration;
import tlc2.tool.fp.HeapBasedDiskFPSet;
import util.Assert;

public class MSBDiskFPSet
extends HeapBasedDiskFPSet {
    protected final int moveBy;

    protected MSBDiskFPSet(FPSetConfiguration fpSetConfig) throws RemoteException {
        super(fpSetConfig);
        this.moveBy = 31 - fpSetConfig.getPrefixBits() - (this.logMaxMemCnt - 4);
        this.mask = this.capacity - 1 << this.moveBy;
        this.flusher = new MSBFlusher();
    }

    @Override
    protected double getAuxiliaryStorageRequirement() {
        return 1.5;
    }

    @Override
    protected long index(long fp, long aMask) {
        return ((long)((int)(fp >>> 32)) & aMask) >> this.moveBy;
    }

    public static class TLCIterator {
        private final long[][] buff;
        private int firstIdx = 0;
        private int secondIdx = 0;
        private long previous = -1L;
        private long readElements = 0L;

        public TLCIterator(long[][] buff) {
            this.buff = buff;
        }

        public boolean hasNext() {
            if (this.firstIdx < this.buff.length) {
                long[] bucket = this.buff[this.firstIdx];
                if (bucket != null && this.secondIdx < bucket.length && bucket[this.secondIdx] > 0L) {
                    return true;
                }
                for (int i = this.firstIdx + 1; i < this.buff.length; ++i) {
                    if (this.buff[i] == null || this.buff[i].length <= 0 || this.buff[i][0] <= 0L) continue;
                    return true;
                }
            }
            return false;
        }

        public long next() {
            long result = -1L;
            if (this.firstIdx < this.buff.length) {
                long[] bucket = this.buff[this.firstIdx];
                if (bucket != null && this.secondIdx < bucket.length && bucket[this.secondIdx] > 0L) {
                    result = bucket[this.secondIdx];
                    int n = this.secondIdx++;
                    bucket[n] = bucket[n] | Long.MIN_VALUE;
                } else {
                    for (int i = this.firstIdx + 1; i < this.buff.length && result == -1L; ++i) {
                        if (this.buff[i] == null || this.buff[i].length <= 0 || this.buff[i][0] <= 0L) continue;
                        this.firstIdx = i;
                        this.secondIdx = 0;
                        result = this.buff[this.firstIdx][this.secondIdx];
                        long[] lArray = this.buff[this.firstIdx];
                        int n = this.secondIdx++;
                        lArray[n] = lArray[n] | Long.MIN_VALUE;
                        break;
                    }
                }
            }
            if (result == -1L) {
                throw new NoSuchElementException();
            }
            Assert.check(this.previous < result, 1000);
            this.previous = result;
            ++this.readElements;
            return result;
        }

        public long getLast(long lowBound) {
            int len = this.buff.length;
            while (len > 0) {
                long[] bucket;
                if ((bucket = this.buff[--len]) == null) continue;
                for (int i = bucket.length - 1; i >= 0; --i) {
                    long fp = bucket[i];
                    if (fp == 0L || fp <= 0L) continue;
                    if (fp < lowBound) {
                        return lowBound;
                    }
                    return fp;
                }
            }
            throw new NoSuchElementException();
        }

        public long getLast() {
            int len = this.buff.length;
            while (len > 0) {
                long[] bucket;
                if ((bucket = this.buff[--len]) == null) continue;
                for (int i = bucket.length - 1; i >= 0; --i) {
                    if (bucket[i] <= 0L) continue;
                    return bucket[i];
                }
            }
            throw new NoSuchElementException();
        }

        public long reads() {
            return this.readElements;
        }
    }

    public class MSBFlusher
    extends DiskFPSet.Flusher {
        @Override
        protected void prepareTable() {
            for (int j = 0; j < MSBDiskFPSet.this.tbl.length; ++j) {
                int k;
                long[] bucket = MSBDiskFPSet.this.tbl[j];
                if (bucket == null) continue;
                int blen = bucket.length;
                for (k = 0; k < blen && bucket[k] > 0L; ++k) {
                }
                Arrays.sort(bucket, 0, k);
            }
        }

        @Override
        protected void mergeNewEntries(RandomAccessFile inRAF, RandomAccessFile outRAF) throws IOException {
            long buffLen = MSBDiskFPSet.this.tblCnt.get();
            TLCIterator itr = new TLCIterator(MSBDiskFPSet.this.tbl);
            long maxVal = MSBDiskFPSet.this.index != null ? itr.getLast(MSBDiskFPSet.this.index[MSBDiskFPSet.this.index.length - 1]) : itr.getLast();
            int indexLen = MSBDiskFPSet.this.calculateIndexLen(buffLen);
            MSBDiskFPSet.this.index = new long[indexLen];
            MSBDiskFPSet.this.index[indexLen - 1] = maxVal;
            MSBDiskFPSet.this.currIndex = 0;
            MSBDiskFPSet.this.counter = 0;
            long value = 0L;
            boolean eof = false;
            if (MSBDiskFPSet.this.fileCnt > 0L) {
                try {
                    value = inRAF.readLong();
                }
                catch (EOFException e) {
                    eof = true;
                }
            } else {
                eof = true;
            }
            boolean eol = false;
            long fp = itr.next();
            while (!eof || !eol) {
                if ((value < fp || eol) && !eof) {
                    MSBDiskFPSet.this.writeFP(outRAF, value);
                    try {
                        value = inRAF.readLong();
                    }
                    catch (EOFException e) {
                        eof = true;
                    }
                    continue;
                }
                if (value == fp) {
                    Assert.check(false, 2166, String.valueOf(value));
                }
                MSBDiskFPSet.this.writeFP(outRAF, fp);
                try {
                    fp = itr.next();
                }
                catch (NoSuchElementException e) {
                    Assert.check(!itr.hasNext(), 1000);
                    Assert.check(itr.reads() == buffLen, 1000);
                    eol = true;
                }
            }
            Assert.check(eof && eol, 1000);
            Assert.check(MSBDiskFPSet.this.currIndex == indexLen - 1, 2134);
            MSBDiskFPSet.this.fileCnt += buffLen;
        }
    }
}

