/*
 * Decompiled with CFR 0.152.
 */
package tlc2.module;

import tlc2.module.Integers;
import tlc2.tool.EvalException;
import tlc2.tool.TLARegistry;
import tlc2.value.BoolValue;
import tlc2.value.IntValue;
import tlc2.value.IntervalValue;
import tlc2.value.ModelValue;
import tlc2.value.UserObj;
import tlc2.value.UserValue;
import tlc2.value.Value;
import tlc2.value.ValueConstants;

public class Naturals
extends UserObj
implements ValueConstants {
    private static Value SetNat;

    public static Value Nat() {
        return SetNat;
    }

    public static IntValue Plus(IntValue x, IntValue y) {
        int n1 = x.val;
        int n2 = y.val;
        int res = n1 + n2;
        if (n1 < 0 == n2 < 0 && n2 < 0 != res < 0) {
            throw new EvalException(2178, n1 + "+" + n2);
        }
        return IntValue.gen(res);
    }

    public static IntValue Minus(IntValue x, IntValue y) {
        int n1 = x.val;
        int n2 = y.val;
        int res = n1 - n2;
        if (n1 < 0 != n2 < 0 && n1 < 0 != res < 0) {
            throw new EvalException(2178, n1 + "-" + n2);
        }
        return IntValue.gen(res);
    }

    public static IntValue Times(IntValue x, IntValue y) {
        int n1 = x.val;
        int n2 = y.val;
        long res = (long)n1 * (long)n2;
        if (Integer.MIN_VALUE > res || res > Integer.MAX_VALUE) {
            throw new EvalException(2178, n1 + "*" + n2);
        }
        return IntValue.gen((int)res);
    }

    public static BoolValue LT(Value x, Value y) {
        if (!(x instanceof IntValue)) {
            throw new EvalException(2266, new String[]{"first", "<", "integer", Value.ppr(x.toString())});
        }
        if (!(y instanceof IntValue)) {
            throw new EvalException(2266, new String[]{"second", "<", "integer", Value.ppr(x.toString())});
        }
        return ((IntValue)x).val < ((IntValue)y).val ? ValTrue : ValFalse;
    }

    public static BoolValue LE(Value x, Value y) {
        if (!(x instanceof IntValue)) {
            throw new EvalException(2266, new String[]{"first", "<=", "integer", Value.ppr(x.toString())});
        }
        if (!(y instanceof IntValue)) {
            throw new EvalException(2266, new String[]{"second", "<=", "integer", Value.ppr(x.toString())});
        }
        return ((IntValue)x).val <= ((IntValue)y).val ? ValTrue : ValFalse;
    }

    public static BoolValue GT(Value x, Value y) {
        if (!(x instanceof IntValue)) {
            throw new EvalException(2266, new String[]{"first", ">", "integer", Value.ppr(x.toString())});
        }
        if (!(y instanceof IntValue)) {
            throw new EvalException(2266, new String[]{"second", ">", "integer", Value.ppr(y.toString())});
        }
        return ((IntValue)x).val > ((IntValue)y).val ? ValTrue : ValFalse;
    }

    public static BoolValue GEQ(Value x, Value y) {
        if (!(x instanceof IntValue)) {
            throw new EvalException(2266, new String[]{"first", ">", "integer", Value.ppr(x.toString())});
        }
        if (!(y instanceof IntValue)) {
            throw new EvalException(2266, new String[]{"second", ">", "integer", Value.ppr(y.toString())});
        }
        return ((IntValue)x).val >= ((IntValue)y).val ? ValTrue : ValFalse;
    }

    public static IntervalValue DotDot(IntValue x, IntValue y) {
        return new IntervalValue(x.val, y.val);
    }

    public static IntValue Divide(IntValue x, IntValue y) {
        int n1 = x.val;
        int n2 = y.val;
        if (n2 == 0) {
            throw new EvalException(2179);
        }
        int q = n1 / n2;
        if (q < 0 && q * n2 != n1) {
            --q;
        }
        return IntValue.gen(q);
    }

    public static IntValue Mod(IntValue x, IntValue y) {
        int n1 = x.val;
        int n2 = y.val;
        if (n2 <= 0) {
            throw new EvalException(2169, new String[]{"second", "%", "positive number", String.valueOf(n2)});
        }
        int r = n1 % n2;
        return IntValue.gen(r < 0 ? r + n2 : r);
    }

    public static IntValue Expt(IntValue x, IntValue y) {
        int n1 = x.val;
        int n2 = y.val;
        if (n2 < 0) {
            throw new EvalException(2169, new String[]{"second", "^", "natural number", String.valueOf(n2)});
        }
        if (n2 == 0) {
            if (n1 == 0) {
                throw new EvalException(2180);
            }
            return ValOne;
        }
        long res = n1;
        for (int i = 1; i < n2; ++i) {
            if ((res *= (long)n1) >= Integer.MIN_VALUE && res <= Integer.MAX_VALUE) continue;
            throw new EvalException(2178, n1 + "^" + n2);
        }
        return IntValue.gen((int)res);
    }

    @Override
    public final int compareTo(Value val) {
        if (val instanceof UserValue) {
            if (((UserValue)val).userObj instanceof Naturals) {
                return 0;
            }
            if (((UserValue)val).userObj instanceof Integers) {
                return -1;
            }
        }
        if (val instanceof ModelValue) {
            return 1;
        }
        throw new EvalException(2155, new String[]{"Nat", Value.ppr(val.toString())});
    }

    @Override
    public final boolean member(Value val) {
        if (val instanceof IntValue) {
            return ((IntValue)val).val >= 0;
        }
        if (val instanceof ModelValue) {
            return ((ModelValue)val).modelValueMember(this);
        }
        throw new EvalException(2158, new String[]{Value.ppr(val.toString()), "Nat"});
    }

    @Override
    public final boolean isFinite() {
        return false;
    }

    @Override
    public final StringBuffer toString(StringBuffer sb, int offset) {
        return sb.append("Nat");
    }

    static {
        TLARegistry.put("Plus", "+");
        TLARegistry.put("Minus", "-");
        TLARegistry.put("Times", "*");
        TLARegistry.put("LT", "<");
        TLARegistry.put("LE", "\\leq");
        TLARegistry.put("GT", ">");
        TLARegistry.put("GEQ", "\\geq");
        TLARegistry.put("DotDot", "..");
        TLARegistry.put("Divide", "\\div");
        TLARegistry.put("Mod", "%");
        TLARegistry.put("Expt", "^");
        SetNat = new UserValue(new Naturals());
    }
}

