/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.parser.operators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eventb.core.ast.Formula;
import org.eventb.internal.core.lexer.Token;
import org.eventb.internal.core.parser.GenParser;
import org.eventb.internal.core.parser.ILedParser;
import org.eventb.internal.core.parser.INudParser;
import org.eventb.internal.core.parser.operators.ExternalViewUtils;

public class LexKindParserDB {
    private final Map<Integer, KindParsers> kindParsers = new HashMap<Integer, KindParsers>();

    public List<INudParser<? extends Formula<?>>> getNudParsers(Token token) {
        KindParsers parsers = this.kindParsers.get(token.kind);
        if (parsers == null) {
            return Collections.emptyList();
        }
        return parsers.getNudParsers();
    }

    public ILedParser<? extends Formula<?>> getLedParser(Token token) {
        KindParsers parsers = this.kindParsers.get(token.kind);
        if (parsers == null) {
            return null;
        }
        List<ILedParser<Formula<?>>> ledParsers = parsers.getLedParsers();
        if (ledParsers.isEmpty()) {
            return null;
        }
        return ledParsers.get(0);
    }

    public void addNud(int kind, INudParser<? extends Formula<?>> subParser) {
        KindParsers parsers = this.fetchParsers(kind);
        parsers.addNud(subParser);
    }

    public void addLed(int kind, ILedParser<? extends Formula<?>> subParser) throws GenParser.OverrideException {
        KindParsers parsers = this.fetchParsers(kind);
        parsers.addLed(subParser);
    }

    private KindParsers fetchParsers(int kind) {
        KindParsers parsers = this.kindParsers.get(kind);
        if (parsers == null) {
            parsers = new KindParsers();
            this.kindParsers.put(kind, parsers);
        }
        return parsers;
    }

    public void redistribute(ExternalViewUtils.Instantiator<Integer, Integer> opKindInst) {
        HashMap<Integer, KindParsers> newKindParsers = new HashMap<Integer, KindParsers>();
        for (Map.Entry<Integer, KindParsers> entry : this.kindParsers.entrySet()) {
            Integer newKind = opKindInst.instantiate(entry.getKey());
            newKindParsers.put(newKind, entry.getValue());
        }
        this.kindParsers.clear();
        this.kindParsers.putAll(newKindParsers);
    }

    private static class KindParsers {
        private final List<ILedParser<? extends Formula<?>>> ledParsers = new ArrayList();
        private final List<INudParser<? extends Formula<?>>> nudParsers = new ArrayList();

        public void addLed(ILedParser<? extends Formula<?>> subParser) throws GenParser.OverrideException {
            if (!this.ledParsers.isEmpty()) {
                throw new GenParser.OverrideException("Cannot add several led parsers for one kind (led backtracking is not supported)");
            }
            this.ledParsers.add(subParser);
        }

        public void addNud(INudParser<? extends Formula<?>> subParser) {
            if (!this.nudParsers.contains(subParser)) {
                this.nudParsers.add(subParser);
            }
        }

        public List<ILedParser<? extends Formula<?>>> getLedParsers() {
            return this.ledParsers;
        }

        public List<INudParser<? extends Formula<?>>> getNudParsers() {
            return this.nudParsers;
        }
    }
}

