/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast.datatype;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.ExtendedExpression;
import org.eventb.core.ast.Predicate;
import org.eventb.core.ast.Type;
import org.eventb.core.ast.datatype.IConstructorArgument;
import org.eventb.core.ast.datatype.IConstructorExtension;
import org.eventb.core.ast.datatype.IDestructorExtension;
import org.eventb.core.ast.extension.ICompatibilityMediator;
import org.eventb.core.ast.extension.IExtendedFormula;
import org.eventb.core.ast.extension.IExtensionKind;
import org.eventb.core.ast.extension.IFormulaExtension;
import org.eventb.core.ast.extension.IPriorityMediator;
import org.eventb.core.ast.extension.ITypeCheckMediator;
import org.eventb.core.ast.extension.ITypeMediator;
import org.eventb.core.ast.extension.IWDMediator;
import org.eventb.internal.core.ast.datatype.ConstructorArgument;
import org.eventb.internal.core.ast.datatype.Datatype;
import org.eventb.internal.core.ast.datatype.DatatypeArgument;
import org.eventb.internal.core.ast.datatype.DatatypeHelper;
import org.eventb.internal.core.ast.datatype.DestructorExtension;
import org.eventb.internal.core.ast.datatype.TypeSubstitution;

public class ConstructorExtension
implements IConstructorExtension {
    private final Datatype origin;
    private final String name;
    private final ConstructorArgument[] arguments;
    private final String id;
    private final IExtensionKind kind;
    private final String groupId;
    private Set<IFormulaExtension> extensions;
    private HashMap<String, DestructorExtension> destructors;

    public ConstructorExtension(Datatype origin, String name, List<DatatypeArgument> builderArgs) {
        this.origin = origin;
        this.name = name;
        this.id = DatatypeHelper.computeId(name);
        int nbArgs = builderArgs.size();
        this.groupId = DatatypeHelper.computeGroup(nbArgs);
        this.kind = DatatypeHelper.computeKind(nbArgs);
        this.arguments = new ConstructorArgument[nbArgs];
        this.extensions = new HashSet<IFormulaExtension>(nbArgs);
        this.destructors = new HashMap(nbArgs);
        int count = 0;
        for (DatatypeArgument builderArg : builderArgs) {
            ConstructorArgument arg = builderArg.finalize(origin, this);
            if (arg.isDestructor()) {
                DestructorExtension destr = arg.asDestructor();
                this.extensions.add(destr);
                this.destructors.put(destr.getName(), destr);
            }
            this.arguments[count] = arg;
            ++count;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean hasArguments() {
        return this.arguments.length != 0;
    }

    public ConstructorArgument[] getArguments() {
        return (ConstructorArgument[])this.arguments.clone();
    }

    public Map<String, DestructorExtension> getDestructorMap() {
        return this.destructors;
    }

    @Override
    public IDestructorExtension getDestructor(String destName) {
        return this.destructors.get(destName);
    }

    @Override
    public int getArgumentIndex(IConstructorArgument argument) {
        for (int i = 0; i < this.arguments.length; ++i) {
            if (argument != this.arguments[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Predicate getWDPredicate(IExtendedFormula formula, IWDMediator wdMediator) {
        return wdMediator.makeTrueWD();
    }

    @Override
    public boolean conjoinChildrenWD() {
        return true;
    }

    @Override
    public String getSyntaxSymbol() {
        return this.name;
    }

    @Override
    public IExtensionKind getKind() {
        return this.kind;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public void addPriorities(IPriorityMediator mediator) {
    }

    @Override
    public void addCompatibilities(ICompatibilityMediator mediator) {
    }

    @Override
    public Type synthesizeType(Expression[] childExprs, Predicate[] childPreds, ITypeMediator mediator) {
        return null;
    }

    @Override
    public boolean verifyType(Type proposedType, Expression[] childExprs, Predicate[] childPreds) {
        TypeSubstitution subst = TypeSubstitution.makeSubstitution(this.origin, proposedType);
        if (subst == null) {
            return false;
        }
        assert (childExprs.length == this.arguments.length);
        for (int i = 0; i < childExprs.length; ++i) {
            Type childType;
            Type argType = this.arguments[i].getType(subst);
            if (argType.equals(childType = childExprs[i].getType())) continue;
            return false;
        }
        assert (childPreds.length == 0);
        return true;
    }

    @Override
    public Type typeCheck(ExtendedExpression expression, ITypeCheckMediator tcMediator) {
        TypeSubstitution subst = TypeSubstitution.makeSubstitution(this.origin, tcMediator);
        Expression[] children = expression.getChildExpressions();
        for (int i = 0; i < children.length; ++i) {
            Type childType = children[i].getType();
            Type argType = this.arguments[i].getType(subst);
            tcMediator.sameType(childType, argType);
        }
        return subst.getInstanceType();
    }

    @Override
    public boolean isATypeConstructor() {
        return false;
    }

    @Override
    public Datatype getOrigin() {
        return this.origin;
    }

    public Set<IFormulaExtension> getExtensions() {
        return this.extensions;
    }

    public int hashCode() {
        int prime = 31;
        return 31 * this.name.hashCode() + Arrays.hashCode(this.arguments);
    }

    public boolean isSimilarTo(ConstructorExtension other) {
        if (this == other) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return this.name.equals(other.name) && ConstructorExtension.areSimilarArguments(this.arguments, other.arguments);
    }

    private static boolean areSimilarArguments(ConstructorArgument[] arguments1, ConstructorArgument[] arguments2) {
        if (arguments1.length != arguments2.length) {
            return false;
        }
        for (int i = 0; i < arguments1.length; ++i) {
            if (arguments1[i].isSimilarTo(arguments2[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
        String sep = "[";
        for (ConstructorArgument arg : this.arguments) {
            sb.append(sep);
            sep = "; ";
            arg.toString(sb);
        }
        if (this.arguments.length != 0) {
            sb.append("]");
        }
    }
}

