/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.core.ast;

import java.util.List;
import org.eventb.core.ast.BoundIdentDecl;
import org.eventb.core.ast.BoundIdentifier;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.Formula;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.Predicate;
import org.eventb.core.ast.SourceLocation;
import org.eventb.core.ast.Type;
import org.eventb.internal.core.ast.BoundIdentDeclRemover;
import org.eventb.internal.core.ast.ITypeCheckingRewriter;

abstract class QuantifiedHelper {
    QuantifiedHelper() {
    }

    protected static String getSyntaxTreeQuantifiers(String[] boundBelow, String tabs, BoundIdentDecl[] boundHere) {
        StringBuffer str = new StringBuffer();
        str.append(tabs + "**quantifiers**" + "\n");
        String newTabs = tabs + "\t";
        for (BoundIdentDecl ident : boundHere) {
            str.append(ident.getSyntaxTree(boundBelow, newTabs));
        }
        return str.toString();
    }

    protected static boolean areEqualDecls(BoundIdentDecl[] leftDecls, BoundIdentDecl[] rightDecls) {
        if (leftDecls.length != rightDecls.length) {
            return false;
        }
        for (int i = 0; i < leftDecls.length; ++i) {
            if (leftDecls[i].equalsWithAlphaConversion(rightDecls[i])) continue;
            return false;
        }
        return true;
    }

    static boolean sameType(Type left, Type right) {
        return left == null ? right == null : left.equals(right);
    }

    protected static BoundIdentifier[] getBoundIdentsAbove(BoundIdentifier[] boundIdentsBelow, BoundIdentDecl[] boundIdentDecls, FormulaFactory ff) {
        int nbBoundBelow = boundIdentsBelow.length;
        int nbBound = boundIdentDecls.length;
        for (int i = 0; i < nbBoundBelow; ++i) {
            int index = boundIdentsBelow[i].getBoundIndex();
            if (nbBound > index) continue;
            int length = nbBoundBelow - i;
            BoundIdentifier[] result = new BoundIdentifier[length];
            int j = 0;
            while (j < length) {
                result[j] = ff.makeBoundIdentifier(boundIdentsBelow[i].getBoundIndex() - nbBound, boundIdentsBelow[i].getSourceLocation(), boundIdentsBelow[i].getType());
                ++j;
                ++i;
            }
            return result;
        }
        return Formula.NO_BOUND_IDENT;
    }

    protected static boolean checkBoundIdentTypes(BoundIdentifier[] boundIdentsBelow, BoundIdentDecl[] boundIdentDecls) {
        Formula ident;
        int index;
        int nbBound = boundIdentDecls.length;
        for (BoundIdentDecl decl : boundIdentDecls) {
            if (decl.isTypeChecked()) continue;
            return false;
        }
        Formula[] arr$ = boundIdentsBelow;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && nbBound > (index = ((BoundIdentifier)(ident = arr$[i$])).getBoundIndex()); ++i$) {
            Type declType = ((BoundIdentifier)ident).getDeclaration(boundIdentDecls).getType();
            if (declType.equals(((Expression)ident).getType())) continue;
            return false;
        }
        return true;
    }

    protected static void addUsedBoundIdentifiers(boolean[] used, Formula<?> formula) {
        int lastIndex = used.length - 1;
        for (BoundIdentifier ident : formula.boundIdents) {
            int index = ident.getBoundIndex();
            if (index > lastIndex) continue;
            used[lastIndex - index] = true;
        }
    }

    protected static boolean areAllUsed(boolean[] used) {
        for (boolean element : used) {
            if (element) continue;
            return false;
        }
        return true;
    }

    protected static Predicate getWDSimplifyQ(FormulaFactory formulaFactory, int quant, BoundIdentDecl[] decls, Predicate pred, SourceLocation loc) {
        if (pred.getTag() == 610) {
            return pred;
        }
        boolean[] used = new boolean[decls.length];
        QuantifiedHelper.addUsedBoundIdentifiers(used, pred);
        if (!QuantifiedHelper.areAllUsed(used)) {
            BoundIdentDeclRemover subst = new BoundIdentDeclRemover(decls, used, formulaFactory);
            List<BoundIdentDecl> newDecls = subst.getNewDeclarations();
            Predicate newPred = (Predicate)pred.rewrite(subst);
            if (newDecls.size() == 0) {
                return newPred;
            }
            return formulaFactory.makeQuantifiedPredicate(quant, newDecls, newPred, loc);
        }
        return formulaFactory.makeQuantifiedPredicate(quant, decls, pred, loc);
    }

    protected static BoundIdentDecl[] rewriteDecls(BoundIdentDecl[] decls, ITypeCheckingRewriter rewriter) {
        int length = decls.length;
        BoundIdentDecl[] result = new BoundIdentDecl[length];
        boolean changed = false;
        for (int i = 0; i < length; ++i) {
            result[i] = decls[i].rewrite(rewriter);
            changed |= result[i] != decls[i];
        }
        if (!changed) {
            return decls;
        }
        return result;
    }
}

