/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.liveness;

import tlc2.tool.liveness.LNAll;
import tlc2.tool.liveness.LNBool;
import tlc2.tool.liveness.LNConj;
import tlc2.tool.liveness.LNDisj;
import tlc2.tool.liveness.LNEven;
import tlc2.tool.liveness.LNNeg;
import tlc2.tool.liveness.LNNext;
import tlc2.tool.liveness.LNState;
import tlc2.tool.liveness.LiveExprNode;
import tlc2.tool.liveness.TBTriple;
import tlc2.util.Vect;
import util.Assert;

public class TBPar
extends Vect {
    public TBPar(int i) {
        super(i);
    }

    public final LiveExprNode exprAt(int i) {
        return (LiveExprNode)this.elementAt(i);
    }

    public final boolean equals(TBPar par) {
        return this.contains(par) && par.contains(this);
    }

    public final boolean member(LiveExprNode e) {
        for (int i = 0; i < this.size(); ++i) {
            if (!e.equals(this.exprAt(i))) continue;
            return true;
        }
        return false;
    }

    public final boolean contains(TBPar par) {
        for (int i = 0; i < par.size(); ++i) {
            if (this.member(par.exprAt(i))) continue;
            return false;
        }
        return true;
    }

    public final TBPar union(TBPar par) {
        int i;
        TBPar res = new TBPar(this.size() + par.size());
        for (i = 0; i < this.size(); ++i) {
            if (par.member(this.exprAt(i))) continue;
            res.addElement(this.exprAt(i));
        }
        for (i = 0; i < par.size(); ++i) {
            res.addElement(par.exprAt(i));
        }
        return res;
    }

    public final TBPar append(LiveExprNode ln) {
        TBPar res = new TBPar(this.size() + 1);
        for (int i = 0; i < this.size(); ++i) {
            res.addElement(this.exprAt(i));
        }
        res.addElement(ln);
        return res;
    }

    public final TBPar append(LiveExprNode ln1, LiveExprNode ln2) {
        TBPar res = new TBPar(this.size() + 2);
        for (int i = 0; i < this.size(); ++i) {
            res.addElement(this.exprAt(i));
        }
        res.addElement(ln1);
        res.addElement(ln2);
        return res;
    }

    public final Vect alphaTriples() {
        Vect ts = new Vect();
        for (int i = 0; i < this.size(); ++i) {
            LiveExprNode ln = this.exprAt(i);
            if (ln instanceof LNAll) {
                ts.addElement(new TBTriple(ln, ((LNAll)ln).getBody(), new LNNext(ln)));
                continue;
            }
            if (!(ln instanceof LNConj)) continue;
            LNConj lnc = (LNConj)ln;
            ts.addElement(new TBTriple(lnc, lnc.getBody(0), lnc.getBody(1)));
        }
        return ts;
    }

    public final Vect betaTriples() {
        Vect ts = new Vect();
        for (int i = 0; i < this.size(); ++i) {
            LiveExprNode ln = this.exprAt(i);
            if (ln instanceof LNEven) {
                ts.addElement(new TBTriple(ln, ((LNEven)ln).getBody(), new LNNext(ln)));
                continue;
            }
            if (!(ln instanceof LNDisj)) continue;
            LNDisj lnd = (LNDisj)ln;
            ts.addElement(new TBTriple(lnd, lnd.getBody(0), lnd.getBody(1)));
        }
        return ts;
    }

    public final boolean isLocallyConsistent() {
        int i;
        TBPar pos = new TBPar(this.size());
        TBPar neg = new TBPar(this.size());
        for (i = 0; i < this.size(); ++i) {
            LiveExprNode body;
            LiveExprNode ln = this.exprAt(i);
            if (ln instanceof LNState) {
                pos.addElement(ln);
                continue;
            }
            if (!(ln instanceof LNNeg) || !((body = ((LNNeg)ln).getBody()) instanceof LNState)) continue;
            neg.addElement(body);
        }
        for (i = 0; i < pos.size(); ++i) {
            if (!neg.member(pos.exprAt(i))) continue;
            return false;
        }
        return true;
    }

    public final TBPar positiveClosure() {
        TBPar tps = new TBPar(this.size() * 2);
        for (int i = 0; i < this.size(); ++i) {
            tps.addElement(this.elementAt(i));
        }
        TBPar res = new TBPar(this.size() * 2);
        while (tps.size() > 0) {
            int i;
            LiveExprNode ln = tps.exprAt(tps.size() - 1);
            tps.removeLastElement();
            if (ln instanceof LNNeg) {
                tps.addElement(((LNNeg)ln).getBody());
                continue;
            }
            if (ln instanceof LNNext) {
                res.addElement(ln);
                tps.addElement(((LNNext)ln).getBody());
                continue;
            }
            if (ln instanceof LNEven) {
                res.addElement(ln);
                res.addElement(new LNNext(ln));
                tps.addElement(((LNEven)ln).getBody());
                continue;
            }
            if (ln instanceof LNAll) {
                res.addElement(ln);
                res.addElement(new LNNext(ln));
                tps.addElement(((LNAll)ln).getBody());
                continue;
            }
            if (ln instanceof LNConj) {
                LNConj lnc = (LNConj)ln;
                for (i = 0; i < lnc.getCount(); ++i) {
                    tps.addElement(lnc.getBody(i));
                }
                res.addElement(ln);
                continue;
            }
            if (ln instanceof LNDisj) {
                LNDisj lnd = (LNDisj)ln;
                for (i = 0; i < lnd.getCount(); ++i) {
                    tps.addElement(lnd.getBody(i));
                }
                res.addElement(ln);
                continue;
            }
            if (ln instanceof LNState) {
                res.addElement(ln);
                continue;
            }
            if (ln instanceof LNBool) {
                res.addElement(ln);
                continue;
            }
            Assert.fail(2249);
        }
        return res;
    }

    public final TBPar impliedSuccessors() {
        TBPar successors = new TBPar(this.size());
        for (int i = 0; i < this.size(); ++i) {
            LiveExprNode ln = this.exprAt(i);
            if (!(ln instanceof LNNext)) continue;
            successors.addElement(((LNNext)ln).getBody());
        }
        return successors;
    }

    public final boolean isFulfilling(LNEven promise) {
        return !this.member(promise) || this.member(promise.getBody());
    }

    public final void toString(StringBuffer sb, String padding) {
        sb.append("{");
        String padding1 = padding + " ";
        if (this.size() != 0) {
            ((LiveExprNode)this.elementAt(0)).toString(sb, padding1);
        }
        for (int i = 1; i < this.size(); ++i) {
            sb.append(",\n");
            sb.append(padding1);
            ((LiveExprNode)this.elementAt(i)).toString(sb, padding1);
        }
        sb.append("}");
    }

    @Override
    public final String toString() {
        StringBuffer sb = new StringBuffer();
        this.toString(sb, "");
        return sb.toString();
    }

    public String toDotViz() {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        if (this.size() != 0) {
            LiveExprNode liveExprNode = (LiveExprNode)this.elementAt(0);
            sb.append(liveExprNode.toDotViz());
        }
        for (int i = 1; i < this.size(); ++i) {
            sb.append(",\n");
            LiveExprNode liveExprNode = (LiveExprNode)this.elementAt(i);
            sb.append(liveExprNode.toDotViz());
        }
        sb.append("}");
        return sb.toString().replace("\\", "\\\\");
    }
}

