/*
 * Decompiled with CFR 0.152.
 */
package tlc2.output;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import tlc2.TLCGlobals;
import tlc2.output.MPRecorder;
import tlc2.output.Messages;
import tlc2.output.OutputCollector;
import tlc2.tool.TLCState;
import tlc2.tool.TLCStateInfo;
import tlc2.tool.liveness.LiveWorker;
import tlc2.util.statistics.IBucketStatistics;
import util.DebugPrinter;
import util.Set;
import util.ToolIO;

public class MP {
    public static final String ENDMSG = "ENDMSG ";
    private static final String CR = "\n";
    private static final String SPACE = " ";
    public static final String COLON = ":";
    public static final String DELIM = "@!@!@";
    public static final String STARTMSG = "STARTMSG ";
    private static final String[] EMPTY_PARAMS = new String[0];
    public static final int NONE = 0;
    public static final int ERROR = 1;
    public static final int TLCBUG = 2;
    public static final int WARNING = 3;
    public static final int STATE = 4;
    public static final String NOT_APPLICABLE_VAL = "-1";
    private static MP instance = null;
    private static MPRecorder recorder = new MPRecorder();
    private Set warningHistory = new Set();
    private static final String CONFIG_FILE_ERROR = "TLC found an error in the configuration file at line %1%\n";
    private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final DecimalFormat df = new DecimalFormat("###,###.###");
    private static final boolean DO_DEBUG = Boolean.getBoolean(MP.class.getName() + ".noDebug");

    private MP() {
    }

    private static synchronized String getMessage(int messageClass, int messageCode, String[] parameters) {
        if (parameters == null) {
            parameters = EMPTY_PARAMS;
        }
        OutputCollector.saveMessage(messageClass, messageCode, parameters);
        DebugPrinter.print("entering MP.getMessage() with error code " + messageCode + " and " + parameters.length + " parameters");
        for (int i = 0; i < parameters.length; ++i) {
            DebugPrinter.print("param " + i + ": '" + parameters[i] + "'");
        }
        StringBuffer b = new StringBuffer();
        if (TLCGlobals.tool) {
            b.append(DELIM).append(STARTMSG).append(messageCode).append(COLON).append(messageClass).append(SPACE).append(DELIM).append(CR);
        } else {
            switch (messageClass) {
                case 1: {
                    b.append("Error: ");
                    break;
                }
                case 2: {
                    b.append("TLC Bug: ");
                    break;
                }
                case 4: {
                    b.append("State ");
                    break;
                }
                case 3: {
                    b.append("Warning: ");
                    break;
                }
            }
        }
        switch (messageCode) {
            case -123456: {
                b.append("[%1%][%2%]");
                break;
            }
            case 1005: {
                b.append("This was a Java StackOverflowError. It was probably the result\nof an incorrect recursive function definition that caused TLC to enter\nan infinite loop when trying to compute the function or its application\nto an element in its putative domain.");
                break;
            }
            case 1001: {
                b.append("Java ran out of memory.  Running Java with a larger memory allocation\npool (heap) may fix this.  But it won't help if some state has an enormous\nnumber of successor states, or if TLC must compute the value of a huge set.");
                break;
            }
            case 1002: {
                b.append("Out Of Memory. There are probably too many initial states.");
                break;
            }
            case 2125: {
                b.append("when reading the disk (StatePoolReader.run):\n%1%");
                break;
            }
            case 2126: {
                b.append("TLC encountered the following error while restarting from a checkpoint;\n the checkpoint file is probably corrupted.\n%1%");
                break;
            }
            case 2174: {
                b.append("TLC encountered the following error reading the %1% of unexplored states:\n%2%");
                break;
            }
            case 2175: {
                b.append("TLC encountered the following error writing the %1% of unexplored states:\n%2%");
                break;
            }
            case 2127: {
                b.append("when writing the disk (StatePoolWriter.run):\n%1%");
                break;
            }
            case 2129: {
                b.append("DiskGraph.toString()");
                break;
            }
            case 2137: {
                b.append("File must be not null");
                break;
            }
            case 2138: {
                b.append("Thread has been interrupted.");
                break;
            }
            case 2134: {
                b.append("Index error.");
                break;
            }
            case 2135: {
                b.append("The provided input stream was null, empty or could not be accessed.");
                break;
            }
            case 2167: {
                b.append("Unable to open %1%.\n%2%");
                break;
            }
            case 2160: {
                b.append("Unable not rename file during the clean-up.");
                break;
            }
            case 2161: {
                b.append("Disk I/O error accessing the file for %1%.");
                break;
            }
            case 2162: {
                b.append("TLC writes its files to a directory whose name is generated from the current time.\nThis directory should be %1%, but that directory already exists.\nTrying to run TLC again will probably fix this problem.");
                break;
            }
            case 2163: {
                b.append("TLC could not make a directory %1% for the disk files it needs to write.");
                break;
            }
            case 1102: {
                b.append("%1%\nUsage: java tlc2.TLC [-option] inputfile");
                break;
            }
            case 1101: {
                b.append("%1%\nUsage: java tlc2.Simulator [-option] inputfile");
                break;
            }
            case 2263: {
                b.append(Messages.getString("HelpMessage"));
                break;
            }
            case 2262: {
                b.append("TLC2 %1%");
                break;
            }
            case 2001: {
                b.append("error while formating %1%\n%2%");
                break;
            }
            case 2000: {
                b.append("error while parsing %1%\n%2%");
                break;
            }
            case 2100: {
                b.append("TLC writes its files to a directory which name is generated from the current time.\nThis directory should be %1%, but that directory already exists.\nTrying to run TLC again will probably fix this problem.\n");
                break;
            }
            case 2101: {
                b.append("TLC could not make a directory for the disk files it needs to write.\n");
                break;
            }
            case 2102: {
                b.append("%1%\nWhile working on the initial state:\n%2%");
                break;
            }
            case 2103: {
                b.append("The error occurred when TLC was evaluating the nested\nexpressions at the following positions:\n%1%");
                break;
            }
            case 2104: {
                b.append("Assumption %1% is false.");
                break;
            }
            case 2220: {
                b.append("Starting SANY...");
                break;
            }
            case 2219: {
                b.append("SANY finished.");
                break;
            }
            case 2105: {
                b.append("Evaluating assumption %1% failed.\n%2%");
                break;
            }
            case 2106: {
                b.append("State is not completely specified by the initial predicate:\n%2%");
                break;
            }
            case 2107: {
                b.append("Invariant %1% is violated by the initial state:\n%2%");
                break;
            }
            case 2108: {
                b.append("Property %1% is violated by the initial state:\n%2%");
                break;
            }
            case 2109: {
                b.append("Successor state is not completely specified by the next-state action.\n");
                break;
            }
            case 2110: {
                b.append("Invariant %1% is violated.");
                break;
            }
            case 2111: {
                b.append("Evaluating invariant %1% failed.");
                break;
            }
            case 2112: {
                b.append("Action property %1% is violated.");
                break;
            }
            case 2113: {
                b.append("Evaluating action property %1% failed.");
                break;
            }
            case 2114: {
                b.append("Deadlock reached.");
                break;
            }
            case 2264: {
                b.append("The following behavior constitutes a counter-example:\n");
                break;
            }
            case 2116: {
                b.append("Temporal properties were violated.\n");
                break;
            }
            case 2117: {
                b.append("Failed to recover the next state from its fingerprint.");
                break;
            }
            case 2123: {
                b.append("Failed to recover the initial state from its fingerprint.");
                break;
            }
            case 2128: {
                b.append("This is probably a TLC bug(%1%).");
                break;
            }
            case 2118: {
                b.append("There is no state satisfying the initial state predicate.");
                break;
            }
            case 2119: {
                b.append("This is a TLC bug: TLC could not find its built-in String module.\n");
                break;
            }
            case 2122: {
                if (TLCGlobals.tool) {
                    b.append("%1%: Back to state.\n");
                    break;
                }
                b.append("Back to state %1%.\n");
                break;
            }
            case 2120: {
                b.append("The error state is:\n");
                break;
            }
            case 2121: {
                b.append("The behavior up to this point is:");
                break;
            }
            case 2124: {
                b.append("Progress report thread died.");
                break;
            }
            case 2130: {
                b.append("AAAAAA");
                break;
            }
            case 2131: {
                b.append("TLA+ Registry initialization error. The name %1% is already in use.");
                break;
            }
            case 3000: {
                b.append("TLC failed in checking traces.");
                break;
            }
            case 3101: {
                b.append("Usage: java tlc2.tool.CheckImplFile [-option] inputfile");
                break;
            }
            case 3102: {
                b.append("Missing input TLA+ module.");
                break;
            }
            case 3100: {
                b.append("Expect a file name for -config option.");
                break;
            }
            case 3103: {
                b.append("need to specify the metadata directory for recovery.");
                break;
            }
            case 3104: {
                b.append("Worker number required. But encountered %1%");
                break;
            }
            case 3105: {
                b.append("At least one worker is required.");
                break;
            }
            case 3106: {
                b.append("Expect an integer for -workers option.");
                break;
            }
            case 3107: {
                b.append("Depth must be an integer. But encountered %1%");
                break;
            }
            case 3108: {
                b.append("Expect an integer for -depth option.");
                break;
            }
            case 3109: {
                b.append("Expect a filename for -trace option.");
                break;
            }
            case 3110: {
                b.append("An integer for coverage report interval required. But encountered %1%");
                break;
            }
            case 3111: {
                b.append("Coverage report interval required.");
                break;
            }
            case 3112: {
                b.append("Expect a nonnegative integer for -coverage option.");
                break;
            }
            case 3113: {
                b.append("Unrecognized option: %1%");
                break;
            }
            case 3114: {
                b.append("More than one input files: %1% and %2%");
                break;
            }
            case 3001: {
                b.append("TLC could not read in the trace. %1%");
                break;
            }
            case 3002: {
                b.append("Parsing or semantic analysis failed.");
                break;
            }
            case 2171: {
                b.append("Parsing or semantic analysis failed.%1%");
                break;
            }
            case 2132: {
                b.append("The first argument of Assert evaluated to FALSE; the second argument was:\n%1%");
                break;
            }
            case 2133: {
                b.append("The fingerprint is not in set.");
                break;
            }
            case 2211: {
                b.append("%1%, work completed. Thank you!");
                break;
            }
            case 2136: {
                b.append("Parameter must be a postfix operator");
                break;
            }
            case 2139: {
                b.append("TLC could not determine if the subscript of the next-state relation contains\nall state variables. Proceed with fingers crossed.");
                break;
            }
            case 2140: {
                b.append("The subscript of the next-state relation specified by the specification\ndoes not seem to contain the state variable %1%");
                break;
            }
            case 2141: {
                b.append("Tuple field name %1% is not an integer.");
                break;
            }
            case 2142: {
                b.append("Record field name %1% is not a string.");
                break;
            }
            case 2143: {
                b.append("The variable %1% was changed while it is specified as UNCHANGED at\n%2%");
                break;
            }
            case 2144: {
                b.append("The EXCEPT was applied to non-existing fields of the value at\n%1%");
                break;
            }
            case 2145: {
                b.append("TLCGet(%1%) was undefined.");
                break;
            }
            case 2178: {
                b.append("Overflow when computing %1%");
                break;
            }
            case 2169: {
                b.append("The %1% argument of %2% should be a %3%, but instead it is:\n%4%");
                break;
            }
            case 2266: {
                b.append("The %1% argument of %2% should be an %3%, but instead it is:\n%4%");
                break;
            }
            case 2183: {
                b.append("The %1% argument of %2% must be in the domain of its %3% argument:\n%4%\n, but instead it is\n%5%");
                break;
            }
            case 2179: {
                b.append("The second argument of \\div is 0.");
                break;
            }
            case 2180: {
                b.append("0^0 is undefined.");
                break;
            }
            case 2176: {
                b.append("Applying %1% to the following value,\nwhich is not %2%:\n%3%");
                break;
            }
            case 2155: {
                b.append("Attempted to compare %1% with the value\n%2%");
                break;
            }
            case 2184: {
                b.append("Attempted to apply %1% to the empty sequence.");
                break;
            }
            case 2158: {
                b.append("Attempted to check if the value:\n%1%\nis an element of %2%.");
                break;
            }
            case 2177: {
                b.append("Attemtped to apply BagUnion to the following set, whose\nelement is not a bag:\n%1%");
                break;
            }
            case 2157: {
                b.append("Attemtped to apply TransitiveClosure to a set containing\nthe following value:\n%1%");
                break;
            }
            case 2181: {
                b.append("Attemtped to compute cardinality of the value\n%1%");
                break;
            }
            case 2182: {
                b.append("Evaluating an expression of the form %1% when s is not a %2%:\n%3%");
                break;
            }
            case 2154: {
                b.append("Attempted to apply the operator overridden by the Java method\n%1%,\nbut it produced the following error:\n%2%");
                break;
            }
            case 2159: {
                b.append("BEGraph.GetPath: Failed to construct a path.");
                break;
            }
            case 2212: {
                b.append("Implied-temporal checking--satisfiability problem has %1% branches.");
                break;
            }
            case 2213: {
                b.append("TLC cannot handle the temporal formula %1%");
                break;
            }
            case 2214: {
                b.append("Temporal formulas containing actions must be of forms <>[]A or []<>A.");
                break;
            }
            case 2249: {
                b.append("TLC encountered actions when computing closure.");
                break;
            }
            case 2250: {
                b.append("A state predicate was evaluated to a non-boolean value.");
                break;
            }
            case 2251: {
                b.append("Can not evaluate a temporal formula %1%F.");
                break;
            }
            case 2252: {
                b.append("Encountered an action predicate that's not a boolean.");
                break;
            }
            case 2215: {
                b.append("TLC expected a %1% value, but did not find one. %2%");
                break;
            }
            case 2246: {
                b.append("TLC expected a %1% expression, but did not find one.\n%2%");
                break;
            }
            case 2247: {
                b.append("In computing %1%, TLC expected a %2% expression,\nbut instead found %3%.\n%4%");
                break;
            }
            case 2248: {
                b.append("In computing %1%, TLC expected a %2% expression,\nbut didn't find one.\n%3%");
                break;
            }
            case 2164: {
                b.append("The arguments to %1% are not appropriate.");
                break;
            }
            case 2165: {
                b.append("Choose can only deal with numbers up to %1%");
                break;
            }
            case 2166: {
                b.append("DiskFPSet.mergeNewEntries: %1% is already on disk.\n");
                break;
            }
            case 4000: {
                b.append("TLA+ Parser sanity check.");
                break;
            }
            case 4001: {
                b.append("TLA+ Parser check: Assertion error in epa().");
                break;
            }
            case 4002: {
                b.append("TLA+ Parser check: Assertion error in SBracketCases().");
                break;
            }
            case 2170: {
                b.append("Argument mismatch in operator application.%1");
                break;
            }
            case 2172: {
                b.append("Too many possible next states for the last state in the trace.");
                break;
            }
            case 2173: {
                b.append("Found a Java class for module %1%, but unable to read\nit as a Java class object. %2%");
                break;
            }
            case 7000: {
                b.append("TLC server at %1% is ready (").append(SDF.format(new Date())).append(")");
                break;
            }
            case 7001: {
                b.append("Registration for worker at %1% completed (").append(SDF.format(new Date())).append(")");
                break;
            }
            case 7002: {
                b.append("TLC worker %1% disconnected (").append(SDF.format(new Date())).append(")");
                break;
            }
            case 7003: {
                b.append("Worker: %1% Sent: %2% Rcvd: %3% CacheRatio: %4% (").append(SDF.format(new Date())).append(")");
                break;
            }
            case 7004: {
                b.append("TLCServer is gone due to %1%, exiting worker... (").append(SDF.format(new Date())).append(")");
                break;
            }
            case 7010: {
                b.append("TLCServer has finished, exiting worker... (").append(SDF.format(new Date())).append(")");
                break;
            }
            case 7005: {
                b.append("VM does not allow to get the UnicastRef port.\nWorker will be identified with port 0 in output (").append(SDF.format(new Date())).append(")");
                break;
            }
            case 7006: {
                b.append("TLC worker connection lost %1% (").append(SDF.format(new Date())).append(")");
                break;
            }
            case 7007: {
                b.append("Trying to limit max block size (to recover from transport failure): %1% (").append(SDF.format(new Date())).append(")");
                break;
            }
            case 7009: {
                b.append("%1% out of %2% FPSet server(s) registered (").append(SDF.format(new Date())).append(")");
                break;
            }
            case 7008: {
                b.append("Waiting for %1% FPSet server(s) to register (").append(SDF.format(new Date())).append(")");
                break;
            }
            case 2185: {
                b.append("Starting... (").append(SDF.format(new Date())).append(")");
                break;
            }
            case 2186: {
                b.append("Finished. (").append(SDF.format(new Date())).append(")");
                break;
            }
            case 2187: {
                b.append("Running in Model-Checking mode.");
                break;
            }
            case 2188: {
                b.append("Running Random Simulation with seed %1%.");
                break;
            }
            case 2189: {
                b.append("Computing initial states...");
                break;
            }
            case 2190: {
                b.append("Finished computing initial states: %1% distinct state%2% generated.");
                break;
            }
            case 2191: {
                b.append("Finished computing initial states: %1% states generated, with %2% of them distinct.");
                break;
            }
            case 2207: {
                b.append("Finished computing initial states: %1% states generated.\nBecause TLC recovers from a previous checkpoint, only %2% of them require further exploration.");
                break;
            }
            case 2208: {
                b.append("Finished computing initial states: %1% states generated, with %2% of them distinct.");
                break;
            }
            case 2192: {
                b.append("Checking temporal properties for the %1% state space with %2% distinct states at (").append(SDF.format(new Date())).append(")");
                break;
            }
            case 2193: {
                b.append("Model checking completed. No error has been found.\n  Estimates of the probability that TLC did not check all reachable states\n  because two distinct states had the same fingerprint:\n  calculated (optimistic):  %1%\n  based on the actual fingerprints:  %2%");
                break;
            }
            case 2194: {
                b.append("The depth of the complete state graph search is %1%.");
                break;
            }
            case 2195: {
                b.append("Checkpointing of run %1%");
                break;
            }
            case 2196: {
                b.append("Checkpointing completed at (").append(SDF.format(new Date())).append(")");
                break;
            }
            case 2197: {
                b.append("Starting recovery from checkpoint %1%");
                break;
            }
            case 2198: {
                b.append("Recovery completed. %1% states examined. %2% states on queue.");
                break;
            }
            case 2203: {
                b.append("Recovery completed. %1% states examined.");
                break;
            }
            case 2199: {
                b.append("%1% states generated, %2% distinct states found, %3% states left on queue.");
                break;
            }
            case 2204: {
                b.append("%1% states generated, %2% distinct states found.");
                break;
            }
            case 2210: {
                b.append("The number of states generated: %1%\nSimulation using seed %2% and aril %3%");
                break;
            }
            case 2200: {
                b.append("Progress(%1%) at " + SDF.format(new Date()) + ": %2% states generated (" + df.format(Long.valueOf(parameters[4])) + " s/min), %3% distinct states found (" + df.format(Long.valueOf(parameters[5])) + " ds/min), %4% states left on queue.");
                break;
            }
            case 2205: {
                b.append("Starting level %1%: %2% states generated, %3% distinct states found.");
                break;
            }
            case 2206: {
                if (TLCGlobals.tool) {
                    b.append("Progress(-1) at " + SDF.format(new Date()) + ": %1% states generated, %2% distinct states found, " + NOT_APPLICABLE_VAL + " states left on queue.");
                    break;
                }
                b.append("Progress: %1% states generated, %2% distinct states found.");
                break;
            }
            case 2209: {
                if (TLCGlobals.tool) {
                    b.append("Progress(-1) at " + SDF.format(new Date()) + ": %1% states generated, " + NOT_APPLICABLE_VAL + " distinct states found, " + NOT_APPLICABLE_VAL + " states left on queue.");
                    break;
                }
                b.append("Progress: %1% states checked.");
                break;
            }
            case 2201: {
                b.append("The coverage statistics at " + SDF.format(new Date()));
                break;
            }
            case 2221: {
                b.append("  %1%: %2%");
                break;
            }
            case 2202: {
                b.append("End of statistics.");
                break;
            }
            case 2222: {
                b.append("The constant parameter %1% is not assigned a value by the configuration file.");
                break;
            }
            case 2223: {
                b.append("In the configuration file, the identifier %1% appears\non the right-hand side of a <- after already appearing on the\nleft-hand side of one.");
                break;
            }
            case 2224: {
                b.append("The configuration file substitutes for %1% with the undefined identifier %2%.");
                break;
            }
            case 2225: {
                b.append("The configuration file substitutes for %1% with %2% of different number of arguments.");
                break;
            }
            case 2226: {
                b.append("In the configuration file, the identifier %1% does not appear in the specification.");
                break;
            }
            case 2227: {
                b.append("The configuration file cannot specify both INIT/NEXT and SPECIFICATION fields.");
                break;
            }
            case 2228: {
                b.append("TLC requires %1% not to take any argument.");
                break;
            }
            case 2229: {
                b.append("The %1% %2% specified in the configuration file\nis not defined in the specification.");
                break;
            }
            case 2230: {
                b.append("The %1% of %2% is equal to %3%");
                break;
            }
            case 2231: {
                b.append("The configuration file did not specify the initial state predicate.\nCan also be caused by trying to run TLC on a specification from\na module imported with a parameterized INSTANCE statement.");
                break;
            }
            case 2232: {
                b.append("The configuration file did not specify the next state predicate.");
                break;
            }
            case 2233: {
                b.append("The %1% %2% cannot be a constant.");
                break;
            }
            case 2234: {
                b.append("The operator %1% cannot take any argument.");
                break;
            }
            case 2235: {
                b.append("The operator %1% is not defined in the spec.");
                break;
            }
            case 2236: {
                b.append("The operator %1%, which equals %2%,\ncannot be used as a %3%");
                break;
            }
            case 2237: {
                b.append("The spec is trivially false because %1% is false.");
                break;
            }
            case 2238: {
                b.append("TLC cannot handle subscript %1%");
                break;
            }
            case 2239: {
                b.append("TLC cannot handle this conjunct of the spec:\n%1%");
                break;
            }
            case 2240: {
                b.append("The specification contains more than one conjunct of the form [][Next]_v,\nbut TLC can handle only specifications with one next-state relation.");
                break;
            }
            case 2241: {
                b.append("The property %1% is not correctly defined.");
                break;
            }
            case 2242: {
                b.append("The arity of the operator %1% is inconsistent in the configuration file.");
                break;
            }
            case 2243: {
                b.append("The configuration file did not specify types for state variables.");
                break;
            }
            case 2244: {
                b.append("TLC can't handle real numbers.\n%1%");
                break;
            }
            case 2265: {
                b.append("TLC can't handle a number this big.\n%1%");
                break;
            }
            case 2245: {
                b.append("In the configuration file, the module name %1% is not a module in the specification.");
                break;
            }
            case 2260: {
                b.append("In computing ENABLED, TLC encountered a temporal formula (%1%).\n%2%");
                break;
            }
            case 2261: {
                b.append("TLC encountered a temporal formula (%1%) when evaluating a predicate or action.\n%2%");
                break;
            }
            case 2216: {
                b.append("%1%:\n%2%");
                break;
            }
            case 2217: {
                b.append("%1%: %2%\n%3%");
                break;
            }
            case 2218: {
                b.append("%1%: Stuttering");
                break;
            }
            case 5003: {
                b.append(CONFIG_FILE_ERROR);
                b.append("The keyword %2% was not followed by an identifier.");
                break;
            }
            case 5004: {
                b.append(CONFIG_FILE_ERROR);
                b.append("The keyword %2% appeared twice.");
                break;
            }
            case 5005: {
                b.append(CONFIG_FILE_ERROR);
                b.append("Expected an identifier after %2%.");
                break;
            }
            case 5002: {
                b.append(CONFIG_FILE_ERROR);
                break;
            }
            case 5006: {
                b.append(CONFIG_FILE_ERROR);
                b.append("It was expecting %2%, but did not find it.");
                break;
            }
            case 5001: {
                b.append("TLC encountered the following error when trying to read the configuration file %1%:\n%2%");
                break;
            }
            case 1000: {
                for (int i = 0; i < parameters.length; ++i) {
                    b.append("%" + (i + 1) + "%");
                }
                break;
            }
            default: {
                b.append("Wrong invocation of TLC error printer. Error code not found.");
            }
        }
        MP.replaceString(b, parameters);
        if (TLCGlobals.tool) {
            b.append(CR).append(DELIM).append(ENDMSG).append(messageCode).append(SPACE).append(DELIM);
        } else {
            switch (messageClass) {
                case 3: {
                    b.append("\n(Use the -nowarning option to disable this warning.)");
                    break;
                }
                case 1: {
                    if (!TLCGlobals.tool) break;
                    b.append("\n--End Error.");
                    break;
                }
            }
        }
        DebugPrinter.print("Leaving getMessage()");
        return b.toString();
    }

    public static String getError(int errorCode) {
        return MP.getError(errorCode, EMPTY_PARAMS);
    }

    public static String getError(int errorCode, String parameter) {
        return MP.getError(errorCode, new String[]{parameter});
    }

    public static String getError(int errorCode, String[] parameters) {
        return MP.getMessage(1, errorCode, parameters);
    }

    public static String getMessage(int errorCode) {
        return MP.getMessage(errorCode, EMPTY_PARAMS);
    }

    public static String getMessage(int errorCode, String parameter) {
        return MP.getMessage(errorCode, new String[]{parameter});
    }

    public static String getMessage(int errorCode, String[] parameters) {
        return MP.getMessage(0, errorCode, parameters);
    }

    public static String getTLCBug(int errorCode) {
        return MP.getMessage(2, errorCode, EMPTY_PARAMS);
    }

    public static void printError(int errorCode) {
        MP.printError(errorCode, EMPTY_PARAMS);
    }

    public static void printError(int errorCode, String parameter) {
        MP.printError(errorCode, new String[]{parameter});
    }

    public static void printError(int errorCode, String[] parameters) {
        recorder.record(errorCode, parameters);
        DebugPrinter.print("entering printError(int, String[]) with errorCode " + errorCode);
        ToolIO.out.println(MP.getMessage(1, errorCode, parameters));
        DebugPrinter.print("leaving printError(int, String[])");
    }

    private static void printError(int errorCode, String cause, Throwable throwable, boolean includeStackTrace) {
        MP.printError(errorCode, cause);
        if (includeStackTrace && TLCGlobals.debug) {
            DebugPrinter.print("printing stacktrace in printError(int, Throwable, boolean)");
            throwable.printStackTrace(ToolIO.out);
        }
    }

    public static void printError(int errorCode, String[] cause, Throwable throwable) {
        MP.printError(errorCode, cause);
        if (TLCGlobals.debug) {
            DebugPrinter.print("printing stacktrace in printError(int, Throwable, boolean)");
            throwable.printStackTrace(ToolIO.out);
        }
    }

    public static void printError(int errorCode, String cause, Throwable throwable) {
        if (errorCode == 1000) {
            MP.printError(errorCode, MP.ECGeneralMsg(cause, throwable));
        } else {
            MP.printError(errorCode, cause, throwable, true);
        }
    }

    public static String ECGeneralMsg(String cause, Throwable throwable) {
        String msg = "TLC threw an unexpected exception.";
        msg = msg + "\nThis was probably caused by an error in the spec or model.";
        msg = cause.equals("") ? msg + "\nSee the User Output or TLC Console for clues to what happened." : msg + "\nThe error occurred when TLC was " + cause + ".";
        msg = msg + "\nThe exception was a " + throwable.getClass().getName();
        if (throwable.getMessage() != null) {
            msg = msg + ": " + throwable.getMessage();
            if (DO_DEBUG) {
                msg = msg + MP.throwableToString(throwable);
            }
        } else {
            msg = msg + MP.throwableToString(throwable);
        }
        return msg;
    }

    private static String throwableToString(Throwable e) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        e.printStackTrace(printWriter);
        return ((Object)result).toString();
    }

    public static void printError(int errorCode, Throwable cause) {
        if (errorCode == 1000) {
            MP.printError(errorCode, "", cause);
        } else {
            MP.printError(errorCode, cause.getMessage(), cause, true);
        }
    }

    public static void printMessage(int errorCode) {
        MP.printMessage(errorCode, EMPTY_PARAMS);
    }

    public static void printMessage(int errorCode, String parameter) {
        MP.printMessage(errorCode, new String[]{parameter});
    }

    public static void printMessage(int errorCode, String[] parameters) {
        recorder.record(errorCode, parameters);
        DebugPrinter.print("entering printMessage(int, String[]) with errorCode " + errorCode);
        ToolIO.out.println(MP.getMessage(0, errorCode, parameters));
        DebugPrinter.print("leaving printError(int, String[]) with errorCode ");
    }

    public static void printState(int code, String[] parameters, TLCState state, int num) {
        recorder.record(code, new TLCStateInfo(state, ""), num);
        DebugPrinter.print("entering printState(String[])");
        ToolIO.out.println(MP.getMessage(4, code, parameters));
        DebugPrinter.print("leaving printState(String[])");
    }

    public static void printState(int code, String[] parameters, TLCStateInfo stateInfo, int num) {
        recorder.record(code, stateInfo, num);
        DebugPrinter.print("entering printState(String[])");
        ToolIO.out.println(MP.getMessage(4, code, parameters));
        DebugPrinter.print("leaving printState(String[])");
    }

    public static void printTLCBug(int errorCode, String[] parameters) {
        recorder.record(errorCode, parameters);
        DebugPrinter.print("entering printTLCBug(int, String[]) with errorCode " + errorCode);
        ToolIO.out.println(MP.getMessage(2, errorCode, parameters));
        DebugPrinter.print("leaving printTLCBug(int, String[])");
    }

    public static void printWarning(int errorCode, String parameter) {
        MP.printWarning(errorCode, new String[]{parameter});
    }

    public static void printWarning(int errorCode, String[] parameters) {
        String message;
        recorder.record(errorCode, parameters);
        DebugPrinter.print("entering printWarning(int, String[]) with errorCode " + errorCode);
        if (TLCGlobals.warn && MP.instance.warningHistory.put(message = MP.getMessage(3, errorCode, parameters)) == null) {
            ToolIO.out.println(message);
        }
        DebugPrinter.print("leaving printWarning(int, String[])");
    }

    public static void printWarning(int errorCode, String parameters, Throwable e) {
        recorder.record(errorCode, parameters, e);
        DebugPrinter.print("entering printWarning(int, String, Exception) with errorCode " + errorCode);
        if (TLCGlobals.warn) {
            String message = MP.getMessage(3, errorCode, new String[]{parameters});
            if (MP.instance.warningHistory.put(message) == null) {
                ToolIO.out.println(message);
            }
            DebugPrinter.print("printing stacktrace in printError(int, Throwable, boolean)");
            e.printStackTrace(ToolIO.out);
        }
        DebugPrinter.print("leaving printWarning(int, String[])");
    }

    public static void printStats(IBucketStatistics inDegree, IBucketStatistics outDegree) {
        ToolIO.out.println(outDegree);
        ToolIO.out.println(inDegree);
        ToolIO.out.println(LiveWorker.STATS.toString());
        ToolIO.out.println(String.format("%s SCC%s found during liveness checking.", LiveWorker.STATS.getObservations(), LiveWorker.STATS.getObservations() > 1L ? "s" : ""));
    }

    public static StringBuffer replaceString(StringBuffer buffer, String[] parameters) {
        int placeHolderPosition = -1;
        String placeHolder = null;
        for (int i = 0; i < parameters.length && parameters[i] != null && (placeHolderPosition = buffer.indexOf(placeHolder = "%" + (i + 1) + "%")) != -1; ++i) {
            buffer.replace(placeHolderPosition, placeHolderPosition + placeHolder.length(), parameters[i]);
        }
        return buffer;
    }

    public static void flush() {
        ToolIO.out.flush();
        ToolIO.err.flush();
    }

    public static void setRecorder(MPRecorder aRecorder) {
        recorder = aRecorder;
    }

    static {
        instance = new MP();
    }
}

