/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.semantic;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import tla2sany.semantic.AbortException;
import tla2sany.semantic.FormalParamNode;
import tla2sany.semantic.LevelNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.OpDeclNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.ThmOrAssumpDefNode;
import tla2sany.st.TreeNode;
import tla2sany.xml.SymbolContext;
import util.UniqueString;

public abstract class SymbolNode
extends LevelNode {
    protected final UniqueString name;

    protected SymbolNode(int kind, TreeNode stn, UniqueString name) {
        super(kind, stn);
        this.name = name;
    }

    public final UniqueString getName() {
        return this.name;
    }

    public abstract int getArity();

    public abstract boolean isLocal();

    public abstract boolean match(OpApplNode var1, ModuleNode var2) throws AbortException;

    public final boolean occur(SymbolNode[] params) {
        for (int i = 0; i < params.length; ++i) {
            if (this != params[i]) continue;
            return true;
        }
        return false;
    }

    public final boolean isParam() {
        return this instanceof OpDeclNode || this instanceof FormalParamNode;
    }

    public final boolean sameOriginallyDefinedInModule(SymbolNode otherNode) {
        if (this.getClass() == otherNode.getClass()) {
            ModuleNode thisModule = null;
            if (this instanceof OpDefNode) {
                OpDefNode thisSrc = ((OpDefNode)this).getSource();
                if (thisSrc != ((OpDefNode)otherNode).getSource()) {
                    return false;
                }
                thisModule = thisSrc.getOriginallyDefinedInModuleNode();
            } else if (this instanceof ThmOrAssumpDefNode) {
                ThmOrAssumpDefNode thisSrc = ((ThmOrAssumpDefNode)this).getSource();
                if (thisSrc != ((ThmOrAssumpDefNode)otherNode).getSource()) {
                    return false;
                }
                thisModule = thisSrc.getOriginallyDefinedInModuleNode();
            } else {
                return false;
            }
            return thisModule == null || thisModule.getConstantDecls().length == 0 && thisModule.getVariableDecls().length == 0;
        }
        return false;
    }

    public Element exportDefinition(Document doc, SymbolContext context) {
        try {
            Element e = this.getSymbolElement(doc, context);
            try {
                Element l = this.appendText(doc, "level", Integer.toString(this.getLevel()));
                e.insertBefore(l, e.getFirstChild());
            }
            catch (RuntimeException ee) {
                // empty catch block
            }
            try {
                Element loc = this.getLocationElement(doc);
                e.insertBefore(loc, e.getFirstChild());
            }
            catch (RuntimeException ee) {
                // empty catch block
            }
            return e;
        }
        catch (RuntimeException ee) {
            System.err.println("failed for node.toString(): " + this.toString() + "\n with error ");
            ee.printStackTrace();
            throw ee;
        }
    }

    protected abstract Element getSymbolElement(Document var1, SymbolContext var2);

    protected abstract String getNodeRef();

    @Override
    protected Element getLevelElement(Document doc, SymbolContext context) {
        throw new UnsupportedOperationException("This should not be possible and therefore a bug");
    }

    @Override
    public Element export(Document doc, SymbolContext context) {
        context.put(this, doc);
        Element e = doc.createElement(this.getNodeRef());
        e.appendChild(this.appendText(doc, "UID", Integer.toString(this.myUID)));
        return e;
    }
}

