/*
 * Decompiled with CFR 0.152.
 */
package pcal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import pcal.exception.PcalResourceFileReaderException;

public class PcalResourceFileReader {
    private boolean done = false;
    private BufferedReader inputReader;
    private String name;

    public PcalResourceFileReader(String fileName) throws PcalResourceFileReaderException {
        this.name = fileName;
        Class<?> cl = null;
        try {
            cl = Class.forName("pcal.AST");
        }
        catch (ClassNotFoundException e) {
            throw new PcalResourceFileReaderException("Java could not find class pcal.AST.  There \n    is probably something wrong with the way\n    the +cal translator is installed");
        }
        InputStream input = cl.getResourceAsStream(fileName);
        if (input == null) {
            throw new PcalResourceFileReaderException("Could not find resource file " + fileName + ".\n" + "    There is probably something wrong with the way\n" + "    the +cal translator is installed");
        }
        this.inputReader = new BufferedReader(new InputStreamReader(input));
    }

    public static Vector ResourceFileToStringVector(String fileName) throws PcalResourceFileReaderException {
        Vector<String> inputVec = new Vector<String>(100);
        PcalResourceFileReader wordFileReader = new PcalResourceFileReader(fileName);
        String word = wordFileReader.getLine();
        while (word != null) {
            inputVec.addElement(word);
            word = wordFileReader.getLine();
        }
        wordFileReader.close();
        return inputVec;
    }

    public String getLine() throws PcalResourceFileReaderException {
        try {
            return this.inputReader.readLine();
        }
        catch (IOException e) {
            throw new PcalResourceFileReaderException("Error reading the +cal translator resource file " + this.name + ".\n" + "    You may be having file system problems");
        }
    }

    public void close() throws PcalResourceFileReaderException {
        try {
            this.inputReader.close();
        }
        catch (IOException e) {
            throw new PcalResourceFileReaderException("Error trying to close the +cal translator resource file " + this.name + ".\n" + "    You may be having file system problems");
        }
    }
}

