/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.parser.operators;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class AllInOnceMap<K, V> {
    private final Map<K, V> map = new HashMap();

    public V get(K key) {
        V value = this.map.get(key);
        if (value == null) {
            throw new IllegalArgumentException("no value set for key: " + key);
        }
        return value;
    }

    public V getNoCheck(K key) {
        return this.map.get(key);
    }

    public void put(K key, V value) {
        V oldValue = this.map.put(key, value);
        if (oldValue != null && oldValue != value) {
            throw new IllegalArgumentException("trying to override value for: " + key);
        }
    }

    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    public Collection<V> values() {
        return Collections.unmodifiableCollection(this.map.values());
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return Collections.unmodifiableSet(this.map.entrySet());
    }

    public Map<V, K> invert() {
        HashMap<V, K> inverted = new HashMap<V, K>();
        for (Map.Entry<K, V> entry : this.map.entrySet()) {
            inverted.put(entry.getValue(), entry.getKey());
        }
        return inverted;
    }
}

