/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast.datatype;

import org.eventb.core.ast.AtomicExpression;
import org.eventb.core.ast.BoundIdentDecl;
import org.eventb.core.ast.BoundIdentifier;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.ExtendedExpression;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.core.ast.Predicate;
import org.eventb.core.ast.SetExtension;
import org.eventb.core.ast.SourceLocation;
import org.eventb.core.ast.Type;
import org.eventb.core.ast.datatype.IDatatype;
import org.eventb.core.ast.extension.IExpressionExtension;
import org.eventb.internal.core.ast.DefaultTypeCheckingRewriter;
import org.eventb.internal.core.ast.datatype.DatatypeTranslation;

public class DatatypeRewriter
extends DefaultTypeCheckingRewriter {
    private final DatatypeTranslation translation;

    public DatatypeRewriter(DatatypeTranslation translation) {
        super(translation.getTargetFormulaFactory());
        this.translation = translation;
    }

    @Override
    public BoundIdentDecl rewrite(BoundIdentDecl decl) {
        Type type = decl.getType();
        Type newType = this.translation.translate(type);
        if (newType == type) {
            return super.rewrite(decl);
        }
        String name = decl.getName();
        SourceLocation sLoc = decl.getSourceLocation();
        return this.ff.makeBoundIdentDecl(name, sLoc, newType);
    }

    @Override
    public Expression rewrite(AtomicExpression expression) {
        Type type = expression.getType();
        Type newType = this.translation.translate(type);
        if (newType == type) {
            return super.rewrite(expression);
        }
        SourceLocation sLoc = expression.getSourceLocation();
        return this.ff.makeAtomicExpression(expression.getTag(), sLoc, newType);
    }

    @Override
    public Expression rewrite(BoundIdentifier identifier) {
        Type type = identifier.getType();
        Type newType = this.translation.translate(type);
        if (newType == type) {
            return super.rewrite(identifier);
        }
        SourceLocation sLoc = identifier.getSourceLocation();
        int index = identifier.getBoundIndex();
        return this.ff.makeBoundIdentifier(index, sLoc, newType);
    }

    @Override
    public Expression rewrite(FreeIdentifier ident) {
        Type type = ident.getType();
        Type newType = this.translation.translate(type);
        if (newType == type) {
            return super.rewrite(ident);
        }
        SourceLocation sLoc = ident.getSourceLocation();
        String name = ident.getName();
        return this.ff.makeFreeIdentifier(name, sLoc, newType);
    }

    @Override
    public Expression rewrite(SetExtension src, SetExtension expr) {
        if (expr.getChildCount() != 0) {
            return expr;
        }
        Type type = expr.getType();
        Type newType = this.translation.translate(type);
        if (newType == type) {
            return expr;
        }
        SourceLocation sLoc = expr.getSourceLocation();
        return this.ff.makeEmptySetExtension(newType, sLoc);
    }

    @Override
    public Expression rewrite(ExtendedExpression src, boolean changed, Expression[] newChildExprs, Predicate[] newChildPreds) {
        IExpressionExtension extension = src.getExtension();
        Object origin = extension.getOrigin();
        if (origin instanceof IDatatype) {
            assert (newChildPreds.length == 0);
            return this.translation.translate(src, newChildExprs);
        }
        SourceLocation sLoc = src.getSourceLocation();
        Type type = this.translation.translate(src.getType());
        return this.ff.makeExtendedExpression(extension, newChildExprs, newChildPreds, sLoc, type);
    }
}

