/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.core.ast;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eventb.core.ast.BoundIdentDecl;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.core.ast.IPosition;
import org.eventb.core.ast.ISimpleVisitor;
import org.eventb.core.ast.IVisitor;
import org.eventb.core.ast.Identifier;
import org.eventb.core.ast.IntegerType;
import org.eventb.core.ast.ProductType;
import org.eventb.core.ast.SingleRewriter;
import org.eventb.core.ast.SourceLocation;
import org.eventb.core.ast.Type;
import org.eventb.core.ast.extension.StandardGroup;
import org.eventb.internal.core.ast.FindingAccumulator;
import org.eventb.internal.core.ast.FormulaChecks;
import org.eventb.internal.core.ast.ITypeCheckingRewriter;
import org.eventb.internal.core.ast.IdentListMerger;
import org.eventb.internal.core.ast.IntStack;
import org.eventb.internal.core.ast.LegibilityResult;
import org.eventb.internal.core.ast.Position;
import org.eventb.internal.core.ast.extension.IToStringMediator;
import org.eventb.internal.core.ast.extension.KindMediator;
import org.eventb.internal.core.parser.AbstractGrammar;
import org.eventb.internal.core.parser.BMath;
import org.eventb.internal.core.parser.GenParser;
import org.eventb.internal.core.parser.IOperatorInfo;
import org.eventb.internal.core.parser.IParserPrinter;
import org.eventb.internal.core.parser.SubParsers;
import org.eventb.internal.core.typecheck.TypeCheckResult;
import org.eventb.internal.core.typecheck.TypeUnifier;
import org.eventb.internal.core.typecheck.TypeVariable;

public class BinaryExpression
extends Expression {
    private final Expression left;
    private final Expression right;
    public static final String PPROD_ID = "Parallel Product";
    public static final String REL_ID = "Relation";
    public static final String TREL_ID = "Total Relation";
    public static final String SREL_ID = "Surjective Relation";
    public static final String STREL_ID = "Surjective Total Relation";
    public static final String PFUN_ID = "Partial Function";
    public static final String PINJ_ID = "Partial Injection";
    public static final String TINJ_ID = "Total Injection";
    public static final String PSUR_ID = "Partial Surjection";
    public static final String TSUR_ID = "Total Surjection";
    public static final String TBIJ_ID = "Total Bijection";
    public static final String SETMINUS_ID = "Set Minus";
    public static final String DPROD_ID = "Direct Product";
    public static final String DOMRES_ID = "Domain Restriction";
    public static final String DOMSUB_ID = "Domain Subtraction";
    public static final String RANRES_ID = "Range Restriction";
    public static final String RANSUB_ID = "Range Subtraction";
    public static final String MINUS_ID = "Minus";
    public static final String DIV_ID = "Integer Division";
    public static final String MOD_ID = "Modulo";
    public static final String EXPN_ID = "Integer Exponentiation";
    public static final String TFUN_ID = "Total Function";
    public static final String UPTO_ID = "Up To";
    public static final String MAPSTO_ID = "Maps to";
    public static final String CPROD_ID = "Cartesian Product";
    public static final String FUNIMAGE_ID = "Fun Image";
    public static final String RELIMAGE_ID = "Relational Image";
    private static final int FIRST_TAG = 201;
    public static final int TAGS_LENGTH = Operators.values().length;

    public static void init(BMath grammar) {
        try {
            for (Operators operInfo : Operators.values()) {
                grammar.addOperator(operInfo);
            }
        }
        catch (GenParser.OverrideException e) {
            e.printStackTrace();
        }
    }

    protected BinaryExpression(Expression left, Expression right, int tag, SourceLocation location, FormulaFactory ff) {
        super(tag, ff, location, BinaryExpression.combineHashCodes(left.hashCode(), right.hashCode()));
        this.left = left;
        this.right = right;
        FormulaChecks.ensureTagInRange(tag, 201, TAGS_LENGTH);
        this.ensureSameFactory(this.left, this.right);
        this.setPredicateVariableCache(this.left, this.right);
        this.synthesizeType(null);
    }

    @Override
    protected void synthesizeType(Type givenType) {
        Type resultType;
        IdentListMerger freeIdentMerger = IdentListMerger.makeMerger((Identifier[])this.left.freeIdents, (Identifier[])this.right.freeIdents);
        this.freeIdents = freeIdentMerger.getFreeMergedArray();
        IdentListMerger boundIdentMerger = IdentListMerger.makeMerger((Identifier[])this.left.boundIdents, (Identifier[])this.right.boundIdents);
        this.boundIdents = boundIdentMerger.getBoundMergedArray();
        if (freeIdentMerger.containsError() || boundIdentMerger.containsError()) {
            return;
        }
        if (!this.left.isTypeChecked() || !this.right.isTypeChecked()) {
            return;
        }
        Type leftType = this.left.getType();
        Type rightType = this.right.getType();
        FormulaFactory ff = this.getFactory();
        switch (this.getTag()) {
            case 226: {
                Type alpha = leftType.getSource();
                if (alpha != null && alpha.equals(rightType)) {
                    resultType = leftType.getTarget();
                    break;
                }
                resultType = null;
                break;
            }
            case 227: {
                Type alpha = leftType.getSource();
                Type beta = leftType.getTarget();
                if (alpha != null && alpha.equals(rightType.getBaseType())) {
                    resultType = ff.makePowerSetType(beta);
                    break;
                }
                resultType = null;
                break;
            }
            case 201: {
                resultType = ff.makeProductType(leftType, rightType);
                break;
            }
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: {
                Type alpha = leftType.getBaseType();
                Type beta = rightType.getBaseType();
                if (alpha != null && beta != null) {
                    resultType = ff.makePowerSetType(ff.makeRelationalType(alpha, beta));
                    break;
                }
                resultType = null;
                break;
            }
            case 213: {
                Type alpha = leftType.getBaseType();
                if (alpha != null && leftType.equals(rightType)) {
                    resultType = leftType;
                    break;
                }
                resultType = null;
                break;
            }
            case 214: {
                Type alpha = leftType.getBaseType();
                Type beta = rightType.getBaseType();
                if (alpha != null && beta != null) {
                    resultType = ff.makeRelationalType(alpha, beta);
                    break;
                }
                resultType = null;
                break;
            }
            case 215: {
                Type alpha = leftType.getSource();
                Type beta = leftType.getTarget();
                Type gamma = rightType.getTarget();
                if (alpha != null && beta != null && gamma != null && alpha.equals(rightType.getSource())) {
                    resultType = ff.makeRelationalType(alpha, ff.makeProductType(beta, gamma));
                    break;
                }
                resultType = null;
                break;
            }
            case 216: {
                Type alpha = leftType.getSource();
                Type beta = rightType.getSource();
                Type gamma = leftType.getTarget();
                Type delta = rightType.getTarget();
                if (alpha != null && beta != null && gamma != null && delta != null) {
                    resultType = ff.makeRelationalType(ff.makeProductType(alpha, beta), ff.makeProductType(gamma, delta));
                    break;
                }
                resultType = null;
                break;
            }
            case 217: 
            case 218: {
                Type alpha = leftType.getBaseType();
                if (alpha != null && alpha.equals(rightType.getSource())) {
                    resultType = rightType;
                    break;
                }
                resultType = null;
                break;
            }
            case 219: 
            case 220: {
                Type beta = rightType.getBaseType();
                if (beta != null && beta.equals(leftType.getTarget())) {
                    resultType = leftType;
                    break;
                }
                resultType = null;
                break;
            }
            case 221: {
                if (leftType instanceof IntegerType && rightType instanceof IntegerType) {
                    resultType = ff.makePowerSetType(leftType);
                    break;
                }
                resultType = null;
                break;
            }
            case 222: 
            case 223: 
            case 224: 
            case 225: {
                if (leftType instanceof IntegerType && rightType instanceof IntegerType) {
                    resultType = leftType;
                    break;
                }
                resultType = null;
                break;
            }
            default: {
                assert (false);
                resultType = null;
            }
        }
        if (resultType == null) {
            return;
        }
        this.setFinalType(resultType, givenType);
    }

    private Operators getOperator() {
        return Operators.values()[this.getTag() - 201];
    }

    private String getOperatorImage() {
        return this.getOperator().getImage();
    }

    @Override
    protected int getKind(KindMediator mediator) {
        return mediator.getKind(this.getOperatorImage());
    }

    @Override
    boolean equalsInternalExpr(Expression expr) {
        BinaryExpression other = (BinaryExpression)expr;
        return this.left.equals(other.left) && this.right.equals(other.right);
    }

    @Override
    protected void typeCheck(TypeCheckResult result, BoundIdentDecl[] quantifiedIdentifiers) {
        Type resultType;
        this.left.typeCheck(result, quantifiedIdentifiers);
        this.right.typeCheck(result, quantifiedIdentifiers);
        switch (this.getTag()) {
            case 226: {
                TypeVariable beta = result.newFreshVariable(null);
                result.unify(this.left.getType(), result.makeRelationalType(this.right.getType(), beta), this);
                resultType = beta;
                break;
            }
            case 227: {
                TypeVariable alpha = result.newFreshVariable(null);
                TypeVariable beta = result.newFreshVariable(null);
                result.unify(this.left.getType(), result.makeRelationalType(alpha, beta), this);
                result.unify(this.right.getType(), result.makePowerSetType(alpha), this);
                resultType = result.makePowerSetType(beta);
                break;
            }
            case 201: {
                resultType = result.makeProductType(this.left.getType(), this.right.getType());
                break;
            }
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: {
                TypeVariable alpha = result.newFreshVariable(null);
                TypeVariable beta = result.newFreshVariable(null);
                result.unify(this.left.getType(), result.makePowerSetType(alpha), this);
                result.unify(this.right.getType(), result.makePowerSetType(beta), this);
                resultType = result.makePowerSetType(result.makeRelationalType(alpha, beta));
                break;
            }
            case 213: {
                TypeVariable alpha = result.newFreshVariable(null);
                resultType = result.makePowerSetType(alpha);
                result.unify(this.left.getType(), resultType, this);
                result.unify(this.right.getType(), resultType, this);
                break;
            }
            case 214: {
                TypeVariable alpha = result.newFreshVariable(null);
                TypeVariable beta = result.newFreshVariable(null);
                result.unify(this.left.getType(), result.makePowerSetType(alpha), this);
                result.unify(this.right.getType(), result.makePowerSetType(beta), this);
                resultType = result.makeRelationalType(alpha, beta);
                break;
            }
            case 215: {
                TypeVariable alpha = result.newFreshVariable(null);
                TypeVariable beta = result.newFreshVariable(null);
                TypeVariable gamma = result.newFreshVariable(null);
                result.unify(this.left.getType(), result.makeRelationalType(alpha, beta), this);
                result.unify(this.right.getType(), result.makeRelationalType(alpha, gamma), this);
                resultType = result.makeRelationalType(alpha, result.makeProductType(beta, gamma));
                break;
            }
            case 216: {
                TypeVariable alpha = result.newFreshVariable(null);
                TypeVariable beta = result.newFreshVariable(null);
                TypeVariable gamma = result.newFreshVariable(null);
                TypeVariable delta = result.newFreshVariable(null);
                result.unify(this.left.getType(), result.makeRelationalType(alpha, gamma), this);
                result.unify(this.right.getType(), result.makeRelationalType(beta, delta), this);
                resultType = result.makeRelationalType(result.makeProductType(alpha, beta), result.makeProductType(gamma, delta));
                break;
            }
            case 217: 
            case 218: {
                TypeVariable alpha = result.newFreshVariable(null);
                TypeVariable beta = result.newFreshVariable(null);
                resultType = result.makeRelationalType(alpha, beta);
                result.unify(this.left.getType(), result.makePowerSetType(alpha), this);
                result.unify(this.right.getType(), resultType, this);
                break;
            }
            case 219: 
            case 220: {
                TypeVariable alpha = result.newFreshVariable(null);
                TypeVariable beta = result.newFreshVariable(null);
                resultType = result.makeRelationalType(alpha, beta);
                result.unify(this.left.getType(), resultType, this);
                result.unify(this.right.getType(), result.makePowerSetType(beta), this);
                break;
            }
            case 221: {
                IntegerType intType = result.makeIntegerType();
                result.unify(this.left.getType(), intType, this);
                result.unify(this.right.getType(), intType, this);
                resultType = result.makePowerSetType(intType);
                break;
            }
            case 222: 
            case 223: 
            case 224: 
            case 225: {
                resultType = result.makeIntegerType();
                result.unify(this.left.getType(), resultType, this);
                result.unify(this.right.getType(), resultType, this);
                break;
            }
            default: {
                assert (false);
                return;
            }
        }
        this.setTemporaryType(resultType, result);
    }

    @Override
    protected void solveChildrenTypes(TypeUnifier unifier) {
        this.left.solveType(unifier);
        this.right.solveType(unifier);
    }

    @Override
    protected void toString(IToStringMediator mediator) {
        Operators operator = this.getOperator();
        int kind = mediator.getKind();
        operator.makeParser(kind).toString(mediator, this);
    }

    @Override
    protected String getSyntaxTree(String[] boundNames, String tabs) {
        return tabs + this.getClass().getSimpleName() + " [" + this.getOperatorImage() + "]" + this.getTypeName() + "\n" + this.left.getSyntaxTree(boundNames, tabs + "\t") + this.right.getSyntaxTree(boundNames, tabs + "\t");
    }

    @Override
    protected void isLegible(LegibilityResult result) {
        this.left.isLegible(result);
        this.right.isLegible(result);
    }

    public Expression getLeft() {
        return this.left;
    }

    public Expression getRight() {
        return this.right;
    }

    @Override
    protected void collectFreeIdentifiers(LinkedHashSet<FreeIdentifier> freeIdentSet) {
        this.left.collectFreeIdentifiers(freeIdentSet);
        this.right.collectFreeIdentifiers(freeIdentSet);
    }

    @Override
    protected void collectNamesAbove(Set<String> names, String[] boundNames, int offset) {
        this.left.collectNamesAbove(names, boundNames, offset);
        this.right.collectNamesAbove(names, boundNames, offset);
    }

    @Override
    public boolean accept(IVisitor visitor) {
        boolean goOn = true;
        switch (this.getTag()) {
            case 201: {
                goOn = visitor.enterMAPSTO(this);
                break;
            }
            case 202: {
                goOn = visitor.enterREL(this);
                break;
            }
            case 203: {
                goOn = visitor.enterTREL(this);
                break;
            }
            case 204: {
                goOn = visitor.enterSREL(this);
                break;
            }
            case 205: {
                goOn = visitor.enterSTREL(this);
                break;
            }
            case 206: {
                goOn = visitor.enterPFUN(this);
                break;
            }
            case 207: {
                goOn = visitor.enterTFUN(this);
                break;
            }
            case 208: {
                goOn = visitor.enterPINJ(this);
                break;
            }
            case 209: {
                goOn = visitor.enterTINJ(this);
                break;
            }
            case 210: {
                goOn = visitor.enterPSUR(this);
                break;
            }
            case 211: {
                goOn = visitor.enterTSUR(this);
                break;
            }
            case 212: {
                goOn = visitor.enterTBIJ(this);
                break;
            }
            case 213: {
                goOn = visitor.enterSETMINUS(this);
                break;
            }
            case 214: {
                goOn = visitor.enterCPROD(this);
                break;
            }
            case 215: {
                goOn = visitor.enterDPROD(this);
                break;
            }
            case 216: {
                goOn = visitor.enterPPROD(this);
                break;
            }
            case 217: {
                goOn = visitor.enterDOMRES(this);
                break;
            }
            case 218: {
                goOn = visitor.enterDOMSUB(this);
                break;
            }
            case 219: {
                goOn = visitor.enterRANRES(this);
                break;
            }
            case 220: {
                goOn = visitor.enterRANSUB(this);
                break;
            }
            case 221: {
                goOn = visitor.enterUPTO(this);
                break;
            }
            case 222: {
                goOn = visitor.enterMINUS(this);
                break;
            }
            case 223: {
                goOn = visitor.enterDIV(this);
                break;
            }
            case 224: {
                goOn = visitor.enterMOD(this);
                break;
            }
            case 225: {
                goOn = visitor.enterEXPN(this);
                break;
            }
            case 226: {
                goOn = visitor.enterFUNIMAGE(this);
                break;
            }
            case 227: {
                goOn = visitor.enterRELIMAGE(this);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (goOn) {
            goOn = this.left.accept(visitor);
        }
        if (goOn) {
            switch (this.getTag()) {
                case 201: {
                    goOn = visitor.continueMAPSTO(this);
                    break;
                }
                case 202: {
                    goOn = visitor.continueREL(this);
                    break;
                }
                case 203: {
                    goOn = visitor.continueTREL(this);
                    break;
                }
                case 204: {
                    goOn = visitor.continueSREL(this);
                    break;
                }
                case 205: {
                    goOn = visitor.continueSTREL(this);
                    break;
                }
                case 206: {
                    goOn = visitor.continuePFUN(this);
                    break;
                }
                case 207: {
                    goOn = visitor.continueTFUN(this);
                    break;
                }
                case 208: {
                    goOn = visitor.continuePINJ(this);
                    break;
                }
                case 209: {
                    goOn = visitor.continueTINJ(this);
                    break;
                }
                case 210: {
                    goOn = visitor.continuePSUR(this);
                    break;
                }
                case 211: {
                    goOn = visitor.continueTSUR(this);
                    break;
                }
                case 212: {
                    goOn = visitor.continueTBIJ(this);
                    break;
                }
                case 213: {
                    goOn = visitor.continueSETMINUS(this);
                    break;
                }
                case 214: {
                    goOn = visitor.continueCPROD(this);
                    break;
                }
                case 215: {
                    goOn = visitor.continueDPROD(this);
                    break;
                }
                case 216: {
                    goOn = visitor.continuePPROD(this);
                    break;
                }
                case 217: {
                    goOn = visitor.continueDOMRES(this);
                    break;
                }
                case 218: {
                    goOn = visitor.continueDOMSUB(this);
                    break;
                }
                case 219: {
                    goOn = visitor.continueRANRES(this);
                    break;
                }
                case 220: {
                    goOn = visitor.continueRANSUB(this);
                    break;
                }
                case 221: {
                    goOn = visitor.continueUPTO(this);
                    break;
                }
                case 222: {
                    goOn = visitor.continueMINUS(this);
                    break;
                }
                case 223: {
                    goOn = visitor.continueDIV(this);
                    break;
                }
                case 224: {
                    goOn = visitor.continueMOD(this);
                    break;
                }
                case 225: {
                    goOn = visitor.continueEXPN(this);
                    break;
                }
                case 226: {
                    goOn = visitor.continueFUNIMAGE(this);
                    break;
                }
                case 227: {
                    goOn = visitor.continueRELIMAGE(this);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
        if (goOn) {
            goOn = this.right.accept(visitor);
        }
        switch (this.getTag()) {
            case 201: {
                return visitor.exitMAPSTO(this);
            }
            case 202: {
                return visitor.exitREL(this);
            }
            case 203: {
                return visitor.exitTREL(this);
            }
            case 204: {
                return visitor.exitSREL(this);
            }
            case 205: {
                return visitor.exitSTREL(this);
            }
            case 206: {
                return visitor.exitPFUN(this);
            }
            case 207: {
                return visitor.exitTFUN(this);
            }
            case 208: {
                return visitor.exitPINJ(this);
            }
            case 209: {
                return visitor.exitTINJ(this);
            }
            case 210: {
                return visitor.exitPSUR(this);
            }
            case 211: {
                return visitor.exitTSUR(this);
            }
            case 212: {
                return visitor.exitTBIJ(this);
            }
            case 213: {
                return visitor.exitSETMINUS(this);
            }
            case 214: {
                return visitor.exitCPROD(this);
            }
            case 215: {
                return visitor.exitDPROD(this);
            }
            case 216: {
                return visitor.exitPPROD(this);
            }
            case 217: {
                return visitor.exitDOMRES(this);
            }
            case 218: {
                return visitor.exitDOMSUB(this);
            }
            case 219: {
                return visitor.exitRANRES(this);
            }
            case 220: {
                return visitor.exitRANSUB(this);
            }
            case 221: {
                return visitor.exitUPTO(this);
            }
            case 222: {
                return visitor.exitMINUS(this);
            }
            case 223: {
                return visitor.exitDIV(this);
            }
            case 224: {
                return visitor.exitMOD(this);
            }
            case 225: {
                return visitor.exitEXPN(this);
            }
            case 226: {
                return visitor.exitFUNIMAGE(this);
            }
            case 227: {
                return visitor.exitRELIMAGE(this);
            }
        }
        return true;
    }

    @Override
    public void accept(ISimpleVisitor visitor) {
        visitor.visitBinaryExpression(this);
    }

    @Override
    protected Expression rewrite(ITypeCheckingRewriter rewriter) {
        Expression newLeft = (Expression)this.left.rewrite(rewriter);
        Expression newRight = (Expression)this.right.rewrite(rewriter);
        BinaryExpression before = newLeft == this.left && newRight == this.right ? this : rewriter.getFactory().makeBinaryExpression(this.getTag(), newLeft, newRight, this.getSourceLocation());
        return rewriter.rewrite(this, before);
    }

    @Override
    public boolean isATypeExpression() {
        int tag = this.getTag();
        return (tag == 214 || tag == 202) && this.left.isATypeExpression() && this.right.isATypeExpression();
    }

    @Override
    public Type toType() {
        FormulaFactory factory = this.getFactory();
        Type leftAsType = this.left.toType();
        Type rightAsType = this.right.toType();
        ProductType result = factory.makeProductType(leftAsType, rightAsType);
        switch (this.getTag()) {
            case 214: {
                return result;
            }
            case 202: {
                return factory.makePowerSetType(result);
            }
        }
        return super.toType();
    }

    @Override
    protected final <F> void inspect(FindingAccumulator<F> acc) {
        acc.inspect(this);
        if (acc.childrenSkipped()) {
            return;
        }
        acc.enterChildren();
        this.left.inspect(acc);
        if (acc.allSkipped()) {
            return;
        }
        acc.nextChild();
        this.right.inspect(acc);
        acc.leaveChildren();
    }

    public Expression getChild(int index) {
        switch (index) {
            case 0: {
                return this.left;
            }
            case 1: {
                return this.right;
            }
        }
        throw BinaryExpression.invalidIndex(index);
    }

    @Override
    public int getChildCount() {
        return 2;
    }

    @Override
    protected IPosition getDescendantPos(SourceLocation sloc, IntStack indexes) {
        indexes.push(0);
        IPosition pos = this.left.getPosition(sloc, indexes);
        if (pos != null) {
            return pos;
        }
        indexes.incrementTop();
        pos = this.right.getPosition(sloc, indexes);
        if (pos != null) {
            return pos;
        }
        indexes.pop();
        return new Position(indexes);
    }

    @Override
    protected Expression rewriteChild(int index, SingleRewriter rewriter) {
        Expression newLeft = this.left;
        Expression newRight = this.right;
        switch (index) {
            case 0: {
                newLeft = rewriter.rewrite(this.left);
                break;
            }
            case 1: {
                newRight = rewriter.rewrite(this.right);
                break;
            }
            default: {
                throw new IllegalArgumentException("Position is outside the formula");
            }
        }
        return this.getFactory().makeBinaryExpression(this.getTag(), newLeft, newRight, this.getSourceLocation());
    }

    @Override
    public boolean isWDStrict() {
        return true;
    }

    private static enum Operators implements IOperatorInfo<BinaryExpression>
    {
        OP_MAPSTO(AbstractGrammar.DefaultToken.MAPS_TO.getImage(), "Maps to", StandardGroup.PAIR, 201),
        OP_REL("\u2194", "Relation", StandardGroup.RELATION, 202),
        OP_TREL("\ue100", "Total Relation", StandardGroup.RELATION, 203),
        OP_SREL("\ue101", "Surjective Relation", StandardGroup.RELATION, 204),
        OP_STREL("\ue102", "Surjective Total Relation", StandardGroup.RELATION, 205),
        OP_PFUN("\u21f8", "Partial Function", StandardGroup.RELATION, 206),
        OP_TFUN("\u2192", "Total Function", StandardGroup.RELATION, 207),
        OP_PINJ("\u2914", "Partial Injection", StandardGroup.RELATION, 208),
        OP_TINJ("\u21a3", "Total Injection", StandardGroup.RELATION, 209),
        OP_PSUR("\u2900", "Partial Surjection", StandardGroup.RELATION, 210),
        OP_TSUR("\u21a0", "Total Surjection", StandardGroup.RELATION, 211),
        OP_TBIJ("\u2916", "Total Bijection", StandardGroup.RELATION, 212),
        OP_SETMINUS("\u2216", "Set Minus", StandardGroup.BINOP, 213),
        OP_CPROD("\u00d7", "Cartesian Product", StandardGroup.BINOP, 214),
        OP_DPROD("\u2297", "Direct Product", StandardGroup.BINOP, 215),
        OP_PPROD("\u2225", "Parallel Product", StandardGroup.BINOP, 216),
        OP_DOMRES("\u25c1", "Domain Restriction", StandardGroup.BINOP, 217),
        OP_DOMSUB("\u2a64", "Domain Subtraction", StandardGroup.BINOP, 218),
        OP_RANRES("\u25b7", "Range Restriction", StandardGroup.BINOP, 219),
        OP_RANSUB("\u2a65", "Range Subtraction", StandardGroup.BINOP, 220),
        OP_UPTO("\u2025", "Up To", StandardGroup.INTERVAL, 221),
        OP_MINUS("\u2212", "Minus", StandardGroup.ARITHMETIC, 222),
        OP_DIV("\u00f7", "Integer Division", StandardGroup.ARITHMETIC, 223),
        OP_MOD("mod", "Modulo", StandardGroup.ARITHMETIC, 224),
        OP_EXPN("^", "Integer Exponentiation", StandardGroup.ARITHMETIC, 225),
        OP_FUNIMAGE(AbstractGrammar.DefaultToken.LPAR.getImage(), "Fun Image", StandardGroup.FUNCTIONAL, 226, false){

            @Override
            public IParserPrinter<BinaryExpression> makeParser(int kind) {
                return new SubParsers.LedImage(kind, 226){

                    @Override
                    protected int getCloseKind(AbstractGrammar grammar) {
                        return grammar.getKind(AbstractGrammar.DefaultToken.RPAR);
                    }
                };
            }
        }
        ,
        OP_RELIMAGE(AbstractGrammar.DefaultToken.LBRACKET.getImage(), "Relational Image", StandardGroup.FUNCTIONAL, 227, false){

            @Override
            public IParserPrinter<BinaryExpression> makeParser(int kind) {
                return new SubParsers.LedImage(kind, 227){

                    @Override
                    protected int getCloseKind(AbstractGrammar grammar) {
                        return grammar.getKind(AbstractGrammar.DefaultToken.RBRACKET);
                    }
                };
            }
        };

        private final String image;
        private final String id;
        private final String groupId;
        private final int tag;
        private final boolean isSpaced;

        private Operators(String image, String id, StandardGroup group, int tag) {
            this(image, id, group, tag, true);
        }

        private Operators(String image, String id, StandardGroup group, int tag, boolean isSpaced) {
            this.image = image;
            this.id = id;
            this.groupId = group.getId();
            this.tag = tag;
            this.isSpaced = isSpaced;
        }

        @Override
        public String getImage() {
            return this.image;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getGroupId() {
            return this.groupId;
        }

        @Override
        public IParserPrinter<BinaryExpression> makeParser(int kind) {
            return new SubParsers.BinaryExpressionInfix(kind, this.tag);
        }

        @Override
        public boolean isSpaced() {
            return this.isSpaced;
        }
    }
}

