/*
 * Decompiled with CFR 0.152.
 */
package de.prob.model.eventb;

import com.github.krukow.clj_lang.PersistentHashMap;
import de.prob.model.eventb.EventBAction;
import de.prob.model.eventb.EventBGuard;
import de.prob.model.eventb.EventBMachine;
import de.prob.model.eventb.EventParameter;
import de.prob.model.eventb.Witness;
import de.prob.model.representation.AbstractElement;
import de.prob.model.representation.Action;
import de.prob.model.representation.BEvent;
import de.prob.model.representation.Guard;
import de.prob.model.representation.ModelElementList;

public class Event
extends BEvent {
    private final EventType type;
    private final boolean extended;

    public Event(String name, EventType type, boolean extended) {
        this(name, type, extended, (PersistentHashMap<Class<? extends AbstractElement>, ModelElementList<? extends AbstractElement>>)PersistentHashMap.emptyMap());
    }

    private Event(String name, EventType type, boolean extended, PersistentHashMap<Class<? extends AbstractElement>, ModelElementList<? extends AbstractElement>> children) {
        super(name, children);
        this.type = type;
        this.extended = extended;
    }

    public Event set(Class<? extends AbstractElement> clazz, ModelElementList<? extends AbstractElement> elements) {
        return new Event(this.name, this.type, this.extended, this.assoc(clazz, elements));
    }

    public <T extends AbstractElement> Event addTo(Class<T> clazz, T element) {
        ModelElementList<T> list = this.getChildrenOfType(clazz);
        return new Event(this.name, this.type, this.extended, this.assoc(clazz, list.addElement(element)));
    }

    public <T extends AbstractElement> Event removeFrom(Class<T> clazz, T element) {
        ModelElementList<T> list = this.getChildrenOfType(clazz);
        return new Event(this.name, this.type, this.extended, this.assoc(clazz, list.removeElement(element)));
    }

    public <T extends AbstractElement> Event replaceIn(Class<T> clazz, T oldElement, T newElement) {
        ModelElementList<T> list = this.getChildrenOfType(clazz);
        return new Event(this.name, this.type, this.extended, this.assoc(clazz, list.replaceElement(oldElement, newElement)));
    }

    public ModelElementList<Event> getRefines(EventBMachine parentMachine) {
        ModelElementList<EventBMachine> refines = parentMachine.getRefines();
        if (refines.size() != 1) {
            return new ModelElementList<Event>();
        }
        EventBMachine m = refines.get(0);
        ModelElementList<Event> refined = new ModelElementList<Event>();
        for (Event event : this.getChildrenOfType(Event.class)) {
            Event e = m.getEvent(event.name);
            if (e == null) {
                throw new IllegalArgumentException("Attempted to retrieve event with name " + event.name + " from refinement but could not find it.");
            }
            refined = refined.addElement(e);
        }
        return refined;
    }

    public ModelElementList<EventBGuard> getGuards() {
        return this.getChildrenAndCast(Guard.class, EventBGuard.class);
    }

    public ModelElementList<EventBAction> getActions() {
        return this.getChildrenAndCast(Action.class, EventBAction.class);
    }

    public ModelElementList<Witness> getWitnesses() {
        return this.getChildrenOfType(Witness.class);
    }

    public ModelElementList<EventParameter> getParameters() {
        return this.getChildrenOfType(EventParameter.class);
    }

    public EventType getType() {
        return this.type;
    }

    public boolean isExtended() {
        return this.extended;
    }

    public Event changeType(EventType type) {
        return new Event(this.name, type, this.extended, (PersistentHashMap<Class<? extends AbstractElement>, ModelElementList<? extends AbstractElement>>)this.children);
    }

    public Event toggleExtended(boolean extended) {
        if (extended == this.extended) {
            return this;
        }
        return new Event(this.name, this.type, extended, (PersistentHashMap<Class<? extends AbstractElement>, ModelElementList<? extends AbstractElement>>)this.children);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public String print() {
        StringBuilder sb = new StringBuilder();
        sb.append("Name: " + this.getName() + "\n");
        sb.append("Type: " + this.type.toString() + "\n");
        this.printChildren("Refines", this.getChildrenOfType(Event.class), sb);
        this.printChildren("Any", this.getChildrenOfType(EventParameter.class), sb);
        this.printChildren("Where", this.getChildrenOfType(Guard.class), sb);
        this.printChildren("With", this.getChildrenOfType(Witness.class), sb);
        this.printChildren("Then", this.getChildrenOfType(Action.class), sb);
        return sb.toString();
    }

    private void printChildren(String name, ModelElementList<? extends AbstractElement> childrenOfType, StringBuilder sb) {
        if (!childrenOfType.isEmpty()) {
            sb.append(name + ": \n");
            for (AbstractElement abstractElement : childrenOfType) {
                sb.append("\t" + abstractElement.toString() + "\n");
            }
        }
    }

    public static enum EventType {
        ORDINARY,
        CONVERGENT,
        ANTICIPATED;

    }
}

