/*
 * Decompiled with CFR 0.152.
 */
package de.prob.cli;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import de.prob.annotations.Home;
import de.prob.cli.AbstractCliPattern;
import de.prob.cli.InterruptRefPattern;
import de.prob.cli.OsSpecificInfo;
import de.prob.cli.PortPattern;
import de.prob.cli.ProBConnection;
import de.prob.cli.ProBInstance;
import de.prob.cli.ProcessHandle;
import de.prob.cli.PrologProcessProvider;
import de.prob.exception.CliError;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public final class ProBInstanceProvider
implements Provider<ProBInstance> {
    private final Logger logger = LoggerFactory.getLogger(ProBInstanceProvider.class);
    private final PrologProcessProvider processProvider;
    private final String home;
    private final OsSpecificInfo osInfo;
    private final AtomicInteger processCounter;
    private final Set<WeakReference<ProBInstance>> processes = new HashSet<WeakReference<ProBInstance>>();

    @Inject
    public ProBInstanceProvider(PrologProcessProvider processProvider, @Home String home, OsSpecificInfo osInfo) {
        this.processProvider = processProvider;
        this.home = home;
        this.osInfo = osInfo;
        this.processCounter = new AtomicInteger();
    }

    public ProBInstance get() {
        return this.create();
    }

    public ProBInstance create() {
        return this.startProlog();
    }

    public int numberOfCLIs() {
        return this.processCounter.get();
    }

    public void shutdownAll() {
        for (WeakReference<ProBInstance> wr : this.processes) {
            if (wr.get() == null) continue;
            ((ProBInstance)wr.get()).shutdown();
        }
    }

    private ProBInstance startProlog() {
        ProcessHandle processTuple = this.processProvider.get();
        Process process = processTuple.getProcess();
        String key = processTuple.getKey();
        BufferedReader stream = new BufferedReader(new InputStreamReader(process.getInputStream(), Charset.defaultCharset()));
        Map<Class<AbstractCliPattern<?>>, AbstractCliPattern<?>> cliInformation = this.extractCliInformation(stream);
        Integer port = ((PortPattern)cliInformation.get(PortPattern.class)).getValue();
        Long userInterruptReference = ((InterruptRefPattern)cliInformation.get(InterruptRefPattern.class)).getValue();
        ProBConnection connection = new ProBConnection(key, port);
        try {
            this.processCounter.incrementAndGet();
            connection.connect();
            ProBInstance cli = new ProBInstance(process, stream, userInterruptReference, connection, this.home, this.osInfo, this.processCounter);
            this.processes.add(new WeakReference<ProBInstance>(cli));
            return cli;
        }
        catch (IOException e) {
            this.processCounter.decrementAndGet();
            this.logger.error("Error connecting to Prolog binary.", (Throwable)e);
            return null;
        }
    }

    Map<Class<? extends AbstractCliPattern<?>>, AbstractCliPattern<?>> extractCliInformation(BufferedReader input) {
        PortPattern portPattern = new PortPattern();
        InterruptRefPattern intPattern = new InterruptRefPattern();
        HashMap pattern = new HashMap();
        pattern.put(PortPattern.class, portPattern);
        pattern.put(InterruptRefPattern.class, intPattern);
        Collection values = pattern.values();
        this.analyseStdout(input, values);
        return pattern;
    }

    private void analyseStdout(BufferedReader input, Collection<? extends AbstractCliPattern<?>> patterns) {
        patterns = new ArrayList(patterns);
        try {
            String line;
            boolean endReached = false;
            while (!endReached && (line = input.readLine()) != null) {
                this.logger.debug("Apply cli detection patterns to {}", (Object)line);
                this.applyPatterns(patterns, line);
                endReached = patterns.isEmpty() || line.contains("starting command loop");
            }
        }
        catch (IOException e) {
            String message = "Problem while starting ProB. Cannot read from input stream.";
            this.logger.error("Problem while starting ProB. Cannot read from input stream.");
            this.logger.debug("Problem while starting ProB. Cannot read from input stream.", (Throwable)e);
            throw new CliError("Problem while starting ProB. Cannot read from input stream.", e);
        }
        for (AbstractCliPattern<?> p : patterns) {
            p.notifyNotFound();
            if (!p.notFoundIsFatal()) continue;
            throw new CliError("Missing info from CLI " + p.getClass().getSimpleName());
        }
    }

    private void applyPatterns(Collection<? extends AbstractCliPattern<?>> patterns, String line) {
        Iterator<AbstractCliPattern<?>> it = patterns.iterator();
        while (it.hasNext()) {
            AbstractCliPattern<?> p = it.next();
            if (!p.matchesLine(line)) continue;
            it.remove();
        }
    }
}

