/*
 * Decompiled with CFR 0.152.
 */
package de.prob.animator.command;

import de.prob.animator.command.AbstractCommand;
import de.prob.parser.BindingGenerator;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.IntegerPrologTerm;
import de.prob.prolog.term.ListPrologTerm;
import de.prob.prolog.term.PrologTerm;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ComputeCoverageCommand
extends AbstractCommand {
    private static final String PROLOG_COMMAND_NAME = "compute_coverage";
    private ComputeCoverageResult coverageResult;
    Logger logger = LoggerFactory.getLogger(ComputeCoverageCommand.class);

    private ComputeCoverageCommand() {
    }

    public ComputeCoverageResult getResult() {
        return this.coverageResult;
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) {
        IntegerPrologTerm totalNodeNr = (IntegerPrologTerm)bindings.get((Object)"TotalNodeNr");
        IntegerPrologTerm totalTransNr = (IntegerPrologTerm)bindings.get((Object)"TotalTransSum");
        ListPrologTerm ops = BindingGenerator.getList((PrologTerm)((PrologTerm)bindings.get((Object)"OpStat")));
        ListPrologTerm nodes = BindingGenerator.getList((PrologTerm)((PrologTerm)bindings.get((Object)"NodeStat")));
        ListPrologTerm uncovered = BindingGenerator.getList((PrologTerm)((PrologTerm)bindings.get((Object)"Uncovered")));
        this.coverageResult = new ComputeCoverageResult(totalNodeNr, totalTransNr, ops, nodes, uncovered);
    }

    @Override
    public void writeCommand(IPrologTermOutput pto) {
        pto.openTerm(PROLOG_COMMAND_NAME).printVariable("TotalNodeNr").printVariable("TotalTransSum").printVariable("NodeStat").printVariable("OpStat").printVariable("Uncovered").closeTerm();
    }

    public static final class ComputeCoverageResult {
        private final BigInteger totalNumberOfNodes;
        private final BigInteger totalNumberOfTransitions;
        private final List<String> ops = new ArrayList<String>();
        private final List<String> nodes = new ArrayList<String>();
        private final List<String> uncovered = new ArrayList<String>();

        public ComputeCoverageResult(IntegerPrologTerm totalNumberOfNodes, IntegerPrologTerm totalNumberOfTransitions, ListPrologTerm ops, ListPrologTerm nodes, ListPrologTerm uncovered) {
            this.totalNumberOfNodes = totalNumberOfNodes.getValue();
            this.totalNumberOfTransitions = totalNumberOfTransitions.getValue();
            for (PrologTerm op : ops) {
                this.getOps().add(op.toString());
            }
            for (PrologTerm node : nodes) {
                this.getNodes().add(node.toString());
            }
            for (PrologTerm unc : uncovered) {
                this.getUncovered().add(unc.toString());
            }
        }

        public BigInteger getTotalNumberOfNodes() {
            return this.totalNumberOfNodes;
        }

        public BigInteger getTotalNumberOfTransitions() {
            return this.totalNumberOfTransitions;
        }

        public List<String> getOps() {
            return this.ops;
        }

        public List<String> getNodes() {
            return this.nodes;
        }

        public List<String> getUncovered() {
            return this.uncovered;
        }
    }
}

