/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.queue;

import java.io.File;
import java.io.IOException;
import tlc2.tool.TLCState;
import tlc2.tool.queue.StateQueue;
import tlc2.util.StatePoolReader;
import tlc2.util.StatePoolWriter;
import tlc2.value.ValueInputStream;
import tlc2.value.ValueOutputStream;
import util.Assert;
import util.FileUtil;

public class DiskStateQueue
extends StateQueue {
    private static final int BufSize = Integer.getInteger(DiskStateQueue.class.getName() + ".BufSize", 8192);
    private final String filePrefix;
    protected TLCState[] deqBuf = new TLCState[BufSize];
    protected TLCState[] enqBuf = new TLCState[BufSize];
    protected int deqIndex = BufSize;
    protected int enqIndex = 0;
    protected StatePoolReader reader;
    protected StatePoolWriter writer;
    private int loPool = 1;
    private int hiPool = 0;
    private int lastLoPool = 0;
    private int newLastLoPool;
    private File loFile;

    public DiskStateQueue(String diskdir) {
        this.filePrefix = diskdir + FileUtil.separator;
        File rFile = new File(this.filePrefix + Integer.toString(0));
        this.reader = new StatePoolReader(BufSize, rFile);
        this.reader.setDaemon(true);
        this.loFile = new File(this.filePrefix + Integer.toString(this.loPool));
        this.reader.start();
        this.writer = new StatePoolWriter(BufSize, this.reader);
        this.writer.setDaemon(true);
        this.writer.start();
    }

    @Override
    final void enqueueInner(TLCState state) {
        if (this.enqIndex == this.enqBuf.length) {
            try {
                String pstr = Integer.toString(this.hiPool);
                File file = new File(this.filePrefix + pstr);
                this.enqBuf = this.writer.doWork(this.enqBuf, file);
                ++this.hiPool;
                this.enqIndex = 0;
            }
            catch (Exception e) {
                Assert.fail(2175, new String[]{"queue", e.getMessage() == null ? e.toString() : e.getMessage()});
            }
        }
        this.enqBuf[this.enqIndex++] = state;
    }

    @Override
    final TLCState dequeueInner() {
        if (this.deqIndex == this.deqBuf.length) {
            this.fillDeqBuffer();
        }
        return this.deqBuf[this.deqIndex++];
    }

    private final void fillDeqBuffer() {
        try {
            if (this.loPool + 1 <= this.hiPool) {
                if (this.loPool + 1 >= this.hiPool) {
                    this.writer.ensureWritten();
                }
                this.deqBuf = this.reader.doWork(this.deqBuf, this.loFile);
                this.deqIndex = 0;
                ++this.loPool;
                String pstr = Integer.toString(this.loPool);
                this.loFile = new File(this.filePrefix + pstr);
            } else {
                this.writer.ensureWritten();
                TLCState[] buf = this.reader.getCache(this.deqBuf, this.loFile);
                if (buf != null) {
                    this.deqBuf = buf;
                    this.deqIndex = 0;
                    ++this.loPool;
                    String pstr = Integer.toString(this.loPool);
                    this.loFile = new File(this.filePrefix + pstr);
                } else {
                    this.deqIndex = this.deqBuf.length - this.enqIndex;
                    System.arraycopy(this.enqBuf, 0, this.deqBuf, this.deqIndex, this.enqIndex);
                    this.enqIndex = 0;
                }
            }
        }
        catch (Exception e) {
            Assert.fail(2174, new String[]{"queue", e.getMessage() == null ? e.toString() : e.getMessage()});
        }
    }

    @Override
    public final void beginChkpt() throws IOException {
        int i;
        String filename = this.filePrefix + "queue.tmp";
        ValueOutputStream vos = new ValueOutputStream(filename);
        vos.writeLongNat(this.len);
        vos.writeInt(this.loPool);
        vos.writeInt(this.hiPool);
        vos.writeInt(this.enqIndex);
        vos.writeInt(this.deqIndex);
        for (i = 0; i < this.enqIndex; ++i) {
            this.enqBuf[i].write(vos);
        }
        for (i = this.deqIndex; i < this.deqBuf.length; ++i) {
            this.deqBuf[i].write(vos);
        }
        vos.close();
        this.newLastLoPool = this.loPool - 1;
    }

    @Override
    public final void commitChkpt() throws IOException {
        for (int i = this.lastLoPool; i < this.newLastLoPool; ++i) {
            String pstr = Integer.toString(i);
            File oldPool = new File(this.filePrefix + pstr);
            if (oldPool.delete()) continue;
            String msg = "DiskStateQueue.commitChkpt: cannot delete " + oldPool;
            throw new IOException(msg);
        }
        this.lastLoPool = this.newLastLoPool;
        File oldChkpt = new File(this.filePrefix + "queue.chkpt");
        File newChkpt = new File(this.filePrefix + "queue.tmp");
        if (oldChkpt.exists() && !oldChkpt.delete() || !newChkpt.renameTo(oldChkpt)) {
            String msg = "DiskStateQueue.commitChkpt: cannot delete " + oldChkpt;
            throw new IOException(msg);
        }
    }

    @Override
    public final void recover() throws IOException {
        int i;
        String filename = this.filePrefix + "queue.chkpt";
        ValueInputStream vis = new ValueInputStream(filename);
        this.len = vis.readInt();
        this.loPool = vis.readInt();
        this.hiPool = vis.readInt();
        this.enqIndex = vis.readInt();
        this.deqIndex = vis.readInt();
        this.lastLoPool = this.loPool - 1;
        for (i = 0; i < this.enqIndex; ++i) {
            this.enqBuf[i] = TLCState.Empty.createEmpty();
            this.enqBuf[i].read(vis);
        }
        for (i = this.deqIndex; i < this.deqBuf.length; ++i) {
            this.deqBuf[i] = TLCState.Empty.createEmpty();
            this.deqBuf[i].read(vis);
        }
        vis.close();
        File file = new File(this.filePrefix + Integer.toString(this.lastLoPool));
        boolean canRead = this.lastLoPool < this.hiPool;
        this.reader.restart(file, canRead);
        String pstr = Integer.toString(this.loPool);
        this.loFile = new File(this.filePrefix + pstr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishAll() {
        super.finishAll();
        Thread thread = this.writer;
        synchronized (thread) {
            this.writer.notifyAll();
        }
        thread = this.reader;
        synchronized (thread) {
            this.reader.setFinished();
            this.reader.notifyAll();
        }
    }
}

