/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.fp;

import java.io.IOException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import tlc2.tool.TLCTrace;
import tlc2.tool.fp.FPSet;
import tlc2.tool.fp.FPSetConfiguration;
import tlc2.tool.fp.FPSetFactory;
import tlc2.tool.fp.MultiFPSetConfiguration;
import tlc2.util.BufferedRandomAccessFile;
import util.Assert;

public class MultiFPSet
extends FPSet {
    private static final int MEM_DEFAULT = -1;
    public static final int MAX_FPBITS = 30;
    public static final int MIN_FPBITS = 0;
    protected FPSet[] sets;
    protected int fpbits;

    public MultiFPSet(FPSetConfiguration fpSetConfiguration) throws RemoteException {
        super(fpSetConfiguration);
        int bits = fpSetConfiguration.getFpBits();
        long fpMemSize = fpSetConfiguration.getMemoryInBytes();
        Assert.check(bits > 0 && bits <= 30, "Illegal number of FPSets found.");
        if (fpMemSize == -1L) {
            fpMemSize = 26214L;
        }
        this.sets = this.getNestedFPSets(fpSetConfiguration);
        this.fpbits = 64 - bits;
    }

    protected FPSet[] getNestedFPSets(FPSetConfiguration fpSetConfiguration) throws RemoteException {
        int len = fpSetConfiguration.getMultiFPSetCnt();
        FPSet[] s = new FPSet[len];
        for (int i = 0; i < len; ++i) {
            s[i] = FPSetFactory.getFPSet(new MultiFPSetConfiguration(fpSetConfiguration));
        }
        return s;
    }

    @Override
    public final void init(int numThreads, String metadir, String filename) throws IOException {
        for (int i = 0; i < this.sets.length; ++i) {
            this.sets[i].init(numThreads, metadir, filename + "_" + i);
        }
    }

    @Override
    public final long size() {
        long sum = 0L;
        for (int i = 0; i < this.sets.length; ++i) {
            sum += this.sets[i].size();
        }
        return sum;
    }

    protected FPSet getFPSet(long fp) {
        int idx = (int)(fp >>> this.fpbits);
        return this.sets[idx];
    }

    @Override
    public final boolean put(long fp) throws IOException {
        return this.getFPSet(fp).put(fp);
    }

    @Override
    public final boolean contains(long fp) throws IOException {
        return this.getFPSet(fp).contains(fp);
    }

    @Override
    public final void close() {
        for (int i = 0; i < this.sets.length; ++i) {
            this.sets[i].close();
        }
    }

    @Override
    public void unexportObject(boolean force) throws NoSuchObjectException {
        for (int i = 0; i < this.sets.length; ++i) {
            this.sets[i].unexportObject(force);
        }
        UnicastRemoteObject.unexportObject(this, force);
    }

    @Override
    public final double checkFPs() throws IOException {
        double res = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.sets.length; ++i) {
            res = Math.max(res, this.sets[i].checkFPs());
        }
        return res;
    }

    @Override
    public final void exit(boolean cleanup) throws IOException {
        for (int i = 0; i < this.sets.length; ++i) {
            this.sets[i].exit(cleanup);
        }
    }

    @Override
    public final void beginChkpt() throws IOException {
        for (int i = 0; i < this.sets.length; ++i) {
            this.sets[i].beginChkpt();
        }
    }

    @Override
    public final void commitChkpt() throws IOException {
        for (int i = 0; i < this.sets.length; ++i) {
            this.sets[i].commitChkpt();
        }
    }

    @Override
    public final void recover() throws IOException {
        for (int i = 0; i < this.sets.length; ++i) {
            this.sets[i].prepareRecovery();
        }
        long recoverPtr = TLCTrace.getRecoverPtr();
        BufferedRandomAccessFile braf = new BufferedRandomAccessFile(TLCTrace.getFilename(), "r");
        while (braf.getFilePointer() < recoverPtr) {
            braf.readLongNat();
            long fp = braf.readLong();
            this.getFPSet(fp).recoverFP(fp);
        }
        braf.close();
        for (int i = 0; i < this.sets.length; ++i) {
            this.sets[i].completeRecovery();
        }
    }

    @Override
    public final void prepareRecovery() throws IOException {
    }

    @Override
    public final void recoverFP(long fp) throws IOException {
        Assert.check(!this.put(fp), 2133);
    }

    @Override
    public final void completeRecovery() throws IOException {
    }

    @Override
    public final void beginChkpt(String filename) throws IOException {
        for (int i = 0; i < this.sets.length; ++i) {
            this.sets[i].beginChkpt(filename + "_" + i);
        }
    }

    @Override
    public final void commitChkpt(String filename) throws IOException {
        for (int i = 0; i < this.sets.length; ++i) {
            this.sets[i].commitChkpt(filename + "_" + i);
        }
    }

    @Override
    public final void recover(String filename) throws IOException {
        for (int i = 0; i < this.sets.length; ++i) {
            this.sets[i].recover(filename + "_" + i);
        }
    }

    public FPSet[] getFPSets() {
        return this.sets;
    }
}

