/*
 * Decompiled with CFR 0.152.
 */
package tla2tex;

import java.util.Hashtable;
import java.util.Vector;
import tla2tex.BuiltInSymbols;
import tla2tex.CharReader;
import tla2tex.CommentToken;
import tla2tex.Debug;
import tla2tex.Misc;
import tla2tex.Parameters;
import tla2tex.Position;
import tla2tex.Token;

public class TokenizeSpec {
    private static Hashtable identHashTable = new Hashtable(1000);
    private static Hashtable usedBuiltinHashTable = new Hashtable(1000);
    private static Hashtable stringHashTable = new Hashtable(100);
    private static String nullString = "";
    public static final int MODULE = 1;
    public static final int TLA = 2;
    public static final int PLUSCAL = 3;
    public static final int P_PLUSCAL = 4;
    public static boolean hasPcal;
    public static boolean isCSyntax;
    public static Position pcalStart;
    public static Position pcalEnd;
    private static boolean inPcal;
    private static boolean canBeLabel;
    private static boolean pseudoCom;
    private static boolean ORCom;
    private static Vector vspec;
    private static Vector linev;
    private static char nextChar;
    private static String token;
    private static String token1;
    private static String token2;
    private static String token3;
    private static int col1;
    private static int col2;
    private static int col3;
    private static int cdepth;
    private static int mdepth;
    private static int col;
    private static int ncol;
    private static CharReader reader;
    private static final int PROLOG = 1;
    private static final int PROLOG_DASH = 2;
    private static final int PROLOG_DASHES = 3;
    private static final int PROLOG_SPACES = 4;
    private static final int PROLOG_ID = 5;
    private static final int START = 6;
    private static final int ID = 7;
    private static final int NUM_OR_ID = 8;
    private static final int BS = 9;
    private static final int NUM = 10;
    private static final int NUM_OR_BI = 11;
    private static final int BSBUILT_IN = 12;
    private static final int BUILT_IN = 13;
    private static final int DASH1 = 14;
    private static final int DASH2 = 15;
    private static final int DASH3 = 16;
    private static final int DASHES = 17;
    private static final int EQ1 = 18;
    private static final int EQ2 = 19;
    private static final int EQ3 = 20;
    private static final int EQS = 21;
    private static final int LEFT_PAREN = 22;
    private static final int STRING = 23;
    private static final int ESC_STRING = 24;
    private static final int LINE_COMMENT = 25;
    private static final int LINE_COM_PAREN = 26;
    private static final int LINE_COM_STAR = 27;
    private static final int COMMENT = 28;
    private static final int COMMENT_STAR = 29;
    private static final int COMMENT_PAREN = 30;
    private static final int OR_COMMENT = 31;
    private static final int OR_COMMENT_PAREN = 32;
    private static final int OR_COMMENT_STAR = 33;
    private static final int EPILOG = 34;
    private static final int DONE = 35;
    private static final int ID_OR_PCAL_LABEL = 36;
    private static final int PCAL_LABEL = 37;
    private static final int C_DASH = 38;
    private static final int C_DASH_DASH = 39;
    private static final int GET_ALG_TOKEN = 40;
    private static final int GET_ALG_NAME = 41;
    private static int state;
    private static final int CAN_BE_LBRACE = 1;
    private static final int NOT_LBRACE = 2;
    private static final int SEEKING_LPAREN = 3;
    private static final int SEEKING_IDENT_LPAREN = 4;
    private static final int AFTER_VAR_DECL = 5;
    private static final int AFTER_COMMA = 6;

    public static boolean isIdent(String str) {
        return null != identHashTable.get(str);
    }

    public static boolean isUsedBuiltin(String str) {
        return null != usedBuiltinHashTable.get(str);
    }

    public static boolean isString(String str) {
        return null != stringHashTable.get(str);
    }

    private static void skipNextChar() {
        ncol = reader.getColumnNumber();
        nextChar = reader.getNextChar();
    }

    private static void addNextChar() {
        token = token + nextChar;
        TokenizeSpec.skipNextChar();
    }

    private static void gotoStart() {
        state = 6;
        col = ncol;
    }

    private static void TokenOut(int type) {
        if (!token.equals("") || type == 3) {
            linev.addElement(new Token(token, col, type));
        }
        if (type == 4) {
            identHashTable.put(token, nullString);
        } else if (type == 3) {
            stringHashTable.put(token, nullString);
            identHashTable.put(token, nullString);
        } else if (type == 1) {
            usedBuiltinHashTable.put(token, nullString);
        }
        token = "";
        canBeLabel = false;
    }

    private static void CommentTokenOut(int subtype) {
        linev.addElement(new CommentToken(token, col, subtype, pseudoCom));
        pseudoCom = false;
        token = "";
    }

    private static void startNewLine() {
        vspec.addElement(linev);
        linev = new Vector(30, 30);
        col = 0;
    }

    private static void SkipSpaceAndNewlines() {
        boolean notDone = true;
        while (notDone) {
            while (Misc.IsSpace(nextChar)) {
                TokenizeSpec.skipNextChar();
            }
            if (nextChar == '\n') {
                TokenizeSpec.skipNextChar();
                TokenizeSpec.startNewLine();
            } else {
                notDone = false;
            }
            col = ncol;
            token = "";
        }
    }

    private static Position getNextTokenPosition() {
        return new Position(vspec.size(), linev.size());
    }

    private static void TokenizingError(String msg) {
        Debug.ReportError(msg + " `" + token + "' found at\n" + "    line " + (reader.getLineNumber() + 1) + ", column " + (col + 1));
    }

    private static Token[][] vspecToArray() {
        Token[][] aspec = new Token[vspec.size()][];
        for (int n = 0; n < vspec.size(); ++n) {
            aspec[n] = new Token[((Vector)vspec.elementAt(n)).size()];
            for (int m = 0; m < aspec[n].length; ++m) {
                aspec[n][m] = (Token)((Vector)vspec.elementAt(n)).elementAt(m);
            }
        }
        return aspec;
    }

    public static Token[][] Tokenize(CharReader charReader, int mode) {
        vspec = new Vector(1000, 1000);
        reader = charReader;
        nextChar = reader.getNextChar();
        hasPcal = false;
        isCSyntax = false;
        pcalStart = null;
        pcalEnd = null;
        inPcal = false;
        canBeLabel = false;
        pseudoCom = false;
        ORCom = false;
        int braceDepth = 0;
        switch (mode) {
            case 1: {
                state = 1;
                break;
            }
            case 2: {
                state = 6;
                break;
            }
            case 3: {
                state = 6;
                hasPcal = true;
                pcalStart = new Position(0, 0);
                inPcal = true;
                canBeLabel = true;
                isCSyntax = true;
                break;
            }
            case 4: {
                state = 6;
                hasPcal = true;
                pcalStart = new Position(0, 0);
                inPcal = true;
                canBeLabel = true;
                break;
            }
            default: {
                Debug.ReportBug("TokenizeSpec.Tokenize called with illegal mode");
            }
        }
        block48: while (state != 35) {
            switch (state) {
                case 6: {
                    if (Misc.IsSpace(nextChar)) {
                        TokenizeSpec.skipNextChar();
                        TokenizeSpec.gotoStart();
                        continue block48;
                    }
                    if (Misc.IsLetter(nextChar)) {
                        TokenizeSpec.addNextChar();
                        state = 7;
                        continue block48;
                    }
                    if (Misc.IsDigit(nextChar)) {
                        TokenizeSpec.addNextChar();
                        state = 8;
                        continue block48;
                    }
                    if (nextChar == '\\') {
                        TokenizeSpec.addNextChar();
                        state = 9;
                        continue block48;
                    }
                    if (nextChar == '-') {
                        TokenizeSpec.addNextChar();
                        state = 14;
                        continue block48;
                    }
                    if (nextChar == '=') {
                        TokenizeSpec.addNextChar();
                        state = 18;
                        continue block48;
                    }
                    if (nextChar == '(') {
                        TokenizeSpec.skipNextChar();
                        state = 22;
                        continue block48;
                    }
                    if (nextChar == '\"') {
                        TokenizeSpec.skipNextChar();
                        state = 23;
                        continue block48;
                    }
                    if (nextChar == '\n') {
                        TokenizeSpec.skipNextChar();
                        TokenizeSpec.startNewLine();
                        TokenizeSpec.gotoStart();
                        continue block48;
                    }
                    if (BuiltInSymbols.IsBuiltInPrefix("" + nextChar, inPcal)) {
                        TokenizeSpec.addNextChar();
                        if (!inPcal || mode != 1) {
                            state = 13;
                            continue block48;
                        }
                        if (token.equals("*") && nextChar == ')') {
                            pcalEnd = TokenizeSpec.getNextTokenPosition();
                            inPcal = false;
                            token = "";
                            TokenizeSpec.gotoStart();
                            continue block48;
                        }
                        if (isCSyntax) {
                            if (token.equals("{")) {
                                TokenizeSpec.TokenOut(1);
                                canBeLabel = true;
                                ++braceDepth;
                                TokenizeSpec.gotoStart();
                                continue block48;
                            }
                            if (token.equals("}")) {
                                TokenizeSpec.TokenOut(1);
                                if (--braceDepth != 0) {
                                    TokenizeSpec.gotoStart();
                                    continue block48;
                                }
                                col = ncol;
                                inPcal = false;
                                cdepth = 1;
                                pcalEnd = TokenizeSpec.getNextTokenPosition();
                                pseudoCom = true;
                                state = 28;
                                continue block48;
                            }
                            state = 13;
                            continue block48;
                        }
                        state = 13;
                        continue block48;
                    }
                    if (nextChar == '\t') {
                        if (mode == 1) {
                            Debug.ReportError("Input ended before end of module");
                        }
                        state = 35;
                        continue block48;
                    }
                    TokenizeSpec.addNextChar();
                    TokenizeSpec.TokenizingError("Illegal lexeme");
                    continue block48;
                }
                case 7: {
                    if (token.length() == 3 && (token.equals("WF_") || token.equals("SF_"))) {
                        TokenizeSpec.TokenOut(1);
                        TokenizeSpec.gotoStart();
                        continue block48;
                    }
                    if (Misc.IsLetter(nextChar) || Misc.IsDigit(nextChar)) {
                        TokenizeSpec.addNextChar();
                        continue block48;
                    }
                    if (BuiltInSymbols.IsBuiltInSymbol(token, inPcal)) {
                        if (token.equals("MODULE")) {
                            ++mdepth;
                            TokenizeSpec.TokenOut(1);
                            TokenizeSpec.gotoStart();
                            continue block48;
                        }
                        if (inPcal && token.equals("algorithm") && !isCSyntax && mode == 1) {
                            TokenizeSpec.TokenOut(1);
                            col = ncol;
                            pcalEnd = TokenizeSpec.getNextTokenPosition();
                            cdepth = 1;
                            inPcal = false;
                            pseudoCom = true;
                            state = 28;
                            continue block48;
                        }
                        boolean cbl = inPcal && BuiltInSymbols.CanPrecedeLabel(token);
                        TokenizeSpec.TokenOut(1);
                        canBeLabel = cbl;
                        TokenizeSpec.gotoStart();
                        continue block48;
                    }
                    if (inPcal && canBeLabel) {
                        token1 = token;
                        col1 = col;
                        state = 36;
                        continue block48;
                    }
                    TokenizeSpec.TokenOut(4);
                    TokenizeSpec.gotoStart();
                    continue block48;
                }
                case 36: {
                    while (Misc.IsSpace(nextChar)) {
                        TokenizeSpec.addNextChar();
                    }
                    if (nextChar == ':') {
                        TokenizeSpec.addNextChar();
                        if (nextChar != '=' && nextChar != ':') {
                            token1 = token;
                            state = 37;
                            continue block48;
                        }
                        reader.backspace();
                        --ncol;
                        nextChar = (char)58;
                        token = token1;
                        TokenizeSpec.TokenOut(4);
                        TokenizeSpec.gotoStart();
                        continue block48;
                    }
                    token = token1;
                    TokenizeSpec.TokenOut(4);
                    TokenizeSpec.gotoStart();
                    continue block48;
                }
                case 37: {
                    while (Misc.IsSpace(nextChar)) {
                        TokenizeSpec.addNextChar();
                    }
                    if (nextChar == '+' || nextChar == '-') {
                        TokenizeSpec.addNextChar();
                        TokenizeSpec.TokenOut(13);
                        TokenizeSpec.gotoStart();
                        continue block48;
                    }
                    token = token1;
                    TokenizeSpec.TokenOut(13);
                    TokenizeSpec.gotoStart();
                    continue block48;
                }
                case 8: {
                    if (Misc.IsDigit(nextChar)) {
                        TokenizeSpec.addNextChar();
                        state = 8;
                        continue block48;
                    }
                    if (Misc.IsLetter(nextChar)) {
                        TokenizeSpec.addNextChar();
                        state = 7;
                        continue block48;
                    }
                    TokenizeSpec.TokenOut(2);
                    TokenizeSpec.gotoStart();
                    continue block48;
                }
                case 9: {
                    if (nextChar == 'b' || nextChar == 'B' || nextChar == 'o' || nextChar == 'O' || nextChar == 'h' || nextChar == 'H') {
                        TokenizeSpec.addNextChar();
                        state = 11;
                        continue block48;
                    }
                    if (Misc.IsLetter(nextChar)) {
                        state = 12;
                        continue block48;
                    }
                    if (nextChar == '*') {
                        TokenizeSpec.skipNextChar();
                        token = "";
                        state = 25;
                        continue block48;
                    }
                    state = 13;
                    continue block48;
                }
                case 11: {
                    if (Misc.IsDigit(nextChar)) {
                        state = 10;
                        continue block48;
                    }
                    state = 12;
                    continue block48;
                }
                case 10: {
                    if (Misc.IsDigit(nextChar)) {
                        TokenizeSpec.addNextChar();
                        state = 10;
                        continue block48;
                    }
                    if (Misc.IsLetter(nextChar)) {
                        TokenizeSpec.addNextChar();
                        if (token.charAt(0) == '\\') {
                            TokenizeSpec.TokenizingError("Illegal lexeme");
                            continue block48;
                        }
                        state = 7;
                        continue block48;
                    }
                    TokenizeSpec.TokenOut(2);
                    TokenizeSpec.gotoStart();
                    continue block48;
                }
                case 12: {
                    if (Misc.IsLetter(nextChar) && nextChar != '_') {
                        TokenizeSpec.addNextChar();
                        state = 12;
                        continue block48;
                    }
                    if (BuiltInSymbols.IsBuiltInSymbol(token)) {
                        TokenizeSpec.TokenOut(1);
                        TokenizeSpec.gotoStart();
                        continue block48;
                    }
                    TokenizeSpec.TokenizingError("Illegal lexeme ");
                    continue block48;
                }
                case 13: {
                    if (BuiltInSymbols.IsBuiltInPrefix(token + nextChar, inPcal)) {
                        TokenizeSpec.addNextChar();
                        continue block48;
                    }
                    if (!BuiltInSymbols.IsBuiltInSymbol(token, inPcal)) {
                        reader.backspace();
                        while (!BuiltInSymbols.IsBuiltInSymbol(token, inPcal)) {
                            reader.backspace();
                            if (token.length() == 0) {
                                TokenizeSpec.TokenizingError("Illegal lexeme");
                            }
                            token = token.substring(0, token.length() - 1);
                        }
                        nextChar = reader.getNextChar();
                    }
                    boolean saved = BuiltInSymbols.CanPrecedeLabel(token);
                    TokenizeSpec.TokenOut(1);
                    canBeLabel = saved;
                    TokenizeSpec.gotoStart();
                    continue block48;
                }
                case 14: {
                    if (nextChar == '-') {
                        TokenizeSpec.addNextChar();
                        state = 15;
                        continue block48;
                    }
                    state = 13;
                    continue block48;
                }
                case 15: {
                    if (nextChar == '-') {
                        TokenizeSpec.addNextChar();
                        state = 16;
                        continue block48;
                    }
                    state = 13;
                    continue block48;
                }
                case 16: {
                    if (nextChar == '-') {
                        TokenizeSpec.addNextChar();
                        state = 17;
                        continue block48;
                    }
                    TokenizeSpec.TokenizingError("Illegal lexeme");
                    continue block48;
                }
                case 17: {
                    if (nextChar == '-') {
                        TokenizeSpec.addNextChar();
                        state = 17;
                        continue block48;
                    }
                    TokenizeSpec.TokenOut(6);
                    TokenizeSpec.gotoStart();
                    continue block48;
                }
                case 18: {
                    if (nextChar == '=') {
                        TokenizeSpec.addNextChar();
                        state = 19;
                        continue block48;
                    }
                    state = 13;
                    continue block48;
                }
                case 19: {
                    if (nextChar == '=') {
                        TokenizeSpec.addNextChar();
                        state = 20;
                        continue block48;
                    }
                    state = 13;
                    continue block48;
                }
                case 20: {
                    if (nextChar == '=') {
                        TokenizeSpec.addNextChar();
                        state = 21;
                        continue block48;
                    }
                    TokenizeSpec.TokenizingError("Illegal lexeme");
                    continue block48;
                }
                case 21: {
                    if (nextChar == '=') {
                        TokenizeSpec.addNextChar();
                        state = 21;
                        continue block48;
                    }
                    TokenizeSpec.TokenOut(7);
                    if (--mdepth > 0 || mode == 2) {
                        TokenizeSpec.gotoStart();
                        continue block48;
                    }
                    if (mdepth == 0) {
                        state = 34;
                        continue block48;
                    }
                    Debug.ReportError("Extra end-of-module lexeme on line " + (reader.getLineNumber() + 1));
                    continue block48;
                }
                case 22: {
                    if (nextChar == '*') {
                        TokenizeSpec.skipNextChar();
                        cdepth = 1;
                        state = 28;
                        continue block48;
                    }
                    token = "(";
                    state = 13;
                    continue block48;
                }
                case 23: {
                    if (nextChar == '\\') {
                        TokenizeSpec.addNextChar();
                        state = 24;
                        continue block48;
                    }
                    if (nextChar == '\"') {
                        TokenizeSpec.skipNextChar();
                        TokenizeSpec.TokenOut(3);
                        TokenizeSpec.gotoStart();
                        continue block48;
                    }
                    if (BuiltInSymbols.IsStringChar(nextChar)) {
                        TokenizeSpec.addNextChar();
                        state = 23;
                        continue block48;
                    }
                    TokenizeSpec.addNextChar();
                    TokenizeSpec.TokenizingError("Illegal character in string");
                    continue block48;
                }
                case 24: {
                    if (nextChar == '\"' || nextChar == '\\' || nextChar == 't' || nextChar == 'n' || nextChar == 'f' || nextChar == 'r') {
                        TokenizeSpec.addNextChar();
                        state = 23;
                        continue block48;
                    }
                    TokenizeSpec.addNextChar();
                    TokenizeSpec.TokenizingError("Illegal character following \\ in string");
                    continue block48;
                }
                case 25: {
                    if (nextChar == '(') {
                        TokenizeSpec.skipNextChar();
                        state = 26;
                        continue block48;
                    }
                    if (nextChar == '*' && cdepth > 0) {
                        TokenizeSpec.skipNextChar();
                        state = 27;
                        continue block48;
                    }
                    if (nextChar == '\n' || nextChar == '\t') {
                        TokenizeSpec.CommentTokenOut(2);
                        cdepth = 0;
                        TokenizeSpec.gotoStart();
                        continue block48;
                    }
                    if (cdepth == 0) {
                        TokenizeSpec.addNextChar();
                    } else {
                        TokenizeSpec.skipNextChar();
                    }
                    state = 25;
                    continue block48;
                }
                case 26: {
                    if (nextChar == '*') {
                        TokenizeSpec.skipNextChar();
                        ++cdepth;
                        state = 25;
                        continue block48;
                    }
                    if (cdepth == 0) {
                        token = token + "(";
                    }
                    state = 25;
                    continue block48;
                }
                case 27: {
                    if (nextChar == ')') {
                        TokenizeSpec.skipNextChar();
                        Debug.Assert(--cdepth >= 0, "case LINE_COM_STAR");
                        state = 25;
                        continue block48;
                    }
                    if (cdepth == 0) {
                        token = token + "*";
                    }
                    state = 25;
                    continue block48;
                }
                case 28: {
                    if (nextChar == '*') {
                        TokenizeSpec.skipNextChar();
                        state = 29;
                        continue block48;
                    }
                    if (nextChar == '(') {
                        TokenizeSpec.skipNextChar();
                        state = 30;
                        continue block48;
                    }
                    if (nextChar == '\n') {
                        TokenizeSpec.CommentTokenOut(3);
                        TokenizeSpec.skipNextChar();
                        TokenizeSpec.startNewLine();
                        state = 31;
                        continue block48;
                    }
                    if (nextChar == '\t') {
                        Debug.ReportError("Input ended in the middle of a comment");
                        continue block48;
                    }
                    if (nextChar == '-' && cdepth == 1 && mode == 1 && !hasPcal) {
                        token1 = token;
                        col1 = col;
                        token = "";
                        col = ncol;
                        ORCom = false;
                        TokenizeSpec.addNextChar();
                        state = 38;
                        continue block48;
                    }
                    if (cdepth == 1) {
                        TokenizeSpec.addNextChar();
                        continue block48;
                    }
                    TokenizeSpec.skipNextChar();
                    continue block48;
                }
                case 29: {
                    if (nextChar == ')') {
                        TokenizeSpec.skipNextChar();
                        if (--cdepth == 0) {
                            TokenizeSpec.CommentTokenOut(1);
                            TokenizeSpec.gotoStart();
                            continue block48;
                        }
                        state = 28;
                        continue block48;
                    }
                    if (cdepth == 1) {
                        token = token + "*";
                    }
                    state = 28;
                    continue block48;
                }
                case 38: {
                    if (nextChar == '-') {
                        TokenizeSpec.addNextChar();
                        state = 39;
                        continue block48;
                    }
                    token = token1 + token;
                    col = col1;
                    state = ORCom ? 31 : 28;
                    continue block48;
                }
                case 39: {
                    while (Misc.IsLetter(nextChar)) {
                        TokenizeSpec.addNextChar();
                    }
                    boolean isAlgorithm = token.equals("--algorithm");
                    if (isAlgorithm || token.equals("--fair")) {
                        if (!Misc.isBlank(token1)) {
                            pseudoCom = true;
                            token2 = token;
                            col2 = col;
                            token = token1;
                            col = col1;
                            TokenizeSpec.CommentTokenOut(ORCom ? 4 : 1);
                            token = token2;
                            col = col2;
                        }
                        hasPcal = true;
                        pcalStart = TokenizeSpec.getNextTokenPosition();
                        TokenizeSpec.TokenOut(1);
                        TokenizeSpec.SkipSpaceAndNewlines();
                        if (isAlgorithm) {
                            state = 41;
                            continue block48;
                        }
                        state = 40;
                        continue block48;
                    }
                    token = token1 + token;
                    col = col1;
                    state = 28;
                    continue block48;
                }
                case 40: {
                    while (Misc.IsLetter(nextChar)) {
                        TokenizeSpec.addNextChar();
                    }
                    if (token.equals("algorithm")) {
                        TokenizeSpec.TokenOut(1);
                        TokenizeSpec.SkipSpaceAndNewlines();
                        state = 41;
                        continue block48;
                    }
                    pcalEnd = TokenizeSpec.getNextTokenPosition();
                    pseudoCom = true;
                    state = 28;
                    continue block48;
                }
                case 41: {
                    while (Misc.IsLetter(nextChar) || Misc.IsDigit(nextChar)) {
                        TokenizeSpec.addNextChar();
                    }
                    if (Misc.hasLetter(token)) {
                        TokenizeSpec.TokenOut(4);
                        TokenizeSpec.SkipSpaceAndNewlines();
                        isCSyntax = nextChar == '{';
                        cdepth = 0;
                        inPcal = true;
                        braceDepth = 0;
                        TokenizeSpec.gotoStart();
                        continue block48;
                    }
                    pcalEnd = TokenizeSpec.getNextTokenPosition();
                    pseudoCom = true;
                    state = 28;
                    continue block48;
                }
                case 30: {
                    if (nextChar == '*') {
                        TokenizeSpec.skipNextChar();
                        ++cdepth;
                        state = 28;
                        continue block48;
                    }
                    if (cdepth == 1) {
                        token = token + "(";
                    }
                    state = 28;
                    continue block48;
                }
                case 31: {
                    if (nextChar == '*') {
                        TokenizeSpec.skipNextChar();
                        state = 33;
                        continue block48;
                    }
                    if (nextChar == '(') {
                        TokenizeSpec.skipNextChar();
                        state = 32;
                        continue block48;
                    }
                    if (nextChar == '\n') {
                        TokenizeSpec.CommentTokenOut(5);
                        TokenizeSpec.skipNextChar();
                        TokenizeSpec.startNewLine();
                        state = 31;
                        continue block48;
                    }
                    if (nextChar == '-' && cdepth == 1 && mode == 1 && !hasPcal) {
                        token1 = token;
                        col1 = col;
                        token = "";
                        col = ncol;
                        ORCom = true;
                        TokenizeSpec.addNextChar();
                        state = 38;
                        continue block48;
                    }
                    if (nextChar == '\t') {
                        Debug.ReportError("Input ended in the middle of a multi-line comment");
                        continue block48;
                    }
                    if (cdepth == 1) {
                        TokenizeSpec.addNextChar();
                        continue block48;
                    }
                    TokenizeSpec.skipNextChar();
                    continue block48;
                }
                case 33: {
                    if (nextChar == ')') {
                        TokenizeSpec.skipNextChar();
                        Debug.Assert(--cdepth >= 0);
                        if (cdepth == 0) {
                            TokenizeSpec.CommentTokenOut(4);
                            TokenizeSpec.gotoStart();
                            continue block48;
                        }
                        state = 31;
                        continue block48;
                    }
                    if (cdepth == 1) {
                        token = token + "*";
                    }
                    state = 31;
                    continue block48;
                }
                case 32: {
                    if (nextChar == '*') {
                        TokenizeSpec.skipNextChar();
                        ++cdepth;
                        state = 31;
                        continue block48;
                    }
                    if (cdepth == 1) {
                        token = token + "(";
                    }
                    state = 31;
                    continue block48;
                }
                case 1: {
                    if (nextChar == '-') {
                        token1 = token;
                        col1 = col;
                        col = ncol;
                        token = "-";
                        TokenizeSpec.skipNextChar();
                        state = 2;
                        continue block48;
                    }
                    if (nextChar == '\n') {
                        TokenizeSpec.TokenOut(8);
                        TokenizeSpec.skipNextChar();
                        TokenizeSpec.startNewLine();
                        continue block48;
                    }
                    if (nextChar == '\t') {
                        Debug.ReportError("Input ended before beginning of module");
                        continue block48;
                    }
                    TokenizeSpec.addNextChar();
                    continue block48;
                }
                case 2: {
                    Debug.Assert(token.length() <= 3);
                    if (nextChar == '-') {
                        TokenizeSpec.addNextChar();
                        if (token.length() != 4) continue block48;
                        state = 3;
                        continue block48;
                    }
                    token = token1 + token;
                    col = col1;
                    state = 1;
                    continue block48;
                }
                case 3: {
                    if (nextChar == '-') {
                        TokenizeSpec.addNextChar();
                        continue block48;
                    }
                    token2 = token;
                    col2 = col;
                    token = "";
                    col = ncol;
                    state = 4;
                    continue block48;
                }
                case 4: {
                    if (nextChar == ' ') {
                        TokenizeSpec.addNextChar();
                        continue block48;
                    }
                    if (Misc.IsLetter(nextChar)) {
                        token3 = token;
                        col3 = ncol;
                        token = "";
                        state = 5;
                        continue block48;
                    }
                    token = token1 + token2;
                    col = col1;
                    state = 1;
                    continue block48;
                }
                case 5: {
                    if (Misc.IsLetter(nextChar)) {
                        TokenizeSpec.addNextChar();
                        continue block48;
                    }
                    if (token.equals("MODULE")) {
                        token = token1;
                        col = col1;
                        TokenizeSpec.TokenOut(8);
                        token = token2;
                        col = col2;
                        TokenizeSpec.TokenOut(6);
                        token = "MODULE";
                        col = col3;
                        TokenizeSpec.TokenOut(1);
                        token = "";
                        mdepth = 1;
                        TokenizeSpec.gotoStart();
                        continue block48;
                    }
                    token = token1 + token2 + token3;
                    col = col1;
                    state = 1;
                    continue block48;
                }
                case 34: {
                    if (nextChar == '\n') {
                        TokenizeSpec.TokenOut(9);
                        TokenizeSpec.skipNextChar();
                        TokenizeSpec.startNewLine();
                        continue block48;
                    }
                    if (nextChar == '\t') {
                        TokenizeSpec.TokenOut(9);
                        state = 35;
                        continue block48;
                    }
                    TokenizeSpec.addNextChar();
                    continue block48;
                }
            }
            Debug.ReportBug("Illegal state in TokenizeSpec.Tokenize");
        }
        if (hasPcal && pcalEnd == null) {
            pcalEnd = new Position(Integer.MAX_VALUE, 0);
        }
        return TokenizeSpec.vspecToArray();
    }

    public static void FixPlusCal(Token[][] spec, boolean isTeX) {
        String firstString;
        boolean beginningOfAlgorithm;
        if (!hasPcal) {
            return;
        }
        if (Parameters.CommentShading && Parameters.NoPlusCalShading && TokenizeSpec.pcalEnd.line < spec.length && TokenizeSpec.pcalEnd.item < spec[TokenizeSpec.pcalEnd.line].length) {
            Token tok = pcalEnd.toToken(spec);
            if (tok.type == 5) {
                CommentToken ctok = (CommentToken)tok;
                if (ctok.string.trim().equals("")) {
                    int rsubtype = ctok.rsubtype;
                    Token[] newline = new Token[spec[TokenizeSpec.pcalEnd.line].length - 1];
                    int j = 0;
                    for (int i = 0; i < spec[TokenizeSpec.pcalEnd.line].length; ++i) {
                        if (i == TokenizeSpec.pcalEnd.item) continue;
                        newline[j] = spec[TokenizeSpec.pcalEnd.line][i];
                        ++j;
                    }
                    if (rsubtype == 1) {
                        spec[TokenizeSpec.pcalEnd.line] = newline;
                    } else if (rsubtype == 3) {
                        Token next = spec[TokenizeSpec.pcalEnd.line + 1][0];
                        int nextLine = TokenizeSpec.pcalEnd.line + 1;
                        while (next != null && next.type == 5 && ((CommentToken)next).rsubtype == 5 && next.string.trim().equals("")) {
                            if (spec[++nextLine + 1].length > 0) {
                                next = spec[nextLine][0];
                                continue;
                            }
                            next = null;
                        }
                        if (next != null && next.type == 5 && next.string.trim().equals("") && ((CommentToken)next).rsubtype == 4) {
                            spec[TokenizeSpec.pcalEnd.line] = newline;
                            for (int i = TokenizeSpec.pcalEnd.line + 1; i < nextLine; ++i) {
                                spec[i] = new Token[0];
                            }
                            newline = new Token[spec[nextLine].length - 1];
                            System.arraycopy(spec[nextLine], 1, newline, 0, spec[nextLine].length - 1);
                            spec[nextLine] = newline;
                        }
                    }
                }
            }
        }
        if (!isCSyntax) {
            return;
        }
        Position pos = pcalStart;
        boolean bl = beginningOfAlgorithm = !isTeX;
        if (isTeX && pos != null && ((firstString = pos.toToken((Token[][])spec).string).equals("--algorithm") || firstString.equals("--fair"))) {
            beginningOfAlgorithm = true;
        }
        if (beginningOfAlgorithm) {
            while (!(pos == null || pos.toToken((Token[][])spec).type == 1 && pos.toToken((Token[][])spec).string.equals("{"))) {
                pos = TokenizeSpec.nextTokenPos(pos, spec);
            }
        }
        if (pos != null) {
            pos = TokenizeSpec.ProcessPcalBrace(pos, spec, isTeX);
        }
        while (isTeX && pos != null) {
            pos = TokenizeSpec.ProcessPcalBrace(pos, spec, isTeX);
        }
    }

    public static Position ProcessPcalBrace(Position pos, Token[][] spec, boolean isTeX) {
        Token tok = pos.toToken(spec);
        Position curPos = pos;
        if (!isTeX) {
            tok.string = BuiltInSymbols.pcalLeftBrace;
            curPos = TokenizeSpec.nextNonComment(pos, spec);
        }
        int pstate = 1;
        block8: while (curPos != null) {
            tok = curPos.toToken(spec);
            switch (pstate) {
                case 1: {
                    if (tok.type == 1 && tok.string.equals("{")) {
                        curPos = TokenizeSpec.ProcessPcalBrace(curPos, spec, false);
                        continue block8;
                    }
                    pstate = 2;
                    continue block8;
                }
                case 2: {
                    if (tok.type == 13) {
                        pstate = 1;
                    } else if (tok.type == 1) {
                        if (tok.string.equals(";") || tok.string.equals("else") || tok.string.equals("either") || tok.string.equals("or") || tok.string.equals("define")) {
                            pstate = 1;
                        } else {
                            if (tok.string.equals("}")) {
                                tok.string = BuiltInSymbols.pcalRightBrace;
                                return TokenizeSpec.nextNonComment(curPos, spec);
                            }
                            if (BuiltInSymbols.GetBuiltInSymbol((String)tok.string, (boolean)true).symbolType == 4) {
                                curPos = TokenizeSpec.skipToUnmatchedEnd(TokenizeSpec.nextNonComment(curPos, spec), spec, false);
                            } else if (tok.string.equals("variable") || tok.string.equals("variables")) {
                                pstate = 5;
                            } else if (tok.string.equals("if") || tok.string.equals("while") || tok.string.equals("with") || tok.string.equals("process")) {
                                pstate = 3;
                            } else if (tok.string.equals("procedure") || tok.string.equals("macro")) {
                                pstate = 4;
                            }
                        }
                    }
                    curPos = TokenizeSpec.nextNonComment(curPos, spec);
                    continue block8;
                }
                case 3: {
                    if (tok.type == 1 && tok.string.equals("(")) {
                        tok.string = BuiltInSymbols.pcalLeftParen;
                        if ((curPos = TokenizeSpec.skipToUnmatchedEnd(TokenizeSpec.nextNonComment(curPos, spec), spec, false)) != null) {
                            tok = curPos.toToken(spec);
                            if (tok.type == 1 && tok.string.equals(")")) {
                                tok.string = BuiltInSymbols.pcalRightParen;
                            } else {
                                System.out.println("Error SEEKING_LPAREN at " + curPos.toString());
                            }
                        }
                        pstate = 1;
                    } else {
                        System.out.println("Error SEEKING_LPAREN(2) at " + curPos.toString());
                        pstate = 2;
                    }
                    curPos = TokenizeSpec.nextNonComment(curPos, spec);
                    continue block8;
                }
                case 4: {
                    if (tok.type == 4) {
                        pstate = 3;
                    } else {
                        System.out.println("Error SEEKING_IDENT_LPAREN at " + curPos.toString());
                        pstate = 2;
                    }
                    curPos = TokenizeSpec.nextNonComment(curPos, spec);
                    continue block8;
                }
                case 5: {
                    if (tok.type == 1 && (tok.string.equals(",") || tok.string.equals(";"))) {
                        pstate = 6;
                    } else if (tok.type == 1 && BuiltInSymbols.GetBuiltInSymbol((String)tok.string, (boolean)true).symbolType == 4) {
                        curPos = TokenizeSpec.skipToUnmatchedEnd(TokenizeSpec.nextNonComment(curPos, spec), spec, false);
                    }
                    curPos = TokenizeSpec.nextNonComment(curPos, spec);
                    continue block8;
                }
                case 6: {
                    if (tok.type == 1 && tok.string.equals("{")) {
                        curPos = TokenizeSpec.ProcessPcalBrace(curPos, spec, false);
                        pstate = 2;
                        continue block8;
                    }
                    if (tok.type == 1 && (tok.string.equals("define") || tok.string.equals("macro") || tok.string.equals("procedure") || tok.string.equals("fair") || tok.string.equals("process"))) {
                        pstate = 2;
                        continue block8;
                    }
                    pstate = 5;
                    continue block8;
                }
            }
            Debug.ReportBug("Impossible case in TokenizeSpec.ProcessPcalBrace");
        }
        return curPos;
    }

    private static Position nextTokenPos(Position pos, Token[][] spec) {
        int nextLine;
        if (pos == null) {
            return null;
        }
        int nextItem = pos.item + 1;
        if (nextItem < spec[pos.line].length && (pos.line < TokenizeSpec.pcalEnd.line || nextItem < TokenizeSpec.pcalEnd.item)) {
            return new Position(pos.line, nextItem);
        }
        for (nextLine = pos.line + 1; nextLine < spec.length && spec[nextLine].length == 0; ++nextLine) {
        }
        if (nextLine < spec.length && (nextLine < TokenizeSpec.pcalEnd.line || nextLine == TokenizeSpec.pcalEnd.line && 0 < TokenizeSpec.pcalEnd.item)) {
            return new Position(nextLine, 0);
        }
        return null;
    }

    private static Position nextNonComment(Position pos, Token[][] spec) {
        Position nextPos = TokenizeSpec.nextTokenPos(pos, spec);
        while (nextPos != null && nextPos.toToken((Token[][])spec).type == 5) {
            nextPos = TokenizeSpec.nextTokenPos(nextPos, spec);
        }
        return nextPos;
    }

    public static Position skipToUnmatchedEnd(Position pos, Token[][] spec, boolean punct) {
        Position nextPos = pos;
        while (nextPos != null) {
            Token tok = nextPos.toToken(spec);
            if (tok.type == 1) {
                int symType = BuiltInSymbols.GetBuiltInSymbol((String)tok.string, (boolean)true).symbolType;
                if (symType == 5 || punct && (tok.string.equals(";") || tok.string.equals(","))) {
                    return nextPos;
                }
                if (symType == 4) {
                    nextPos = TokenizeSpec.nextNonComment(nextPos, spec);
                    nextPos = TokenizeSpec.skipToUnmatchedEnd(nextPos, spec, false);
                }
            }
            nextPos = TokenizeSpec.nextNonComment(nextPos, spec);
        }
        return null;
    }

    static {
        vspec = null;
        linev = new Vector(30, 30);
        token = "";
        token1 = "";
        token2 = "";
        token3 = "";
        col1 = 0;
        col2 = 0;
        col3 = 0;
        cdepth = 0;
        mdepth = 0;
        ncol = 0;
        state = 0;
    }
}

