/*
 * Decompiled with CFR 0.152.
 */
package tla2tex;

import tla2tex.BuiltInSymbols;
import tla2tex.CommentToken;
import tla2tex.Debug;
import tla2tex.Position;
import tla2tex.Token;
import tla2tex.TokenizeSpec;

public class FindAlignments {
    public static void FindAlignments(Token[][] spec) {
        int item;
        FindAlignments.setSubscriptField(spec);
        int line = 0;
        boolean inProlog = true;
        while (inProlog && line < spec.length) {
            if (spec[line].length > 0 && spec[line][0].type != 8) {
                inProlog = false;
                continue;
            }
            ++line;
        }
        while (line < spec.length) {
            boolean prevInfixInner = false;
            for (item = 0; item < spec[line].length; ++item) {
                Position pos = new Position(line, item);
                Token token = spec[line][item];
                if (!token.subscript) {
                    if (FindAlignments.isRightComment(spec, pos)) {
                        Position bpos = FindAlignments.blockingPosition(spec, pos);
                        Token btoken = null;
                        if (bpos.line != -1) {
                            btoken = bpos.toToken(spec);
                        }
                        CommentToken ctok = (CommentToken)token;
                        if (ctok.subtype == 8 || ctok.subtype == 9) {
                            Debug.Assert(btoken != null && btoken.type == 5, "Bad blocking token for a MULTI or NULL token");
                            token.aboveAlign = ((CommentToken)btoken).subtype == 7 ? bpos : btoken.aboveAlign;
                            btoken.belowAlign = pos;
                        } else if (bpos.line != -1 && FindAlignments.isRightComment(spec, bpos) && btoken.column == token.column && (btoken.aboveAlign.line == -1 && bpos.item > 0 || btoken.aboveAlign.line != -1 && btoken.aboveAlign.toToken((Token[][])spec).belowAlign.line != -1)) {
                            btoken.belowAlign = pos;
                            token.aboveAlign = btoken.aboveAlign.line == -1 ? bpos : btoken.aboveAlign;
                        } else if (item == 0 || item == 1 && spec[line][0].type == 5) {
                            pos.toToken((Token[][])spec).aboveAlign = FindAlignments.coveringPosition(spec, pos, true);
                        }
                        prevInfixInner = false;
                    }
                    if (prevInfixInner) {
                        Debug.Assert(pos.item > 0, "prevInfixInner true for first item on line");
                        Position lPos = new Position(pos.line, pos.item - 1);
                        Debug.Assert(lPos.toToken((Token[][])spec).aboveAlign.line != -1, "prevInfixInner true, but token to left not aligned");
                        Position alPos = lPos.toToken((Token[][])spec).aboveAlign;
                        Token alToken = alPos.toToken(spec);
                        if (alPos.item + 1 < spec[alPos.line].length) {
                            Position aPos = new Position(alPos.line, alPos.item + 1);
                            Token atoken = aPos.toToken(spec);
                            Position cPos = FindAlignments.coveringPosition(spec, pos, true);
                            if (cPos.line == aPos.line && cPos.item == aPos.item && token.column == atoken.column && atoken.type != 5) {
                                token.aboveAlign = aPos;
                            }
                        }
                        prevInfixInner = false;
                        continue;
                    }
                    if (item == 0 && token.type != 5 || item == 1 && spec[line][0].type == 5) {
                        token.aboveAlign = FindAlignments.coveringPosition(spec, pos, true);
                        continue;
                    }
                    if (FindAlignments.isLeftComment(spec, pos)) {
                        token.aboveAlign = FindAlignments.coveringPosition(spec, pos, false);
                        continue;
                    }
                    Position cpos = FindAlignments.coveringPosition(spec, pos, true);
                    Token ctoken = null;
                    if (cpos.line != -1) {
                        ctoken = cpos.toToken(spec);
                    }
                    int alignClass = 0;
                    int calignClass = 0;
                    if (token.type == 1) {
                        alignClass = BuiltInSymbols.GetBuiltInSymbol((String)token.string, (boolean)true).alignmentType;
                    }
                    if (ctoken != null && ctoken.type == 1) {
                        calignClass = BuiltInSymbols.GetBuiltInSymbol((String)ctoken.string, (boolean)true).alignmentType;
                    }
                    if (ctoken != null && token.column == ctoken.column && alignClass != 0 && alignClass == calignClass) {
                        ctoken.belowAlign = pos;
                        token.aboveAlign = ctoken.aboveAlign.line == -1 ? cpos : ctoken.aboveAlign;
                        prevInfixInner = true;
                        continue;
                    }
                    if (item != 1 && (item != 2 || spec[line][0].type != 5) || spec[line][item - 1].type != 1 || BuiltInSymbols.GetBuiltInSymbol((String)spec[line][item - 1].string, (boolean)true).symbolType != 1 || ctoken == null || token.column != ctoken.column || spec[line][item - 1].aboveAlign.line == -1) continue;
                    Token lTok = spec[line][item - 1];
                    Position alPos = lTok.aboveAlign;
                    Token alTok = alPos.toToken(spec);
                    if (alPos.line == cpos.line && alPos.item == cpos.item - 1) {
                        token.aboveAlign = cpos;
                        continue;
                    }
                    if (cpos.item != 0 && (cpos.item != 1 || spec[cpos.line][0].type != 5)) continue;
                    token.aboveAlign = cpos;
                    ctoken.belowAlign = pos;
                    continue;
                }
                prevInfixInner = false;
            }
            if (++line >= spec.length || spec[line].length <= 0 || spec[line][0].type != 9) continue;
            line = spec.length;
        }
        FindAlignments.FindLabelAlignments(spec);
        for (line = 0; line < spec.length; ++line) {
            for (item = 0; item < spec[line].length; ++item) {
                Token token = spec[line][item];
                if (token.aboveAlign.line != -1) {
                    if (item > 0) {
                        token.isAlignmentPoint = true;
                    }
                    if (token.aboveAlign.item != 0) {
                        token.aboveAlign.toToken((Token[][])spec).isAlignmentPoint = true;
                    }
                }
                if (token.belowAlign.line == -1) continue;
                if (item > 0) {
                    token.isAlignmentPoint = true;
                }
                if (token.belowAlign.line == 0) continue;
                token.belowAlign.toToken((Token[][])spec).isAlignmentPoint = true;
            }
        }
    }

    public static void FindLabelAlignments(Token[][] spec) {
        if (!TokenizeSpec.hasPcal) {
            return;
        }
        int pcalStartLine = TokenizeSpec.pcalStart.line + 1;
        int pcalEndLine = TokenizeSpec.pcalEnd.line;
        for (int curLabelLine = pcalStartLine; curLabelLine <= pcalEndLine && curLabelLine < spec.length; ++curLabelLine) {
            if (spec[curLabelLine].length <= 1 || spec[curLabelLine][0].type != 13) continue;
            Token tok = spec[curLabelLine][1];
            int alignCol = tok.column;
            int curLine = curLabelLine + 1;
            int alignLine = curLabelLine;
            int alignItem = 1;
            boolean notDone = true;
            while (notDone) {
                int curItem = 0;
                boolean shouldSkip = false;
                if (spec[curLine].length != 0) {
                    if (spec[curLine][0].type == 13) {
                        if (spec[curLine].length > 1) {
                            curItem = 1;
                        } else {
                            notDone = spec[curLine][0].column >= alignCol;
                            shouldSkip = true;
                        }
                    }
                    if (!shouldSkip) {
                        if (spec[curLine][curItem].column < alignCol) {
                            notDone = false;
                        } else if (spec[curLine][curItem].column == alignCol) {
                            spec[alignLine][alignItem].belowAlign = new Position(curLine, curItem);
                            spec[curLine][curItem].aboveAlign = new Position(alignLine, alignItem);
                            alignLine = curLine;
                            alignItem = curItem;
                        }
                    }
                }
                if (++curLine <= pcalEndLine && curLine < spec.length) continue;
                notDone = false;
            }
            if (tok.aboveAlign.line != -1 && tok.aboveAlign.toToken((Token[][])spec).belowAlign.equals(new Position(curLabelLine, 1))) continue;
            curLine = curLabelLine - 1;
            alignLine = curLabelLine;
            alignItem = 1;
            notDone = true;
            while (notDone) {
                if (spec[curLine].length > 0 && spec[curLine][0].column <= alignCol && (spec[curLine][0].type != 13 || spec[curLine].length > 1 && spec[curLine][1].column <= alignCol)) {
                    if (spec[curLine][0].column == alignCol) {
                        spec[alignLine][alignItem].aboveAlign = new Position(curLine, 0);
                        spec[curLine][0].belowAlign = new Position(alignLine, alignItem);
                        alignLine = curLine;
                        alignItem = 0;
                    } else if (spec[alignLine][alignItem].aboveAlign.line == -1) {
                        int item;
                        for (item = 0; item < spec[curLine].length && spec[curLine][item].column <= alignCol; ++item) {
                        }
                        Token altok = null;
                        if (--item > 0) {
                            altok = spec[curLine][item - 1];
                        }
                        if (altok != null && (altok.type == 13 || altok.type == 1 && BuiltInSymbols.IsBuiltInSymbol(altok.string, true) && !BuiltInSymbols.IsBuiltInSymbol(altok.string, false))) {
                            spec[alignLine][alignItem].aboveAlign = new Position(curLine, item);
                            if (spec[curLine][item].column == alignCol) {
                                spec[curLine][item].belowAlign = new Position(alignLine, alignItem);
                            }
                        }
                        notDone = false;
                    } else {
                        notDone = false;
                    }
                }
                if (--curLine >= pcalStartLine) continue;
                notDone = false;
            }
        }
    }

    private static boolean isLeftComment(Token[][] spec, Position p) {
        return p.item == 0 && spec[p.line][p.item].type == 5 && spec[p.line].length > 1;
    }

    private static boolean isRightComment(Token[][] spec, Position p) {
        return p.item == spec[p.line].length - 1 && spec[p.line][p.item].type == 5;
    }

    private static Position coveringPosition(Token[][] spec, Position p, boolean ignore) {
        int item;
        int line = p.line - 1;
        Token tok = p.toToken(spec);
        boolean notDone = true;
        while (line >= 0 && notDone) {
            if (spec[line].length > 0) {
                if (spec[line][0].type == 8) {
                    line = -1;
                    notDone = false;
                } else {
                    item = 0;
                    if (ignore && FindAlignments.isLeftComment(spec, new Position(line, 0))) {
                        item = 1;
                    }
                    if (spec[line][item].column <= tok.column) {
                        notDone = false;
                    }
                }
            }
            if (!notDone) continue;
            --line;
        }
        if (line == -1) {
            return new Position(-1, 0);
        }
        item = 0;
        int nsItem = 0;
        boolean dashFound = false;
        if (spec[line][0].type == 6) {
            dashFound = true;
        }
        while (!dashFound && item + 1 < spec[line].length && spec[line][item + 1].column <= tok.column) {
            if (spec[line][item + 1].type == 6) {
                dashFound = true;
            }
            if (spec[line][++item].subscript) continue;
            nsItem = item;
        }
        if (dashFound) {
            return new Position(-1, 0);
        }
        return new Position(line, nsItem);
    }

    private static Position blockingPosition(Token[][] spec, Position p) {
        int line = p.line - 1;
        int item = 0;
        Token tok = p.toToken(spec);
        boolean notDone = true;
        while (line >= 0 && notDone) {
            if (spec[line].length > 0) {
                if (spec[line][0].type == 8) {
                    line = -1;
                    notDone = false;
                } else {
                    item = 0;
                    if (FindAlignments.isLeftComment(spec, new Position(line, 0))) {
                        item = 1;
                    }
                    while (notDone && item < spec[line].length) {
                        if (spec[line][item].column >= tok.column && !spec[line][item].subscript) {
                            notDone = false;
                            continue;
                        }
                        ++item;
                    }
                }
            }
            if (!notDone) continue;
            --line;
        }
        if (line == -1) {
            return new Position(-1, 0);
        }
        return new Position(line, item);
    }

    private static void setSubscriptField(Token[][] spec) {
        for (int line = 0; line < spec.length; ++line) {
            int startSub = -1;
            int nestingDepth = 0;
            for (int item = 0; item < spec[line].length; ++item) {
                Token tok = spec[line][item];
                if (startSub == -1) {
                    if (tok.type != 1 || BuiltInSymbols.GetBuiltInSymbol((String)tok.string, (boolean)true).symbolType != 6 && !tok.string.equals("^")) continue;
                    startSub = item + 1;
                    continue;
                }
                int symType = 10;
                if (tok.type == 1) {
                    symType = BuiltInSymbols.GetBuiltInSymbol((String)tok.string, (boolean)true).symbolType;
                }
                if (nestingDepth == 0 && symType != 4 || nestingDepth == 1 && symType == 5) {
                    nestingDepth = 0;
                    while (startSub <= item) {
                        spec[line][startSub].subscript = true;
                        ++startSub;
                    }
                    startSub = -1;
                    continue;
                }
                if (symType == 4) {
                    ++nestingDepth;
                    continue;
                }
                if (symType != 5) continue;
                --nestingDepth;
            }
        }
    }
}

