/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.parser;

import tla2sany.parser.OSelement;
import tla2sany.parser.Operator;
import tla2sany.parser.Operators;
import tla2sany.parser.ParseError;
import tla2sany.parser.ParseErrors;
import tla2sany.parser.ParseException;
import tla2sany.parser.SyntaxTreeNode;
import tla2sany.st.SyntaxTreeConstants;
import tla2sany.utilities.Vector;
import util.UniqueString;

public class OperatorStack
implements SyntaxTreeConstants {
    private Vector StackOfStack = new Vector(10);
    private SyntaxTreeNode VoidSTNode = new SyntaxTreeNode();
    private Vector CurrentTop = null;
    private ParseErrors PErrors;
    private Operator fcnOp;

    public OperatorStack(ParseErrors pe) {
        this.PErrors = pe;
        this.fcnOp = Operators.getOperator(UniqueString.uniqueStringOf("["));
    }

    public final void newStack() {
        this.CurrentTop = new Vector(20);
        this.StackOfStack.addElement(this.CurrentTop);
    }

    public final void popStack() {
        this.StackOfStack.removeElementAt(this.StackOfStack.size() - 1);
        this.CurrentTop = this.StackOfStack.size() > 0 ? (Vector)this.StackOfStack.elementAt(this.StackOfStack.size() - 1) : null;
    }

    public final boolean empty() {
        return this.CurrentTop.size() == 0;
    }

    public final int size() {
        return this.CurrentTop.size();
    }

    public final boolean preInEmptyTop() {
        if (this.CurrentTop == null) {
            return true;
        }
        if (this.CurrentTop.size() == 0) {
            return true;
        }
        Operator op = ((OSelement)this.CurrentTop.elementAt(this.CurrentTop.size() - 1)).getOperator();
        if (op != null) {
            return op.isPrefix() || op.isInfix();
        }
        return false;
    }

    private final void reduceInfix(Operator op) {
        int n = this.CurrentTop.size() - 1;
        if (n >= 3) {
            SyntaxTreeNode lSTN;
            SyntaxTreeNode opNode = ((OSelement)this.CurrentTop.elementAt(n - 2)).getNode();
            SyntaxTreeNode leftOp = ((OSelement)this.CurrentTop.elementAt(n - 3)).getNode();
            SyntaxTreeNode rightOp = ((OSelement)this.CurrentTop.elementAt(n - 1)).getNode();
            this.CurrentTop.removeElementAt(n - 1);
            this.CurrentTop.removeElementAt(n - 2);
            if (op.isNfix() && leftOp.isKind(349)) {
                SyntaxTreeNode[] children = (SyntaxTreeNode[])leftOp.heirs();
                SyntaxTreeNode[] newC = new SyntaxTreeNode[children.length + 2];
                System.arraycopy(children, 0, newC, 0, children.length);
                newC[newC.length - 2] = opNode;
                newC[newC.length - 1] = rightOp;
                lSTN = new SyntaxTreeNode(349, newC);
            } else {
                lSTN = op.isNfix() ? new SyntaxTreeNode(349, leftOp, opNode, rightOp) : new SyntaxTreeNode(371, leftOp, opNode, rightOp);
            }
            this.CurrentTop.setElementAt(new OSelement(lSTN), n - 3);
        }
    }

    private final void reducePrefix() {
        int n = this.CurrentTop.size() - 1;
        if (n >= 2) {
            Operator op = ((OSelement)this.CurrentTop.elementAt(n - 2)).getOperator();
            SyntaxTreeNode opNode = ((OSelement)this.CurrentTop.elementAt(n - 2)).getNode();
            SyntaxTreeNode lSTN = new SyntaxTreeNode(399, ((OSelement)this.CurrentTop.elementAt(n - 2)).getNode(), ((OSelement)this.CurrentTop.elementAt(n - 1)).getNode());
            this.CurrentTop.removeElementAt(n - 1);
            this.CurrentTop.setElementAt(new OSelement(lSTN), n - 2);
        }
    }

    private final void reducePostfix() {
        int n = this.CurrentTop.size() - 1;
        if (n >= 2) {
            SyntaxTreeNode lSTN;
            Operator op = ((OSelement)this.CurrentTop.elementAt(n - 1)).getOperator();
            SyntaxTreeNode opNode = ((OSelement)this.CurrentTop.elementAt(n - 1)).getNode();
            if (op != this.fcnOp) {
                lSTN = new SyntaxTreeNode(395, ((OSelement)this.CurrentTop.elementAt(n - 2)).getNode(), opNode);
            } else {
                SyntaxTreeNode eSTN = ((OSelement)this.CurrentTop.elementAt(n - 2)).getNode();
                lSTN = new SyntaxTreeNode(eSTN.getFN(), 352, eSTN, (SyntaxTreeNode[])opNode.heirs());
            }
            this.CurrentTop.removeElementAt(n - 1);
            this.CurrentTop.setElementAt(new OSelement(lSTN), n - 2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void reduceStack() throws ParseException {
        int n;
        Object LastOp = null;
        do {
            Operator mixR;
            OSelement tm2;
            Operator oL;
            OSelement tm1;
            OSelement tm0;
            if (!(tm0 = (OSelement)this.CurrentTop.elementAt(n = this.CurrentTop.size() - 1)).isOperator()) {
                return;
            }
            Operator oR = tm0.getOperator();
            if (oR.isPostfix()) {
                if (n == 0) {
                    throw new ParseException("\n  Encountered postfix op " + oR.getIdentifier() + " in block " + tm0.getNode().getLocation().toString() + " on empty stack");
                }
                tm1 = (OSelement)this.CurrentTop.elementAt(n - 1);
                if (tm1.isOperator()) {
                    oL = tm1.getOperator();
                    if (oL.isInfix()) throw new ParseException("\n  Encountered postfix op " + oR.getIdentifier() + " in block " + tm0.getNode().getLocation().toString() + " following prefix or infix op " + oL.getIdentifier() + ".");
                    if (oL.isPrefix()) {
                        throw new ParseException("\n  Encountered postfix op " + oR.getIdentifier() + " in block " + tm0.getNode().getLocation().toString() + " following prefix or infix op " + oL.getIdentifier() + ".");
                    }
                    this.reducePostfix();
                    continue;
                }
                if (n <= 1) return;
                tm2 = (OSelement)this.CurrentTop.elementAt(n - 2);
                if (!tm2.isOperator()) throw new ParseException("Expression at location " + tm2.getNode().getLocation().toString() + " and expression at location " + tm1.getNode().getLocation().toString() + " follow each other without any intervening operator.");
                oL = tm2.getOperator();
                if (!Operator.succ(oL, oR)) {
                    if (Operator.prec(oL, oR)) return;
                    throw new ParseException("Precedence conflict between ops " + oL.getIdentifier() + " in block " + tm0.getNode().getLocation().toString() + " and " + oR.getIdentifier() + ".");
                }
                if (oL.isInfix()) {
                    this.reduceInfix(oL);
                    continue;
                }
                this.reducePrefix();
                continue;
            }
            if (oR.isPrefix()) {
                if (n == 0) {
                    return;
                }
                tm1 = (OSelement)this.CurrentTop.elementAt(n - 1);
                if (!tm1.isOperator()) throw new ParseException("\n  Encountered prefix op " + oR.getIdentifier() + " in block " + tm0.getNode().getLocation().toString() + " following an expression.");
                oL = tm1.getOperator();
                if (!oL.isPostfix()) return;
                throw new ParseException("\n  Encountered prefix op " + oR.getIdentifier() + " in block " + tm0.getNode().getLocation().toString() + " following postfix op " + oL.getIdentifier() + ".");
            }
            if (n == 0) {
                mixR = Operators.getMixfix(oR);
                if (mixR != null) return;
                throw new ParseException("\n  Encountered infix op " + oR.getIdentifier() + " in block " + tm0.getNode().getLocation().toString() + " on empty stack.");
            }
            tm1 = (OSelement)this.CurrentTop.elementAt(n - 1);
            if (tm1.isOperator()) {
                oL = tm1.getOperator();
                if (oL.isInfix() || oL.isPrefix()) {
                    mixR = Operators.getMixfix(oR);
                    if (mixR == null) {
                        if (oR != Operator.VoidOperator()) throw new ParseException("\n  Encountered infix op " + oR.getIdentifier() + " in block " + tm1.getNode().getLocation().toString() + " following prefix or infix op " + oL.getIdentifier() + ".");
                        throw new ParseException("\n  Missing expression in block " + tm1.getNode().getLocation().toString() + " following prefix or infix op " + oL.getIdentifier() + ".");
                    }
                    if (Operator.succ(oL, mixR)) throw new ParseException("\n  Precedence conflict between ops " + oL.getIdentifier() + " in block " + tm1.getNode().getLocation().toString() + " and " + mixR.getIdentifier() + ".");
                    if (oL != mixR || !oL.assocLeft()) continue;
                    throw new ParseException("\n  Precedence conflict between ops " + oL.getIdentifier() + " in block " + tm1.getNode().getLocation().toString() + " and " + mixR.getIdentifier() + ".");
                }
                this.reducePostfix();
                continue;
            }
            if (n <= 1) return;
            tm2 = (OSelement)this.CurrentTop.elementAt(n - 2);
            if (!tm2.isOperator()) throw new ParseException("Expression at location " + tm2.getNode().getLocation().toString() + " and expression at location " + tm1.getNode().getLocation().toString() + " follow each other without any " + "intervening operator.");
            oL = tm2.getOperator();
            Operator mixL = Operators.getMixfix(oL);
            if (mixL != null && (n == 2 || ((OSelement)this.CurrentTop.elementAt(n - 3)).isOperator())) {
                oL = mixL;
            }
            if (Operator.succ(oL, oR) || oL == oR && oL.assocLeft()) {
                if (oL.isInfix()) {
                    this.reduceInfix(oL);
                    continue;
                }
                if (oL.isPrefix()) {
                    this.reducePrefix();
                    continue;
                }
                if (tm2.getNode().getLocation().beginLine() < tm1.getNode().getLocation().beginLine() && oR.getIdentifier() == UniqueString.uniqueStringOf("=")) {
                    throw new ParseException("\n  *** Hint *** You may have mistyped ==\n  Illegal combination of operators " + oL.getIdentifier() + " in block " + tm2.getNode().getLocation().toString() + " and " + oR.getIdentifier() + ".");
                }
                if (oR != Operator.VoidOperator()) throw new ParseException("\n  Illegal combination of operators " + oL.getIdentifier() + " in block " + tm2.getNode().getLocation().toString() + " and " + oR.getIdentifier() + ".");
                throw new ParseException("\n Error following expression at  " + tm2.getNode().getLocation().toString() + ", missing operator or separator.");
            }
            if (Operator.prec(oL, oR)) return;
            if (oL != oR) throw new ParseException("\n  Precedence conflict between ops " + oL.getIdentifier() + " in block " + tm2.getNode().getLocation().toString() + " and " + oR.getIdentifier() + ".");
            if (oL.assocRight()) return;
            throw new ParseException("\n  Precedence conflict between ops " + oL.getIdentifier() + " in block " + tm2.getNode().getLocation().toString() + " and " + oR.getIdentifier() + ".");
        } while (n != this.CurrentTop.size() - 1);
    }

    public final SyntaxTreeNode finalReduce() throws ParseException {
        int n = 0;
        this.pushOnStack(null, Operator.VoidOperator());
        this.reduceStack();
        if (this.isWellReduced()) {
            return ((OSelement)this.CurrentTop.elementAt(0)).getNode();
        }
        StringBuffer msg = new StringBuffer("Couldn't properly parse expression");
        do {
            msg.append("-- incomplete expression at ");
            msg.append(((OSelement)this.CurrentTop.elementAt(n)).getNode().getLocation().toString());
            msg.append(".\n");
        } while (++n < this.CurrentTop.size() - 1);
        this.PErrors.push(new ParseError(msg.toString(), "-- --"));
        return null;
    }

    public boolean isWellReduced() {
        return this.CurrentTop.size() == 2;
    }

    public final void pushOnStack(SyntaxTreeNode n, Operator o) {
        this.CurrentTop.addElement(new OSelement(n, o));
    }

    public SyntaxTreeNode bottomOfStack() {
        return ((OSelement)this.CurrentTop.elementAt(0)).getNode();
    }

    public final void reduceRecord(SyntaxTreeNode middle, SyntaxTreeNode right) throws ParseException {
        int index = this.CurrentTop.size() - 1;
        if (index < 0) {
            throw new ParseException("\n    ``.'' has no left hand side at " + middle.getLocation().toString() + ".");
        }
        OSelement oselt = (OSelement)this.CurrentTop.elementAt(index);
        if (oselt.isOperator()) {
            OSelement ospelt = (OSelement)this.CurrentTop.elementAt(index - 1);
            if (oselt.getOperator().isPostfix() && !ospelt.isOperator()) {
                this.CurrentTop.addElement(null);
                this.reducePostfix();
                index = this.CurrentTop.size() - 1;
                this.CurrentTop.removeElementAt(index);
                oselt = (OSelement)this.CurrentTop.elementAt(--index);
            } else {
                throw new ParseException("\n    ``.'' follows operator " + oselt.getNode().getLocation().toString() + ".");
            }
        }
        SyntaxTreeNode left = ((OSelement)this.CurrentTop.elementAt(index)).getNode();
        SyntaxTreeNode rcd = new SyntaxTreeNode(410, left, middle, right);
        this.CurrentTop.setElementAt(new OSelement(rcd), index);
    }

    private final String printStack() {
        String str = new String("stack dump, " + this.StackOfStack.size() + " levels, " + this.CurrentTop.size() + " in top one: ");
        for (int i = 0; i < this.CurrentTop.size(); ++i) {
            SyntaxTreeNode tn = ((OSelement)this.CurrentTop.elementAt(i)).getNode();
            if (tn == null) continue;
            str = str.concat(tn.getImage() + " ");
        }
        return str;
    }

    public final OSelement topOfStack() {
        if (this.CurrentTop == null) {
            return null;
        }
        int n = this.CurrentTop.size();
        if (n == 0) {
            return null;
        }
        return (OSelement)this.CurrentTop.elementAt(n - 1);
    }

    public final void popCurrentTop() {
        this.CurrentTop.removeElementAt(this.CurrentTop.size() - 1);
    }
}

