/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast.wd;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eventb.core.ast.Predicate;
import org.eventb.internal.core.ast.wd.FormulaBuilder;
import org.eventb.internal.core.ast.wd.Lemma;

public abstract class Node {
    private boolean subsumed = false;

    public Predicate simplifyTree(FormulaBuilder fb) {
        int depthmax = this.maxBindingDepth();
        this.boundIdentifiersEqualizer(depthmax);
        LinkedHashSet<Lemma> knownLemmas = new LinkedHashSet<Lemma>();
        this.simplify(knownLemmas, new HashSet<Predicate>(), fb);
        return (Predicate)this.asPredicate(fb, true).flatten();
    }

    protected abstract int maxBindingDepth();

    protected abstract void boundIdentifiersEqualizer(int var1);

    protected final Predicate asPredicate(FormulaBuilder fb, boolean original) {
        if (!this.subsumed) {
            return this.internalAsPredicate(fb, original);
        }
        return fb.btrue;
    }

    protected abstract Predicate internalAsPredicate(FormulaBuilder var1, boolean var2);

    protected abstract void collectAntecedents(Set<Predicate> var1, FormulaBuilder var2);

    protected final void addPredicateToSet(Set<Predicate> set, FormulaBuilder fb) {
        if (this.subsumed) {
            return;
        }
        if (!set.add(this.internalAsPredicate(fb, false))) {
            this.setNodeSubsumed();
        }
    }

    protected final void simplify(Set<Lemma> knownLemmas, Set<Predicate> antecedents, FormulaBuilder fb) {
        if (!this.subsumed) {
            this.internalSimplify(knownLemmas, antecedents, fb);
        }
    }

    protected abstract void internalSimplify(Set<Lemma> var1, Set<Predicate> var2, FormulaBuilder var3);

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb, "");
        return sb.toString();
    }

    protected final void toString(StringBuilder sb, String indent) {
        sb.append(indent);
        if (this.subsumed) {
            sb.append("-- ");
        }
        this.internalToString(sb, indent);
    }

    protected abstract void internalToString(StringBuilder var1, String var2);

    protected final void setNodeSubsumed() {
        this.subsumed = true;
    }
}

