/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast.extension;

import java.util.Arrays;
import org.eventb.core.ast.BinaryPredicate;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.ExtendedExpression;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.Predicate;
import org.eventb.core.ast.Type;
import org.eventb.core.ast.UnaryPredicate;
import org.eventb.core.ast.extension.ExtensionFactory;
import org.eventb.core.ast.extension.ICompatibilityMediator;
import org.eventb.core.ast.extension.IExpressionExtension;
import org.eventb.core.ast.extension.IExtendedFormula;
import org.eventb.core.ast.extension.IExtensionKind;
import org.eventb.core.ast.extension.IOperatorProperties;
import org.eventb.core.ast.extension.IPriorityMediator;
import org.eventb.core.ast.extension.ITypeCheckMediator;
import org.eventb.core.ast.extension.ITypeMediator;
import org.eventb.core.ast.extension.IWDMediator;
import org.eventb.core.ast.extension.StandardGroup;

public class Cond
implements IExpressionExtension {
    private static final Cond INSTANCE = new Cond();
    private static final String COND_ID = "Cond Id";
    private static final String COND_SYMBOL = "COND";

    private Cond() {
    }

    public static Cond getCond() {
        return INSTANCE;
    }

    @Override
    public String getSyntaxSymbol() {
        return COND_SYMBOL;
    }

    @Override
    public Predicate getWDPredicate(IExtendedFormula formula, IWDMediator wdMediator) {
        FormulaFactory ff = wdMediator.getFormulaFactory();
        Predicate cond = formula.getChildPredicates()[0];
        Predicate wdCond = cond.getWDPredicate();
        Expression[] exprs = formula.getChildExpressions();
        Predicate wdE1 = exprs[0].getWDPredicate();
        Predicate wdE2 = exprs[1].getWDPredicate();
        BinaryPredicate condE1 = ff.makeBinaryPredicate(251, cond, wdE1, null);
        UnaryPredicate notCond = ff.makeUnaryPredicate(701, cond, null);
        BinaryPredicate notCondE2 = ff.makeBinaryPredicate(251, notCond, wdE2, null);
        return ff.makeAssociativePredicate(351, Arrays.asList(wdCond, condE1, notCondE2), null);
    }

    @Override
    public boolean conjoinChildrenWD() {
        return false;
    }

    @Override
    public String getId() {
        return COND_ID;
    }

    @Override
    public String getGroupId() {
        return StandardGroup.CLOSED.getId();
    }

    @Override
    public IExtensionKind getKind() {
        return ExtensionFactory.makePrefixKind(IOperatorProperties.FormulaType.EXPRESSION, ExtensionFactory.makeChildTypes(IOperatorProperties.FormulaType.PREDICATE, IOperatorProperties.FormulaType.EXPRESSION, IOperatorProperties.FormulaType.EXPRESSION));
    }

    @Override
    public Object getOrigin() {
        return null;
    }

    @Override
    public void addCompatibilities(ICompatibilityMediator mediator) {
    }

    @Override
    public void addPriorities(IPriorityMediator mediator) {
    }

    @Override
    public Type synthesizeType(Expression[] childExprs, Predicate[] childPreds, ITypeMediator mediator) {
        Expression e1 = childExprs[0];
        Expression e2 = childExprs[1];
        if (e1.getType().equals(e2.getType())) {
            return e1.getType();
        }
        return null;
    }

    @Override
    public boolean verifyType(Type proposedType, Expression[] childExprs, Predicate[] childPreds) {
        Expression e1 = childExprs[0];
        Expression e2 = childExprs[1];
        return proposedType.equals(e1.getType()) && proposedType.equals(e2.getType());
    }

    @Override
    public Type typeCheck(ExtendedExpression expression, ITypeCheckMediator tcMediator) {
        Expression[] childExprs = expression.getChildExpressions();
        Expression e1 = childExprs[0];
        Expression e2 = childExprs[1];
        Type type = tcMediator.newTypeVariable();
        tcMediator.sameType(type, e1.getType());
        tcMediator.sameType(type, e2.getType());
        return type;
    }

    @Override
    public boolean isATypeConstructor() {
        return false;
    }
}

