/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast;

import org.eventb.core.ast.Identifier;
import org.eventb.internal.core.ast.IdentListMerger;

public final class ArrayStream
extends IdentListMerger {
    final Identifier[] source;
    int curIndex;

    protected ArrayStream(Identifier[] source) {
        super(source.getClass().getComponentType());
        this.source = source;
        this.curIndex = 0;
    }

    @Override
    public boolean containsError() {
        return this.errorFound;
    }

    @Override
    protected int getPotentialLength() {
        return this.source.length;
    }

    @Override
    protected Identifier[] getMaximalArray() {
        return this.source;
    }

    @Override
    protected Identifier getNext() {
        if (this.curIndex < this.source.length) {
            Identifier result;
            if ((result = this.source[this.curIndex++]).getType() == null) {
                this.errorFound = true;
            }
            return result;
        }
        return null;
    }
}

