/*
 * Decompiled with CFR 0.152.
 */
package de.prob.web.worksheet;

import de.prob.web.WebUtils;
import de.prob.web.worksheet.AbstractBox;
import de.prob.web.worksheet.BindingsSnapshot;
import de.prob.web.worksheet.EChangeEffect;
import de.prob.web.worksheet.IBox;
import groovy.lang.MissingPropertyException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.commons.lang.StringEscapeUtils;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;

public class Groovy
extends AbstractBox
implements IBox {
    private String content = "";

    @Override
    public void setContent(Map<String, String[]> data) {
        this.content = data.get("text")[0];
    }

    @Override
    public List<Object> render(@Nullable BindingsSnapshot snapshot) {
        ScriptEngine groovy = this.owner.getGroovy();
        if (snapshot != null) {
            snapshot.restoreBindings(groovy);
        }
        ArrayList<Object> res = new ArrayList<Object>();
        StringBuffer outputsb = new StringBuffer();
        Bindings bindings = groovy.getBindings(200);
        bindings.put("__console", (Object)outputsb);
        Object evaluationResult = "null";
        try {
            evaluationResult = groovy.eval(this.content);
            String result = StringEscapeUtils.escapeHtml((String)evaluationResult.toString());
            String output = StringEscapeUtils.escapeHtml((String)outputsb.toString()).replaceAll("\n", "<br />");
            res.add(this.makeHtml(this.id, WebUtils.render("ui/worksheet/groovy_box.html", WebUtils.wrap("id", this.id, "result", result, "output", output))));
        }
        catch (ScriptException e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            res.add(this.makeHtml(this.id, WebUtils.render("ui/worksheet/groovy_exception.html", WebUtils.wrap("id", this.id, "message", this.cleanup(e), "stacktrace", sw.toString().replaceAll(" ", "&nbsp;").replaceAll("\\n", "<br />")))));
        }
        return res;
    }

    private String cleanup(Exception e) {
        String message = e.getMessage();
        if (e.getCause() instanceof MultipleCompilationErrorsException) {
            return message.replaceAll("(.*\n.*Script.*?groovy):.*?:", "").replaceAll("@ line(.*\n)*", "").replaceAll(" ", "&nbsp;").replaceAll("\\n", "<br />");
        }
        if (e.getCause().getCause() instanceof MissingPropertyException) {
            String r1 = message.replaceAll(".*property:", "No such property: ");
            String r2 = r1.replaceAll("for.*", "");
            return r2;
        }
        return message.replaceAll(" ", "&nbsp;").replaceAll("\\n", "<br />");
    }

    @Override
    protected String getContentAsJson() {
        return this.content;
    }

    @Override
    public EChangeEffect changeEffect() {
        return EChangeEffect.EVERYTHING_BELOW;
    }
}

