/*
 * Decompiled with CFR 0.152.
 */
package de.prob.animator.command;

import de.prob.animator.command.AbstractCommand;
import de.prob.animator.domainobjects.StateError;
import de.prob.parser.BindingGenerator;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.CompoundPrologTerm;
import de.prob.prolog.term.ListPrologTerm;
import de.prob.prolog.term.PrologTerm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class GetStateBasedErrorsCommand
extends AbstractCommand {
    private static final String PROLOG_COMMAND_NAME = "get_state_errors";
    private final String stateId;
    private Collection<StateError> stateErrors;

    public GetStateBasedErrorsCommand(String stateId) {
        this.stateId = stateId;
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) {
        List errors;
        ListPrologTerm list = BindingGenerator.getList(bindings, (String)"Errors");
        if (list.isEmpty()) {
            errors = Collections.emptyList();
        } else {
            errors = new ArrayList();
            for (PrologTerm term : list) {
                CompoundPrologTerm compoundTerm = BindingGenerator.getCompoundTerm((PrologTerm)term, (String)"error", (int)3);
                errors.add(new StateError(compoundTerm));
            }
        }
        this.stateErrors = errors;
    }

    @Override
    public void writeCommand(IPrologTermOutput pto) {
        pto.openTerm(PROLOG_COMMAND_NAME).printAtomOrNumber(this.stateId).printVariable("Errors").closeTerm();
    }

    public Collection<StateError> getResult() {
        return this.stateErrors;
    }
}

