/*
 * Decompiled with CFR 0.152.
 */
package de.prob.animator.command;

import de.prob.animator.command.AbstractCommand;
import de.prob.animator.command.IStateSpaceModifier;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.CompoundPrologTerm;
import de.prob.prolog.term.ListPrologTerm;
import de.prob.prolog.term.PrologTerm;
import de.prob.statespace.ITraceDescription;
import de.prob.statespace.StateSpace;
import de.prob.statespace.Trace;
import de.prob.statespace.Transition;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetShortestTraceCommand
extends AbstractCommand
implements ITraceDescription,
IStateSpaceModifier {
    private static final String PROLOG_COMMAND_NAME = "find_trace_to_node";
    Logger logger = LoggerFactory.getLogger(GetShortestTraceCommand.class);
    private static final String TRACE = "Trace";
    private final String stateId;
    private final List<Transition> transitions = new ArrayList<Transition>();
    private boolean tracefound;
    private final StateSpace s;

    public GetShortestTraceCommand(StateSpace s, String stateId) {
        this.s = s;
        this.stateId = stateId;
    }

    @Override
    public void writeCommand(IPrologTermOutput pto) {
        pto.openTerm(PROLOG_COMMAND_NAME);
        pto.printAtomOrNumber(this.stateId);
        pto.printVariable(TRACE);
        pto.closeTerm();
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) {
        PrologTerm trace = (PrologTerm)bindings.get((Object)TRACE);
        if (trace instanceof ListPrologTerm) {
            this.tracefound = true;
            for (PrologTerm term : (ListPrologTerm)trace) {
                this.transitions.add(Transition.createTransitionFromCompoundPrologTerm(this.s, (CompoundPrologTerm)term));
            }
        } else {
            this.tracefound = false;
        }
    }

    @Override
    public List<Transition> getNewTransitions() {
        return this.transitions;
    }

    public boolean traceFound() {
        return this.tracefound;
    }

    @Override
    public Trace getTrace(StateSpace s) throws RuntimeException {
        if (!this.tracefound) {
            String msg = "No trace was found";
            this.logger.error(msg);
            throw new RuntimeException(msg);
        }
        return Trace.getTraceFromTransitions(s, this.transitions);
    }
}

