/*
 * Decompiled with CFR 0.152.
 */
package de.prob.model.eventb.translate;

import de.prob.animator.domainobjects.EventB;
import de.prob.model.eventb.EventBAxiom;
import de.prob.model.eventb.EventBModel;
import de.prob.model.eventb.theory.AxiomaticDefinitionBlock;
import de.prob.model.eventb.theory.DataType;
import de.prob.model.eventb.theory.DataTypeConstructor;
import de.prob.model.eventb.theory.DataTypeDestructor;
import de.prob.model.eventb.theory.DirectDefinition;
import de.prob.model.eventb.theory.IOperatorDefinition;
import de.prob.model.eventb.theory.InferenceRule;
import de.prob.model.eventb.theory.MetaVariable;
import de.prob.model.eventb.theory.Operator;
import de.prob.model.eventb.theory.OperatorArgument;
import de.prob.model.eventb.theory.ProofRulesBlock;
import de.prob.model.eventb.theory.RecursiveDefinitionCase;
import de.prob.model.eventb.theory.RecursiveOperatorDefinition;
import de.prob.model.eventb.theory.RewriteRule;
import de.prob.model.eventb.theory.RewriteRuleRHS;
import de.prob.model.eventb.theory.Theory;
import de.prob.model.eventb.theory.Type;
import de.prob.model.representation.ModelElementList;
import de.prob.tmparser.OperatorMapping;
import de.prob.tmparser.TheoryMappingException;
import de.prob.tmparser.TheoryMappingParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.extension.IFormulaExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TheoryXmlHandler
extends DefaultHandler {
    Logger logger = LoggerFactory.getLogger(TheoryXmlHandler.class);
    private final String workspacePath;
    private final Set<IFormulaExtension> typeEnv = new HashSet<IFormulaExtension>();
    private EventBModel model;
    private ModelElementList<Theory> theories = new ModelElementList();
    private final HashMap<String, Theory> theoryMap = new HashMap();

    public TheoryXmlHandler(EventBModel model, String workspacePath) {
        this.model = model;
        this.workspacePath = workspacePath;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("org.eventb.theory.core.scAvailableTheory")) {
            String path = attributes.getValue("org.eventb.theory.core.availableTheory");
            if (!this.theoryMap.containsKey(path = path.substring(0, path.indexOf(124)))) {
                try {
                    SAXParserFactory parserFactory = SAXParserFactory.newInstance();
                    SAXParser saxParser = parserFactory.newSAXParser();
                    TheoryExtractor extractor = new TheoryExtractor(path);
                    saxParser.parse(new File(this.workspacePath + path), (DefaultHandler)extractor);
                    this.theories = this.theories.addElement(extractor.getTheory());
                }
                catch (ParserConfigurationException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                this.theories = this.theories.addElement(this.theoryMap.get(path));
            }
        }
    }

    public Set<IFormulaExtension> getTypeEnv() {
        return this.typeEnv;
    }

    @Override
    public void endDocument() throws SAXException {
        this.model = this.model.set(Theory.class, this.theories);
    }

    public EventBModel getModel() {
        return this.model;
    }

    class TheoryExtractor
    extends DefaultHandler {
        private Theory theory;
        private ModelElementList<Theory> imported = new ModelElementList();
        private ModelElementList<Type> typeParameters = new ModelElementList();
        private ModelElementList<DataType> dataTypes = new ModelElementList();
        private ModelElementList<Operator> operators = new ModelElementList();
        private ModelElementList<AxiomaticDefinitionBlock> axiomaticDefinitionsBlocks = new ModelElementList();
        private ModelElementList<EventBAxiom> theorems = new ModelElementList();
        private ModelElementList<ProofRulesBlock> proofRules = new ModelElementList();
        private DataType dataType;
        private ModelElementList<DataTypeConstructor> constructors;
        private ModelElementList<Type> typeArguments;
        private DataTypeConstructor constructor;
        private ModelElementList<DataTypeDestructor> destructors;
        private Operator operator;
        private ModelElementList<OperatorArgument> opArgs;
        private IOperatorDefinition definition;
        private ModelElementList<RecursiveDefinitionCase> recursiveDefinitions;
        private AxiomaticDefinitionBlock axiomaticDefinitionBlock;
        private Operator axiomaticOperator;
        private ModelElementList<Operator> axiomaticOperators;
        private ModelElementList<EventBAxiom> definitionAxioms;
        private ProofRulesBlock block;
        private ModelElementList<MetaVariable> metaVars;
        private ModelElementList<RewriteRule> rewriteRules;
        private ModelElementList<InferenceRule> inferenceRules;
        private RewriteRule rewriteRule;
        private ModelElementList<RewriteRuleRHS> rightHandSides;
        private List<EventB> given;
        private EventB infer;

        public TheoryExtractor(String path) {
            String dir = path.substring(path.indexOf(47) + 1, path.lastIndexOf(47));
            String name = path.substring(path.lastIndexOf(47) + 1, path.lastIndexOf(46));
            Collection<Object> mappings = new ArrayList<OperatorMapping>();
            try {
                String mappingFileName = TheoryXmlHandler.this.workspacePath + File.separator + dir + File.separator + name + ".ptm";
                mappings = TheoryMappingParser.parseTheoryMapping((String)name, (String)mappingFileName);
            }
            catch (FileNotFoundException e) {
                TheoryXmlHandler.this.logger.warn("No .ptm file found for Theory " + name + ". This means that ProB has no information on how to interpret this theory.");
            }
            catch (TheoryMappingException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.theory = new Theory(name, dir, mappings);
            TheoryXmlHandler.this.theoryMap.put(path, this.theory);
        }

        public Theory getTheory() {
            return this.theory;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("org.eventb.theory.core.scTypeParameter")) {
                this.addTypeParameter(attributes);
            } else if (qName.equals("org.eventb.theory.core.useTheory")) {
                this.addUsedTheory(attributes);
            } else if (qName.equals("org.eventb.theory.core.scDatatypeDefinition")) {
                this.beginAddingDataType(attributes);
            } else if (qName.equals("org.eventb.theory.core.scDatatypeConstructor")) {
                this.beginAddingDataTypeConstructor(attributes);
            } else if (qName.equals("org.eventb.theory.core.scConstructorArgument")) {
                this.addDestructor(attributes);
            } else if (qName.equals("org.eventb.theory.core.scNewOperatorDefinition")) {
                this.beginAddingOperator(attributes);
            } else if (qName.equals("org.eventb.theory.core.scDirectOperatorDefinition")) {
                this.addDirectDefinition(attributes);
            } else if (qName.equals("org.eventb.theory.core.scRecursiveOperatorDefinition")) {
                this.beginRecursiveOpDef(attributes);
            } else if (qName.equals("org.eventb.theory.core.scRecursiveDefinitionCase")) {
                this.addRecursiveDefinitionCase(attributes);
            } else if (qName.equals("org.eventb.theory.core.scNewOperatorDefinition")) {
                this.addDirectDefinition(attributes);
            } else if (qName.equals("org.eventb.theory.core.scOperatorArgument")) {
                this.addOperatorArgument(attributes);
            } else if (qName.equals("org.eventb.theory.core.scAxiomaticDefinitionsBlock")) {
                this.addAxiomaticDefinitionBlock(attributes);
            } else if (qName.equals("org.eventb.theory.core.scAxiomaticOperatorDefinition")) {
                this.beginAddingAxiomaticOperator(attributes);
            } else if (qName.equals("org.eventb.theory.core.scAxiomaticDefinitionAxiom")) {
                this.addDefinitionAxiom(attributes);
            } else if (qName.equals("org.eventb.theory.core.scAxiomaticTypeDefinition")) {
                this.addTypeParameter(attributes);
            } else if (qName.equals("org.eventb.theory.core.scTheorem")) {
                this.addTheorem(attributes);
            } else if (qName.equals("org.eventb.theory.core.scProofRulesBlock")) {
                this.beginProofRulesBlock(attributes);
            } else if (qName.equals("org.eventb.theory.core.scMetavariable")) {
                this.addMetaVariable(attributes);
            } else if (qName.equals("org.eventb.theory.core.scRewriteRule")) {
                this.beginRewriteRule(attributes);
            } else if (qName.equals("org.eventb.theory.core.scRewriteRuleRHS")) {
                this.addRightHandSide(attributes);
            } else if (qName.equals("org.eventb.theory.core.scInferenceRule")) {
                this.beginInferenceRule(attributes);
            } else if (qName.equals("org.eventb.theory.core.scInfer")) {
                this.addInfer(attributes);
            } else if (qName.equals("org.eventb.theory.core.scGiven")) {
                this.addGiven(attributes);
            }
        }

        private void addGiven(Attributes attributes) {
            String predicate = attributes.getValue("org.eventb.core.predicate");
            this.given.add(new EventB(predicate, TheoryXmlHandler.this.typeEnv));
        }

        private void addInfer(Attributes attributes) {
            String predicate = attributes.getValue("org.eventb.core.predicate");
            this.infer = new EventB(predicate, TheoryXmlHandler.this.typeEnv);
        }

        private void beginInferenceRule(Attributes attributes) {
            this.given = new ArrayList<EventB>();
        }

        private void addRightHandSide(Attributes attributes) {
            String name = attributes.getValue("org.eventb.core.label");
            String predicate = attributes.getValue("org.eventb.core.predicate");
            String formula = attributes.getValue("org.eventb.theory.core.formula");
            this.rightHandSides = this.rightHandSides.addElement(new RewriteRuleRHS(name, predicate, formula, TheoryXmlHandler.this.typeEnv));
        }

        private void beginRewriteRule(Attributes attributes) {
            String label = attributes.getValue("org.eventb.core.label");
            String applicability = attributes.getValue("org.eventb.theory.core.applicability");
            boolean complete = "true".equals(attributes.getValue("org.eventb.theory.core.complete"));
            String desc = attributes.getValue("org.eventb.theory.core.desc");
            String formula = attributes.getValue("org.eventb.theory.core.formula");
            this.rewriteRule = new RewriteRule(label, applicability, complete, desc, formula, TheoryXmlHandler.this.typeEnv);
            this.rightHandSides = new ModelElementList();
            this.rewriteRules = this.rewriteRules.addElement(this.rewriteRule);
        }

        private void addMetaVariable(Attributes attributes) {
            String name = attributes.getValue("name");
            String type = attributes.getValue("org.eventb.core.type");
            this.metaVars = this.metaVars.addElement(new MetaVariable(name, type, TheoryXmlHandler.this.typeEnv));
        }

        private void beginProofRulesBlock(Attributes attributes) {
            String name = attributes.getValue("org.eventb.core.label");
            if (name == null) {
                name = attributes.getValue("name");
            }
            this.block = new ProofRulesBlock(name);
            this.metaVars = new ModelElementList();
            this.rewriteRules = new ModelElementList();
            this.inferenceRules = new ModelElementList();
            this.proofRules = this.proofRules.addElement(this.block);
        }

        private void addTheorem(Attributes attributes) {
            String label = attributes.getValue("org.eventb.core.label");
            String predicate = attributes.getValue("org.eventb.core.predicate");
            this.theorems = this.theorems.addElement(new EventBAxiom(label, predicate, true, TheoryXmlHandler.this.typeEnv));
        }

        private void addAxiomaticDefinitionBlock(Attributes attributes) {
            String name = attributes.getValue("org.eventb.core.label");
            this.axiomaticDefinitionBlock = new AxiomaticDefinitionBlock(name);
            this.typeArguments = new ModelElementList();
            this.axiomaticOperators = new ModelElementList();
            this.definitionAxioms = new ModelElementList();
            this.axiomaticDefinitionsBlocks = this.axiomaticDefinitionsBlocks.addElement(this.axiomaticDefinitionBlock);
        }

        private void beginAddingAxiomaticOperator(Attributes attributes) {
            this.axiomaticOperator = this.createOperator(attributes);
            this.opArgs = new ModelElementList();
        }

        private void addDefinitionAxiom(Attributes attributes) {
            String label = attributes.getValue("org.eventb.core.label");
            String predicate = attributes.getValue("org.eventb.core.predicate");
            this.definitionAxioms = this.definitionAxioms.addElement(new EventBAxiom(label, predicate, false, TheoryXmlHandler.this.typeEnv));
        }

        private void addOperatorArgument(Attributes attributes) {
            String identifier = attributes.getValue("name");
            String type = attributes.getValue("org.eventb.core.type");
            this.opArgs = this.opArgs.addElement(new OperatorArgument(identifier, type, TheoryXmlHandler.this.typeEnv));
        }

        private void addDirectDefinition(Attributes attributes) {
            String formula = attributes.getValue("org.eventb.theory.core.formula");
            this.definition = new DirectDefinition(formula, TheoryXmlHandler.this.typeEnv);
        }

        private void addRecursiveDefinitionCase(Attributes attributes) {
            String expression = attributes.getValue("org.eventb.core.expression");
            String formula = attributes.getValue("org.eventb.theory.core.formula");
            this.recursiveDefinitions = this.recursiveDefinitions.addElement(new RecursiveDefinitionCase(expression, formula));
        }

        private void beginRecursiveOpDef(Attributes attributes) {
            String indArg = attributes.getValue("org.eventb.theory.core.inductiveArgument");
            this.definition = new RecursiveOperatorDefinition(indArg, TheoryXmlHandler.this.typeEnv);
            this.recursiveDefinitions = new ModelElementList();
        }

        private void beginAddingOperator(Attributes attributes) {
            this.operator = this.createOperator(attributes);
            this.opArgs = new ModelElementList();
        }

        private Operator createOperator(Attributes attributes) {
            String label = attributes.getValue("org.eventb.core.label");
            boolean associative = "true".equals(attributes.getValue("org.eventb.theory.core.associative"));
            boolean commutative = "true".equals(attributes.getValue("org.eventb.theory.core.commutative"));
            boolean formulaType = "true".equals(attributes.getValue("org.eventb.theory.core.formulaType"));
            String notationType = attributes.getValue("org.eventb.theory.core.notationType");
            String groupId = attributes.getValue("org.eventb.theory.core.groupID");
            String predicate = attributes.getValue("org.eventb.core.predicate");
            String type = attributes.getValue("org.eventb.theory.core.type");
            String wd = attributes.getValue("org.eventb.theory.core.wd");
            return new Operator(this.theory.getName(), label, associative, commutative, formulaType, notationType, groupId, type, wd, predicate, TheoryXmlHandler.this.typeEnv);
        }

        private void addDestructor(Attributes attributes) {
            String name = attributes.getValue("name");
            String type = attributes.getValue("org.eventb.core.type");
            this.destructors = this.destructors.addElement(new DataTypeDestructor(name, type));
        }

        private void beginAddingDataTypeConstructor(Attributes attributes) {
            String name = attributes.getValue("name");
            this.constructor = new DataTypeConstructor(name);
            this.destructors = new ModelElementList();
        }

        private void beginAddingDataType(Attributes attributes) {
            String name = attributes.getValue("name");
            this.dataType = new DataType(name);
            this.constructors = new ModelElementList();
            this.typeArguments = new ModelElementList();
        }

        private void addUsedTheory(Attributes attributes) throws SAXException {
            String target = attributes.getValue("org.eventb.core.scTarget");
            String path = target.substring(0, target.indexOf(124));
            if (TheoryXmlHandler.this.theoryMap.containsKey(path)) {
                this.imported = this.imported.addElement((Theory)TheoryXmlHandler.this.theoryMap.get(path));
            } else {
                try {
                    SAXParserFactory parserFactory = SAXParserFactory.newInstance();
                    SAXParser saxParser = parserFactory.newSAXParser();
                    TheoryExtractor extractor = new TheoryExtractor(path);
                    saxParser.parse(new File(TheoryXmlHandler.this.workspacePath + path), (DefaultHandler)extractor);
                    TheoryXmlHandler.this.theories = TheoryXmlHandler.this.theories.addElement(extractor.getTheory());
                }
                catch (ParserConfigurationException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        private void addTypeParameter(Attributes attributes) {
            String name = attributes.getValue("name");
            Type p = new Type(name, TheoryXmlHandler.this.typeEnv);
            this.typeParameters = this.typeParameters.addElement(p);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals("org.eventb.theory.core.scDatatypeDefinition")) {
                this.finishDataType();
            } else if (qName.equals("org.eventb.theory.core.scDatatypeConstructor")) {
                this.finishDataTypeConstructor();
            } else if (qName.equals("org.eventb.theory.core.scNewOperatorDefinition")) {
                this.finishOperator();
            } else if (qName.equals("org.eventb.theory.core.scRecursiveDefinitionCase")) {
                this.finishRecursiveDefinition();
            } else if (qName.equals("org.eventb.theory.core.scAxiomaticOperatorDefinition")) {
                this.finishAxiomaticOperator();
            } else if (qName.equals("org.eventb.theory.core.scAxiomaticDefinitionsBlock")) {
                this.finishAxiomaticDefinitionBlock();
            } else if (qName.equals("org.eventb.theory.core.scProofRulesBlock")) {
                this.finishProofRulesBlock();
            } else if (qName.equals("org.eventb.theory.core.scRewriteRule")) {
                this.finishRewriteRule();
            } else if (qName.equals("org.eventb.theory.core.scInferenceRule")) {
                this.finishInferenceRule();
            }
        }

        private void finishAxiomaticDefinitionBlock() {
            this.axiomaticDefinitionBlock = this.axiomaticDefinitionBlock.set(EventBAxiom.class, this.definitionAxioms);
            this.axiomaticDefinitionBlock = this.axiomaticDefinitionBlock.set(Operator.class, this.axiomaticOperators);
            this.axiomaticDefinitionBlock = this.axiomaticDefinitionBlock.set(Type.class, this.typeArguments);
        }

        private void finishInferenceRule() {
            this.inferenceRules = this.inferenceRules.addElement(new InferenceRule(this.given, this.infer));
        }

        private void finishRewriteRule() {
            this.rewriteRule = this.rewriteRule.addRightHandSide(this.rightHandSides);
        }

        private void finishProofRulesBlock() {
            this.block = this.block.set(InferenceRule.class, this.inferenceRules);
            this.block = this.block.set(MetaVariable.class, this.metaVars);
            this.block = this.block.set(RewriteRule.class, this.rewriteRules);
        }

        private void finishRecursiveDefinition() {
            this.definition = ((RecursiveOperatorDefinition)this.definition).addCases(this.recursiveDefinitions);
        }

        private void finishAxiomaticOperator() {
            this.axiomaticOperator = this.axiomaticOperator.addArguments(this.opArgs);
            this.axiomaticOperators = this.axiomaticOperators.addElement(this.axiomaticOperator);
            TheoryXmlHandler.this.typeEnv.add(this.axiomaticOperator.getFormulaExtension());
        }

        private void finishOperator() {
            this.operator = this.operator.setDefinition(this.definition);
            this.operator = this.operator.addArguments(this.opArgs);
            TheoryXmlHandler.this.typeEnv.add(this.operator.getFormulaExtension());
            this.operators = this.operators.addElement(this.operator);
            if (this.recursiveDefinitions != null) {
                for (RecursiveDefinitionCase def : this.recursiveDefinitions) {
                    def.parseCase(TheoryXmlHandler.this.typeEnv);
                }
                this.recursiveDefinitions = null;
            }
        }

        public void finishDataTypeConstructor() {
            this.constructor = this.constructor.addDestructors(this.destructors);
            this.constructors = this.constructors.addElement(this.constructor);
        }

        private void finishDataType() {
            this.dataType = this.dataType.set(DataTypeConstructor.class, this.constructors);
            this.dataType = this.dataType.set(Type.class, this.typeArguments);
            Set<IFormulaExtension> newExts = this.dataType.getFormulaExtensions(FormulaFactory.getInstance((Set)TheoryXmlHandler.this.typeEnv));
            this.dataTypes = this.dataTypes.addElement(this.dataType);
            TheoryXmlHandler.this.typeEnv.addAll(newExts);
            this.dataType.parseElements(TheoryXmlHandler.this.typeEnv);
        }

        @Override
        public void endDocument() throws SAXException {
            this.theory = this.theory.set(DataType.class, this.dataTypes);
            this.theory = this.theory.set(Theory.class, this.imported);
            this.theory = this.theory.set(Operator.class, this.operators);
            this.theory = this.theory.set(AxiomaticDefinitionBlock.class, this.axiomaticDefinitionsBlocks);
            this.theory = this.theory.set(ProofRulesBlock.class, this.proofRules);
            this.theory = this.theory.set(EventBAxiom.class, this.theorems);
            this.theory = this.theory.set(Type.class, this.typeParameters);
        }
    }
}

