/*
 * Decompiled with CFR 0.152.
 */
package de.prob.model.eventb.theory;

import com.github.krukow.clj_lang.PersistentHashMap;
import de.prob.animator.domainobjects.EventB;
import de.prob.model.eventb.theory.DataTypeConstructor;
import de.prob.model.eventb.theory.Type;
import de.prob.model.representation.AbstractElement;
import de.prob.model.representation.ModelElementList;
import java.util.Set;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.GivenType;
import org.eventb.core.ast.datatype.IDatatype;
import org.eventb.core.ast.datatype.IDatatypeBuilder;
import org.eventb.core.ast.extension.IFormulaExtension;

public class DataType
extends AbstractElement {
    final String identifierString;
    private final EventB identifier;

    public DataType(String identifier) {
        this.identifierString = identifier;
        this.identifier = new EventB(identifier);
    }

    private DataType(String identifier, PersistentHashMap<Class<? extends AbstractElement>, ModelElementList<? extends AbstractElement>> children) {
        super(children);
        this.identifierString = identifier;
        this.identifier = new EventB(identifier);
    }

    public DataType set(Class<? extends AbstractElement> clazz, ModelElementList<? extends AbstractElement> elements) {
        return new DataType(this.identifierString, this.assoc(clazz, elements));
    }

    public EventB getTypeIdentifier() {
        return this.identifier;
    }

    public ModelElementList<DataTypeConstructor> getDataTypeConstructors() {
        return this.getChildrenOfType(DataTypeConstructor.class);
    }

    public ModelElementList<Type> getTypeArguments() {
        return this.getChildrenOfType(Type.class);
    }

    public String toString() {
        return this.identifierString;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DataType) {
            return this.identifierString.equals(((DataType)obj).toString());
        }
        return false;
    }

    public int hashCode() {
        return this.identifierString.hashCode();
    }

    public void parseElements(Set<IFormulaExtension> typeEnv) {
        for (DataTypeConstructor cons : this.getDataTypeConstructors()) {
            cons.parseElements(typeEnv);
        }
    }

    public Set<IFormulaExtension> getFormulaExtensions(FormulaFactory ff) {
        IDatatypeBuilder builder = ff.makeDatatypeBuilder(this.identifierString, new GivenType[0]);
        for (DataTypeConstructor c : this.getDataTypeConstructors()) {
            builder.addConstructor(c.getUnicode());
        }
        IDatatype datatype = builder.finalizeDatatype();
        return datatype.getExtensions();
    }
}

