/*
 * Decompiled with CFR 0.152.
 */
package de.prob.animator.command;

import de.prob.animator.command.AbstractCommand;
import de.prob.animator.domainobjects.CSP;
import de.prob.parser.BindingGenerator;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.ListPrologTerm;
import de.prob.prolog.term.PrologTerm;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSPAssertionsCommand
extends AbstractCommand {
    private static final String PROLOG_COMMAND_NAME = "check_csp_assertions";
    Logger logger = LoggerFactory.getLogger(CSPAssertionsCommand.class);
    private static final String RESULT_VARIABLE = "Results";
    private static final String RESULT_TRACES_VARIABLE = "ResultTraces";
    private final List<CSP> evalElements;
    private final List<String> results = new ArrayList<String>();
    private final List<ListPrologTerm> resultTraces = new ArrayList<ListPrologTerm>();

    public CSPAssertionsCommand(List<CSP> evalElements) {
        this.evalElements = evalElements;
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) {
        ListPrologTerm prologTermResults = BindingGenerator.getList((PrologTerm)((PrologTerm)bindings.get((Object)RESULT_VARIABLE)));
        ListPrologTerm prologTermResultTraces = BindingGenerator.getList((PrologTerm)((PrologTerm)bindings.get((Object)RESULT_TRACES_VARIABLE)));
        for (PrologTerm term : prologTermResults) {
            if (!(term instanceof PrologTerm)) continue;
            this.results.add(term.getFunctor());
        }
        for (PrologTerm term : prologTermResultTraces) {
            if (!(term instanceof ListPrologTerm)) continue;
            this.resultTraces.add(BindingGenerator.getList((PrologTerm)term));
        }
    }

    public List<String> getResults() {
        return this.results;
    }

    public List<ListPrologTerm> getResultTraces() {
        return this.resultTraces;
    }

    @Override
    public void writeCommand(IPrologTermOutput pout) {
        pout.openTerm(PROLOG_COMMAND_NAME);
        pout.openList();
        for (CSP term : this.evalElements) {
            term.printPrologAssertion(pout);
        }
        pout.closeList();
        pout.printVariable(RESULT_VARIABLE);
        pout.printVariable(RESULT_TRACES_VARIABLE);
        pout.closeTerm();
    }
}

