/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util;

public final class MemIntStack {
    private int size = 0;
    private int[] elems = new int[1024];

    public MemIntStack(String diskdir, String name) {
    }

    public final int size() {
        return this.size;
    }

    public final synchronized void pushInt(int x) {
        if (this.size == this.elems.length) {
            int[] elems1 = new int[2 * this.size];
            System.arraycopy(this.elems, 0, elems1, 0, this.size);
            this.elems = elems1;
        }
        this.elems[this.size] = x;
        ++this.size;
    }

    public final synchronized void pushLong(long x) {
        this.pushInt((int)(x & 0xFFFFFFFFL));
        this.pushInt((int)(x >>> 32));
    }

    public final synchronized int popInt() {
        return this.elems[--this.size];
    }

    public final synchronized int peakInt() {
        return this.peakInt(this.size - 1);
    }

    public final synchronized int peakInt(int pos) {
        return this.elems[pos];
    }

    public final synchronized long popLong() {
        long high = this.popInt();
        long low = this.popInt();
        return high << 32 | low & 0xFFFFFFFFL;
    }

    public final synchronized long peakLong() {
        long high = this.peakInt();
        long low = this.peakInt();
        return high << 32 | low & 0xFFFFFFFFL;
    }

    public final synchronized long peakLong(int pos) {
        long high = this.peakInt(pos);
        long low = this.peakInt(pos + 1);
        return high << 32 | low & 0xFFFFFFFFL;
    }

    public final void reset() {
        this.size = 0;
    }
}

