/*
 * Decompiled with CFR 0.152.
 */
package de.prob.web.worksheet;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.script.Bindings;
import javax.script.ScriptEngine;

public class BindingsSnapshot {
    private final Set<Map.Entry<String, Object>> global;
    private final Set<Map.Entry<String, Object>> local;
    private final Set<String> keys = new HashSet<String>();
    public static final BindingsSnapshot FRESH = new BindingsSnapshot();

    private BindingsSnapshot() {
        this.global = new HashSet<Map.Entry<String, Object>>();
        this.local = new HashSet<Map.Entry<String, Object>>();
    }

    public BindingsSnapshot(ScriptEngine groovy) {
        Bindings gbindings = groovy.getBindings(200);
        this.global = new HashSet(gbindings.entrySet());
        Bindings lbindings = groovy.getBindings(100);
        this.local = new HashSet(lbindings.entrySet());
        this.keys.addAll(gbindings.keySet());
        this.keys.addAll(lbindings.keySet());
    }

    public void restoreBindings(ScriptEngine groovy) {
        Bindings gbindings = groovy.getBindings(200);
        gbindings.clear();
        Bindings lbindings = groovy.getBindings(100);
        lbindings.clear();
        for (Map.Entry<String, Object> entry : this.global) {
            gbindings.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.local) {
            lbindings.put(entry.getKey(), entry.getValue());
        }
    }

    public Set<String> getKeys() {
        return this.keys;
    }

    public Set<String> delta(@Nullable BindingsSnapshot old) {
        HashSet<String> delta = new HashSet<String>(this.keys);
        if (old != null) {
            delta.removeAll(old.keys);
        }
        return delta;
    }
}

