/*
 * Decompiled with CFR 0.152.
 */
package de.prob.web.views;

import com.google.inject.Inject;
import de.prob.animator.domainobjects.AbstractEvalResult;
import de.prob.animator.domainobjects.EnumerationWarning;
import de.prob.animator.domainobjects.EvalResult;
import de.prob.animator.domainobjects.EvaluationErrorResult;
import de.prob.animator.domainobjects.IEvalElement;
import de.prob.animator.domainobjects.IdentifierNotInitialised;
import de.prob.annotations.OneToOne;
import de.prob.annotations.PublicSession;
import de.prob.model.eventb.EventBMachine;
import de.prob.model.representation.AbstractElement;
import de.prob.model.representation.AbstractFormulaElement;
import de.prob.model.representation.ModelElementList;
import de.prob.model.representation.ModelRep;
import de.prob.statespace.AnimationSelector;
import de.prob.statespace.FormalismType;
import de.prob.statespace.IAnimationChangeListener;
import de.prob.statespace.State;
import de.prob.statespace.StateSpace;
import de.prob.statespace.Trace;
import de.prob.statespace.Transition;
import de.prob.unicode.UnicodeTranslator;
import de.prob.web.AbstractAnimationBasedView;
import de.prob.web.WebUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.AsyncContext;
import org.apache.commons.lang.StringEscapeUtils;

@PublicSession
@OneToOne
public class StateInspector
extends AbstractAnimationBasedView {
    List<IEvalElement> formulasForEvaluating = new ArrayList<IEvalElement>();
    List<String> history = new ArrayList<String>();
    Trace currentTrace;
    StateSpace currentStateSpace;

    @Inject
    public StateInspector(AnimationSelector animations) {
        super(animations);
        this.incrementalUpdate = false;
        animations.registerAnimationChangeListener((IAnimationChangeListener)this);
    }

    @Override
    public void reload(String client, int lastinfo, AsyncContext context) {
        this.sendInitMessage(context);
        if (this.currentStateSpace != null && this.currentTrace != null) {
            this.extractFormulas(this.currentStateSpace);
            Object values = this.calculateFormulas(this.currentTrace);
            this.submit(WebUtils.wrap("cmd", "StateInspector.setModel", "components", WebUtils.toJson(ModelRep.translate((StateSpace)this.currentStateSpace)), "values", WebUtils.toJson(values), "history", WebUtils.toJson(this.history)));
        }
    }

    public Object evaluate(Map<String, String[]> params) {
        String code = params.get("code")[0];
        if (this.history.size() > 200) {
            this.history = this.history.subList(100, this.history.size());
        }
        this.history.add(code);
        if (this.currentStateSpace != null) {
            AbstractEvalResult eval = this.currentTrace.evalCurrent((Object)this.currentStateSpace.getModel().parseFormula(code));
            return WebUtils.wrap("cmd", "StateInspector.result", "code", this.unicode(code), "result", StringEscapeUtils.escapeHtml((String)eval.toString()));
        }
        return null;
    }

    public Object registerFormula(Map<String, String[]> params) {
        AbstractFormulaElement e;
        AbstractElement abstractElement;
        String[] path = params.get("path[]");
        List<String> listP = Arrays.asList(path);
        if (this.currentStateSpace != null && (abstractElement = this.currentStateSpace.getModel().get(listP)) instanceof AbstractFormulaElement && !(e = (AbstractFormulaElement)abstractElement).isSubscribed(this.currentStateSpace)) {
            e.subscribe(this.currentStateSpace);
            this.formulasForEvaluating.add(e.getFormula());
        }
        return WebUtils.wrap("cmd", "StateInspector.updateValues", "values", WebUtils.toJson(this.calculateFormulas(this.currentTrace)));
    }

    public Object deregisterFormula(Map<String, String[]> params) {
        AbstractFormulaElement e;
        AbstractElement element;
        String[] path = params.get("path[]");
        List<String> listP = Arrays.asList(path);
        if (this.currentStateSpace != null && (element = this.currentStateSpace.getModel().get(listP)) instanceof AbstractFormulaElement && (e = (AbstractFormulaElement)element).isSubscribed(this.currentStateSpace)) {
            e.unsubscribe(this.currentStateSpace);
            this.formulasForEvaluating.remove(e.getFormula());
        }
        return WebUtils.wrap("cmd", "StateInspector.updateValues", "values", WebUtils.toJson(this.calculateFormulas(this.currentTrace)));
    }

    @Override
    public String html(String clientid, Map<String, String[]> parameterMap) {
        return this.simpleRender(clientid, "ui/stateInspector/index.html");
    }

    @Override
    public void performTraceChange(Trace trace) {
        if (trace == null) {
            this.currentTrace = null;
            this.currentStateSpace = null;
            this.submit(WebUtils.wrap("cmd", "StateInspector.clearInput"));
            return;
        }
        this.currentTrace = trace;
        StateSpace s = trace.getStateSpace();
        if (!s.equals(this.currentStateSpace)) {
            this.currentStateSpace = s;
            this.extractFormulas(this.currentStateSpace);
            this.history = new ArrayList<String>();
            Object calculatedValues = this.calculateFormulas(this.currentTrace);
            this.submit(WebUtils.wrap("cmd", "StateInspector.setModel", "components", WebUtils.toJson(ModelRep.translate((StateSpace)this.currentStateSpace)), "values", WebUtils.toJson(calculatedValues), "history", WebUtils.toJson(this.history)));
            return;
        }
        Object calculatedValues = this.calculateFormulas(this.currentTrace);
        this.submit(WebUtils.wrap("cmd", "StateInspector.updateValues", "values", WebUtils.toJson(calculatedValues)));
    }

    public Object calculateFormulas(Trace t) {
        ArrayList<Map<String, String>> extracted = new ArrayList<Map<String, String>>();
        StateSpace s = t.getStateSpace();
        Transition currentTransition = t.getCurrentTransition();
        State currentS = currentTransition == null ? t.getCurrentState() : currentTransition.getDestination();
        Map current = s.valuesAt(currentS);
        State prevS = currentTransition == null ? null : currentTransition.getSource();
        Map previous = prevS == null ? new HashMap() : s.valuesAt(prevS);
        for (IEvalElement e : this.formulasForEvaluating) {
            String currentVal = this.stringRep((AbstractEvalResult)current.get(e));
            String previousVal = this.stringRep((AbstractEvalResult)previous.get(e));
            extracted.add(WebUtils.wrap("id", e.getFormulaId().getUUID(), "code", this.unicode(e.getCode()), "current", currentVal, "previous", previousVal));
        }
        return extracted;
    }

    private String stringRep(AbstractEvalResult res) {
        if (res instanceof EvalResult) {
            return this.unicode(((EvalResult)res).getValue());
        }
        if (res instanceof EvaluationErrorResult && !(res instanceof IdentifierNotInitialised)) {
            return ((EvaluationErrorResult)res).getResult();
        }
        if (res instanceof EnumerationWarning) {
            return this.unicode("?(\u221e)");
        }
        return "";
    }

    private String unicode(String code) {
        return StringEscapeUtils.escapeHtml((String)UnicodeTranslator.toUnicode((String)code));
    }

    private void extractFormulas(StateSpace s) {
        this.formulasForEvaluating = new ArrayList<IEvalElement>();
        if (s.getModel().getFormalismType().equals((Object)FormalismType.B)) {
            this.extractFormulas((AbstractElement)s.getModel(), s);
        }
    }

    private void extractFormulas(AbstractElement e, StateSpace s) {
        if (e instanceof AbstractFormulaElement) {
            AbstractFormulaElement formulaElement = (AbstractFormulaElement)e;
            if (formulaElement.isSubscribed(s)) {
                this.formulasForEvaluating.add(formulaElement.getFormula());
            }
            return;
        }
        if (e instanceof EventBMachine) {
            // empty if block
        }
        Map children = e.getChildren();
        Collection values = children.values();
        for (ModelElementList modelElementList : values) {
            for (AbstractElement e2 : modelElementList) {
                this.extractFormulas(e2, s);
            }
        }
    }

    public void animatorStatus(boolean busy) {
        if (busy) {
            this.submit(WebUtils.wrap("cmd", "StateInspector.disable"));
        } else {
            this.submit(WebUtils.wrap("cmd", "StateInspector.enable"));
        }
    }
}

