/*
 * Decompiled with CFR 0.152.
 */
package de.prob.web;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import de.prob.web.ReloadRequiredException;
import de.prob.web.data.Message;
import java.util.concurrent.TimeUnit;

public class Responses {
    private final Cache<Integer, Message> responseCache;
    private int itemcount = 0;

    public Responses() {
        this(5, TimeUnit.SECONDS);
    }

    public Responses(int timeout, TimeUnit unit) {
        this.responseCache = CacheBuilder.newBuilder().expireAfterWrite((long)timeout, unit).build();
    }

    public int size() {
        return this.itemcount;
    }

    public boolean isEmpty() {
        return this.itemcount == 0;
    }

    public Message get(int i) throws ReloadRequiredException {
        Message v = (Message)this.responseCache.getIfPresent((Object)i);
        if (v == null) {
            throw new ReloadRequiredException();
        }
        return v;
    }

    public void add(Message message) {
        this.responseCache.put((Object)this.itemcount++, (Object)message);
    }

    public void reset() {
        this.responseCache.invalidateAll();
        this.itemcount = 0;
    }
}

