/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.parser;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eventb.core.ast.ASTProblem;
import org.eventb.core.ast.BoundIdentDecl;
import org.eventb.core.ast.Formula;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.ProblemKind;
import org.eventb.core.ast.SourceLocation;
import org.eventb.internal.core.lexer.Scanner;
import org.eventb.internal.core.lexer.Token;
import org.eventb.internal.core.parser.AbstractGrammar;
import org.eventb.internal.core.parser.GenParser;
import org.eventb.internal.core.parser.ILedParser;
import org.eventb.internal.core.parser.INudParser;
import org.eventb.internal.core.parser.IParserPrinter;
import org.eventb.internal.core.parser.ParseResult;
import org.eventb.internal.core.parser.operators.OperatorRelationship;

public class ParserContext {
    private static final Token INIT_TOKEN = new Token(-1, "", -1);
    private final Scanner scanner;
    protected final FormulaFactory factory;
    private final AbstractGrammar grammar;
    protected final ParseResult result;
    protected final boolean withPredVar;
    private StackedValue<Binding> binding = new StackedValue<Binding>(new Binding());
    private StackedValue<Integer> parentKind;
    private StackedValue<Integer> startPos = new StackedValue<Integer>(-1);
    private int endPos = -1;
    private boolean parsingType;
    protected Token t;
    protected Token la;
    private ASTProblem curProblem;

    protected ParserContext(Scanner scanner, FormulaFactory factory, ParseResult result, boolean withPredVar) {
        this.scanner = scanner;
        this.factory = factory;
        this.grammar = factory.getGrammar();
        this.result = result;
        this.withPredVar = withPredVar;
        this.parentKind = new StackedValue<Integer>(this.grammar.getKind(AbstractGrammar.DefaultToken.EOF));
    }

    public AbstractGrammar getGrammar() {
        return this.grammar;
    }

    public SourceLocation getSourceLocation() {
        if ((Integer)this.startPos.val < 0) {
            throw new IllegalStateException("no start position set");
        }
        return this.makeSourceLocation((Integer)this.startPos.val, this.endPos);
    }

    public SourceLocation getEnclosingSourceLocation() {
        if ((Integer)this.startPos.val < 0) {
            throw new IllegalStateException("no start position set");
        }
        return this.makeSourceLocation(this.startPos.peekStack(), this.t.getEnd());
    }

    public SourceLocation makeSourceLocation(Token token) {
        return this.makeSourceLocation(token.pos, token.getEnd());
    }

    public SourceLocation makeSourceLocation(int start, int end) {
        start = Math.max(0, start);
        end = Math.max(0, end);
        start = Math.min(end, start);
        return new SourceLocation(start, end, this.result.getOrigin());
    }

    public void init() {
        this.t = INIT_TOKEN;
        this.la = this.scanner.Scan();
        this.accept();
    }

    private void accept() {
        if (this.grammar.isOpen(this.t.kind)) {
            this.pushParentKind(this.grammar.getKind(AbstractGrammar.DefaultToken.OPEN));
        }
        if (this.grammar.isClose(this.la.kind)) {
            this.popParentKind();
        }
        this.endPos = this.t.getEnd();
        this.t = this.la;
        this.la = this.scanner.Scan();
    }

    private void pushParentKind(int newParentKind) {
        this.parentKind.push(newParentKind);
    }

    public void pushParentKind() {
        this.parentKind.push(this.t.kind);
    }

    public void popParentKind() {
        if (this.parentKind.isStackEmpty()) {
            this.result.addProblem(new ASTProblem(this.makeSourceLocation(this.la), ProblemKind.UnmatchedTokens, 1, new Object[0]));
            this.t = this.la;
            this.la = this.scanner.Scan();
            return;
        }
        this.parentKind.pop();
    }

    public SavedContext save() {
        return new SavedContext(this.scanner.save(), this.t, this.la, this.parsingType, this.startPos, this.binding, this.parentKind);
    }

    public void restore(SavedContext sc) {
        this.scanner.restore(sc.scanState);
        this.t = sc.t;
        this.la = sc.la;
        this.parsingType = sc.parsingType;
        this.startPos = new StackedValue<Integer>(sc.startPos);
        this.binding = new StackedValue<Binding>(sc.binding);
        this.parentKind = new StackedValue<Integer>(sc.parentKind);
    }

    public GenParser.SyntaxError syntaxError(ASTProblem problem) throws GenParser.SyntaxError {
        assert (this.curProblem == null);
        this.curProblem = problem;
        return GenParser.SyntaxError.getInstance();
    }

    public ASTProblem takeProblem() {
        assert (this.curProblem != null);
        ASTProblem copy = this.curProblem;
        this.curProblem = null;
        return copy;
    }

    public boolean isParsingType() {
        return this.parsingType;
    }

    public void startParsingType() {
        this.parsingType = true;
    }

    public void stopParsingType() {
        this.parsingType = false;
    }

    public void accept(int expectedKind) throws GenParser.SyntaxError {
        if (this.t.kind != expectedKind) {
            String expected = this.grammar.getImage(expectedKind);
            throw this.syntaxError(new ASTProblem(this.makeSourceLocation(this.t), ProblemKind.UnexpectedSymbol, 1, expected, this.grammar.getImage(this.t.kind)));
        }
        this.accept();
    }

    public void acceptOpenParen() throws GenParser.SyntaxError {
        this.accept(this.grammar.getKind(AbstractGrammar.DefaultToken.LPAR));
    }

    public void acceptCloseParen() throws GenParser.SyntaxError {
        this.accept(this.grammar.getKind(AbstractGrammar.DefaultToken.RPAR));
    }

    void scanUntilEOF() {
        int eof = this.grammar.getKind(AbstractGrammar.DefaultToken.EOF);
        while (this.t.kind != eof) {
            this.accept();
        }
    }

    public List<INudParser<? extends Formula<?>>> getNudParsers() {
        return this.grammar.getNudParsers(this.t);
    }

    public ILedParser<? extends Formula<?>> getLedParser() {
        return this.grammar.getLedParser(this.t);
    }

    public int getBoundIndex(String name) {
        return ((Binding)this.binding.val).getBoundIndex(name);
    }

    public GenParser.ProgressDirection giveProgressDirection() throws GenParser.SyntaxError {
        int leftKind = (Integer)this.parentKind.val;
        int rightKind = this.t.kind;
        if (!this.grammar.isOperator(rightKind)) {
            return GenParser.ProgressDirection.LEFT;
        }
        OperatorRelationship opRel = this.grammar.getOperatorRelationship(leftKind, rightKind);
        switch (opRel) {
            case INCOMPATIBLE: {
                throw this.syntaxError(new ASTProblem(this.makeSourceLocation(this.t), ProblemKind.IncompatibleOperators, 1, this.grammar.getImage(leftKind), this.grammar.getImage(rightKind)));
            }
            case RIGHT_PRIORITY: {
                return GenParser.ProgressDirection.RIGHT;
            }
            case COMPATIBLE: 
            case LEFT_PRIORITY: {
                return GenParser.ProgressDirection.LEFT;
            }
        }
        return GenParser.ProgressDirection.LEFT;
    }

    private void pushPos() {
        this.startPos.push(this.t.pos);
    }

    private void popPos() {
        this.startPos.pop();
    }

    public <T> IParserPrinter.SubParseResult<T> subParseRes(INudParser<T> parser, boolean isRightChild) throws GenParser.SyntaxError {
        int childKind;
        IParserPrinter.SubParseResult<T> parseRes = this.subParseNoCheckRes(parser);
        if (!parseRes.isClosed() && this.grammar.needsParentheses(isRightChild, childKind = parseRes.getKind(), (Integer)this.parentKind.val)) {
            throw this.syntaxError(new ASTProblem(this.getSourceLocation(), ProblemKind.IncompatibleOperators, 1, this.grammar.getImage((Integer)this.parentKind.val), this.grammar.getImage(childKind)));
        }
        return parseRes;
    }

    public <T> T subParse(INudParser<T> parser, boolean isRightChild) throws GenParser.SyntaxError {
        return this.subParseRes(parser, isRightChild).getParsed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> IParserPrinter.SubParseResult<T> subParseNoCheckRes(INudParser<T> parser) throws GenParser.SyntaxError {
        this.pushPos();
        try {
            IParserPrinter.SubParseResult<T> subParseResult = parser.nud(this);
            return subParseResult;
        }
        finally {
            this.popPos();
        }
    }

    public <T> T subParseNoCheck(INudParser<T> parser) throws GenParser.SyntaxError {
        return this.subParseNoCheckRes(parser).getParsed();
    }

    public <T> T subParse(INudParser<T> parser, List<BoundIdentDecl> newBoundIdents, boolean isRightChild) throws GenParser.SyntaxError {
        return this.subParse(parser, newBoundIdents, isRightChild, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T subParse(INudParser<T> parser, List<BoundIdentDecl> newBoundIdents, boolean isRightChild, boolean noCheck) throws GenParser.SyntaxError {
        this.binding.push(new Binding((Binding)this.binding.val, newBoundIdents));
        try {
            if (noCheck) {
                T t = this.subParseNoCheck(parser);
                return t;
            }
            T t = this.subParse(parser, isRightChild);
            return t;
        }
        finally {
            this.binding.pop();
        }
    }

    public <T> T subParseNoParent(INudParser<T> parser, List<BoundIdentDecl> newBoundIdents) throws GenParser.SyntaxError {
        return this.subParseNoParent(parser, newBoundIdents, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T subParseNoParent(INudParser<T> parser, List<BoundIdentDecl> newBoundIdents, boolean noCheck) throws GenParser.SyntaxError {
        this.pushParentKind(this.grammar.getKind(AbstractGrammar.DefaultToken.NOOP));
        try {
            T t = this.subParse(parser, newBoundIdents, false, noCheck);
            return t;
        }
        finally {
            this.popParentKind();
        }
    }

    public <T> T subParseNoParentNoCheck(INudParser<T> parser, List<BoundIdentDecl> newBoundIdents) throws GenParser.SyntaxError {
        return this.subParseNoParent(parser, newBoundIdents, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T subParseSpecial(INudParser<T> parser, boolean noBinding, boolean noCheck) throws GenParser.SyntaxError {
        if (noBinding) {
            this.binding.push(new Binding());
        }
        try {
            if (noCheck) {
                T t = this.subParseNoCheck(parser);
                return t;
            }
            T t = this.subParse(parser, false);
            return t;
        }
        finally {
            if (noBinding) {
                this.binding.pop();
            }
        }
    }

    public <T> T subParseNoBinding(INudParser<T> parser) throws GenParser.SyntaxError {
        return this.subParseSpecial(parser, true, false);
    }

    public <T> T subParseNoBindingNoCheck(INudParser<T> parser) throws GenParser.SyntaxError {
        return this.subParseSpecial(parser, true, true);
    }

    public int getKind(String operatorImage) {
        return this.grammar.getKind(operatorImage);
    }

    public boolean lookAheadFor(int searchedKind) {
        if (this.la.kind == searchedKind) {
            return true;
        }
        return this.scanner.lookAheadFor(searchedKind);
    }

    public void debugEndChecks() {
        int eof = this.grammar.getKind(AbstractGrammar.DefaultToken.EOF);
        if ((Integer)this.parentKind.val != eof) {
            throw new IllegalStateException("Improper parent stack: " + this.parentKind + " with " + this.parentKind.val + " = " + this.grammar.getImage((Integer)this.parentKind.val));
        }
    }

    static class SavedContext {
        final Scanner.ScannerState scanState;
        final Token t;
        final Token la;
        final boolean parsingType;
        final StackedValue<Integer> startPos;
        final StackedValue<Binding> binding;
        final StackedValue<Integer> parentKind;

        SavedContext(Scanner.ScannerState scanState, Token t, Token la, boolean parsingType, StackedValue<Integer> startPos, StackedValue<Binding> binding, StackedValue<Integer> parentKind) {
            this.scanState = scanState;
            this.t = t;
            this.la = la;
            this.parsingType = parsingType;
            this.startPos = new StackedValue<Integer>(startPos);
            this.binding = new StackedValue<Binding>(binding);
            this.parentKind = new StackedValue<Integer>(parentKind);
        }
    }

    private static class StackedValue<T> {
        T val;
        private final Stack<T> stack = new Stack();

        public StackedValue(T initVal) {
            this.val = initVal;
        }

        public StackedValue(StackedValue<T> toCopy) {
            this.val = toCopy.val;
            this.stack.addAll(toCopy.stack);
        }

        public void push(T newVal) {
            this.stack.push(this.val);
            this.val = newVal;
        }

        public void pop() {
            this.val = this.stack.pop();
        }

        public T peekStack() {
            return this.stack.peek();
        }

        public boolean isStackEmpty() {
            return this.stack.isEmpty();
        }

        public String toString() {
            return this.val.toString() + " " + this.stack.toString();
        }
    }

    private static class Binding {
        private Map<String, Integer> binders;
        private int maxCount = -1;

        Binding() {
            this.binders = new HashMap<String, Integer>();
        }

        Binding(Binding base, List<BoundIdentDecl> idents) {
            this.binders = new HashMap<String, Integer>(base.binders);
            int index = base.maxCount;
            for (BoundIdentDecl ident : idents) {
                this.binders.put(ident.getName(), ++index);
            }
            this.maxCount = index;
        }

        int getBoundIndex(String name) {
            Integer index = this.binders.get(name);
            if (index == null) {
                return -1;
            }
            return this.maxCount - index;
        }
    }
}

