/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast.datatype;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eventb.core.ast.GivenType;
import org.eventb.core.ast.ParametricType;
import org.eventb.core.ast.Type;
import org.eventb.core.ast.datatype.IDatatype;
import org.eventb.core.ast.datatype.ITypeInstantiation;
import org.eventb.core.ast.extension.IExpressionExtension;
import org.eventb.core.ast.extension.ITypeCheckMediator;
import org.eventb.internal.core.ast.TypeRewriter;
import org.eventb.internal.core.ast.datatype.Datatype;
import org.eventb.internal.core.ast.datatype.TypeConstructorExtension;

public class TypeSubstitution
extends TypeRewriter
implements ITypeInstantiation {
    private final Datatype datatype;
    private final ParametricType instance;
    private final Map<String, Type> map = new HashMap<String, Type>();

    public static TypeSubstitution makeSubstitution(Datatype datatype, ITypeCheckMediator tcMediator) {
        TypeConstructorExtension tcons = datatype.getTypeConstructor();
        int nbParams = tcons.getNbParams();
        ArrayList<Type> actuals = new ArrayList<Type>(nbParams);
        for (int i = 0; i < nbParams; ++i) {
            actuals.add(tcMediator.newTypeVariable());
        }
        ParametricType instance = tcMediator.makeParametricType(tcons, actuals);
        return new TypeSubstitution(instance);
    }

    public static TypeSubstitution makeSubstitution(Datatype datatype, Type proposedInstance) {
        if (!(proposedInstance instanceof ParametricType)) {
            return null;
        }
        ParametricType instance = (ParametricType)proposedInstance;
        IExpressionExtension ext = instance.getExprExtension();
        if (!(ext instanceof TypeConstructorExtension)) {
            return null;
        }
        if (!datatype.equals(ext.getOrigin())) {
            return null;
        }
        return new TypeSubstitution(instance);
    }

    private TypeSubstitution(ParametricType instance) {
        super(instance.getFactory());
        this.instance = instance;
        TypeConstructorExtension tcons = (TypeConstructorExtension)instance.getExprExtension();
        this.datatype = tcons.getOrigin();
        this.map.put(tcons.getName(), instance);
        String[] formalNames = tcons.getFormalNames();
        int nbParams = formalNames.length;
        Type[] actuals = instance.getTypeParameters();
        assert (actuals.length == nbParams);
        for (int i = 0; i < nbParams; ++i) {
            this.map.put(formalNames[i], actuals[i]);
        }
    }

    @Override
    public IDatatype getOrigin() {
        return this.datatype;
    }

    @Override
    public ParametricType getInstanceType() {
        return this.instance;
    }

    @Override
    public void visit(GivenType type) {
        this.result = this.map.get(type.getName());
        if (this.result == null) {
            super.visit(type);
        }
    }
}

