/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast.datatype;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eventb.core.ast.GivenType;
import org.eventb.core.ast.ParametricType;
import org.eventb.core.ast.Type;
import org.eventb.core.ast.extension.ExtensionFactory;
import org.eventb.core.ast.extension.IExtensionKind;
import org.eventb.core.ast.extension.IFormulaExtension;
import org.eventb.core.ast.extension.IOperatorProperties;
import org.eventb.core.ast.extension.StandardGroup;
import org.eventb.internal.core.ast.datatype.TypeConstructorExtension;
import org.eventb.internal.core.typecheck.TypeCheckResult;
import org.eventb.internal.core.typecheck.TypeVariable;

public class DatatypeHelper {
    private static long uniqueId = 0L;

    public static String computeId(String name) {
        if (name == null) {
            name = "Id";
        }
        return name + uniqueId++;
    }

    public static String computeGroup(int nbArgs) {
        if (nbArgs > 0) {
            return StandardGroup.CLOSED.getId();
        }
        if (nbArgs == 0) {
            return StandardGroup.ATOMIC_EXPR.getId();
        }
        throw new IllegalArgumentException("negative number of arguments !");
    }

    public static IExtensionKind computeKind(int nbArgs) {
        IExtensionKind kind = nbArgs == 0 ? IFormulaExtension.ATOMIC_EXPRESSION : ExtensionFactory.makePrefixKind(IOperatorProperties.FormulaType.EXPRESSION, ExtensionFactory.makeAllExpr(ExtensionFactory.makeFixedArity(nbArgs)));
        return kind;
    }

    public static Map<GivenType, Type> instantiate(TypeConstructorExtension typeCons, GivenType datatypeType, List<GivenType> typeParams, Type givenDTType) {
        TypeCheckResult result = new TypeCheckResult(givenDTType.getFactory().makeTypeEnvironment().makeSnapshot());
        Type[] instantiations = new TypeVariable[typeParams.size()];
        for (int i = 0; i < typeParams.size(); ++i) {
            instantiations[i] = result.newFreshVariable(null);
        }
        ParametricType resultType = result.makeParametricType(typeCons, instantiations);
        result.unify(givenDTType, resultType, givenDTType.toExpression());
        result.solveTypeVariables();
        if (result.hasProblem()) {
            return null;
        }
        HashMap<GivenType, Type> instantiated = new HashMap<GivenType, Type>(typeParams.size());
        for (int i = 0; i < typeParams.size(); ++i) {
            instantiated.put(typeParams.get(i), ((TypeVariable)instantiations[i]).getValue());
        }
        instantiated.put(datatypeType, givenDTType);
        return instantiated;
    }
}

