/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast.datatype;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.GivenType;
import org.eventb.core.ast.IParseResult;
import org.eventb.core.ast.Type;
import org.eventb.core.ast.datatype.IConstructorBuilder;
import org.eventb.core.ast.datatype.IDatatype;
import org.eventb.core.ast.datatype.IDatatypeBuilder;
import org.eventb.core.ast.extension.IFormulaExtension;
import org.eventb.internal.core.ast.datatype.ArgumentTypeChecker;
import org.eventb.internal.core.ast.datatype.ConstructorBuilder;
import org.eventb.internal.core.ast.datatype.Datatype;
import org.eventb.internal.core.ast.datatype.DatatypeLexer;
import org.eventb.internal.core.ast.datatype.ExtensionHarvester;
import org.eventb.internal.core.lexer.Scanner;
import org.eventb.internal.core.parser.GenParser;
import org.eventb.internal.core.parser.ParseResult;

public final class DatatypeBuilder
implements IDatatypeBuilder {
    private final FormulaFactory ff;
    private final Set<String> names;
    private final String name;
    private final GivenType givenType;
    private final ArgumentTypeChecker argumentTypeChecker;
    private final GivenType[] typeParameters;
    private final List<ConstructorBuilder> constructors;
    private final Object origin;
    private Datatype finalized = null;

    public DatatypeBuilder(FormulaFactory ff, String name, List<GivenType> params, Object origin) {
        this.ff = ff;
        this.name = name;
        this.origin = origin;
        this.givenType = ff.makeGivenType(name);
        this.argumentTypeChecker = new ArgumentTypeChecker(this.givenType);
        this.checkTypeParameters(params);
        this.typeParameters = params.toArray(new GivenType[params.size()]);
        this.names = new HashSet<String>();
        this.names.add(name);
        this.constructors = new ArrayList<ConstructorBuilder>();
    }

    private void checkTypeParameters(List<GivenType> typeParams) {
        FormalNameChecker checker = new FormalNameChecker(this.ff, this.name);
        for (GivenType typeParam : typeParams) {
            checker.check(typeParam);
        }
    }

    @Override
    public boolean hasBasicConstructor() {
        for (ConstructorBuilder cons : this.constructors) {
            if (!cons.isBasic()) continue;
            return true;
        }
        return false;
    }

    private void checkHasBasicConstructor() {
        if (!this.hasBasicConstructor()) {
            throw new IllegalStateException("The datatype cannot be finalized without a basic constructor defined.");
        }
    }

    @Override
    public IConstructorBuilder addConstructor(String consName) {
        this.checkNotFinalized();
        this.checkName(consName, "constructor");
        ConstructorBuilder cons = new ConstructorBuilder(this, consName);
        this.constructors.add(cons);
        return cons;
    }

    void checkName(String consName, String nature) {
        if (!this.ff.isValidIdentifierName(consName)) {
            throw new IllegalArgumentException("The " + nature + " name: " + consName + " is not a valid identifier in the factory: " + this.ff);
        }
        if (!this.names.add(consName)) {
            throw new IllegalArgumentException("The " + nature + " name: " + consName + " has already been defined for this datatype");
        }
    }

    @Override
    public IParseResult parseType(String strType) {
        if (this.typeParameters.length == 0) {
            return this.ff.parseType(strType);
        }
        ParseResult result = new ParseResult(this.ff, null);
        Scanner scanner = DatatypeLexer.makeDatatypeScanner(this, strType, result, this.ff.getGrammar());
        GenParser parser = new GenParser(Type.class, scanner, result, false);
        parser.parse();
        return parser.getResult();
    }

    public GivenType[] getTypeParameters() {
        return this.typeParameters;
    }

    public String getName() {
        return this.name;
    }

    public GivenType asGivenType() {
        return this.givenType;
    }

    public ArgumentTypeChecker getArgumentTypeChecker() {
        return this.argumentTypeChecker;
    }

    public List<ConstructorBuilder> getConstructors() {
        return this.constructors;
    }

    @Override
    public Datatype finalizeDatatype() {
        if (this.finalized == null) {
            this.checkHasBasicConstructor();
            this.finalized = Datatype.makeDatatype(this);
        }
        return this.finalized;
    }

    protected void checkNotFinalized() {
        if (this.finalized != null) {
            throw new IllegalStateException("This operation is forbidden on a finalized DatatypeBuilder");
        }
    }

    public FormulaFactory getBaseFactory() {
        ExtensionHarvester harvester = new ExtensionHarvester();
        for (ConstructorBuilder cbuilder : this.constructors) {
            cbuilder.harvest(harvester);
        }
        Set<IFormulaExtension> extns = harvester.getResult();
        this.completeDatatypes(extns);
        return FormulaFactory.getInstance(extns);
    }

    private final void completeDatatypes(Set<IFormulaExtension> extns) {
        HashSet<IFormulaExtension> newExtns = new HashSet<IFormulaExtension>();
        for (IFormulaExtension extn : extns) {
            Object extnOrigin = extn.getOrigin();
            if (!(extnOrigin instanceof IDatatype)) continue;
            IDatatype dt = (IDatatype)extnOrigin;
            newExtns.addAll(dt.getBaseFactory().getExtensions());
            newExtns.addAll(dt.getExtensions());
        }
        extns.addAll(newExtns);
    }

    @Override
    public FormulaFactory getFactory() {
        return this.ff;
    }

    public Object getOrigin() {
        return this.origin;
    }

    private static class FormalNameChecker {
        private final FormulaFactory ff;
        private final Set<String> names;

        public FormalNameChecker(FormulaFactory ff, String datatypeName) {
            this.ff = ff;
            this.names = new HashSet<String>();
            this.names.add(datatypeName);
        }

        public void check(GivenType param) {
            if (this.ff != param.getFactory()) {
                throw new IllegalArgumentException("The type parameter " + param + " has an incompatible factory: " + param.getFactory() + " instead of: " + this.ff);
            }
            String name = param.getName();
            if (!this.names.add(name)) {
                throw new IllegalArgumentException("The type parameter name " + name + " is duplicated");
            }
        }
    }
}

