/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast;

import org.eventb.core.ast.Expression;
import org.eventb.internal.core.ast.Cache;

public abstract class Substitute {
    public static Substitute makeSubstitute(Expression expr) {
        if (expr.isWellFormed()) {
            return new SimpleSubstitute(expr);
        }
        return new ComplexSubstitute(expr);
    }

    public static Substitute makeSubstitute(Expression expr, int offset) {
        return new ComplexSubstituteWithOffset(expr, offset);
    }

    public static Substitute makeSubstitute(int index) {
        return new BoundIdentSubstitute(index);
    }

    public abstract Expression getSubstitute(Expression var1, int var2);

    private static class ComplexSubstituteWithOffset
    extends ComplexSubstitute {
        private final int offset;

        public ComplexSubstituteWithOffset(Expression expr, int offset) {
            super(expr);
            this.offset = offset;
        }

        @Override
        public Expression getSubstitute(Expression original, int nbOfInternallyBound) {
            return super.getSubstitute(original, nbOfInternallyBound + this.offset);
        }

        @Override
        public int hashCode() {
            return super.hashCode() + 31 * this.offset;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ComplexSubstituteWithOffset other = (ComplexSubstituteWithOffset)obj;
            return this.equalExpressions(other) && this.offset == other.offset;
        }

        @Override
        public String toString() {
            return super.toString() + "with offset of " + this.offset;
        }
    }

    private static class ComplexSubstitute
    extends Substitute {
        private Cache<Expression> cache = new Cache();

        public ComplexSubstitute(Expression expr) {
            this.cache.set(0, expr);
        }

        @Override
        public Expression getSubstitute(Expression original, int nbOfInternallyBound) {
            Expression result = this.cache.get(nbOfInternallyBound);
            if (result == null) {
                Expression expr = this.cache.get(0);
                result = (Expression)expr.shiftBoundIdentifiers(nbOfInternallyBound);
                this.cache.set(nbOfInternallyBound, result);
            }
            return result;
        }

        public int hashCode() {
            return this.cache.get(0).hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            return this.equalExpressions((ComplexSubstitute)obj);
        }

        protected boolean equalExpressions(ComplexSubstitute other) {
            return this.cache.get(0).equals(other.cache.get(0));
        }

        public String toString() {
            return this.cache.get(0).toString();
        }
    }

    private static class BoundIdentSubstitute
    extends Substitute {
        final int index;

        public BoundIdentSubstitute(int index) {
            this.index = index;
        }

        @Override
        public Expression getSubstitute(Expression original, int nbOfInternallyBound) {
            return original.getFactory().makeBoundIdentifier(this.index + nbOfInternallyBound, original.getSourceLocation(), original.getType());
        }

        public int hashCode() {
            return this.index;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            BoundIdentSubstitute other = (BoundIdentSubstitute)obj;
            return this.index == other.index;
        }

        public String toString() {
            return "[[" + this.index + "]]";
        }
    }

    private static class SimpleSubstitute
    extends Substitute {
        Expression expr;

        public SimpleSubstitute(Expression expr) {
            this.expr = expr;
        }

        @Override
        public Expression getSubstitute(Expression original, int nbOfInternallyBound) {
            return this.expr;
        }

        public int hashCode() {
            return this.expr.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            SimpleSubstitute other = (SimpleSubstitute)obj;
            return this.expr.equals(other.expr);
        }

        public String toString() {
            return this.expr.toString();
        }
    }
}

