/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.core.ast;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eventb.core.ast.Assignment;
import org.eventb.core.ast.BoundIdentDecl;
import org.eventb.core.ast.BoundIdentifier;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.Formula;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.core.ast.ISimpleVisitor;
import org.eventb.core.ast.ITypeEnvironmentBuilder;
import org.eventb.core.ast.IVisitor;
import org.eventb.core.ast.Predicate;
import org.eventb.core.ast.QuantifiedHelper;
import org.eventb.core.ast.QuantifiedUtil;
import org.eventb.core.ast.SourceLocation;
import org.eventb.core.ast.Type;
import org.eventb.core.ast.extension.StandardGroup;
import org.eventb.internal.core.ast.BoundIdentSubstitution;
import org.eventb.internal.core.ast.FormulaChecks;
import org.eventb.internal.core.ast.IdentListMerger;
import org.eventb.internal.core.ast.LegibilityResult;
import org.eventb.internal.core.ast.extension.IToStringMediator;
import org.eventb.internal.core.ast.extension.KindMediator;
import org.eventb.internal.core.parser.BMath;
import org.eventb.internal.core.parser.GenParser;
import org.eventb.internal.core.parser.IOperatorInfo;
import org.eventb.internal.core.parser.IParserPrinter;
import org.eventb.internal.core.parser.MainParsers;
import org.eventb.internal.core.typecheck.TypeCheckResult;
import org.eventb.internal.core.typecheck.TypeUnifier;

public class BecomesSuchThat
extends Assignment {
    private static final String BECST_ID = "Becomes Such That";
    public static final IOperatorInfo<BecomesSuchThat> OP_BECST = new IOperatorInfo<BecomesSuchThat>(){

        @Override
        public IParserPrinter<BecomesSuchThat> makeParser(int kind) {
            return new MainParsers.BecomesSuchThatParser(kind);
        }

        @Override
        public String getImage() {
            return ":\u2223";
        }

        @Override
        public String getId() {
            return BecomesSuchThat.BECST_ID;
        }

        @Override
        public String getGroupId() {
            return StandardGroup.INFIX_SUBST.getId();
        }

        @Override
        public boolean isSpaced() {
            return true;
        }
    };
    private BoundIdentDecl[] primedIdents;
    private final Predicate condition;

    public static void init(BMath grammar) {
        try {
            grammar.addOperator(OP_BECST);
        }
        catch (GenParser.OverrideException e) {
            e.printStackTrace();
        }
    }

    protected BecomesSuchThat(FreeIdentifier[] assignedIdents, BoundIdentDecl[] primedIdents, Predicate condition, SourceLocation location, FormulaFactory ff) {
        super(8, ff, location, condition.hashCode(), assignedIdents);
        this.condition = condition;
        this.primedIdents = primedIdents;
        FormulaChecks.ensureSameLength(assignedIdents, primedIdents);
        this.ensureSameFactory(this.primedIdents);
        this.ensureSameFactory(this.condition);
        this.setPredicateVariableCache(this.condition);
        this.synthesizeType();
    }

    @Override
    protected void synthesizeType() {
        int length = this.assignedIdents.length;
        Formula[] children = new Formula[2 * length + 1];
        System.arraycopy(this.assignedIdents, 0, children, 0, length);
        System.arraycopy(this.primedIdents, 0, children, length, length);
        children[2 * length] = this.condition;
        IdentListMerger freeIdentMerger = BecomesSuchThat.mergeFreeIdentifiers((Formula[])children);
        this.freeIdents = freeIdentMerger.getFreeMergedArray();
        BoundIdentifier[] boundIdentsBelow = this.condition.boundIdents;
        this.boundIdents = QuantifiedHelper.getBoundIdentsAbove(boundIdentsBelow, this.primedIdents, this.getFactory());
        if (freeIdentMerger.containsError()) {
            return;
        }
        if (!this.condition.isTypeChecked()) {
            return;
        }
        for (int i = 0; i < length; ++i) {
            Type type = this.assignedIdents[i].getType();
            if (type != null && type.equals(this.primedIdents[i].getType())) continue;
            return;
        }
        this.typeChecked = true;
    }

    public BoundIdentDecl[] getPrimedIdents() {
        return (BoundIdentDecl[])this.primedIdents.clone();
    }

    public Predicate getCondition() {
        return this.condition;
    }

    @Override
    protected void collectFreeIdentifiers(LinkedHashSet<FreeIdentifier> freeIdentSet) {
        for (FreeIdentifier ident : this.assignedIdents) {
            ident.collectFreeIdentifiers(freeIdentSet);
        }
        this.condition.collectFreeIdentifiers(freeIdentSet);
    }

    @Override
    protected void collectNamesAbove(Set<String> names, String[] boundNames, int offset) {
        for (FreeIdentifier ident : this.assignedIdents) {
            ident.collectNamesAbove(names, boundNames, offset);
        }
        int newOffset = offset + this.primedIdents.length;
        this.condition.collectNamesAbove(names, boundNames, newOffset);
    }

    @Override
    protected void toString(IToStringMediator mediator) {
        int kind = mediator.getKind();
        OP_BECST.makeParser(kind).toString(mediator, this);
    }

    @Override
    protected int getKind(KindMediator mediator) {
        return mediator.getKind(OP_BECST.getImage());
    }

    @Override
    protected String getSyntaxTree(String[] boundNames, String tabs) {
        String childTabs = tabs + '\t';
        String[] boundNamesBelow = QuantifiedUtil.catenateBoundIdentLists(boundNames, this.primedIdents);
        return tabs + this.getClass().getSimpleName() + " [:\u2223]\n" + this.getSyntaxTreeLHS(boundNames, childTabs) + QuantifiedHelper.getSyntaxTreeQuantifiers(boundNamesBelow, childTabs, this.primedIdents) + this.condition.getSyntaxTree(boundNamesBelow, childTabs);
    }

    @Override
    protected boolean equalsInternal(Formula<?> formula) {
        BecomesSuchThat other = (BecomesSuchThat)formula;
        return this.hasSameAssignedIdentifiers(other) && QuantifiedHelper.areEqualDecls(this.primedIdents, other.primedIdents) && this.condition.equals(other.condition);
    }

    @Override
    protected void typeCheck(TypeCheckResult result, BoundIdentDecl[] boundAbove) {
        for (int i = 0; i < this.primedIdents.length; ++i) {
            this.assignedIdents[i].typeCheck(result, boundAbove);
            this.primedIdents[i].typeCheck(result, boundAbove);
            result.unify(this.assignedIdents[i].getType(), this.primedIdents[i].getType(), this);
        }
        BoundIdentDecl[] boundBelow = QuantifiedUtil.catenateBoundIdentLists(boundAbove, this.primedIdents);
        this.condition.typeCheck(result, boundBelow);
    }

    @Override
    protected void isLegible(LegibilityResult result) {
        for (FreeIdentifier freeIdentifier : this.assignedIdents) {
            freeIdentifier.isLegible(result);
        }
        for (Formula formula : this.primedIdents) {
            ((BoundIdentDecl)formula).isLegible(result);
        }
        this.condition.isLegible(result);
    }

    @Override
    protected void solveChildrenTypes(TypeUnifier unifier) {
        for (BoundIdentDecl ident : this.primedIdents) {
            ident.solveType(unifier);
        }
        this.condition.solveType(unifier);
    }

    @Override
    public boolean accept(IVisitor visitor) {
        int i;
        boolean goOn = visitor.enterBECOMES_SUCH_THAT(this);
        for (i = 0; goOn && i < this.assignedIdents.length; ++i) {
            goOn = this.assignedIdents[i].accept(visitor);
            if (!goOn) continue;
            goOn = visitor.continueBECOMES_SUCH_THAT(this);
        }
        for (i = 0; goOn && i < this.primedIdents.length; ++i) {
            goOn = this.primedIdents[i].accept(visitor);
            if (!goOn) continue;
            goOn = visitor.continueBECOMES_SUCH_THAT(this);
        }
        if (goOn) {
            goOn = this.condition.accept(visitor);
        }
        return visitor.exitBECOMES_SUCH_THAT(this);
    }

    @Override
    public void accept(ISimpleVisitor visitor) {
        visitor.visitBecomesSuchThat(this);
    }

    @Override
    protected Predicate getFISPredicateRaw() {
        SourceLocation loc = this.getSourceLocation();
        return QuantifiedHelper.getWDSimplifyQ(this.getFactory(), 852, this.primedIdents, this.condition, loc);
    }

    @Override
    protected Predicate getBAPredicateRaw() {
        FormulaFactory ff = this.getFactory();
        ITypeEnvironmentBuilder typeEnvironment = ff.makeTypeEnvironment();
        Expression[] freshIdents = typeEnvironment.makeFreshIdentifiers(this.primedIdents);
        BoundIdentSubstitution subst = new BoundIdentSubstitution(this.primedIdents, freshIdents, ff);
        return (Predicate)this.condition.rewrite(subst);
    }

    @Override
    public FreeIdentifier[] getUsedIdentifiers() {
        return this.condition.getFreeIdentifiers();
    }

    @Override
    public boolean isWDStrict() {
        return true;
    }
}

