/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.fp;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import tlc2.output.MP;
import tlc2.tool.fp.FPSet;
import tlc2.tool.fp.FPSetConfiguration;
import tlc2.tool.fp.LSBDiskFPSet;
import tlc2.tool.fp.MSBDiskFPSet;
import tlc2.tool.fp.MSBMultiFPSet;
import tlc2.tool.fp.MultiFPSet;
import tlc2.tool.fp.OffHeapDiskFPSet;

public abstract class FPSetFactory {
    public static final String IMPL_PROPERTY = FPSet.class.getName() + ".impl";

    private static boolean allocatesOnHeap(Class<? extends FPSet> clazz) {
        return !OffHeapDiskFPSet.class.isAssignableFrom(clazz);
    }

    static boolean allocatesOnHeap(String clazz) {
        try {
            ClassLoader classLoader = FPSet.class.getClassLoader();
            Class<?> cls = classLoader.loadClass(clazz);
            return FPSetFactory.allocatesOnHeap(cls);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static FPSet getFPSet() throws RemoteException {
        return FPSetFactory.getFPSet(new FPSetConfiguration());
    }

    public static FPSet getFPSet(FPSetConfiguration fpSetConfig) throws RemoteException {
        String implClassname = fpSetConfig.getImplementation();
        if (fpSetConfig.allowsNesting()) {
            if (FPSetFactory.msbBasedFPSet(implClassname)) {
                return new MSBMultiFPSet(fpSetConfig);
            }
            return new MultiFPSet(fpSetConfig);
        }
        if (implClassname != null) {
            return FPSetFactory.loadImplementation(implClassname, fpSetConfig);
        }
        return new MSBDiskFPSet(fpSetConfig);
    }

    public static String[] getImplementations() {
        ArrayList<String> l = new ArrayList<String>();
        l.add(MSBDiskFPSet.class.getName());
        l.add(LSBDiskFPSet.class.getName());
        l.add(OffHeapDiskFPSet.class.getName());
        return l.toArray(new String[l.size()]);
    }

    public static String getImplementationDefault() {
        return MSBDiskFPSet.class.getName();
    }

    public static String getVMArguments(String clazz, long memory) {
        if (FPSetFactory.allocatesOnHeap(clazz)) {
            return "-Xmx" + memory + "m";
        }
        return "-XX:MaxDirectMemorySize=" + memory + "m";
    }

    private static FPSet loadImplementation(String clazz, FPSetConfiguration fpSetConfig) {
        Exception exp = null;
        try {
            ClassLoader classLoader = FPSet.class.getClassLoader();
            Class<?> factoryClass = classLoader.loadClass(clazz);
            Constructor<?> constructor = factoryClass.getDeclaredConstructor(FPSetConfiguration.class);
            Object instance = constructor.newInstance(fpSetConfig);
            if (instance instanceof FPSet) {
                return (FPSet)instance;
            }
        }
        catch (ClassNotFoundException e) {
            exp = e;
        }
        catch (InstantiationException e) {
            exp = e;
        }
        catch (IllegalAccessException e) {
            exp = e;
        }
        catch (SecurityException e) {
            exp = e;
        }
        catch (NoSuchMethodException e) {
            exp = e;
        }
        catch (IllegalArgumentException e) {
            exp = e;
        }
        catch (InvocationTargetException e) {
            exp = e;
        }
        MP.printWarning(1000, "unsuccessfully trying to load custom FPSet class: " + clazz, exp);
        return null;
    }

    private static boolean msbBasedFPSet(String userFpsetImplClassname) {
        if (!FPSetFactory.allocatesOnHeap(userFpsetImplClassname)) {
            return true;
        }
        return userFpsetImplClassname.equals(MSBDiskFPSet.class.getName());
    }
}

