/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.fp;

import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.NotCompliantMBeanException;
import tlc2.output.MP;
import tlc2.tool.TLCTrace;
import tlc2.tool.fp.FPSet;
import tlc2.tool.fp.FPSetConfiguration;
import tlc2.tool.fp.FPSetStatistic;
import tlc2.tool.fp.management.DiskFPSetMXWrapper;
import tlc2.tool.management.TLCStandardMBean;
import tlc2.util.BufferedRandomAccessFile;
import tlc2.util.IdThread;
import tlc2.util.Striped;
import util.Assert;
import util.FileUtil;

public abstract class DiskFPSet
extends FPSet
implements FPSetStatistic {
    private static final Logger LOGGER = Logger.getLogger(DiskFPSet.class.getName());
    protected long maxTblCnt;
    protected String metadir;
    protected String fpFilename;
    protected String tmpFilename;
    protected static final int LogLockCnt = Integer.getInteger(DiskFPSet.class.getName() + ".logLockCnt", 10);
    protected final Striped rwLock;
    protected final int lockCnt;
    protected long fileCnt;
    protected AtomicBoolean flusherChosen;
    protected AtomicLong tblCnt;
    protected long tblLoad;
    protected long bucketsCapacity;
    protected BufferedRandomAccessFile[] braf;
    protected BufferedRandomAccessFile[] brafPool;
    protected int poolIndex;
    protected long[] index;
    private AtomicLong memHitCnt = new AtomicLong(0L);
    private AtomicLong diskLookupCnt = new AtomicLong(0L);
    private AtomicLong diskHitCnt = new AtomicLong(0L);
    private AtomicLong diskWriteCnt = new AtomicLong(0L);
    private AtomicLong diskSeekCnt = new AtomicLong(0L);
    private AtomicLong diskSeekCache = new AtomicLong(0L);
    private int checkPointMark;
    private int growDiskMark;
    protected static final int LogMaxLoad = 4;
    static final int InitialBucketCapacity = 16;
    public static final int NumEntriesPerPage = 1024;
    protected TLCStandardMBean diskFPSetMXWrapper;
    private long flushTime = 0L;
    protected Flusher flusher;
    protected volatile boolean forceFlush = false;
    protected int currIndex;
    protected int counter;
    private long[] recoveryBuff = null;
    private int recoveryIdx = -1;

    protected double getAuxiliaryStorageRequirement() {
        return 1.0;
    }

    protected DiskFPSet(FPSetConfiguration fpSetConfig) throws RemoteException {
        super(fpSetConfig);
        this.lockCnt = 1 << LogLockCnt;
        this.rwLock = Striped.readWriteLock(this.lockCnt);
        this.maxTblCnt = fpSetConfig.getMemoryInFingerprintCnt();
        if (this.maxTblCnt <= 0L) {
            throw new IllegalArgumentException("Negative or zero upper storage limit");
        }
        this.fileCnt = 0L;
        this.tblCnt = new AtomicLong(0L);
        this.flusherChosen = new AtomicBoolean(false);
        this.index = null;
        try {
            this.diskFPSetMXWrapper = new DiskFPSetMXWrapper(this);
        }
        catch (NotCompliantMBeanException e) {
            MP.printWarning(1000, "Failed to create MBean wrapper for DiskFPSet. No statistics/metrics will be avaiable.", e);
            this.diskFPSetMXWrapper = TLCStandardMBean.getNullTLCStandardMBean();
        }
    }

    @Override
    public void init(int numThreads, String aMetadir, String filename) throws IOException {
        String propMetaDirPrefix = System.getProperty(DiskFPSet.class.getName() + ".metadirPrefix");
        if (propMetaDirPrefix == null) {
            this.metadir = aMetadir;
        } else {
            File file = new File(aMetadir);
            if (file.isAbsolute()) {
                aMetadir = file.getName();
            }
            String folder = propMetaDirPrefix + File.separator + aMetadir;
            new File(folder).mkdirs();
            this.metadir = folder;
        }
        filename = this.metadir + FileUtil.separator + filename;
        this.tmpFilename = filename + ".tmp";
        this.fpFilename = filename + ".fp";
        this.braf = new BufferedRandomAccessFile[numThreads];
        this.brafPool = new BufferedRandomAccessFile[5];
        this.poolIndex = 0;
        try {
            int i;
            FileOutputStream f = new FileOutputStream(this.fpFilename);
            f.close();
            for (i = 0; i < numThreads; ++i) {
                this.braf[i] = new BufferedRandomAccessFile(this.fpFilename, "r");
            }
            for (i = 0; i < this.brafPool.length; ++i) {
                this.brafPool[i] = new BufferedRandomAccessFile(this.fpFilename, "r");
            }
        }
        catch (IOException e) {
            String message = MP.getMessage(2167, new String[]{this.fpFilename, e.getMessage()});
            throw new IOException(message);
        }
    }

    @Override
    public long size() {
        return this.tblCnt.get() + this.fileCnt;
    }

    @Override
    public abstract long sizeof();

    public final void finalize() {
        int i;
        for (i = 0; i < this.braf.length; ++i) {
            try {
                this.braf[i].close();
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        for (i = 0; i < this.brafPool.length; ++i) {
            try {
                this.brafPool[i].close();
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addThread() throws IOException {
        BufferedRandomAccessFile[] bufferedRandomAccessFileArray = this.braf;
        synchronized (this.braf) {
            int len = this.braf.length;
            BufferedRandomAccessFile[] nraf = new BufferedRandomAccessFile[len + 1];
            for (int i = 0; i < len; ++i) {
                nraf[i] = this.braf[i];
            }
            nraf[len] = new BufferedRandomAccessFile(this.fpFilename, "r");
            this.braf = nraf;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public final boolean put(long fp) throws IOException {
        fp = this.checkValid(fp);
        long fp0 = fp & Long.MAX_VALUE;
        Lock readLock = this.rwLock.getAt(this.getLockIndex(fp0)).readLock();
        readLock.lock();
        if (this.memLookup(fp0)) {
            readLock.unlock();
            this.memHitCnt.getAndIncrement();
            return true;
        }
        boolean diskHit = this.diskLookup(fp0);
        if (diskHit) {
            readLock.unlock();
            this.diskHitCnt.getAndIncrement();
            return true;
        }
        readLock.unlock();
        Lock w = this.rwLock.getAt(this.getLockIndex(fp0)).writeLock();
        w.lock();
        if (this.memInsert(fp0)) {
            w.unlock();
            this.memHitCnt.getAndIncrement();
            return true;
        }
        if (this.needsDiskFlush() && this.flusherChosen.compareAndSet(false, true)) {
            ++this.growDiskMark;
            long timestamp = System.currentTimeMillis();
            this.rwLock.acquireAllLocks();
            this.flusher.flushTable();
            this.rwLock.releaseAllLocks();
            this.forceFlush = false;
            this.flusherChosen.set(false);
            long l = System.currentTimeMillis() - timestamp;
            this.flushTime += l;
            LOGGER.log(Level.FINE, "Flushed disk {0} {1}. tine, in {2} sec", new Object[]{((DiskFPSetMXWrapper)this.diskFPSetMXWrapper).getObjectName(), this.getGrowDiskMark(), l});
        }
        w.unlock();
        return false;
    }

    protected boolean needsDiskFlush() {
        return this.tblCnt.get() >= this.maxTblCnt || this.forceFlush;
    }

    @Override
    public final boolean contains(long fp) throws IOException {
        fp = this.checkValid(fp);
        long fp0 = fp & Long.MAX_VALUE;
        Lock readLock = this.rwLock.getAt(this.getLockIndex(fp0)).readLock();
        readLock.lock();
        if (this.memLookup(fp0)) {
            readLock.unlock();
            this.memHitCnt.getAndIncrement();
            return true;
        }
        boolean diskHit = this.diskLookup(fp0);
        if (diskHit) {
            this.diskHitCnt.getAndIncrement();
        }
        readLock.unlock();
        return diskHit;
    }

    protected abstract int getLockIndex(long var1);

    protected long checkValid(long fp) {
        if (fp == 0L) {
            // empty if block
        }
        return fp;
    }

    abstract boolean memLookup(long var1);

    abstract boolean memInsert(long var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    final boolean diskLookup(long fp) throws IOException {
        if (this.index == null) {
            return false;
        }
        this.diskLookupCnt.getAndIncrement();
        int indexLength = this.index.length;
        int loPage = 0;
        int hiPage = indexLength - 1;
        long loVal = this.index[loPage];
        long hiVal = this.index[hiPage];
        if (fp < loVal) return false;
        if (fp > hiVal) {
            return false;
        }
        if (fp == hiVal) {
            return true;
        }
        double dfp = fp;
        while (loPage < hiPage - 1) {
            double dhi = hiPage;
            double dlo = loPage;
            double dloVal = loVal;
            double dhiVal = hiVal;
            int midPage = loPage + 1 + (int)((dhi - dlo - 1.0) * (dfp - dloVal) / (dhiVal - dloVal));
            if (midPage == hiPage) {
                --midPage;
            }
            Assert.check(loPage < midPage && midPage < hiPage, 2134);
            long v = this.index[midPage];
            if (fp < v) {
                hiPage = midPage;
                hiVal = v;
                continue;
            }
            if (fp <= v) return true;
            loPage = midPage;
            loVal = v;
        }
        Assert.check(hiPage == loPage + 1, 2134);
        boolean diskHit = false;
        long midEntry = -1L;
        long loEntry = (long)loPage * 1024L;
        long hiEntry = loPage == indexLength - 2 ? this.fileCnt - 1L : (long)hiPage * 1024L;
        try {
            BufferedRandomAccessFile raf;
            int id = IdThread.GetId(this.braf.length);
            if (id < this.braf.length) {
                raf = this.braf[id];
            } else {
                BufferedRandomAccessFile[] v = this.brafPool;
                // MONITORENTER : this.brafPool
                raf = this.poolIndex < this.brafPool.length ? this.brafPool[this.poolIndex++] : new BufferedRandomAccessFile(this.fpFilename, "r");
                // MONITOREXIT : v
            }
            while (loEntry < hiEntry) {
                midEntry = this.calculateMidEntry(loVal, hiVal, dfp, loEntry, hiEntry);
                Assert.check(loEntry <= midEntry && midEntry < hiEntry, 2134);
                if (raf.seeek(midEntry * 8L)) {
                    this.diskSeekCnt.getAndIncrement();
                } else {
                    this.diskSeekCache.getAndIncrement();
                }
                long v = raf.readLong();
                if (fp < v) {
                    hiEntry = midEntry;
                    hiVal = v;
                    continue;
                }
                if (fp > v) {
                    loEntry = midEntry + 1L;
                    loVal = v;
                    continue;
                }
                diskHit = true;
                break;
            }
            if (id < this.braf.length) return diskHit;
            BufferedRandomAccessFile[] bufferedRandomAccessFileArray = this.brafPool;
            // MONITORENTER : this.brafPool
            if (this.poolIndex > 0) {
                this.brafPool[--this.poolIndex] = raf;
                return diskHit;
            }
            raf.close();
            // MONITOREXIT : bufferedRandomAccessFileArray
            return diskHit;
        }
        catch (IOException e) {
            if (midEntry * 8L < 0L) {
                MP.printError(1000, new String[]{"looking up a fingerprint, and\nmidEntry turned negative (loEntry, midEntry, hiEntry, loVal, hiVal): ", Long.toString(loEntry) + " ", Long.toString(midEntry) + " ", Long.toString(hiEntry) + " ", Long.toString(loVal) + " ", Long.toString(hiVal)}, (Throwable)e);
            }
            MP.printError(2129, e);
            throw e;
        }
    }

    long calculateMidEntry(long loVal, long hiVal, double dfp, long loEntry, long hiEntry) {
        double dhi = hiEntry;
        double dlo = loEntry;
        double dloVal = loVal;
        double dhiVal = hiVal;
        long midEntry = loEntry + (long)((dhi - dlo) * (dfp - dloVal) / (dhiVal - dloVal));
        if (midEntry == hiEntry) {
            --midEntry;
        }
        return midEntry;
    }

    protected final void writeFP(RandomAccessFile outRAF, long fp) throws IOException {
        outRAF.writeLong(fp);
        this.diskWriteCnt.getAndIncrement();
        if (this.counter == 0) {
            this.index[this.currIndex++] = fp;
            this.counter = 1024;
        }
        --this.counter;
    }

    protected int calculateIndexLen(long buffLen) {
        long indexLen = (this.fileCnt + buffLen - 1L) / 1024L + 2L;
        Assert.check(indexLen > 0L, 1000);
        return (int)indexLen;
    }

    @Override
    public final void close() {
        int i;
        this.diskFPSetMXWrapper.unregister();
        for (i = 0; i < this.braf.length; ++i) {
            try {
                this.braf[i].close();
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        for (i = 0; i < this.brafPool.length; ++i) {
            try {
                this.brafPool[i].close();
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.poolIndex = 0;
    }

    @Override
    public final void exit(boolean cleanup) throws IOException {
        if (cleanup) {
            FileUtil.deleteDir(this.metadir, true);
        }
        String hostname = InetAddress.getLocalHost().getHostName();
        MP.printMessage(2211, hostname);
        System.exit(0);
    }

    @Override
    public final double checkFPs() throws IOException {
        this.rwLock.acquireAllLocks();
        this.flusher.flushTable();
        this.rwLock.releaseAllLocks();
        BufferedRandomAccessFile braf = new BufferedRandomAccessFile(this.fpFilename, "r");
        long fileLen = ((RandomAccessFile)braf).length();
        long dis = Long.MAX_VALUE;
        if (fileLen > 0L) {
            long x = braf.readLong();
            while (((RandomAccessFile)braf).getFilePointer() < fileLen) {
                long y = braf.readLong();
                long dis1 = y - x;
                if (dis1 >= 0L) {
                    dis = Math.min(dis, dis1);
                }
                x = y;
            }
        }
        ((RandomAccessFile)braf).close();
        return 1.0 / (double)dis;
    }

    @Override
    public final void beginChkpt(String fname) throws IOException {
        this.flusherChosen.set(true);
        this.rwLock.acquireAllLocks();
        this.flusher.flushTable();
        FileUtil.copyFile(this.fpFilename, this.getChkptName(fname, "tmp"));
        ++this.checkPointMark;
        this.rwLock.releaseAllLocks();
        this.flusherChosen.set(false);
    }

    @Override
    public final void commitChkpt(String fname) throws IOException {
        File oldChkpt = new File(this.getChkptName(fname, "chkpt"));
        File newChkpt = new File(this.getChkptName(fname, "tmp"));
        if (!newChkpt.renameTo(oldChkpt)) {
            throw new IOException("DiskFPSet.commitChkpt: cannot delete " + oldChkpt);
        }
    }

    @Override
    public final void recover(String fname) throws IOException {
        BufferedRandomAccessFile chkptRAF = new BufferedRandomAccessFile(this.getChkptName(fname, "chkpt"), "r");
        BufferedRandomAccessFile currRAF = new BufferedRandomAccessFile(this.fpFilename, "rw");
        this.fileCnt = ((RandomAccessFile)chkptRAF).length() / 8L;
        int indexLen = (int)((this.fileCnt - 1L) / 1024L) + 2;
        this.index = new long[indexLen];
        this.currIndex = 0;
        this.counter = 0;
        long fp = 0L;
        try {
            long predecessor = Long.MIN_VALUE;
            while (true) {
                fp = chkptRAF.readLong();
                this.writeFP(currRAF, fp);
                Assert.check(predecessor < fp, 2134);
                predecessor = fp;
            }
        }
        catch (EOFException e) {
            int i;
            Assert.check(this.currIndex == indexLen - 1, 2134);
            this.index[indexLen - 1] = fp;
            ((RandomAccessFile)chkptRAF).close();
            ((RandomAccessFile)currRAF).close();
            for (i = 0; i < this.braf.length; ++i) {
                this.braf[i].close();
                this.braf[i] = new BufferedRandomAccessFile(this.fpFilename, "r");
            }
            for (i = 0; i < this.brafPool.length; ++i) {
                this.brafPool[i].close();
                this.brafPool[i] = new BufferedRandomAccessFile(this.fpFilename, "r");
            }
            this.poolIndex = 0;
            return;
        }
    }

    @Override
    public final void beginChkpt() throws IOException {
    }

    @Override
    public final void commitChkpt() throws IOException {
    }

    @Override
    public final void prepareRecovery() throws IOException {
        int i;
        for (i = 0; i < this.braf.length; ++i) {
            this.braf[i].close();
        }
        for (i = 0; i < this.brafPool.length; ++i) {
            this.brafPool[i].close();
        }
        this.recoveryBuff = new long[0x200000];
        this.recoveryIdx = 0;
    }

    @Override
    public final void recoverFP(long fp) throws IOException {
        this.recoveryBuff[this.recoveryIdx++] = fp & Long.MAX_VALUE;
        if (this.recoveryIdx == this.recoveryBuff.length) {
            Arrays.sort(this.recoveryBuff, 0, this.recoveryIdx);
            this.flusher.mergeNewEntries(this.recoveryBuff, this.recoveryIdx);
            this.recoveryIdx = 0;
        }
    }

    @Override
    public final void completeRecovery() throws IOException {
        int i;
        Arrays.sort(this.recoveryBuff, 0, this.recoveryIdx);
        this.flusher.mergeNewEntries(this.recoveryBuff, this.recoveryIdx);
        this.recoveryBuff = null;
        this.recoveryIdx = -1;
        for (i = 0; i < this.braf.length; ++i) {
            this.braf[i] = new BufferedRandomAccessFile(this.fpFilename, "r");
        }
        for (i = 0; i < this.brafPool.length; ++i) {
            this.brafPool[i] = new BufferedRandomAccessFile(this.fpFilename, "r");
        }
        this.poolIndex = 0;
    }

    @Override
    public final void recover() throws IOException {
        this.prepareRecovery();
        long recoverPtr = TLCTrace.getRecoverPtr();
        BufferedRandomAccessFile braf = new BufferedRandomAccessFile(TLCTrace.getFilename(), "r");
        while (((RandomAccessFile)braf).getFilePointer() < recoverPtr) {
            if (braf.readInt() < 0) {
                braf.readInt();
            }
            long fp = braf.readLong();
            this.recoverFP(fp);
        }
        this.completeRecovery();
    }

    private String getChkptName(String fname, String name) {
        return this.metadir + FileUtil.separator + fname + ".fp." + name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkInvariant() throws IOException {
        this.rwLock.acquireAllLocks();
        this.flusher.flushTable();
        BufferedRandomAccessFile braf = new BufferedRandomAccessFile(this.fpFilename, "r");
        try {
            long fileLen = ((RandomAccessFile)braf).length();
            long predecessor = Long.MIN_VALUE;
            if (fileLen > 0L) {
                while (((RandomAccessFile)braf).getFilePointer() < fileLen) {
                    long l = braf.readLong();
                    if (predecessor >= l) {
                        boolean bl = false;
                        return bl;
                    }
                    predecessor = l;
                }
            }
        }
        finally {
            ((RandomAccessFile)braf).close();
            this.rwLock.releaseAllLocks();
        }
        return true;
    }

    @Override
    public boolean checkInvariant(long expectedFPCnt) throws IOException {
        return this.checkInvariant() && this.size() == expectedFPCnt;
    }

    @Override
    public long getBucketCapacity() {
        return this.bucketsCapacity;
    }

    @Override
    public long getTblCapacity() {
        return -1L;
    }

    @Override
    public long getIndexCapacity() {
        if (this.index == null) {
            return 0L;
        }
        return this.index.length;
    }

    @Override
    public long getOverallCapacity() {
        return this.getBucketCapacity() + this.getTblCapacity() + this.getIndexCapacity();
    }

    @Override
    public long getTblLoad() {
        return this.tblLoad;
    }

    @Override
    public long getTblCnt() {
        return this.tblCnt.get();
    }

    @Override
    public long getMaxTblCnt() {
        return this.maxTblCnt;
    }

    @Override
    public long getFileCnt() {
        return this.fileCnt;
    }

    @Override
    public long getDiskLookupCnt() {
        return this.diskLookupCnt.get();
    }

    @Override
    public long getMemHitCnt() {
        return this.memHitCnt.get();
    }

    @Override
    public long getDiskHitCnt() {
        return this.diskHitCnt.get();
    }

    @Override
    public long getDiskWriteCnt() {
        return this.diskWriteCnt.get();
    }

    @Override
    public long getDiskSeekCnt() {
        return this.diskSeekCnt.get();
    }

    @Override
    public long getDiskSeekCache() {
        return this.diskSeekCache.get();
    }

    @Override
    public int getGrowDiskMark() {
        return this.growDiskMark;
    }

    @Override
    public int getCheckPointMark() {
        return this.checkPointMark;
    }

    @Override
    public long getFlushTime() {
        return this.flushTime;
    }

    @Override
    public void forceFlush() {
        this.forceFlush = true;
    }

    @Override
    public int getReaderWriterCnt() {
        return this.braf.length + this.brafPool.length;
    }

    @Override
    public long getCollisionBucketCnt() {
        return -1L;
    }

    @Override
    public double getCollisionRatio() {
        return -1.0;
    }

    @Override
    public double getLoadFactor() {
        return this.tblCnt.doubleValue() / (double)this.maxTblCnt;
    }

    public abstract class Flusher {
        protected void prepareTable() {
        }

        void flushTable() throws IOException {
            if (DiskFPSet.this.tblCnt.get() == 0L) {
                return;
            }
            this.prepareTable();
            try {
                this.mergeNewEntries();
            }
            catch (IOException e) {
                String msg = "Error: merging entries into file " + DiskFPSet.this.fpFilename + "  " + e;
                throw new IOException(msg);
            }
            DiskFPSet.this.tblCnt.set(0L);
            DiskFPSet.this.bucketsCapacity = 0L;
            DiskFPSet.this.tblLoad = 0L;
        }

        private final void mergeNewEntries() throws IOException {
            int i;
            int i2;
            for (i2 = 0; i2 < DiskFPSet.this.braf.length; ++i2) {
                DiskFPSet.this.braf[i2].close();
            }
            for (i2 = 1; i2 < DiskFPSet.this.brafPool.length; ++i2) {
                DiskFPSet.this.brafPool[i2].close();
            }
            File tmpFile = new File(DiskFPSet.this.tmpFilename);
            tmpFile.delete();
            BufferedRandomAccessFile tmpRAF = new BufferedRandomAccessFile(tmpFile, "rw");
            BufferedRandomAccessFile raf = DiskFPSet.this.brafPool[0];
            ((RandomAccessFile)raf).seek(0L);
            this.mergeNewEntries(raf, tmpRAF);
            ((RandomAccessFile)raf).close();
            ((RandomAccessFile)tmpRAF).close();
            String realName = DiskFPSet.this.fpFilename;
            File currFile = new File(realName);
            currFile.delete();
            boolean status = tmpFile.renameTo(currFile);
            Assert.check(status, 2160);
            for (i = 0; i < DiskFPSet.this.braf.length; ++i) {
                DiskFPSet.this.braf[i] = new BufferedRandomAccessFile(realName, "r");
            }
            for (i = 0; i < DiskFPSet.this.brafPool.length; ++i) {
                DiskFPSet.this.brafPool[i] = new BufferedRandomAccessFile(realName, "r");
            }
            DiskFPSet.this.poolIndex = 0;
        }

        public final void mergeNewEntries(long[] buff, int buffLen) throws IOException {
            File tmpFile = new File(DiskFPSet.this.tmpFilename);
            tmpFile.delete();
            BufferedRandomAccessFile tmpRAF = new BufferedRandomAccessFile(tmpFile, "rw");
            File currFile = new File(DiskFPSet.this.fpFilename);
            BufferedRandomAccessFile currRAF = new BufferedRandomAccessFile(currFile, "r");
            this.mergeNewEntries(currRAF, tmpRAF);
            ((RandomAccessFile)currRAF).close();
            ((RandomAccessFile)tmpRAF).close();
            currFile.delete();
            boolean status = tmpFile.renameTo(currFile);
            Assert.check(status, 2160);
        }

        protected abstract void mergeNewEntries(RandomAccessFile var1, RandomAccessFile var2) throws IOException;
    }
}

