/*
 * Decompiled with CFR 0.152.
 */
package pcal;

import java.util.Hashtable;
import java.util.Vector;
import pcal.AST;
import pcal.IntPair;
import pcal.PCalLocation;
import pcal.PcalBuiltInSymbols;
import pcal.PcalCharReader;
import pcal.PcalDebug;
import pcal.PcalParams;
import pcal.Region;
import pcal.TLAExpr;
import pcal.TLAToken;
import pcal.TLAtoPCalMapping;
import pcal.Tokenize;
import pcal.exception.ParseAlgorithmException;
import pcal.exception.TLAExprException;
import pcal.exception.TokenizerException;
import pcal.exception.UnrecoverableException;
import pcal.trans;
import tla2tex.Debug;

public class ParseAlgorithm {
    private static PcalCharReader charReader;
    public static String currentProcedure;
    public static Vector plusLabels;
    public static Vector minusLabels;
    public static boolean gotoUsed;
    public static boolean gotoDoneUsed;
    public static boolean omitPC;
    public static boolean omitStutteringWhenDone;
    public static Vector proceduresCalled;
    public static boolean hasDefaultInitialization;
    public static boolean hasLabel;
    public static Hashtable allLabels;
    public static int nextLabelNum;
    public static Vector addedLabels;
    public static Vector addedLabelsLocs;
    public static Vector procedures;
    public static boolean pSyntax;
    public static boolean cSyntax;
    public static boolean inGetMacro;
    public static PCalLocation getLabelLocation;
    public static String[] LAT;
    public static int LATsize;
    public static int[] curTokCol;
    public static int[] curTokLine;
    public static int lastTokCol;
    public static int lastTokLine;
    private static String lastTokString;

    public static void Init(PcalCharReader charR) {
        addedLabels = new Vector();
        addedLabelsLocs = new Vector();
        nextLabelNum = 1;
        charReader = charR;
        allLabels = new Hashtable();
        hasLabel = false;
        hasDefaultInitialization = false;
        currentProcedure = null;
        procedures = new Vector();
        pSyntax = false;
        cSyntax = false;
        plusLabels = new Vector(0);
        minusLabels = new Vector(0);
        proceduresCalled = new Vector(0);
        gotoUsed = false;
        gotoDoneUsed = false;
        omitPC = true;
        omitStutteringWhenDone = true;
        if (PcalParams.inputVersionNumber < PcalParams.VersionToNumber("1.5")) {
            omitPC = false;
            omitStutteringWhenDone = false;
        }
        PcalBuiltInSymbols.Initialize();
        AST.ASTInit();
    }

    public static AST getAlgorithm(PcalCharReader charR, boolean fairAlgorithm) throws ParseAlgorithmException {
        ParseAlgorithm.Init(charR);
        if (fairAlgorithm) {
            String nextToken = ParseAlgorithm.GetAlgToken();
            if (!nextToken.equals("algorithm")) {
                ParseAlgorithm.ParsingError("`--fair' not followed by `algorithm'");
            }
            PcalParams.FairAlgorithm = true;
        }
        String name = ParseAlgorithm.GetAlgToken();
        if (ParseAlgorithm.PeekAtAlgToken(1).equals("{")) {
            cSyntax = true;
            ParseAlgorithm.MustGobbleThis("{");
        } else {
            pSyntax = true;
        }
        Vector vdecls = new Vector();
        if (ParseAlgorithm.PeekAtAlgToken(1).equals("variable") || ParseAlgorithm.PeekAtAlgToken(1).equals("variables")) {
            vdecls = ParseAlgorithm.GetVarDecls();
        }
        TLAExpr defs = new TLAExpr();
        if (ParseAlgorithm.PeekAtAlgToken(1).equals("define")) {
            ParseAlgorithm.MustGobbleThis("define");
            if (cSyntax) {
                ParseAlgorithm.GobbleThis("{");
            }
            defs = ParseAlgorithm.GetExpr();
            if (pSyntax) {
                ParseAlgorithm.GobbleThis("end");
                ParseAlgorithm.GobbleThis("define");
            } else {
                ParseAlgorithm.GobbleThis("}");
            }
            ParseAlgorithm.GobbleThis(";");
        }
        Vector<AST.Macro> macros = new Vector<AST.Macro>();
        while (ParseAlgorithm.PeekAtAlgToken(1).equals("macro")) {
            macros.addElement(ParseAlgorithm.GetMacro(macros));
        }
        while (ParseAlgorithm.PeekAtAlgToken(1).equals("procedure")) {
            procedures.addElement(ParseAlgorithm.GetProcedure());
            omitPC = false;
        }
        if (ParseAlgorithm.PeekAtAlgToken(1).equals("fair") && (ParseAlgorithm.PeekAtAlgToken(2).equals("process") || ParseAlgorithm.PeekAtAlgToken(2).equals("+") && ParseAlgorithm.PeekAtAlgToken(3).equals("process")) || ParseAlgorithm.PeekAtAlgToken(1).equals("process")) {
            int i;
            AST.Multiprocess multiproc = new AST.Multiprocess();
            TLAtoPCalMapping map = PcalParams.tlaPcalMapping;
            PCalLocation multiprocBegin = new PCalLocation(map.algLine, map.algColumn);
            multiproc.name = name;
            multiproc.decls = vdecls;
            multiproc.defs = defs;
            multiproc.macros = macros;
            multiproc.prcds = procedures;
            multiproc.procs = new Vector();
            while (ParseAlgorithm.PeekAtAlgToken(1).equals("fair") || ParseAlgorithm.PeekAtAlgToken(1).equals("process")) {
                int fairness = 0;
                if (ParseAlgorithm.PeekAtAlgToken(1).equals("fair")) {
                    ParseAlgorithm.MustGobbleThis("fair");
                    if (ParseAlgorithm.PeekAtAlgToken(1).equals("+")) {
                        ParseAlgorithm.MustGobbleThis("+");
                        fairness = 2;
                    } else {
                        fairness = 1;
                    }
                } else if (PcalParams.FairnessOption.equals("wf")) {
                    fairness = 1;
                } else if (PcalParams.FairnessOption.equals("sf")) {
                    fairness = 2;
                }
                AST.Process proc = ParseAlgorithm.GetProcess();
                proc.fairness = fairness;
                multiproc.procs.addElement(proc);
            }
            if (pSyntax) {
                ParseAlgorithm.GobbleThis("end");
                ParseAlgorithm.GobbleThis("algorithm");
            } else {
                ParseAlgorithm.GobbleThis("}");
            }
            ParseAlgorithm.CheckForDuplicateMacros(multiproc.macros);
            boolean omitStutteringWhenDoneValue = false;
            for (i = 0; i < multiproc.procs.size(); ++i) {
                AST.Process proc = (AST.Process)multiproc.procs.elementAt(i);
                ParseAlgorithm.ExpandMacrosInStmtSeq(proc.body, multiproc.macros);
                ParseAlgorithm.AddLabelsToStmtSeq(proc.body);
                proc.body = ParseAlgorithm.MakeLabeledStmtSeq(proc.body);
                omitStutteringWhenDone = true;
                ParseAlgorithm.checkBody(proc.body);
                omitStutteringWhenDoneValue = omitStutteringWhenDoneValue || omitStutteringWhenDone;
            }
            omitStutteringWhenDone = omitStutteringWhenDoneValue;
            for (i = 0; i < multiproc.prcds.size(); ++i) {
                AST.Procedure prcd = (AST.Procedure)multiproc.prcds.elementAt(i);
                currentProcedure = prcd.name;
                ParseAlgorithm.ExpandMacrosInStmtSeq(prcd.body, multiproc.macros);
                ParseAlgorithm.AddLabelsToStmtSeq(prcd.body);
                prcd.body = ParseAlgorithm.MakeLabeledStmtSeq(prcd.body);
            }
            if (addedLabels.size() > 0) {
                if (!PcalParams.LabelFlag) {
                    ParseAlgorithm.AddedMessagesError();
                }
                if (PcalParams.ReportLabelsFlag) {
                    ParseAlgorithm.ReportLabels();
                } else {
                    PcalDebug.reportInfo("Labels added.");
                }
            }
            if (gotoDoneUsed) {
                omitPC = false;
                omitStutteringWhenDone = false;
            }
            if (gotoUsed) {
                omitPC = false;
            }
            multiproc.setOrigin(new Region(multiprocBegin, ParseAlgorithm.GetLastLocationEnd()));
            return multiproc;
        }
        AST.Uniprocess uniproc = new AST.Uniprocess();
        TLAtoPCalMapping map = PcalParams.tlaPcalMapping;
        PCalLocation uniprocBegin = new PCalLocation(map.algLine, map.algColumn);
        uniproc.name = name;
        uniproc.decls = vdecls;
        uniproc.defs = defs;
        uniproc.macros = macros;
        uniproc.prcds = procedures;
        if (PcalParams.inputVersionNumber == PcalParams.VersionToNumber("1.5") && ParseAlgorithm.PeekAtAlgToken(1).equals("fair")) {
            ParseAlgorithm.GobbleThis("fair");
            if (ParseAlgorithm.PeekAtAlgToken(1).equals("+")) {
                ParseAlgorithm.GobbleThis("+");
            }
            PcalParams.FairnessOption = "wf";
        }
        if (fairAlgorithm) {
            if (!(PcalParams.FairnessOption.equals("") || PcalParams.FairnessOption.equals("wf") || PcalParams.FairnessOption.equals("wfNext"))) {
                PcalDebug.reportWarning("Option `" + PcalParams.FairnessOption + "' specified for --fair algorithm.");
            }
            PcalParams.FairnessOption = "wf";
        }
        ParseAlgorithm.GobbleBeginOrLeftBrace();
        uniproc.body = ParseAlgorithm.GetStmtSeq();
        ParseAlgorithm.CheckForDuplicateMacros(uniproc.macros);
        ParseAlgorithm.ExpandMacrosInStmtSeq(uniproc.body, uniproc.macros);
        for (int i = 0; i < uniproc.prcds.size(); ++i) {
            AST.Procedure prcd = (AST.Procedure)uniproc.prcds.elementAt(i);
            currentProcedure = prcd.name;
            ParseAlgorithm.ExpandMacrosInStmtSeq(prcd.body, uniproc.macros);
            ParseAlgorithm.AddLabelsToStmtSeq(prcd.body);
            prcd.body = ParseAlgorithm.MakeLabeledStmtSeq(prcd.body);
        }
        if (cSyntax) {
            ParseAlgorithm.GobbleThis("}");
            ParseAlgorithm.GobbleThis("}");
        } else {
            ParseAlgorithm.GobbleThis("end");
            ParseAlgorithm.GobbleThis("algorithm");
        }
        ParseAlgorithm.AddLabelsToStmtSeq(uniproc.body);
        uniproc.body = ParseAlgorithm.MakeLabeledStmtSeq(uniproc.body);
        if (addedLabels.size() > 0) {
            if (hasLabel && !PcalParams.LabelFlag) {
                ParseAlgorithm.AddedMessagesError();
            }
            if (PcalParams.ReportLabelsFlag) {
                ParseAlgorithm.ReportLabels();
            } else {
                PcalDebug.reportInfo("Labels added.");
            }
        }
        if (gotoUsed) {
            omitPC = false;
        }
        if (gotoDoneUsed) {
            omitPC = false;
            omitStutteringWhenDone = false;
        } else {
            ParseAlgorithm.checkBody(uniproc.body);
        }
        uniproc.setOrigin(new Region(uniprocBegin, ParseAlgorithm.GetLastLocationEnd()));
        return uniproc;
    }

    private static void checkBody(Vector body) {
        if (body == null || body.size() == 0) {
            return;
        }
        if (body.size() > 1 || !body.elementAt(0).getClass().equals(AST.LabeledStmtObj.getClass())) {
            omitPC = false;
            omitStutteringWhenDone = false;
            return;
        }
        AST.LabeledStmt lblStmt = (AST.LabeledStmt)body.elementAt(0);
        if (lblStmt.stmts == null || lblStmt.stmts.size() == 0) {
            return;
        }
        if (lblStmt.stmts.size() > 1 || !lblStmt.stmts.elementAt(0).getClass().equals(AST.WhileObj.getClass())) {
            omitPC = false;
            omitStutteringWhenDone = false;
            return;
        }
        AST.While whileStmt = (AST.While)lblStmt.stmts.elementAt(0);
        Vector tokens = whileStmt.test.tokens;
        if (tokens.size() != 1) {
            omitPC = false;
            omitStutteringWhenDone = false;
            return;
        }
        Vector line = (Vector)tokens.elementAt(0);
        if (line.size() != 1) {
            omitPC = false;
            omitStutteringWhenDone = false;
            return;
        }
        TLAToken tok = (TLAToken)line.elementAt(0);
        if (!tok.string.equals("TRUE")) {
            omitPC = false;
            omitStutteringWhenDone = false;
            return;
        }
        if (whileStmt.labDo != null && whileStmt.labDo.size() > 0) {
            omitPC = false;
        }
        if (whileStmt.unlabDo == null) {
            return;
        }
        for (int i = 0; i < whileStmt.unlabDo.size(); ++i) {
            Object obj = whileStmt.unlabDo.elementAt(i);
            if (!obj.getClass().equals(AST.LabelIfObj.getClass()) && !obj.getClass().equals(AST.LabelEitherObj.getClass()) && !obj.getClass().equals(AST.LabeledStmtObj.getClass())) continue;
            omitPC = false;
            return;
        }
    }

    public static void AddedMessagesError() throws ParseAlgorithmException {
        String msg = null;
        msg = addedLabels.size() > 1 ? "Missing labels at the following locations:" : "Missing label at the following location:";
        for (int i = 0; i < addedLabels.size(); ++i) {
            msg = msg + "\n     " + (String)addedLabelsLocs.elementAt(i);
        }
        throw new ParseAlgorithmException(msg);
    }

    public static void ReportLabels() {
        if (addedLabels.size() > 1) {
            PcalDebug.reportInfo("The following labels were added:");
        } else {
            PcalDebug.reportInfo("The following label was added:");
        }
        for (int i = 0; i < addedLabels.size(); ++i) {
            PcalDebug.reportInfo("  " + (String)addedLabels.elementAt(i) + " at " + (String)addedLabelsLocs.elementAt(i));
        }
    }

    public static AST.Procedure GetProcedure() throws ParseAlgorithmException {
        AST.Procedure result = new AST.Procedure();
        ParseAlgorithm.GobbleThis("procedure");
        PCalLocation beginLoc = ParseAlgorithm.GetLastLocationStart();
        result.col = lastTokCol;
        result.line = lastTokLine;
        currentProcedure = result.name = ParseAlgorithm.GetAlgToken();
        plusLabels = new Vector(0);
        minusLabels = new Vector(0);
        proceduresCalled = new Vector(0);
        ParseAlgorithm.GobbleThis("(");
        result.params = new Vector();
        boolean lookForComma = false;
        while (!ParseAlgorithm.PeekAtAlgToken(1).equals(")")) {
            if (lookForComma) {
                ParseAlgorithm.GobbleThis(",");
            }
            result.params.addElement(ParseAlgorithm.GetPVarDecl());
            lookForComma = true;
        }
        ParseAlgorithm.MustGobbleThis(")");
        result.decls = ParseAlgorithm.PeekAtAlgToken(1).equals("begin") || ParseAlgorithm.PeekAtAlgToken(1).equals("{") ? new Vector(1) : ParseAlgorithm.GetPVarDecls();
        ParseAlgorithm.GobbleBeginOrLeftBrace();
        result.body = ParseAlgorithm.GetStmtSeq();
        ParseAlgorithm.GobbleEndOrRightBrace("procedure");
        PCalLocation endLoc = ParseAlgorithm.GetLastLocationEnd();
        if (ParseAlgorithm.PeekAtAlgToken(1).equals(";")) {
            String tok = ParseAlgorithm.GetAlgToken();
        }
        currentProcedure = null;
        result.plusLabels = plusLabels;
        result.minusLabels = minusLabels;
        result.proceduresCalled = proceduresCalled;
        result.setOrigin(new Region(beginLoc, endLoc));
        return result;
    }

    public static AST.Process GetProcess() throws ParseAlgorithmException {
        AST.Process result = new AST.Process();
        ParseAlgorithm.GobbleThis("process");
        PCalLocation beginLoc = ParseAlgorithm.GetLastLocationStart();
        result.col = lastTokCol;
        result.line = lastTokLine;
        if (cSyntax) {
            ParseAlgorithm.GobbleThis("(");
        }
        result.name = ParseAlgorithm.GetAlgToken();
        result.isEq = ParseAlgorithm.GobbleEqualOrIf();
        result.id = ParseAlgorithm.GetExpr();
        plusLabels = new Vector(0);
        minusLabels = new Vector(0);
        proceduresCalled = new Vector(0);
        if (cSyntax) {
            ParseAlgorithm.GobbleThis(")");
        }
        if (result.id.tokens.size() == 0) {
            ParseAlgorithm.ParsingError("Empty process id at ");
        }
        result.decls = ParseAlgorithm.PeekAtAlgToken(1).equals("begin") || ParseAlgorithm.PeekAtAlgToken(1).equals("{") ? new Vector(1) : ParseAlgorithm.GetVarDecls();
        ParseAlgorithm.GobbleBeginOrLeftBrace();
        result.body = ParseAlgorithm.GetStmtSeq();
        ParseAlgorithm.GobbleEndOrRightBrace("process");
        PCalLocation endLoc = ParseAlgorithm.GetLastLocationEnd();
        if (ParseAlgorithm.PeekAtAlgToken(1).equals(";")) {
            String string = ParseAlgorithm.GetAlgToken();
        }
        result.plusLabels = plusLabels;
        result.minusLabels = minusLabels;
        result.proceduresCalled = proceduresCalled;
        result.setOrigin(new Region(beginLoc, endLoc));
        return result;
    }

    public static Vector GetPVarDecls() throws ParseAlgorithmException {
        String tok = ParseAlgorithm.PeekAtAlgToken(1);
        if (tok.equals("variables")) {
            ParseAlgorithm.MustGobbleThis("variables");
        } else {
            ParseAlgorithm.GobbleThis("variable");
        }
        Vector<AST.PVarDecl> result = new Vector<AST.PVarDecl>();
        while (!ParseAlgorithm.PeekAtAlgToken(1).equals("begin") && !ParseAlgorithm.PeekAtAlgToken(1).equals("{")) {
            result.addElement(ParseAlgorithm.GetPVarDecl());
            ParseAlgorithm.GobbleCommaOrSemicolon();
        }
        return result;
    }

    public static AST.PVarDecl GetPVarDecl() throws ParseAlgorithmException {
        AST.PVarDecl pv = new AST.PVarDecl();
        pv.var = ParseAlgorithm.GetAlgToken();
        PCalLocation beginLoc = ParseAlgorithm.GetLastLocationStart();
        PCalLocation endLoc = ParseAlgorithm.GetLastLocationEnd();
        pv.col = lastTokCol;
        pv.line = lastTokLine;
        if (ParseAlgorithm.PeekAtAlgToken(1).equals("=")) {
            ParseAlgorithm.GobbleThis("=");
            pv.val = ParseAlgorithm.GetExpr();
            endLoc = pv.val.getOrigin().getEnd();
            if (pv.val.tokens.size() == 0) {
                ParseAlgorithm.ParsingError("Missing expression at ");
            }
        } else {
            hasDefaultInitialization = true;
        }
        pv.setOrigin(new Region(beginLoc, endLoc));
        return pv;
    }

    public static Vector GetVarDecls() throws ParseAlgorithmException {
        String tok = ParseAlgorithm.PeekAtAlgToken(1);
        if (tok.equals("variables")) {
            ParseAlgorithm.MustGobbleThis("variables");
        } else {
            ParseAlgorithm.GobbleThis("variable");
        }
        Vector<AST.VarDecl> result = new Vector<AST.VarDecl>();
        while (!(ParseAlgorithm.PeekAtAlgToken(1).equals("begin") || ParseAlgorithm.PeekAtAlgToken(1).equals("{") || ParseAlgorithm.PeekAtAlgToken(1).equals("procedure") || ParseAlgorithm.PeekAtAlgToken(1).equals("process") || ParseAlgorithm.PeekAtAlgToken(1).equals("fair") || ParseAlgorithm.PeekAtAlgToken(1).equals("define") || ParseAlgorithm.PeekAtAlgToken(1).equals("macro"))) {
            result.addElement(ParseAlgorithm.GetVarDecl());
        }
        return result;
    }

    public static AST.VarDecl GetVarDecl() throws ParseAlgorithmException {
        AST.VarDecl pv = new AST.VarDecl();
        pv.var = ParseAlgorithm.GetAlgToken();
        PCalLocation beginLoc = ParseAlgorithm.GetLastLocationStart();
        PCalLocation endLoc = ParseAlgorithm.GetLastLocationEnd();
        pv.col = lastTokCol;
        pv.line = lastTokLine;
        if (ParseAlgorithm.PeekAtAlgToken(1).equals("=") || ParseAlgorithm.PeekAtAlgToken(1).equals("\\in")) {
            pv.isEq = ParseAlgorithm.GobbleEqualOrIf();
            pv.val = ParseAlgorithm.GetExpr();
            endLoc = pv.val.getOrigin().getEnd();
            if (pv.val.tokens.size() == 0) {
                ParseAlgorithm.ParsingError("Missing expression at ");
            }
        } else {
            hasDefaultInitialization = true;
        }
        ParseAlgorithm.GobbleCommaOrSemicolon();
        pv.setOrigin(new Region(beginLoc, endLoc));
        return pv;
    }

    public static TLAExpr GetExpr() throws ParseAlgorithmException {
        TLAExpr result;
        if (LATsize != 0) {
            PcalDebug.ReportBug("ParseAlgorithm: GetExpr called after lookahead");
        }
        try {
            result = Tokenize.TokenizeExpr(charReader);
        }
        catch (TokenizerException e) {
            throw new ParseAlgorithmException(e.getMessage());
        }
        ParseAlgorithm.LAT[ParseAlgorithm.LATsize] = Tokenize.Delimiter;
        ParseAlgorithm.curTokCol[ParseAlgorithm.LATsize] = Tokenize.DelimiterCol;
        ParseAlgorithm.curTokLine[ParseAlgorithm.LATsize] = Tokenize.DelimiterLine;
        ++LATsize;
        if (result.tokens != null && result.tokens.size() != 0) {
            PCalLocation begin = ((TLAToken)((Vector)result.tokens.elementAt((int)0)).elementAt((int)0)).source.getBegin();
            Vector lastLineOfTokens = (Vector)result.tokens.elementAt(result.tokens.size() - 1);
            if (lastLineOfTokens.size() == 0) {
                Debug.ReportBug("Unexpected Event in ParseAlgorithm.GetExpr");
            }
            PCalLocation end = ((TLAToken)lastLineOfTokens.elementAt((int)(lastLineOfTokens.size() - 1))).source.getEnd();
            result.setOrigin(new Region(begin, end));
        } else {
            result.setOrigin(null);
        }
        return result;
    }

    public static Vector ObsoleteGetLabeledStmtSeq() throws ParseAlgorithmException {
        Vector<AST.LabeledStmt> result = new Vector<AST.LabeledStmt>();
        while (ParseAlgorithm.IsLabelNext()) {
            result.addElement(ParseAlgorithm.ObsoleteGetLabeledStmt());
        }
        return result;
    }

    public static AST.LabeledStmt ObsoleteGetLabeledStmt() throws ParseAlgorithmException {
        if (!ParseAlgorithm.IsLabelNext()) {
            ParseAlgorithm.ParsingError("Was expecting a label");
        }
        AST.LabeledStmt result = new AST.LabeledStmt();
        result.label = ParseAlgorithm.GetAlgToken();
        if (result.label.equals("Done")) {
            ParseAlgorithm.ParsingError("Cannot use `Done' as a label.");
        }
        if (result.label.equals("Error")) {
            ParseAlgorithm.ParsingError("Cannot use `Error' as a label.");
        }
        result.col = lastTokCol;
        result.line = lastTokLine;
        result.stmts = new Vector();
        ParseAlgorithm.GobbleThis(":");
        Object whileStmt = null;
        if (ParseAlgorithm.PeekAtAlgToken(1).equals("while")) {
            result.stmts.addElement(ParseAlgorithm.GetWhile());
        }
        Vector stmtSeq = ParseAlgorithm.GetStmtSeq();
        for (int i = 0; i < stmtSeq.size(); ++i) {
            result.stmts.addElement(stmtSeq.elementAt(i));
        }
        if (result.stmts.size() == 0) {
            ParseAlgorithm.ParsingError("Label with no following statement");
        }
        return result;
    }

    public static AST.While GetWhile() throws ParseAlgorithmException {
        ParseAlgorithm.MustGobbleThis("while");
        PCalLocation beginLoc = ParseAlgorithm.GetLastLocationStart();
        AST.While result = new AST.While();
        result.col = lastTokCol;
        result.line = lastTokLine;
        if (cSyntax) {
            ParseAlgorithm.GobbleThis("(");
        }
        result.test = ParseAlgorithm.GetExpr();
        if (cSyntax) {
            ParseAlgorithm.GobbleThis(")");
        }
        if (result.test.tokens.size() == 0) {
            ParseAlgorithm.ParsingError("Empty while test at ");
        }
        if (pSyntax) {
            ParseAlgorithm.GobbleThis("do");
            result.unlabDo = ParseAlgorithm.GetStmtSeq();
            ParseAlgorithm.GobbleThis("end");
            ParseAlgorithm.GobbleThis("while");
            ParseAlgorithm.GobbleThis(";");
        } else {
            result.unlabDo = ParseAlgorithm.GetCStmt();
        }
        result.labDo = new Vector();
        result.setOrigin(new Region(beginLoc, ((AST)result.unlabDo.elementAt(result.unlabDo.size() - 1)).getOrigin().getEnd()));
        return result;
    }

    public static String GetLabel() throws ParseAlgorithmException {
        String nextLabel = "";
        if (ParseAlgorithm.IsLabelNext()) {
            nextLabel = ParseAlgorithm.GetAlgToken();
            getLabelLocation = new PCalLocation(lastTokLine - 1, lastTokCol - 1);
            if (inGetMacro) {
                ParseAlgorithm.ParsingError("A label may not appear in a macro.");
            }
            if (nextLabel.equals("Done")) {
                ParseAlgorithm.ParsingError("Cannot use `Done' as a label.");
            }
            if (nextLabel.equals("Error")) {
                ParseAlgorithm.ParsingError("Cannot use `Error' as a label.");
            }
            ParseAlgorithm.GobbleThis(":");
            hasLabel = true;
            allLabels.put(nextLabel, "");
            if (ParseAlgorithm.PeekAtAlgToken(1).equals("+")) {
                ParseAlgorithm.GobbleThis("+");
                plusLabels.addElement(nextLabel);
                omitPC = false;
            } else if (ParseAlgorithm.PeekAtAlgToken(1).equals("-")) {
                ParseAlgorithm.GobbleThis("-");
                minusLabels.addElement(nextLabel);
                omitPC = false;
            }
        }
        return nextLabel;
    }

    public static Vector GetStmtSeq() throws ParseAlgorithmException {
        Vector<AST> result = new Vector<AST>();
        String tok = ParseAlgorithm.PeekAtAlgToken(1);
        while (!(pSyntax && (tok.equals("end") || tok.equals("else") || tok.equals("elsif") || tok.equals("or")) || cSyntax && tok.equals("}"))) {
            String nextLabel = ParseAlgorithm.GetLabel();
            PCalLocation labelLoc = getLabelLocation;
            if (cSyntax && ParseAlgorithm.PeekAtAlgToken(1).equals("{")) {
                result.addAll(ParseAlgorithm.GetCStmtSeq(nextLabel));
            } else {
                AST stmt = ParseAlgorithm.GetStmt();
                stmt.lbl = nextLabel;
                stmt.lblLocation = labelLoc;
                result.addElement(stmt);
            }
            tok = ParseAlgorithm.PeekAtAlgToken(1);
        }
        if (cSyntax && result.size() == 0) {
            ParseAlgorithm.ParsingError("Empty statement list");
        }
        return result;
    }

    public static AST GetStmt() throws ParseAlgorithmException {
        String nextTok = ParseAlgorithm.PeekAtAlgToken(1);
        if (nextTok.equals("if")) {
            return ParseAlgorithm.GetIf(0);
        }
        if (nextTok.equals("either")) {
            return ParseAlgorithm.GetEither();
        }
        if (nextTok.equals("with")) {
            return ParseAlgorithm.GetWith(0);
        }
        if (nextTok.equals("when")) {
            return ParseAlgorithm.GetWhen(true);
        }
        if (nextTok.equals("await")) {
            return ParseAlgorithm.GetWhen(false);
        }
        if (nextTok.equals("print")) {
            return ParseAlgorithm.GetPrintS();
        }
        if (nextTok.equals("assert")) {
            return ParseAlgorithm.GetAssert();
        }
        if (nextTok.equals("skip")) {
            return ParseAlgorithm.GetSkip();
        }
        if (nextTok.equals("call")) {
            return ParseAlgorithm.GetCallOrCallReturn();
        }
        if (nextTok.equals("return")) {
            return ParseAlgorithm.GetReturn();
        }
        if (nextTok.equals("goto")) {
            return ParseAlgorithm.GetGoto();
        }
        if (nextTok.equals("while")) {
            return ParseAlgorithm.GetWhile();
        }
        if (ParseAlgorithm.PeekPastAlgToken(1).charAt(0) == '(') {
            return ParseAlgorithm.GetMacroCall();
        }
        return ParseAlgorithm.GetAssign();
    }

    public static Vector GetCStmtSeq(String lbl) throws ParseAlgorithmException {
        PCalLocation lblLocation = getLabelLocation;
        ParseAlgorithm.MustGobbleThis("{");
        Vector sseq = ParseAlgorithm.GetStmtSeq();
        ParseAlgorithm.GobbleThis("}");
        ParseAlgorithm.GobbleThis(";");
        if (!lbl.equals("")) {
            if (!((AST)sseq.elementAt((int)0)).lbl.equals("")) {
                throw new ParseAlgorithmException("Duplicate labeling of statement", (AST)sseq.elementAt(0));
            }
            AST firstStmt = (AST)sseq.elementAt(0);
            firstStmt.lbl = lbl;
            firstStmt.lblLocation = lblLocation;
        }
        return sseq;
    }

    public static Vector GetCStmt() throws ParseAlgorithmException {
        String label = ParseAlgorithm.GetLabel();
        PCalLocation labelLocation = getLabelLocation;
        if (ParseAlgorithm.PeekAtAlgToken(1).equals("{")) {
            return ParseAlgorithm.GetCStmtSeq(label);
        }
        AST stmt = ParseAlgorithm.GetStmt();
        stmt.lbl = label;
        stmt.lblLocation = labelLocation;
        Vector<AST> result = new Vector<AST>();
        result.addElement(stmt);
        return result;
    }

    public static boolean IsLabelNext() throws ParseAlgorithmException {
        String tok = ParseAlgorithm.PeekAtAlgToken(1);
        if (tok.equals("while") || tok.equals("if") || tok.equals("assert") || tok.equals("print") || tok.equals("else") || tok.equals("elsif") || tok.equals("either") || tok.equals("or") || tok.equals("end") || tok.equals("with") || tok.equals("when") || tok.equals("await") || tok.equals("skip") || tok.equals("call") || tok.equals("return") || tok.equals("goto")) {
            return false;
        }
        tok = charReader.peek();
        return tok.length() != 0 && tok.charAt(0) == ':' && (tok.length() <= 1 || tok.charAt(1) != '=');
    }

    public static AST.LabelIf GetIf(int depth) throws ParseAlgorithmException {
        if (depth == 0) {
            ParseAlgorithm.MustGobbleThis("if");
        } else {
            ParseAlgorithm.MustGobbleThis("elsif");
        }
        PCalLocation beginLoc = ParseAlgorithm.GetLastLocationStart();
        AST.LabelIf result = new AST.LabelIf();
        result.col = lastTokCol;
        result.line = lastTokLine;
        if (cSyntax) {
            ParseAlgorithm.GobbleThis("(");
        }
        result.test = ParseAlgorithm.GetExpr();
        if (cSyntax) {
            ParseAlgorithm.GobbleThis(")");
        }
        if (result.test.tokens.size() == 0) {
            ParseAlgorithm.ParsingError("Empty if test at ");
        }
        if (pSyntax) {
            ParseAlgorithm.GobbleThis("then");
            result.unlabThen = ParseAlgorithm.GetStmtSeq();
        } else {
            result.unlabThen = ParseAlgorithm.GetCStmt();
        }
        String nextTok = ParseAlgorithm.PeekAtAlgToken(1);
        if (pSyntax) {
            if (nextTok.equals("else")) {
                ParseAlgorithm.MustGobbleThis("else");
                result.unlabElse = ParseAlgorithm.GetStmtSeq();
            } else if (nextTok.equals("elsif")) {
                AST.LabelIf innerIf = ParseAlgorithm.GetIf(depth + 1);
                result.unlabElse = new Vector();
                result.unlabElse.addElement(innerIf);
            } else if (nextTok.equals("end")) {
                result.unlabElse = new Vector();
            } else {
                ParseAlgorithm.ParsingError("Expecting \"else\", \"elsif\", or \"end\"");
            }
            if (depth == 0) {
                ParseAlgorithm.GobbleThis("end");
                ParseAlgorithm.GobbleThis("if");
                ParseAlgorithm.GobbleThis(";");
            }
        } else if (nextTok.equals("else")) {
            ParseAlgorithm.MustGobbleThis("else");
            result.unlabElse = ParseAlgorithm.GetCStmt();
        } else {
            result.unlabElse = new Vector();
        }
        result.labThen = new Vector();
        result.labElse = new Vector();
        AST lastStmt = null;
        lastStmt = result.unlabElse.size() != 0 ? (AST)result.unlabElse.elementAt(result.unlabElse.size() - 1) : (AST)result.unlabThen.elementAt(result.unlabThen.size() - 1);
        result.setOrigin(new Region(beginLoc, lastStmt.getOrigin().getEnd()));
        return result;
    }

    public static AST.LabelEither GetEither() throws ParseAlgorithmException {
        ParseAlgorithm.MustGobbleThis("either");
        PCalLocation beginLoc = ParseAlgorithm.GetLastLocationStart();
        AST.LabelEither result = new AST.LabelEither();
        result.col = lastTokCol;
        result.line = lastTokLine;
        result.clauses = new Vector();
        boolean done = false;
        boolean hasOr = false;
        while (!done) {
            AST.Clause nextClause = new AST.Clause();
            nextClause.labOr = new Vector();
            nextClause.unlabOr = pSyntax ? ParseAlgorithm.GetStmtSeq() : ParseAlgorithm.GetCStmt();
            if (nextClause.unlabOr.size() == 0) {
                throw new ParseAlgorithmException("`either' statement with empty `or' clause", result);
            }
            nextClause.setOrigin(new Region(((AST)nextClause.unlabOr.elementAt(0)).getOrigin().getBegin(), ((AST)nextClause.unlabOr.elementAt(nextClause.unlabOr.size() - 1)).getOrigin().getEnd()));
            result.clauses.addElement(nextClause);
            String nextTok = ParseAlgorithm.PeekAtAlgToken(1);
            if (nextTok.equals("or")) {
                ParseAlgorithm.MustGobbleThis("or");
                hasOr = true;
                continue;
            }
            done = true;
        }
        if (pSyntax) {
            ParseAlgorithm.MustGobbleThis("end");
            ParseAlgorithm.GobbleThis("either");
            ParseAlgorithm.GobbleThis(";");
        }
        if (!hasOr) {
            throw new ParseAlgorithmException("`either' statement has no `or'", result);
        }
        result.setOrigin(new Region(beginLoc, ((AST)result.clauses.elementAt(result.clauses.size() - 1)).getOrigin().getEnd()));
        return result;
    }

    public static AST GetWith(int depth) throws ParseAlgorithmException {
        return ParseAlgorithm.InnerGetWith(depth, null);
    }

    public static AST InnerGetWith(int depth, PCalLocation beginLoc) throws ParseAlgorithmException {
        PCalLocation begLoc = beginLoc;
        if (depth == 0) {
            ParseAlgorithm.GobbleThis("with");
            begLoc = ParseAlgorithm.GetLastLocationStart();
            if (cSyntax) {
                ParseAlgorithm.GobbleThis("(");
            }
        }
        AST.With result = new AST.With();
        result.col = lastTokCol;
        result.line = lastTokLine;
        result.var = ParseAlgorithm.GetAlgToken();
        result.isEq = ParseAlgorithm.GobbleEqualOrIf();
        result.exp = ParseAlgorithm.GetExpr();
        if (pSyntax || !ParseAlgorithm.PeekAtAlgToken(1).equals(")")) {
            ParseAlgorithm.GobbleCommaOrSemicolon();
        }
        if (result.exp.tokens.size() == 0) {
            ParseAlgorithm.ParsingError("Empty with expression at ");
        }
        if (pSyntax && ParseAlgorithm.PeekAtAlgToken(1).equals("do")) {
            ParseAlgorithm.GobbleThis("do");
            result.Do = ParseAlgorithm.GetStmtSeq();
            ParseAlgorithm.GobbleThis("end");
            ParseAlgorithm.GobbleThis("with");
            ParseAlgorithm.GobbleThis(";");
        } else if (cSyntax && ParseAlgorithm.PeekAtAlgToken(1).equals(")")) {
            ParseAlgorithm.MustGobbleThis(")");
            result.Do = ParseAlgorithm.GetCStmt();
        } else {
            result.Do = new Vector();
            result.Do.addElement(ParseAlgorithm.InnerGetWith(depth + 1, begLoc));
        }
        result.setOrigin(new Region(begLoc, ((AST)result.Do.elementAt(result.Do.size() - 1)).getOrigin().getEnd()));
        return result;
    }

    public static AST.Assign GetAssign() throws ParseAlgorithmException {
        AST.Assign result = new AST.Assign();
        result.col = curTokCol[0] + 1;
        result.line = curTokLine[0] + 1;
        result.ass = new Vector();
        result.ass.addElement(ParseAlgorithm.GetSingleAssign());
        while (ParseAlgorithm.PeekAtAlgToken(1).equals("||")) {
            String throwAway = ParseAlgorithm.GetAlgToken();
            try {
                result.ass.addElement(ParseAlgorithm.GetSingleAssign());
            }
            catch (ParseAlgorithmException e) {
                ParseAlgorithm.ParsingError("Bad assignment statement at ");
            }
        }
        ParseAlgorithm.GobbleThis(";");
        AST firstAssign = (AST)result.ass.elementAt(0);
        AST lastAssign = (AST)result.ass.elementAt(result.ass.size() - 1);
        result.setOrigin(new Region(firstAssign.getOrigin().getBegin(), lastAssign.getOrigin().getEnd()));
        return result;
    }

    public static AST.SingleAssign GetSingleAssign() throws ParseAlgorithmException {
        AST.SingleAssign result = new AST.SingleAssign();
        result.col = curTokCol[0] + 1;
        result.line = curTokLine[0] + 1;
        result.lhs = ParseAlgorithm.GetLhs();
        ParseAlgorithm.GobbleThis(":=");
        result.rhs = ParseAlgorithm.GetExpr();
        if (result.rhs.tokens.size() == 0) {
            ParseAlgorithm.ParsingError("Empty right-hand side of assignment at ");
        }
        result.setOrigin(new Region(result.lhs.getOrigin().getBegin(), result.rhs.getOrigin().getEnd()));
        return result;
    }

    public static AST.Lhs GetLhs() throws ParseAlgorithmException {
        AST.Lhs result = new AST.Lhs();
        result.col = curTokCol[0] + 1;
        result.line = curTokLine[0] + 1;
        PCalLocation beginLoc = null;
        PCalLocation endLoc = null;
        try {
            result.var = ParseAlgorithm.GetAlgToken();
            beginLoc = ParseAlgorithm.GetLastLocationStart();
            endLoc = ParseAlgorithm.GetLastLocationEnd();
            result.sub = ParseAlgorithm.GetExpr();
        }
        catch (ParseAlgorithmException e) {
            throw new ParseAlgorithmException(e.getMessage());
        }
        if (result.sub.getOrigin() != null) {
            endLoc = result.sub.getOrigin().getEnd();
        }
        result.setOrigin(new Region(beginLoc, endLoc));
        return result;
    }

    public static AST.PrintS GetPrintS() throws ParseAlgorithmException {
        ParseAlgorithm.MustGobbleThis("print");
        PCalLocation beginLoc = ParseAlgorithm.GetLastLocationStart();
        AST.PrintS result = new AST.PrintS();
        result.col = lastTokCol;
        result.line = lastTokLine;
        result.exp = ParseAlgorithm.GetExpr();
        if (result.exp.tokens.size() == 0) {
            ParseAlgorithm.ParsingError("Empty expression in print statement at ");
        }
        result.setOrigin(new Region(beginLoc, result.exp.getOrigin().getEnd()));
        ParseAlgorithm.GobbleThis(";");
        return result;
    }

    public static AST.Assert GetAssert() throws ParseAlgorithmException {
        AST.Assert result = new AST.Assert();
        ParseAlgorithm.MustGobbleThis("assert");
        result.col = lastTokCol;
        result.line = lastTokLine;
        result.exp = ParseAlgorithm.GetExpr();
        if (result.exp.tokens.size() == 0) {
            ParseAlgorithm.ParsingError("Empty expression in assert statement at ");
        }
        ParseAlgorithm.GobbleThis(";");
        result.setOrigin(new Region(new PCalLocation(result.line - 1, result.col - 1), result.exp.getOrigin().getEnd()));
        return result;
    }

    public static AST.Skip GetSkip() throws ParseAlgorithmException {
        AST.Skip result = new AST.Skip();
        ParseAlgorithm.MustGobbleThis("skip");
        result.col = lastTokCol;
        result.line = lastTokLine;
        result.setOrigin(new Region(lastTokLine - 1, lastTokCol - 1, 4));
        ParseAlgorithm.GobbleThis(";");
        return result;
    }

    public static AST.When GetWhen(boolean isWhen) throws ParseAlgorithmException {
        AST.When result = new AST.When();
        if (isWhen) {
            ParseAlgorithm.MustGobbleThis("when");
        } else {
            ParseAlgorithm.MustGobbleThis("await");
        }
        result.col = lastTokCol;
        result.line = lastTokLine;
        result.exp = ParseAlgorithm.GetExpr();
        result.setOrigin(new Region(new PCalLocation(result.line - 1, result.col - 1), result.exp.getOrigin().getEnd()));
        if (result.exp.tokens.size() == 0) {
            ParseAlgorithm.ParsingError("Empty expression in when statement at ");
        }
        ParseAlgorithm.GobbleThis(";");
        return result;
    }

    public static AST.Call GetCall() throws ParseAlgorithmException {
        int i;
        boolean moreArgs;
        ParseAlgorithm.MustGobbleThis("call");
        AST.Call result = new AST.Call();
        result.col = lastTokCol;
        result.line = lastTokLine;
        result.to = ParseAlgorithm.GetAlgToken();
        ParseAlgorithm.GobbleThis("(");
        result.args = new Vector();
        boolean bl = moreArgs = ParseAlgorithm.PeekPastAlgToken(0).charAt(0) != ')';
        while (moreArgs) {
            result.args.addElement(ParseAlgorithm.GetExpr());
            if (((TLAExpr)result.args.lastElement()).tokens.size() == 0) {
                ParseAlgorithm.ParsingError("Empty argument in call statement at ");
            }
            if (!ParseAlgorithm.PeekAtAlgToken(1).equals(")")) {
                ParseAlgorithm.GobbleThis(",");
                continue;
            }
            moreArgs = false;
        }
        ParseAlgorithm.GobbleThis(")");
        result.setOrigin(new Region(new PCalLocation(result.line - 1, result.col - 1), new PCalLocation(lastTokLine - 1, lastTokCol)));
        ParseAlgorithm.GobbleThis(";");
        for (i = 0; i < proceduresCalled.size() && !result.to.equals(proceduresCalled.elementAt(i)); ++i) {
        }
        if (i == proceduresCalled.size()) {
            proceduresCalled.addElement(result.to);
        }
        return result;
    }

    public static AST.Return GetReturn() throws ParseAlgorithmException {
        AST.Return result = new AST.Return();
        ParseAlgorithm.MustGobbleThis("return");
        result.setOrigin(new Region(ParseAlgorithm.GetLastLocationStart(), ParseAlgorithm.GetLastLocationEnd()));
        result.col = lastTokCol;
        result.line = lastTokLine;
        result.from = currentProcedure;
        result.setOrigin(new Region(lastTokLine - 1, lastTokCol - 1, 6));
        ParseAlgorithm.GobbleThis(";");
        return result;
    }

    public static AST GetCallOrCallReturn() throws ParseAlgorithmException {
        AST.Call theCall = ParseAlgorithm.GetCall();
        if (ParseAlgorithm.PeekAtAlgToken(1).equals("return")) {
            ParseAlgorithm.MustGobbleThis("return");
            PCalLocation end = new PCalLocation(lastTokLine - 1, lastTokCol + 5);
            ParseAlgorithm.GobbleThis(";");
            AST.CallReturn result = new AST.CallReturn();
            result.col = theCall.col;
            result.line = theCall.line;
            result.to = theCall.to;
            result.from = currentProcedure;
            result.args = theCall.args;
            result.setOrigin(new Region(theCall.getOrigin().getBegin(), end));
            return result;
        }
        return theCall;
    }

    public static AST.Goto GetGoto() throws ParseAlgorithmException {
        ParseAlgorithm.MustGobbleThis("goto");
        AST.Goto result = new AST.Goto();
        result.col = lastTokCol;
        result.line = lastTokLine;
        result.to = ParseAlgorithm.GetAlgToken();
        result.setOrigin(new Region(new PCalLocation(result.line - 1, result.col - 1), new PCalLocation(lastTokLine - 1, lastTokCol - 1 + result.to.length())));
        gotoUsed = true;
        if (result.to.equals("Done") || result.to.equals("\"Done\"")) {
            gotoDoneUsed = true;
        }
        ParseAlgorithm.GobbleThis(";");
        return result;
    }

    public static AST.Macro GetMacro(Vector macros) throws ParseAlgorithmException {
        AST.Macro result = new AST.Macro();
        inGetMacro = true;
        ParseAlgorithm.MustGobbleThis("macro");
        PCalLocation beginLoc = ParseAlgorithm.GetLastLocationStart();
        result.col = lastTokCol;
        result.line = lastTokLine;
        result.name = ParseAlgorithm.GetAlgToken();
        ParseAlgorithm.GobbleThis("(");
        result.params = new Vector();
        boolean lookForComma = false;
        while (!ParseAlgorithm.PeekAtAlgToken(1).equals(")")) {
            if (lookForComma) {
                ParseAlgorithm.GobbleThis(",");
            }
            result.params.addElement(ParseAlgorithm.GetAlgToken());
            lookForComma = true;
        }
        ParseAlgorithm.MustGobbleThis(")");
        ParseAlgorithm.GobbleBeginOrLeftBrace();
        result.body = ParseAlgorithm.GetStmtSeq();
        ParseAlgorithm.GobbleEndOrRightBrace("macro");
        result.setOrigin(new Region(beginLoc, ParseAlgorithm.GetLastLocationEnd()));
        if (ParseAlgorithm.PeekAtAlgToken(1).equals(";")) {
            String tok = ParseAlgorithm.GetAlgToken();
        }
        ParseAlgorithm.ExpandMacrosInStmtSeq(result.body, macros);
        inGetMacro = false;
        return result;
    }

    public static AST.MacroCall GetMacroCall() throws ParseAlgorithmException {
        boolean moreArgs;
        AST.MacroCall result = new AST.MacroCall();
        result.name = ParseAlgorithm.GetAlgToken();
        PCalLocation beginLoc = ParseAlgorithm.GetLastLocationStart();
        result.col = lastTokCol;
        result.line = lastTokLine;
        ParseAlgorithm.MustGobbleThis("(");
        result.args = new Vector();
        boolean bl = moreArgs = ParseAlgorithm.PeekPastAlgToken(0).charAt(0) != ')';
        while (moreArgs) {
            result.args.addElement(ParseAlgorithm.GetExpr());
            if (((TLAExpr)result.args.lastElement()).tokens.size() == 0) {
                ParseAlgorithm.ParsingError("Empty argument in call statement at ");
            }
            if (!ParseAlgorithm.PeekAtAlgToken(1).equals(")")) {
                ParseAlgorithm.GobbleThis(",");
                continue;
            }
            moreArgs = false;
        }
        ParseAlgorithm.GobbleThis(")");
        result.setOrigin(new Region(beginLoc, ParseAlgorithm.GetLastLocationEnd()));
        ParseAlgorithm.GobbleThis(";");
        return result;
    }

    public static void AddLabelsToStmtSeq(Vector stmtseq) throws ParseAlgorithmException {
        ParseAlgorithm.InnerAddLabels(stmtseq, true, false, new Vector(), new Vector());
    }

    public static boolean InnerAddLabels(Vector stmtseq, boolean firstLabeled, boolean inWith, Vector inAssigned, Vector outAssigned) throws ParseAlgorithmException {
        ParseAlgorithm.Copy(inAssigned, outAssigned);
        boolean nextStepNeedsLabel = firstLabeled;
        boolean hadOrAddedLabel = false;
        for (int i = 0; i < stmtseq.size(); ++i) {
            AST obj;
            AST stmt = (AST)stmtseq.elementAt(i);
            if (!stmt.lbl.equals("")) {
                hadOrAddedLabel = true;
                outAssigned.removeAllElements();
                if (inWith) {
                    throw new ParseAlgorithmException("Label in `with' statement", stmt);
                }
            }
            if (nextStepNeedsLabel) {
                if (inWith) {
                    throw new ParseAlgorithmException("Statement follows `call' or `return' inside a `with' statement.", stmt);
                }
                ParseAlgorithm.NeedsLabel((AST)stmtseq.elementAt(i));
                nextStepNeedsLabel = false;
                hadOrAddedLabel = true;
                outAssigned.removeAllElements();
            }
            if (stmt.getClass().equals(AST.LabelIfObj.getClass())) {
                obj = (AST.LabelIf)stmt;
                Vector thenAssigned = new Vector();
                Vector elseAssigned = new Vector();
                nextStepNeedsLabel = ParseAlgorithm.InnerAddLabels(obj.unlabThen, false, inWith, outAssigned, thenAssigned);
                nextStepNeedsLabel = ParseAlgorithm.InnerAddLabels(obj.unlabElse, false, inWith, outAssigned, elseAssigned) || nextStepNeedsLabel;
                ParseAlgorithm.Copy(ParseAlgorithm.Union(thenAssigned, elseAssigned), outAssigned);
                continue;
            }
            if (stmt.getClass().equals(AST.LabelEitherObj.getClass())) {
                obj = (AST.LabelEither)stmt;
                Vector newOutAssigned = new Vector();
                Vector newOutWithAssigned = new Vector();
                for (int j = 0; j < ((AST.LabelEither)obj).clauses.size(); ++j) {
                    AST.Clause clause = (AST.Clause)((AST.LabelEither)obj).clauses.elementAt(j);
                    Vector orAssigned = new Vector();
                    Vector orWithAssigned = new Vector();
                    nextStepNeedsLabel = ParseAlgorithm.InnerAddLabels(clause.unlabOr, false, inWith, outAssigned, orAssigned) || nextStepNeedsLabel;
                    ParseAlgorithm.Copy(ParseAlgorithm.Union(orAssigned, newOutAssigned), newOutAssigned);
                }
                ParseAlgorithm.Copy(newOutAssigned, outAssigned);
                continue;
            }
            if (stmt.getClass().equals(AST.WhileObj.getClass())) {
                obj = (AST.While)stmt;
                if (inWith) {
                    throw new ParseAlgorithmException("`while' inside a `with' statement", stmt);
                }
                ParseAlgorithm.NeedsLabel(stmt);
                hadOrAddedLabel = true;
                outAssigned.removeAllElements();
                Vector newOutAssigned = new Vector();
                ParseAlgorithm.InnerAddLabels(((AST.While)obj).unlabDo, false, false, outAssigned, newOutAssigned);
                nextStepNeedsLabel = false;
                continue;
            }
            if (stmt.getClass().equals(AST.WithObj.getClass())) {
                obj = (AST.With)stmt;
                Vector newInAssigned = new Vector();
                if (inWith) {
                    ParseAlgorithm.Copy(inAssigned, newInAssigned);
                }
                Vector newOutAssigned = new Vector();
                nextStepNeedsLabel = ParseAlgorithm.InnerAddLabels(((AST.With)obj).Do, false, true, newInAssigned, newOutAssigned);
                ParseAlgorithm.Copy(newOutAssigned, outAssigned);
                if (inWith || ParseAlgorithm.HasEmptyIntersection(inAssigned, outAssigned)) continue;
                ParseAlgorithm.NeedsLabel(stmt);
                hadOrAddedLabel = true;
                outAssigned.removeAllElements();
                continue;
            }
            if (stmt.getClass().equals(AST.AssignObj.getClass())) {
                obj = (AST.Assign)stmt;
                Vector<String> assignedVbls = new Vector<String>();
                for (int j = 0; j < ((AST.Assign)obj).ass.size(); ++j) {
                    AST.SingleAssign assgn = (AST.SingleAssign)((AST.Assign)obj).ass.elementAt(j);
                    String vbl = assgn.lhs.var;
                    if (ParseAlgorithm.IsIn(vbl, assignedVbls)) continue;
                    assignedVbls.addElement(vbl);
                }
                if (ParseAlgorithm.HasEmptyIntersection(outAssigned, assignedVbls)) {
                    ParseAlgorithm.Copy(ParseAlgorithm.Union(outAssigned, assignedVbls), outAssigned);
                } else {
                    if (inWith) {
                        throw new ParseAlgorithmException("Second assignment to same variable inside a `with' statement", stmt);
                    }
                    ParseAlgorithm.NeedsLabel(stmt);
                    hadOrAddedLabel = true;
                    ParseAlgorithm.Copy(assignedVbls, outAssigned);
                }
                nextStepNeedsLabel = false;
                continue;
            }
            nextStepNeedsLabel = false;
            Vector<String> assignedVbls = new Vector<String>();
            boolean isCallOrReturn = false;
            boolean setsPrcdVbls = false;
            if (stmt.getClass().equals(AST.CallObj.getClass())) {
                AST.Call obj2 = (AST.Call)stmt;
                isCallOrReturn = true;
                if (obj2.to.equals(currentProcedure)) {
                    setsPrcdVbls = true;
                }
            } else if (stmt.getClass().equals(AST.ReturnObj.getClass()) || stmt.getClass().equals(AST.CallReturnObj.getClass())) {
                isCallOrReturn = true;
                setsPrcdVbls = true;
            } else if (stmt.getClass().equals(AST.GotoObj.getClass())) {
                nextStepNeedsLabel = true;
            }
            if (isCallOrReturn) {
                nextStepNeedsLabel = true;
                assignedVbls.addElement("stack");
                if (setsPrcdVbls) {
                    for (int j = 0; j < procedures.size(); ++j) {
                        AST.PVarDecl decl;
                        int k;
                        AST.Procedure prcd = (AST.Procedure)procedures.elementAt(j);
                        for (k = 0; k < prcd.params.size(); ++k) {
                            decl = (AST.PVarDecl)prcd.params.elementAt(k);
                            assignedVbls.addElement(decl.var);
                        }
                        for (k = 0; k < prcd.decls.size(); ++k) {
                            decl = (AST.PVarDecl)prcd.decls.elementAt(k);
                            assignedVbls.addElement(decl.var);
                        }
                    }
                }
            }
            if (ParseAlgorithm.HasEmptyIntersection(outAssigned, assignedVbls)) {
                ParseAlgorithm.Copy(ParseAlgorithm.Union(outAssigned, assignedVbls), outAssigned);
                continue;
            }
            if (inWith) {
                throw new ParseAlgorithmException("Call or return makes second assignment to a variable inside a `with' statement", stmt);
            }
            ParseAlgorithm.NeedsLabel(stmt);
            hadOrAddedLabel = true;
            ParseAlgorithm.Copy(assignedVbls, outAssigned);
        }
        return hadOrAddedLabel || nextStepNeedsLabel;
    }

    public static void NeedsLabel(AST stmt) {
        if (stmt.lbl.equals("")) {
            String lbl = PcalParams.LabelRoot + nextLabelNum;
            ++nextLabelNum;
            while (allLabels.containsKey(lbl)) {
                lbl = PcalParams.LabelRoot + nextLabelNum;
                ++nextLabelNum;
            }
            stmt.lbl = lbl;
            addedLabels.addElement(lbl);
            addedLabelsLocs.addElement(stmt.location());
        }
    }

    public static boolean IsIn(String elt, Vector set) {
        boolean result = false;
        for (int i = 0; i < set.size(); ++i) {
            result = result || elt.equals((String)set.elementAt(i));
        }
        return result;
    }

    public static boolean HasEmptyIntersection(Vector S, Vector T) {
        boolean negResult = false;
        for (int i = 0; i < T.size(); ++i) {
            negResult = negResult || ParseAlgorithm.IsIn((String)T.elementAt(i), S);
        }
        return !negResult;
    }

    public static Vector Union(Vector S, Vector T) {
        Vector result = (Vector)S.clone();
        for (int i = 0; i < T.size(); ++i) {
            String str = (String)T.elementAt(i);
            if (ParseAlgorithm.IsIn(str, result)) continue;
            result.addElement(str);
        }
        return result;
    }

    public static void Copy(Vector in, Vector out) {
        out.removeAllElements();
        for (int i = 0; i < in.size(); ++i) {
            out.addElement(in.elementAt(i));
        }
    }

    public static Vector MakeLabeledStmtSeq(Vector stmtseq) throws ParseAlgorithmException {
        Vector result = ParseAlgorithm.InnerMakeLabeledStmtSeq(stmtseq);
        ParseAlgorithm.CheckLabeledStmtSeq(result);
        return result;
    }

    public static Vector InnerMakeLabeledStmtSeq(Vector stmtseq) {
        Vector<AST.LabeledStmt> result = new Vector<AST.LabeledStmt>();
        int nextStmt = 0;
        while (nextStmt < stmtseq.size()) {
            AST.LabeledStmt lstmt = new AST.LabeledStmt();
            AST stmt = (AST)stmtseq.elementAt(nextStmt);
            lstmt.col = stmt.col;
            lstmt.line = stmt.line;
            lstmt.macroCol = stmt.macroCol;
            lstmt.macroLine = stmt.macroLine;
            PcalDebug.Assert(!stmt.lbl.equals(""), "Missing Label in MakeLabeledStmtSeq");
            lstmt.label = stmt.lbl;
            if (stmt.lbl.equals("")) {
                Debug.ReportBug("ParseAlgorithmInnerMakeLabeledStmtSeq found null label starting labeled stmt seq");
            }
            lstmt.stmts = new Vector();
            PCalLocation lstmtBegin = null;
            if (!stmt.lbl.equals("")) {
                lstmtBegin = stmt.lblLocation;
            }
            boolean firstTime = true;
            while (nextStmt < stmtseq.size() && (firstTime || stmt.lbl.equals(""))) {
                firstTime = false;
                lstmt.stmts.addElement(stmt);
                if (++nextStmt >= stmtseq.size()) continue;
                stmt = (AST)stmtseq.elementAt(nextStmt);
            }
            ParseAlgorithm.FixStmtSeq(lstmt.stmts);
            int numberOfStmts = lstmt.stmts.size();
            if (numberOfStmts == 0) {
                Debug.ReportBug("Found empty statement sequence in InnerMakeLabeledStmtSeq");
            }
            if (lstmtBegin == null) {
                lstmtBegin = ((AST)lstmt.stmts.elementAt(0)).getOrigin().getBegin();
            }
            PCalLocation lstmtEnd = ((AST)lstmt.stmts.elementAt(numberOfStmts - 1)).getOrigin().getEnd();
            lstmt.setOrigin(new Region(lstmtBegin, lstmtEnd));
            result.addElement(lstmt);
        }
        return result;
    }

    public static void FixStmtSeq(Vector stmtseq) {
        Vector result = new Vector();
        for (int i = 0; i < stmtseq.size(); ++i) {
            AST obj;
            AST stmt = (AST)stmtseq.elementAt(i);
            if (stmt.getClass().equals(AST.LabelIfObj.getClass())) {
                obj = (AST.LabelIf)stmt;
                Vector curr = obj.unlabThen;
                obj.unlabThen = new Vector();
                while (curr.size() > 0 && ((AST)curr.elementAt((int)0)).lbl.equals("")) {
                    obj.unlabThen.addElement(curr.elementAt(0));
                    curr.removeElementAt(0);
                }
                ParseAlgorithm.FixStmtSeq(obj.unlabThen);
                obj.labThen = ParseAlgorithm.InnerMakeLabeledStmtSeq(curr);
                curr = obj.unlabElse;
                obj.unlabElse = new Vector();
                while (curr.size() > 0 && ((AST)curr.elementAt((int)0)).lbl.equals("")) {
                    obj.unlabElse.addElement(curr.elementAt(0));
                    curr.removeElementAt(0);
                }
                ParseAlgorithm.FixStmtSeq(obj.unlabElse);
                obj.labElse = ParseAlgorithm.InnerMakeLabeledStmtSeq(curr);
                continue;
            }
            if (stmt.getClass().equals(AST.LabelEitherObj.getClass())) {
                obj = (AST.LabelEither)stmt;
                for (int j = 0; j < ((AST.LabelEither)obj).clauses.size(); ++j) {
                    AST.Clause clause = (AST.Clause)((AST.LabelEither)obj).clauses.elementAt(j);
                    Vector curr = clause.unlabOr;
                    clause.unlabOr = new Vector();
                    while (curr.size() > 0 && ((AST)curr.elementAt((int)0)).lbl.equals("")) {
                        clause.unlabOr.addElement(curr.elementAt(0));
                        curr.removeElementAt(0);
                    }
                    ParseAlgorithm.FixStmtSeq(clause.unlabOr);
                    clause.labOr = ParseAlgorithm.InnerMakeLabeledStmtSeq(curr);
                }
                continue;
            }
            if (!stmt.getClass().equals(AST.WhileObj.getClass())) continue;
            obj = (AST.While)stmt;
            Vector curr = ((AST.While)obj).unlabDo;
            ((AST.While)obj).unlabDo = new Vector();
            while (curr.size() > 0 && ((AST)curr.elementAt((int)0)).lbl.equals("")) {
                ((AST.While)obj).unlabDo.addElement(curr.elementAt(0));
                curr.removeElementAt(0);
            }
            ParseAlgorithm.FixStmtSeq(((AST.While)obj).unlabDo);
            ((AST.While)obj).labDo = ParseAlgorithm.InnerMakeLabeledStmtSeq(curr);
        }
    }

    public static void CheckLabeledStmtSeq(Vector stmtseq) throws ParseAlgorithmException {
        for (int i = 0; i < stmtseq.size(); ++i) {
            AST.LabeledStmt stmt = (AST.LabeledStmt)stmtseq.elementAt(i);
            int ignore = ParseAlgorithm.ClassifyStmtSeq(stmt.stmts);
        }
    }

    public static int ClassifyStmtSeq(Vector stmtseq) throws ParseAlgorithmException {
        int result = 0;
        for (int i = 0; i < stmtseq.size(); ++i) {
            AST node = (AST)stmtseq.elementAt(i);
            if (node.getClass().equals(AST.LabelIfObj.getClass())) {
                AST.LabelIf ifNode = (AST.LabelIf)node;
                result = ParseAlgorithm.ClassifyIf(ifNode);
                if (result < 2) {
                    AST.If newIf = new AST.If();
                    newIf.test = ifNode.test;
                    newIf.Then = ifNode.unlabThen;
                    newIf.Else = ifNode.unlabElse;
                    newIf.setOrigin(ifNode.getOrigin());
                    stmtseq.setElementAt(newIf, i);
                }
            } else if (node.getClass().equals(AST.LabelEitherObj.getClass())) {
                AST.LabelEither eitherNode = (AST.LabelEither)node;
                result = ParseAlgorithm.ClassifyEither(eitherNode);
                if (result < 2) {
                    AST.Either newEither = new AST.Either();
                    newEither.ors = new Vector();
                    for (int j = 0; j < eitherNode.clauses.size(); ++j) {
                        newEither.ors.addElement(((AST.Clause)eitherNode.clauses.elementAt((int)j)).unlabOr);
                    }
                    newEither.setOrigin(eitherNode.getOrigin());
                    stmtseq.setElementAt(newEither, i);
                }
            } else if (node.getClass().equals(AST.WithObj.getClass())) {
                result = ParseAlgorithm.ClassifyStmtSeq(((AST.With)node).Do);
                if (result == 2) {
                    throw new ParseAlgorithmException("with statement at " + node.location() + " contains a labeled statement");
                }
            } else if (node.getClass().equals(AST.WhileObj.getClass())) {
                if (i != 0) {
                    PcalDebug.ReportBug("ParseAlgorithm.ClassifyStmtSeq encountered `while' not at beginning of StmtSeq.");
                }
                int ignore = ParseAlgorithm.ClassifyStmtSeq(((AST.While)node).unlabDo);
                ParseAlgorithm.CheckLabeledStmtSeq(((AST.While)node).labDo);
            } else if (node.getClass().equals(AST.CallObj.getClass())) {
                if (i >= stmtseq.size() - 1 || !stmtseq.elementAt(i + 1).getClass().equals(AST.ReturnObj.getClass())) {
                    result = 1;
                }
            } else if (node.getClass().equals(AST.ReturnObj.getClass()) || node.getClass().equals(AST.CallReturnObj.getClass())) {
                if (currentProcedure == null) {
                    throw new ParseAlgorithmException("return statement not in a procedure at " + node.location());
                }
                result = 1;
            } else if (node.getClass().equals(AST.GotoObj.getClass())) {
                result = 1;
            } else if (!(node.getClass().equals(AST.AssignObj.getClass()) || node.getClass().equals(AST.WhenObj.getClass()) || node.getClass().equals(AST.PrintSObj.getClass()) || node.getClass().equals(AST.AssertObj.getClass()) || node.getClass().equals(AST.SkipObj.getClass()) || node.getClass().equals(AST.MacroCallObj.getClass()))) {
                PcalDebug.ReportBug("ParseAlgorithm.ClassifyStmtSeq encountered the unexpected statement type " + node.getClass().toString());
            }
            if (result <= 0) continue;
            if (i == stmtseq.size() - 1) {
                return result;
            }
            node = (AST)stmtseq.elementAt(i + 1);
            PcalDebug.ReportBug("Translator discovered later than it should have  that\n  Statement at " + node.location() + " must have a label");
        }
        return result;
    }

    public static int ClassifyIf(AST.LabelIf node) throws ParseAlgorithmException {
        int thenClass = ParseAlgorithm.ClassifyStmtSeq(node.unlabThen);
        boolean isLabeled = false;
        if (node.labThen.size() > 0) {
            isLabeled = true;
            ParseAlgorithm.CheckLabeledStmtSeq(node.labThen);
        }
        int elseClass = ParseAlgorithm.ClassifyStmtSeq(node.unlabElse);
        if (node.labElse.size() > 0) {
            isLabeled = true;
            ParseAlgorithm.CheckLabeledStmtSeq(node.labElse);
        }
        if (isLabeled || thenClass == 2 || elseClass == 2) {
            return 2;
        }
        if (thenClass + elseClass > 0) {
            return 1;
        }
        return 0;
    }

    public static int ClassifyEither(AST.LabelEither node) throws ParseAlgorithmException {
        int theClass = 0;
        for (int i = 0; i < node.clauses.size(); ++i) {
            AST.Clause currClause = (AST.Clause)node.clauses.elementAt(i);
            int unlabClass = ParseAlgorithm.ClassifyStmtSeq(currClause.unlabOr);
            if (unlabClass > theClass) {
                theClass = unlabClass;
            }
            if (currClause.labOr.size() <= 0) continue;
            theClass = 2;
            ParseAlgorithm.CheckLabeledStmtSeq(currClause.labOr);
        }
        return theClass;
    }

    public static void CheckForDuplicateMacros(Vector macros) throws ParseAlgorithmException {
        for (int i = 0; i < macros.size(); ++i) {
            String namei = ((AST.Macro)macros.elementAt((int)i)).name;
            for (int j = i + 1; j < macros.size(); ++j) {
                if (!namei.equals(((AST.Macro)macros.elementAt((int)j)).name)) continue;
                throw new ParseAlgorithmException("Multiple definitions of macro name `" + namei + "'");
            }
        }
    }

    public static void ObsoleteExpandMacrosInLabeledStmtSeq(Vector stmtseq, Vector macros) throws ParseAlgorithmException {
        for (int i = 0; i < stmtseq.size(); ++i) {
            AST.LabeledStmt stmt = (AST.LabeledStmt)stmtseq.elementAt(i);
            ParseAlgorithm.ExpandMacrosInStmtSeq(stmt.stmts, macros);
        }
    }

    public static void ExpandMacrosInStmtSeq(Vector stmtseq, Vector macros) throws ParseAlgorithmException {
        for (int i = 0; i < stmtseq.size(); ++i) {
            int j;
            AST node = (AST)stmtseq.elementAt(i);
            if (node.getClass().equals(AST.LabelIfObj.getClass())) {
                ParseAlgorithm.ExpandMacrosInStmtSeq(((AST.LabelIf)node).unlabThen, macros);
                ParseAlgorithm.ExpandMacrosInStmtSeq(((AST.LabelIf)node).unlabElse, macros);
                continue;
            }
            if (node.getClass().equals(AST.LabelEitherObj.getClass())) {
                AST.LabelEither eNode = (AST.LabelEither)node;
                for (j = 0; j < eNode.clauses.size(); ++j) {
                    ParseAlgorithm.ExpandMacrosInStmtSeq(((AST.Clause)eNode.clauses.elementAt((int)j)).unlabOr, macros);
                }
                continue;
            }
            if (node.getClass().equals(AST.WithObj.getClass())) {
                ParseAlgorithm.ExpandMacrosInStmtSeq(((AST.With)node).Do, macros);
                continue;
            }
            if (node.getClass().equals(AST.WhileObj.getClass())) {
                ParseAlgorithm.ExpandMacrosInStmtSeq(((AST.While)node).unlabDo, macros);
                continue;
            }
            if (!node.getClass().equals(AST.MacroCallObj.getClass())) continue;
            Vector expansion = ParseAlgorithm.ExpandMacroCall((AST.MacroCall)node, macros);
            stmtseq.remove(i);
            for (j = expansion.size(); j > 0; --j) {
                stmtseq.insertElementAt(expansion.elementAt(j - 1), i);
            }
            i = i + expansion.size() - 1;
        }
    }

    public static Vector ExpandMacroCall(AST.MacroCall call, Vector macros) throws ParseAlgorithmException {
        AST.Macro macroDef = null;
        for (int i = 0; i < macros.size(); ++i) {
            AST.Macro md = (AST.Macro)macros.elementAt(i);
            if (!md.name.equals(call.name)) continue;
            macroDef = md;
        }
        if (macroDef == null) {
            throw new ParseAlgorithmException("Macro " + call.name + " undefined,\n    at " + call.location());
        }
        int numOfArgs = call.args.size();
        if (macroDef.params.size() != numOfArgs) {
            throw new ParseAlgorithmException("Macro " + call.name + " called with wrong number of arguments at " + "\n    " + call.location());
        }
        Vector result = ParseAlgorithm.SubstituteInStmtSeq(macroDef.body, call.args, macroDef.params, call.line, call.col);
        if (result.size() > 0) {
            AST first = (AST)result.elementAt(0);
            first.lbl = call.lbl;
            first.lblLocation = call.lblLocation;
            Region callOrigin = call.getOrigin();
            if (callOrigin != null) {
                first.macroOriginBegin = callOrigin.getBegin();
                AST last = (AST)result.elementAt(result.size() - 1);
                last.macroOriginEnd = callOrigin.getEnd();
            }
        }
        return result;
    }

    public static Vector SubstituteInLabeledStmtSeq(Vector stmts, Vector args, Vector params) throws ParseAlgorithmException {
        Vector<AST.LabeledStmt> result = new Vector<AST.LabeledStmt>();
        for (int i = 0; i < stmts.size(); ++i) {
            result.addElement(ParseAlgorithm.SubstituteInLabeledStmt((AST.LabeledStmt)stmts.elementAt(i), args, params));
        }
        return result;
    }

    public static AST.LabeledStmt SubstituteInLabeledStmt(AST.LabeledStmt stmt, Vector args, Vector params) throws ParseAlgorithmException {
        AST.LabeledStmt result = new AST.LabeledStmt();
        result.label = stmt.label;
        result.stmts = ParseAlgorithm.SubstituteInStmtSeq(stmt.stmts, args, params, -1, 0);
        result.setOrigin(stmt.getOrigin());
        return result;
    }

    public static Vector SubstituteInStmtSeq(Vector stmts, Vector args, Vector params, int macroLine, int macroCol) throws ParseAlgorithmException {
        Vector<AST> result = new Vector<AST>();
        for (int i = 0; i < stmts.size(); ++i) {
            result.addElement(ParseAlgorithm.SubstituteInStmt((AST)stmts.elementAt(i), args, params, macroLine, macroCol));
        }
        return result;
    }

    public static AST SubstituteInStmt(AST stmt, Vector args, Vector params, int macroLine, int macroCol) throws ParseAlgorithmException {
        try {
            if (stmt.getClass().equals(AST.AssignObj.getClass())) {
                AST.Assign tstmt = (AST.Assign)stmt;
                AST.Assign result = new AST.Assign();
                result.col = tstmt.col;
                result.line = tstmt.line;
                result.macroCol = tstmt.macroCol;
                result.macroLine = tstmt.macroLine;
                result.setOrigin(tstmt.getOrigin());
                if (macroLine > 0) {
                    result.macroLine = macroLine;
                    result.macroCol = macroCol;
                }
                result.ass = new Vector();
                for (int i = 0; i < tstmt.ass.size(); ++i) {
                    result.ass.addElement(ParseAlgorithm.SubstituteInSingleAssign((AST.SingleAssign)tstmt.ass.elementAt(i), args, params, macroLine, macroCol));
                }
                return result;
            }
            if (stmt.getClass().equals(AST.IfObj.getClass())) {
                AST.If tstmt = (AST.If)stmt;
                AST.If result = new AST.If();
                result.col = tstmt.col;
                result.line = tstmt.line;
                result.macroCol = tstmt.macroCol;
                result.macroLine = tstmt.macroLine;
                result.setOrigin(tstmt.getOrigin());
                if (macroLine > 0) {
                    result.macroLine = macroLine;
                    result.macroCol = macroCol;
                }
                result.test = tstmt.test.cloneAndNormalize();
                result.test.substituteForAll(args, params);
                result.Then = ParseAlgorithm.SubstituteInStmtSeq(tstmt.Then, args, params, macroLine, macroCol);
                result.Else = ParseAlgorithm.SubstituteInStmtSeq(tstmt.Else, args, params, macroLine, macroCol);
                return result;
            }
            if (stmt.getClass().equals(AST.EitherObj.getClass())) {
                AST.Either tstmt = (AST.Either)stmt;
                AST.Either result = new AST.Either();
                result.col = tstmt.col;
                result.line = tstmt.line;
                result.macroCol = tstmt.macroCol;
                result.macroLine = tstmt.macroLine;
                result.setOrigin(tstmt.getOrigin());
                if (macroLine > 0) {
                    result.macroLine = macroLine;
                    result.macroCol = macroCol;
                }
                result.ors = new Vector();
                for (int i = 0; i < tstmt.ors.size(); ++i) {
                    result.ors.addElement(ParseAlgorithm.SubstituteInStmtSeq((Vector)tstmt.ors.elementAt(i), args, params, macroLine, macroCol));
                }
                return result;
            }
            if (stmt.getClass().equals(AST.WithObj.getClass())) {
                AST.With tstmt = (AST.With)stmt;
                AST.With result = new AST.With();
                result.col = tstmt.col;
                result.line = tstmt.line;
                result.macroCol = tstmt.macroCol;
                result.macroLine = tstmt.macroLine;
                result.setOrigin(tstmt.getOrigin());
                if (macroLine > 0) {
                    result.macroLine = macroLine;
                    result.macroCol = macroCol;
                }
                result.var = tstmt.var;
                result.isEq = tstmt.isEq;
                result.exp = tstmt.exp.cloneAndNormalize();
                result.exp.substituteForAll(args, params);
                result.Do = ParseAlgorithm.SubstituteInStmtSeq(tstmt.Do, args, params, macroLine, macroCol);
                return result;
            }
            if (stmt.getClass().equals(AST.WhenObj.getClass())) {
                AST.When tstmt = (AST.When)stmt;
                AST.When result = new AST.When();
                result.col = tstmt.col;
                result.line = tstmt.line;
                result.macroCol = tstmt.macroCol;
                result.macroLine = tstmt.macroLine;
                result.setOrigin(tstmt.getOrigin());
                if (macroLine > 0) {
                    result.macroLine = macroLine;
                    result.macroCol = macroCol;
                }
                result.exp = tstmt.exp.cloneAndNormalize();
                result.exp.substituteForAll(args, params);
                return result;
            }
            if (stmt.getClass().equals(AST.AssertObj.getClass())) {
                AST.Assert tstmt = (AST.Assert)stmt;
                AST.Assert result = new AST.Assert();
                result.col = tstmt.col;
                result.line = tstmt.line;
                result.macroCol = tstmt.macroCol;
                result.macroLine = tstmt.macroLine;
                result.setOrigin(tstmt.getOrigin());
                if (macroLine > 0) {
                    result.macroLine = macroLine;
                    result.macroCol = macroCol;
                }
                result.exp = tstmt.exp.cloneAndNormalize();
                result.exp.substituteForAll(args, params);
                return result;
            }
            if (stmt.getClass().equals(AST.SkipObj.getClass())) {
                AST.Skip tstmt = (AST.Skip)stmt;
                AST.Skip result = new AST.Skip();
                result.col = tstmt.col;
                result.line = tstmt.line;
                result.setOrigin(tstmt.getOrigin());
                if (macroLine > 0) {
                    result.macroLine = macroLine;
                    result.macroCol = macroCol;
                }
                return result;
            }
            if (stmt.getClass().equals(AST.PrintSObj.getClass())) {
                AST.PrintS tstmt = (AST.PrintS)stmt;
                AST.PrintS result = new AST.PrintS();
                result.col = tstmt.col;
                result.line = tstmt.line;
                result.macroCol = tstmt.macroCol;
                result.macroLine = tstmt.macroLine;
                result.setOrigin(tstmt.getOrigin());
                if (macroLine > 0) {
                    result.macroLine = macroLine;
                    result.macroCol = macroCol;
                }
                result.exp = tstmt.exp.cloneAndNormalize();
                result.exp.substituteForAll(args, params);
                return result;
            }
            if (stmt.getClass().equals(AST.WhileObj.getClass())) {
                AST.While tstmt = (AST.While)stmt;
                AST.While result = new AST.While();
                result.col = tstmt.col;
                result.line = tstmt.line;
                result.macroCol = tstmt.macroCol;
                result.macroLine = tstmt.macroLine;
                result.setOrigin(tstmt.getOrigin());
                if (macroLine > 0) {
                    result.macroLine = macroLine;
                    result.macroCol = macroCol;
                }
                result.test = tstmt.test.cloneAndNormalize();
                result.test.substituteForAll(args, params);
                result.unlabDo = ParseAlgorithm.SubstituteInStmtSeq(tstmt.unlabDo, args, params, macroLine, macroCol);
                result.labDo = ParseAlgorithm.SubstituteInLabeledStmtSeq(tstmt.labDo, args, params);
                return result;
            }
            if (stmt.getClass().equals(AST.LabelIfObj.getClass())) {
                AST.LabelIf tstmt = (AST.LabelIf)stmt;
                AST.LabelIf result = new AST.LabelIf();
                result.col = tstmt.col;
                result.line = tstmt.line;
                result.macroCol = tstmt.macroCol;
                result.macroLine = tstmt.macroLine;
                result.setOrigin(tstmt.getOrigin());
                if (macroLine > 0) {
                    result.macroLine = macroLine;
                    result.macroCol = macroCol;
                }
                result.test = tstmt.test.cloneAndNormalize();
                result.test.substituteForAll(args, params);
                result.unlabThen = ParseAlgorithm.SubstituteInStmtSeq(tstmt.unlabThen, args, params, macroLine, macroCol);
                result.labThen = ParseAlgorithm.SubstituteInLabeledStmtSeq(tstmt.labThen, args, params);
                result.unlabElse = ParseAlgorithm.SubstituteInStmtSeq(tstmt.unlabElse, args, params, macroLine, macroCol);
                result.labElse = ParseAlgorithm.SubstituteInLabeledStmtSeq(tstmt.labElse, args, params);
                return result;
            }
            if (stmt.getClass().equals(AST.LabelEitherObj.getClass())) {
                AST.LabelEither tstmt = (AST.LabelEither)stmt;
                AST.LabelEither result = new AST.LabelEither();
                result.col = tstmt.col;
                result.line = tstmt.line;
                result.macroCol = tstmt.macroCol;
                result.macroLine = tstmt.macroLine;
                result.setOrigin(tstmt.getOrigin());
                if (macroLine > 0) {
                    result.macroLine = macroLine;
                    result.macroCol = macroCol;
                }
                result.clauses = new Vector();
                for (int i = 0; i < tstmt.clauses.size(); ++i) {
                    AST.Clause oldClause = (AST.Clause)tstmt.clauses.elementAt(i);
                    AST.Clause newClause = new AST.Clause();
                    newClause.setOrigin(oldClause.getOrigin());
                    newClause.labOr = ParseAlgorithm.SubstituteInLabeledStmtSeq(oldClause.labOr, args, params);
                    newClause.unlabOr = ParseAlgorithm.SubstituteInStmtSeq(oldClause.unlabOr, args, params, macroLine, macroCol);
                    result.clauses.addElement(newClause);
                }
                return result;
            }
            if (stmt.getClass().equals(AST.CallObj.getClass())) {
                AST.Call tstmt = (AST.Call)stmt;
                AST.Call result = new AST.Call();
                result.col = tstmt.col;
                result.line = tstmt.line;
                result.macroCol = tstmt.macroCol;
                result.macroLine = tstmt.macroLine;
                result.setOrigin(tstmt.getOrigin());
                if (macroLine > 0) {
                    result.macroLine = macroLine;
                    result.macroCol = macroCol;
                }
                result.to = tstmt.to;
                result.returnTo = tstmt.returnTo;
                result.args = TLAExpr.SeqSubstituteForAll(tstmt.args, args, params);
                return result;
            }
            if (stmt.getClass().equals(AST.ReturnObj.getClass())) {
                AST.Return tstmt = (AST.Return)stmt;
                AST.Return result = new AST.Return();
                result.col = tstmt.col;
                result.line = tstmt.line;
                result.macroCol = tstmt.macroCol;
                result.macroLine = tstmt.macroLine;
                result.setOrigin(tstmt.getOrigin());
                if (macroLine > 0) {
                    result.macroLine = macroLine;
                    result.macroCol = macroCol;
                }
                result.from = tstmt.from;
                return result;
            }
            if (stmt.getClass().equals(AST.CallReturnObj.getClass())) {
                AST.CallReturn tstmt = (AST.CallReturn)stmt;
                AST.CallReturn result = new AST.CallReturn();
                result.col = tstmt.col;
                result.line = tstmt.line;
                result.macroCol = tstmt.macroCol;
                result.macroLine = tstmt.macroLine;
                result.setOrigin(tstmt.getOrigin());
                if (macroLine > 0) {
                    result.macroLine = macroLine;
                    result.macroCol = macroCol;
                }
                result.to = tstmt.to;
                result.from = tstmt.from;
                result.args = TLAExpr.SeqSubstituteForAll(tstmt.args, args, params);
                return result;
            }
            if (stmt.getClass().equals(AST.GotoObj.getClass())) {
                AST.Goto tstmt = (AST.Goto)stmt;
                AST.Goto result = new AST.Goto();
                result.col = tstmt.col;
                result.line = tstmt.line;
                result.macroCol = tstmt.macroCol;
                result.macroLine = tstmt.macroLine;
                result.setOrigin(tstmt.getOrigin());
                if (macroLine > 0) {
                    result.macroLine = macroLine;
                    result.macroCol = macroCol;
                }
                result.to = tstmt.to;
                return result;
            }
            PcalDebug.ReportBug("Found unexpected statement type in macro at" + stmt.location());
            return new AST();
        }
        catch (UnrecoverableException e) {
            throw new ParseAlgorithmException(e.getMessage());
        }
    }

    public static AST SubstituteInSingleAssign(AST.SingleAssign assgn, Vector args, Vector params, int macroLine, int macroCol) throws ParseAlgorithmException {
        try {
            AST.SingleAssign result = new AST.SingleAssign();
            result.setOrigin(assgn.getOrigin());
            result.col = assgn.col;
            result.line = assgn.line;
            result.macroCol = assgn.macroCol;
            result.macroLine = assgn.macroLine;
            if (macroLine > 0) {
                result.macroLine = macroLine;
                result.macroCol = macroCol;
            }
            result.rhs = assgn.rhs.cloneAndNormalize();
            result.rhs.substituteForAll(args, params);
            result.lhs = new AST.Lhs();
            result.lhs.setOrigin(assgn.getOrigin());
            result.lhs.sub = assgn.lhs.sub;
            if (assgn.lhs.sub.tokens != null && assgn.lhs.sub.tokens.size() != 0) {
                result.lhs.sub = assgn.lhs.sub.cloneAndNormalize();
                result.lhs.sub.substituteForAll(args, params);
            }
            result.lhs.var = assgn.lhs.var;
            int i = 0;
            boolean found = false;
            while (i < params.size() && !found) {
                if (result.lhs.var.equals((String)params.elementAt(i))) {
                    found = true;
                    continue;
                }
                ++i;
            }
            if (found) {
                TLAExpr subForVar = (TLAExpr)args.elementAt(i);
                TLAToken varToken = subForVar.tokenAt(new IntPair(0, 0));
                if (varToken.type != 4) {
                    throw new ParseAlgorithmException("Macro expansion substitutes `" + varToken.string + "' for assignment variable\n    at " + result.location());
                }
                result.lhs.var = varToken.string;
                if (subForVar.stepCoord(new IntPair(0, 0), 1) != null) {
                    TLAExpr exprCopy = subForVar.cloneAndNormalize();
                    Vector firstLine = (Vector)exprCopy.tokens.elementAt(0);
                    firstLine.removeElementAt(0);
                    exprCopy.normalize();
                    if (result.lhs.sub == null || result.lhs.sub.tokens.size() == 0) {
                        result.lhs.sub = exprCopy;
                    } else {
                        result.lhs.sub.prepend(exprCopy, 0);
                    }
                }
            }
            return result;
        }
        catch (TLAExprException e) {
            throw new ParseAlgorithmException(e.getMessage());
        }
    }

    private static void ParsingError(String msg) throws ParseAlgorithmException {
        throw new ParseAlgorithmException(msg + "\n    line " + lastTokLine + ", column " + lastTokCol);
    }

    public static void GobbleCommaOrSemicolon() throws ParseAlgorithmException {
        String nxt = ParseAlgorithm.PeekAtAlgToken(1);
        if (nxt.equals(",")) {
            ParseAlgorithm.GobbleThis(",");
        } else {
            ParseAlgorithm.GobbleThis(";");
        }
    }

    public static void GobbleBeginOrLeftBrace() throws ParseAlgorithmException {
        if (pSyntax) {
            ParseAlgorithm.GobbleThis("begin");
        } else if (cSyntax) {
            ParseAlgorithm.GobbleThis("{");
        } else {
            PcalDebug.ReportBug("Syntax not initialized.");
        }
    }

    public static void GobbleEndOrRightBrace(String str) throws ParseAlgorithmException {
        if (pSyntax) {
            ParseAlgorithm.GobbleThis("end");
            ParseAlgorithm.GobbleThis(str);
        } else if (cSyntax) {
            ParseAlgorithm.GobbleThis("}");
        } else {
            PcalDebug.ReportBug("Bad call of GobbleEndRightBrace");
        }
    }

    public static void GobbleThis(String str) throws ParseAlgorithmException {
        String tok;
        if (str.equals(";")) {
            String nxt = ParseAlgorithm.PeekAtAlgToken(1);
            if (nxt.equals("end") || nxt.equals("begin") || nxt.equals("else") || nxt.equals("elsif") || nxt.equals("or") || nxt.equals("do") || nxt.equals("macro") || nxt.equals("procedure") || nxt.equals("process") || nxt.equals("fair") || nxt.equals("define") || nxt.equals("}") || nxt.equals("{")) {
                return;
            }
            if (nxt.equals("if") || nxt.equals("either") || nxt.equals("while") || nxt.equals("with") || nxt.equals("call") || nxt.equals("return") || nxt.equals("goto") || nxt.equals("print") || nxt.equals("assert") || nxt.equals("skip")) {
                throw new ParseAlgorithmException("Missing `;' before line " + (curTokLine[0] + 1) + ", column " + (curTokCol[0] + 1));
            }
        }
        if (!(tok = ParseAlgorithm.GetAlgToken()).equals(str)) {
            ParseAlgorithm.ParsingError("Expected \"" + str + "\" but found \"" + tok + "\"");
        }
    }

    public static void MustGobbleThis(String str) throws ParseAlgorithmException {
        String tok;
        try {
            tok = ParseAlgorithm.GetAlgToken();
        }
        catch (ParseAlgorithmException e) {
            throw new ParseAlgorithmException(e.getMessage());
        }
        if (!tok.equals(str)) {
            PcalDebug.ReportBug("Expected \"" + str + "\" but found \"" + tok + "\"");
        }
    }

    public static boolean GobbleEqualOrIf() throws ParseAlgorithmException {
        String tok = ParseAlgorithm.GetAlgToken();
        if (tok.equals("=")) {
            return true;
        }
        if (tok.equals("\\in")) {
            return false;
        }
        ParseAlgorithm.ParsingError("Expected \"=\" or \"\\in\"  but found \"" + tok + "\"");
        return false;
    }

    private static PCalLocation GetLastLocationStart() {
        return new PCalLocation(lastTokLine - 1, lastTokCol - 1);
    }

    private static PCalLocation GetLastLocationEnd() {
        return new PCalLocation(lastTokLine - 1, lastTokCol - 1 + lastTokString.length());
    }

    public static String GetAlgToken() throws ParseAlgorithmException {
        if (LATsize == 0) {
            String tok;
            charReader.peek();
            lastTokCol = charReader.getColumnNumber() + 1;
            lastTokLine = charReader.getLineNumber() + 1;
            try {
                tok = Tokenize.GetAlgorithmToken(charReader);
            }
            catch (TokenizerException e) {
                throw new ParseAlgorithmException(e.getMessage());
            }
            lastTokString = tok;
            return tok;
        }
        lastTokCol = curTokCol[0] + 1;
        lastTokLine = curTokLine[0] + 1;
        String result = LAT[0];
        for (int i = 1; i < LATsize; ++i) {
            ParseAlgorithm.LAT[i - 1] = LAT[i];
            ParseAlgorithm.curTokCol[i - 1] = curTokCol[i];
            ParseAlgorithm.curTokLine[i - 1] = curTokLine[i];
        }
        --LATsize;
        lastTokString = result;
        return result;
    }

    public static String PeekAtAlgToken(int tokNum) throws ParseAlgorithmException {
        while (LATsize < tokNum) {
            if (charReader.peek().equals("\t")) {
                throw new ParseAlgorithmException("Premature end of file, perhaps because of unclosed comment, near\n    line " + (curTokLine[LATsize] + 1) + ", column " + (curTokCol[LATsize] + 1));
            }
            ParseAlgorithm.curTokCol[ParseAlgorithm.LATsize] = charReader.getColumnNumber();
            ParseAlgorithm.curTokLine[ParseAlgorithm.LATsize] = charReader.getLineNumber();
            try {
                ParseAlgorithm.LAT[ParseAlgorithm.LATsize] = Tokenize.GetAlgorithmToken(charReader);
            }
            catch (TokenizerException e) {
                throw new ParseAlgorithmException(e.getMessage());
            }
            ++LATsize;
        }
        return LAT[tokNum - 1];
    }

    public static String PeekPastAlgToken(int tokNum) throws ParseAlgorithmException {
        if (tokNum < LATsize) {
            PcalDebug.ReportBug("ParseAlgorithm.PeekPastAlgToken called to peek after a token\n    it has already peeked at");
        }
        while (tokNum > LATsize) {
            try {
                ParseAlgorithm.LAT[ParseAlgorithm.LATsize] = Tokenize.GetAlgorithmToken(charReader);
            }
            catch (TokenizerException e) {
                throw new ParseAlgorithmException(e.getMessage());
            }
            ++LATsize;
        }
        return charReader.peek();
    }

    public static void uncomment(Vector inp, int begLine, int begCol) throws ParseAlgorithmException {
        int line;
        int col = begCol;
        boolean notDone = true;
        int commentDepth = 0;
        StringBuffer newLine = new StringBuffer(((String)inp.elementAt(line)).substring(0, col));
        for (line = begLine; notDone && line < inp.size(); ++line) {
            String oldLine = (String)inp.elementAt(line);
            boolean inString = false;
            boolean afterBackslash = false;
            boolean afterAsterisk = false;
            while (notDone && col < oldLine.length()) {
                char inChar;
                char outChar = inChar = oldLine.charAt(col);
                if (inChar == '(' && !inString && col < oldLine.length() - 1 && oldLine.charAt(col + 1) == '*') {
                    ++commentDepth;
                    outChar = ' ';
                    ++col;
                    newLine.append(outChar);
                } else if (inChar == '*' && !inString && col < oldLine.length() - 1 && oldLine.charAt(col + 1) == ')') {
                    if (commentDepth == 0) {
                        newLine.append(inChar);
                        outChar = ')';
                        ++col;
                        notDone = false;
                    } else {
                        --commentDepth;
                        outChar = ' ';
                        ++col;
                        newLine.append(outChar);
                    }
                } else if (commentDepth == 0) {
                    if (inString) {
                        if (inChar == '\"') {
                            inString = false;
                        } else if (inChar == '\\' && col < oldLine.length() - 1) {
                            newLine.append(inChar);
                            outChar = oldLine.charAt(col + 1);
                            ++col;
                        }
                    } else if (inChar == '\\' && col < oldLine.length() - 1 && oldLine.charAt(col + 1) == '*') {
                        outChar = ' ';
                        col = oldLine.length();
                    } else if (inChar == '\"') {
                        inString = true;
                    }
                } else {
                    outChar = ' ';
                }
                newLine.append(outChar);
                ++col;
            }
            if (inString) {
                throw new ParseAlgorithmException("Unterminated string in line " + (line + 1));
            }
            inp.set(line, newLine.toString());
            newLine = new StringBuffer();
            col = 0;
        }
    }

    public static int ProcessOptions(Vector untabInputVec, IntPair curLoc) {
        String curLine = ParseAlgorithm.GotoNextNonSpace(untabInputVec, curLoc);
        if (curLine.substring(curLoc.two).startsWith("options")) {
            curLoc.two += 7;
            curLine = ParseAlgorithm.GotoNextNonSpace(untabInputVec, curLoc);
            if (!curLine.substring(curLoc.two).startsWith("(")) {
                curLoc.one = untabInputVec.size();
                PcalDebug.reportError("`PlusCal options' not followed by '('");
                return -1;
            }
            ++curLoc.two;
            curLine = ParseAlgorithm.GotoNextNonSpace(untabInputVec, curLoc);
            Vector<String> argsVec = new Vector<String>();
            while (curLoc.one < untabInputVec.size() && curLine.charAt(curLoc.two) != ')') {
                if (curLine.charAt(curLoc.two) == ',') {
                    ++curLoc.two;
                } else {
                    int endOfArg = ParseAlgorithm.NextDelimiterCol(curLine, curLoc.two);
                    argsVec.addElement(curLine.substring(curLoc.two, endOfArg));
                    curLoc.two = endOfArg;
                }
                curLine = ParseAlgorithm.GotoNextNonSpace(untabInputVec, curLoc);
            }
            if (curLoc.one >= untabInputVec.size()) {
                PcalDebug.reportError("No closing ')' found in options statement");
                return -1;
            }
            ++curLoc.two;
            curLine = ParseAlgorithm.GotoNextNonSpace(untabInputVec, curLoc);
            argsVec.addElement("");
            String[] argsArray = new String[argsVec.size()];
            for (int i = 0; i < argsArray.length; ++i) {
                argsArray[i] = (String)argsVec.elementAt(i);
            }
            int status = trans.parseAndProcessArguments(argsArray);
            if (status != 1) {
                return status;
            }
        }
        return 1;
    }

    public static void FindToken(String token, Vector inputVec, IntPair curLoc, String errorMsg) throws ParseAlgorithmException {
        boolean found = false;
        while (!found && curLoc.one < inputVec.size()) {
            int endLoc;
            String curLine = ParseAlgorithm.GotoNextNonSpace(inputVec, curLoc);
            if (curLine.substring(curLoc.two).startsWith(token) && ((endLoc = curLoc.two + token.length()) >= curLine.length() || !Character.isLetter(curLine.charAt(endLoc)) && curLine.charAt(endLoc) != '_')) {
                found = true;
                curLoc.two = endLoc;
            }
            curLoc.two = ParseAlgorithm.NextSpaceCol(curLine, curLoc.two);
        }
        if (!found) {
            throw new ParseAlgorithmException(errorMsg);
        }
    }

    public static void FindMatchingBrace(Vector inputVec, IntPair curLoc, String errorMsg) throws ParseAlgorithmException {
        ++curLoc.two;
        while (curLoc.one < inputVec.size()) {
            String curLine = (String)inputVec.elementAt(curLoc.one);
            while (curLoc.two < curLine.length()) {
                curLoc.two = ParseAlgorithm.NextBraceQuoteOrCommentCol(curLine, curLoc.two);
                if (curLoc.two >= curLine.length()) continue;
                char c = curLine.charAt(curLoc.two);
                if (c == '}') {
                    ++curLoc.two;
                    return;
                }
                if (c == '{') {
                    ParseAlgorithm.FindMatchingBrace(inputVec, curLoc, errorMsg);
                    curLine = (String)inputVec.elementAt(curLoc.one);
                    continue;
                }
                if (c == '(' && curLoc.two + 1 < curLine.length() && curLine.charAt(curLoc.two + 1) == '*') {
                    ParseAlgorithm.gotoEndOfComment(inputVec, curLoc);
                    curLine = (String)inputVec.elementAt(curLoc.one);
                    continue;
                }
                if (c == '\\' && curLoc.two + 1 < curLine.length() && curLine.charAt(curLoc.two + 1) == '*') {
                    curLoc.two = curLine.length();
                    continue;
                }
                if (c != '\"') continue;
                curLoc.two = ParseAlgorithm.findEndOfString(curLine, curLoc.two, curLoc.one);
            }
            ++curLoc.one;
            curLoc.two = 0;
        }
        throw new ParseAlgorithmException(errorMsg);
    }

    private static int NextDelimiterCol(String str, int col) {
        String[] splitStr = str.substring(col).split(" |,|\\)");
        if (splitStr.length == 0) {
            return col;
        }
        return col + splitStr[0].length();
    }

    private static int NextSpaceCol(String str, int col) {
        String[] splitStr = str.substring(col).split(" ");
        if (splitStr.length == 0) {
            return col;
        }
        return col + splitStr[0].length();
    }

    private static int NextBraceQuoteOrCommentCol(String str, int col) {
        String[] splitStr = str.substring(col).split("\\{|\\}|\"|\\(\\*|\\\\\\*");
        if (splitStr.length == 0) {
            return col;
        }
        return col + splitStr[0].length();
    }

    public static int NextNonIdChar(String str, int col) {
        int curCol = col;
        char c = str.charAt(col);
        while (curCol < str.length() && (Character.isLetter(c) || Character.isDigit(c) || c == '_')) {
            if (++curCol >= str.length()) continue;
            c = str.charAt(curCol);
        }
        return curCol;
    }

    public static String GotoNextNonSpace(Vector inputVec, IntPair curLoc) {
        boolean found = false;
        while (!found && curLoc.one < inputVec.size()) {
            String line = (String)inputVec.elementAt(curLoc.one);
            while (!found && curLoc.two < line.length()) {
                if (line.charAt(curLoc.two) == ' ') {
                    ++curLoc.two;
                    continue;
                }
                found = true;
            }
            if (found) continue;
            ++curLoc.one;
            curLoc.two = 0;
        }
        if (curLoc.one < inputVec.size()) {
            return (String)inputVec.elementAt(curLoc.one);
        }
        return "";
    }

    public static int findEndOfString(String str, int loc, int line) throws ParseAlgorithmException {
        int pos;
        boolean found = false;
        for (pos = loc + 1; !found && pos < str.length(); ++pos) {
            char c = str.charAt(pos);
            if (c == '\"') {
                found = true;
                continue;
            }
            if (c != '\\' || pos >= str.length() - 1) continue;
            ++pos;
        }
        if (!found) {
            throw new ParseAlgorithmException("Unterminated string begun at line \n    line " + (line + 1) + ", column " + (loc + 1));
        }
        return pos;
    }

    public static void gotoEndOfComment(Vector inputVec, IntPair curLoc) throws ParseAlgorithmException {
        IntPair originalLoc = curLoc;
        boolean found = false;
        String curLine = (String)inputVec.elementAt(curLoc.one);
        StringBuffer newLine = new StringBuffer(curLine.substring(0, curLoc.two));
        curLoc.two += 2;
        while (!found && curLoc.one < inputVec.size()) {
            while (!found && curLoc.two < curLine.length()) {
                char c = curLine.charAt(curLoc.two);
                if (c == '(' && curLoc.two + 1 < curLine.length() && curLine.charAt(curLoc.two + 1) == '*') {
                    ParseAlgorithm.gotoEndOfComment(inputVec, curLoc);
                    curLine = (String)inputVec.elementAt(curLoc.one);
                    continue;
                }
                if (c == '*' && curLoc.two + 1 < curLine.length() && curLine.charAt(curLoc.two + 1) == ')') {
                    curLoc.two += 2;
                    found = true;
                    continue;
                }
                ++curLoc.two;
            }
            if (found) continue;
            ++curLoc.one;
            curLoc.two = 0;
            if (curLoc.one >= inputVec.size()) continue;
            curLine = (String)inputVec.elementAt(curLoc.one);
        }
        if (!found) {
            throw new ParseAlgorithmException("Unterminated comment begun at line \n    line " + (curLoc.one + 1) + ", column " + (curLoc.two + 1));
        }
    }

    public static final void printArray(Object[] array) {
        if (array == null) {
            System.out.println("null array");
            return;
        }
        if (array.length == 0) {
            System.out.println("zero-length array");
            return;
        }
        System.out.println("0-" + array[0].toString() + "-0");
        for (int i = 1; i < array.length; ++i) {
            System.out.println("*-" + array[i].toString() + "-*");
        }
    }

    static {
        inGetMacro = false;
        LAT = new String[10];
        LATsize = 0;
        curTokCol = new int[10];
        curTokLine = new int[10];
    }
}

