/*
 * Decompiled with CFR 0.152.
 */
package de.prob.animator;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.inject.Inject;
import de.prob.animator.CommandProcessor;
import de.prob.animator.IAnimator;
import de.prob.animator.IPrologResult;
import de.prob.animator.InterruptedResult;
import de.prob.animator.NoResult;
import de.prob.animator.YesResult;
import de.prob.animator.command.AbstractCommand;
import de.prob.animator.command.ComposedCommand;
import de.prob.animator.command.GetErrorsCommand;
import de.prob.cli.ProBInstance;
import de.prob.exception.CliError;
import de.prob.exception.ProBError;
import de.prob.statespace.AnimationSelector;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AnimatorImpl
implements IAnimator {
    private static int counter = 0;
    private final String id = "animator" + counter++;
    private final ProBInstance cli;
    private final Logger logger = LoggerFactory.getLogger(AnimatorImpl.class);
    private final CommandProcessor processor;
    private final GetErrorsCommand getErrors;
    public static boolean DEBUG = false;
    private final AnimationSelector animations;
    private boolean busy = false;

    @Inject
    public AnimatorImpl(@Nullable ProBInstance cli, CommandProcessor processor, GetErrorsCommand getErrors, AnimationSelector animations) {
        this.cli = cli;
        this.processor = processor;
        this.getErrors = getErrors;
        this.animations = animations;
        processor.configure(cli);
    }

    @Override
    public synchronized void execute(AbstractCommand command) {
        if (this.cli == null) {
            this.logger.error("Probcli is missing. Try \"upgrade\".");
            throw new CliError("no cli found");
        }
        if (DEBUG && !command.getSubcommands().isEmpty()) {
            List<AbstractCommand> cmds = command.getSubcommands();
            for (AbstractCommand abstractCommand : cmds) {
                this.execute(abstractCommand);
            }
        }
        if (command.blockAnimator()) {
            this.startTransaction();
        }
        do {
            IPrologResult result = this.processor.sendCommand(command);
            List<String> errormessages = this.getErrors();
            if (result instanceof YesResult && errormessages.isEmpty()) {
                try {
                    command.processResult(((YesResult)result).getBindings());
                }
                catch (Exception e) {
                    String message = "Exception of type " + e.getClass() + " was thrown when executing " + command.getClass().getSimpleName() + ". Message was: " + e.getMessage();
                    System.out.println(message + "\n");
                    e.printStackTrace();
                    this.logger.error(message, (Throwable)e);
                    System.exit(-1);
                }
                continue;
            }
            command.processErrorResult(result, errormessages);
        } while (!command.isCompleted());
        if (command.blockAnimator()) {
            this.endTransaction();
        }
    }

    private synchronized List<String> getErrors() {
        List<Object> errors = Collections.emptyList();
        IPrologResult errorresult = this.processor.sendCommand(this.getErrors);
        if (errorresult instanceof YesResult) {
            this.getErrors.processResult(((YesResult)errorresult).getBindings());
            errors = this.getErrors.getErrors();
            if (!errors.isEmpty()) {
                String msg = Joiner.on((char)'\n').join(errors);
                this.logger.error("ProB raised exception(s):\n", (Object)msg);
                return errors;
            }
        } else {
            if (errorresult instanceof NoResult || errorresult instanceof InterruptedResult) {
                throw new ProBError("Get errors must be successful");
            }
            throw new ProBError("Unknown result type");
        }
        return errors;
    }

    public String toString() {
        return MoreObjects.toStringHelper(AnimatorImpl.class).addValue((Object)this.cli).toString();
    }

    @Override
    public void execute(AbstractCommand ... commands) {
        this.execute((AbstractCommand)new ComposedCommand(commands));
    }

    @Override
    public void sendInterrupt() {
        this.logger.info("Sending an interrupt to the CLI");
        this.cli.sendInterrupt();
    }

    public static void setDebug(boolean debug) {
        DEBUG = debug;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void startTransaction() {
        this.busy = true;
        this.animations.notifyAnimatorStatus(this.id, this.busy);
    }

    @Override
    public void endTransaction() {
        this.busy = false;
        this.animations.notifyAnimatorStatus(this.id, this.busy);
    }

    @Override
    public boolean isBusy() {
        return this.busy;
    }

    @Override
    public void kill() {
        this.cli.shutdown();
    }
}

