/*
 * Decompiled with CFR 0.152.
 */
package de.prob.web.views;

import com.google.inject.Inject;
import de.prob.animator.command.AbstractCommand;
import de.prob.animator.command.GetDotForStateVizCmd;
import de.prob.statespace.AnimationSelector;
import de.prob.statespace.IAnimationChangeListener;
import de.prob.statespace.Trace;
import de.prob.web.AbstractAnimationBasedView;
import de.prob.web.WebUtils;
import java.util.Map;
import javax.servlet.AsyncContext;

public class StateVisualization
extends AbstractAnimationBasedView {
    Trace currentTrace;

    @Inject
    public StateVisualization(AnimationSelector animations) {
        super(animations);
        animations.registerAnimationChangeListener((IAnimationChangeListener)this);
        this.incrementalUpdate = false;
    }

    public void draw() {
        GetDotForStateVizCmd cmd = new GetDotForStateVizCmd(this.currentTrace.getCurrentState());
        this.currentTrace.getStateSpace().execute((AbstractCommand)cmd);
        Map<String, String> wrap = WebUtils.wrap("cmd", "Dotty.draw", "content", cmd.getContent());
        this.submit(wrap);
    }

    @Override
    public String html(String clientid, Map<String, String[]> parameterMap) {
        return this.simpleRender(clientid, "ui/dotty/index.html");
    }

    @Override
    public void reload(String client, int lastinfo, AsyncContext context) {
        this.sendInitMessage(context);
        if (this.currentTrace != null) {
            this.draw();
        }
    }

    @Override
    public void performTraceChange(Trace trace) {
        this.currentTrace = trace;
        if (this.currentTrace != null) {
            this.draw();
        }
    }

    public void animatorStatus(boolean busy) {
    }
}

