/*
 * Decompiled with CFR 0.152.
 */
package de.prob.web.views;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import de.prob.annotations.PublicSession;
import de.prob.model.representation.AbstractElement;
import de.prob.model.representation.AbstractModel;
import de.prob.statespace.AnimationSelector;
import de.prob.statespace.IAnimationChangeListener;
import de.prob.statespace.Trace;
import de.prob.statespace.Transition;
import de.prob.web.AbstractSession;
import de.prob.web.WebUtils;
import java.util.List;
import java.util.Map;
import javax.servlet.AsyncContext;

@Singleton
@PublicSession
public class CurrentAnimations
extends AbstractSession
implements IAnimationChangeListener {
    private final AnimationSelector animations;

    @Inject
    public CurrentAnimations(AnimationSelector animations) {
        this.animations = animations;
        animations.registerAnimationChangeListener((IAnimationChangeListener)this);
        this.incrementalUpdate = false;
    }

    @Override
    public String html(String clientid, Map<String, String[]> parameterMap) {
        return this.simpleRender(clientid, "ui/animations/index.html");
    }

    public Object selectTrace(Map<String, String[]> params) {
        int pos = Integer.parseInt(params.get("pos")[0]);
        Trace trace = (Trace)this.animations.getTraces().get(pos);
        this.animations.changeCurrentAnimation(trace);
        return null;
    }

    public Object removeTrace(Map<String, String[]> params) {
        int pos = Integer.parseInt(params.get("pos")[0]);
        Trace trace = (Trace)this.animations.getTraces().get(pos);
        this.animations.removeTrace(trace);
        return null;
    }

    public Object protectTrace(Map<String, String[]> params) {
        int pos = Integer.parseInt(params.get("pos")[0]);
        boolean protect = Boolean.valueOf(params.get("protect")[0]);
        Trace trace = (Trace)this.animations.getTraces().get(pos);
        this.animations.setProtected(trace, protect);
        return null;
    }

    public void traceChange(Trace currentTrace, boolean currentAnimationChanged) {
        List traces = this.animations.getTraces();
        Object[] result = new Object[traces.size()];
        int ctr = 0;
        for (Trace t : traces) {
            AbstractModel model = t.getModel();
            AbstractElement mainComponent = t.getStateSpace().getMainComponent();
            String modelName = mainComponent != null ? mainComponent.toString() : model.getModelFile().getName();
            Transition op = t.getCurrentTransition();
            String lastOp = op != null ? op.getPrettyRep() : "";
            String steps = t.getTransitionList().size() + "";
            String isCurrent = t.equals(currentTrace) + "";
            boolean isProtected = this.animations.getProtectedTraces().contains(t.getUUID());
            Map<String, String> wrapped = WebUtils.wrap("model", modelName, "lastOp", lastOp, "steps", steps, "isCurrent", isCurrent, "protected", isProtected);
            result[ctr++] = wrapped;
        }
        Map<String, String> wrap = WebUtils.wrap("cmd", "Animations.setContent", "animations", WebUtils.toJson(result));
        this.submit(wrap);
    }

    public void animatorStatus(boolean busy) {
    }

    @Override
    public void reload(String client, int lastinfo, AsyncContext context) {
        this.sendInitMessage(context);
        this.traceChange(this.animations.getCurrentTrace(), false);
    }
}

