/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform;

import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.parboiled.common.Preconditions;
import org.parboiled.transform.GroupClassGenerator;
import org.parboiled.transform.InstructionGraphNode;
import org.parboiled.transform.InstructionGroup;
import org.parboiled.transform.ParserClassNode;
import org.parboiled.transform.RuleMethod;
import org.parboiled.transform.Types;

class VarInitClassGenerator
extends GroupClassGenerator {
    public VarInitClassGenerator(boolean forceCodeBuilding) {
        super(forceCodeBuilding);
    }

    public boolean appliesTo(ParserClassNode classNode, RuleMethod method) {
        Preconditions.checkArgNotNull((Object)((Object)method), (String)"method");
        return method.containsVars();
    }

    protected boolean appliesTo(InstructionGraphNode node) {
        return node.isVarInitRoot();
    }

    protected Type getBaseType() {
        return Types.BASE_VAR_INIT;
    }

    protected void generateMethod(InstructionGroup group, ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "create", "()Ljava/lang/Object;", null, null);
        this.convertXLoads(group);
        group.getInstructions().accept(mv);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
    }
}

